/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;
import oracle.jdevimpl.ant.runner.ui.EnvironmentPanel;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibraryPanel;

public class AntJavaPage
extends AntRunConfigurationPage {
    private JLabel jdkLabel;
    private JTextField jdkField;
    private JButton editJDKButton;
    private LibraryList[] libLists;
    private JProjectLibraryList prjLibList;
    private Project jProject;
    private JLabel workingDirLabel;
    private URLTextField workingDirField;
    private JButton browseWorkingDirButton;
    private JLabel javaArgsLabel;
    private JTextField javaArgsField;
    private JButton environmentButton;
    private EnvironmentPanel environmentPanel;
    private List envNames;
    private List envValues;
    private JDK jdk;
    private JProjectLibraries projectLibraries;
    private static final LocalChangeListener LISTENER = new LocalChangeListener(null);
    private static final String[] PROPERTY_KEYS = new String[]{"jdkVersion", "workingDir", "javaArgs"};

    public AntJavaPage() {
        this.jbInit();
    }

    public void setJProject(Project project) {
        this.jProject = project;
        this.projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antRunConfiguration) {
        this.loadJDKs();
        this.jdk = antRunConfiguration.getJDK(this.jProject);
        if (this.jdk != null) {
            this.jdkField.setText(this.jdk.toString());
        }
        this.workingDirField.setURL(antRunConfiguration.getWorkingDirectory());
        URL uRL = antRunConfiguration.getBuildfile();
        if (uRL != null) {
            this.workingDirField.setDefaultChooserURL(URLFileSystem.getParent((URL)uRL));
        }
        this.javaArgsField.setText(antRunConfiguration.getJavaArgs());
        this.envNames = antRunConfiguration.getEnvironmentNames();
        this.envValues = antRunConfiguration.getEnvironmentValues();
    }

    public void saveTo(AntRunConfiguration antRunConfiguration) {
        if (this.jdk != null && this.jdk.equals(this.getDefaultJDK())) {
            antRunConfiguration.setJDK(null);
        } else {
            antRunConfiguration.setJDK(this.jdk);
        }
        antRunConfiguration.setWorkingDirectory(this.workingDirField.getURL());
        String string = this.javaArgsField.getText();
        if (string != null && string.length() == 0) {
            string = null;
        }
        antRunConfiguration.setJavaArgs(string);
        antRunConfiguration.setEnvironmentNames(this.envNames);
        antRunConfiguration.setEnvironmentValues(this.envValues);
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        Project project;
        this.jProject = project = (Project)traversableContext.find("Project");
        PropertyStorage propertyStorage = AntJavaPage.getPropertyData((Namespace)traversableContext);
        this.projectLibraries = JProjectLibraries.getInstance(propertyStorage);
        super.onProjectPanelEntry(traversableContext);
    }

    public Component getInitialFocus() {
        return this.jdkField;
    }

    public String getPageName() {
        return AntArb.getString(65);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        if (this.workingDirField.getText().trim().length() > 0 && this.workingDirField.getURL() == null) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(145), (String)AntArb.getString(146), null);
            return false;
        }
        return true;
    }

    public String getPageHelpTopicID() {
        return "process_html";
    }

    private void jbInit() {
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>" + AntArb.getString(66) + "</html>");
        this.jdkLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.jdkLabel, null, (String)JProjectArb.getString(151));
        this.jdkField = new JTextField();
        this.jdkField.setEditable(false);
        this.editJDKButton = new JButton();
        this.editJDKButton.addActionListener(new 2());
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString(10));
        this.workingDirField = new URLTextField(null, true, false);
        this.workingDirField.setColumns(30);
        this.workingDirField.setDialogHelpContext("f1_idedurlchooserdir_html");
        this.workingDirLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.workingDirLabel, (Component)this.workingDirField, (String)AntArb.getString(104));
        this.browseWorkingDirButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseWorkingDirButton, (String)AntArb.getString(105));
        this.browseWorkingDirButton.addActionListener((ActionListener)this.workingDirField);
        this.javaArgsField = new JTextField();
        this.javaArgsLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.javaArgsLabel, (Component)this.javaArgsField, (String)AntArb.getString(106));
        this.environmentButton = new JButton();
        this.environmentPanel = new EnvironmentPanel();
        ResourceUtils.resButton((AbstractButton)this.environmentButton, (String)AntArb.getString(113));
        this.environmentButton.addActionListener(new 1());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        gridBagConstraints.weightx = 1.0;
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 5);
        this.add(this.jdkLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.jdkField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add(this.editJDKButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add(this.javaArgsLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add(this.javaArgsField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add(this.workingDirLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.workingDirField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        this.add(this.browseWorkingDirButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.environmentButton, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(new JLabel(), gridBagConstraints);
    }

    private void loadJDKs() {
        LibraryList[] libraryListArray = JLibraryManager.getAllLibraryLists();
        if (this.jProject != null) {
            this.prjLibList = this.projectLibraries.getProjectLibraryList();
            this.libLists = new LibraryList[libraryListArray.length + 1];
            System.arraycopy(libraryListArray, 0, this.libLists, 0, libraryListArray.length);
            this.libLists[this.libLists.length - 1] = this.prjLibList;
        } else {
            this.libLists = libraryListArray;
        }
    }

    private void editJDK() {
        JDKPanel jDKPanel = new JDKPanel();
        ListWrapper[] listWrapperArray = new ListWrapper[this.libLists.length];
        int n = 0;
        while (n < listWrapperArray.length) {
            listWrapperArray[n] = new ListWrapper(this.libLists[n]);
            ++n;
        }
        jDKPanel.initPanel(listWrapperArray, this.jdk);
        jDKPanel.setSelectionMode(1);
        LocalChangeListener.wa$_panel(LISTENER, jDKPanel);
        if (OnePageWizardDialogFactory.runDialog((Component)((Object)this), (Component)jDKPanel, null, (String)ControlsArb.getString(45), (int)7, (VetoableChangeListener)LISTENER)) {
            listWrapperArray = jDKPanel.getLibraryLists();
            int n2 = 0;
            while (n2 < listWrapperArray.length) {
                listWrapperArray[n2].commit(listWrapperArray[n2].getWrappedList() != this.prjLibList);
                ++n2;
            }
            Library[] libraryArray = jDKPanel.getSelection();
            if (libraryArray != null && libraryArray.length > 0) {
                this.jdk = (JDK)libraryArray[0];
            }
            this.jdkField.setText(this.jdk.toString());
            this.loadJDKs();
        }
    }

    private JDK getDefaultJDK() {
        JDK jDK = null;
        if (this.jProject != null) {
            jDK = this.projectLibraries.getJDK();
        }
        if (jDK == null) {
            jDK = JLibraryManager.getDefaultJDK();
        }
        return jDK;
    }

    static void mav$editJDK(AntJavaPage antJavaPage) {
        antJavaPage.editJDK();
    }

    static EnvironmentPanel ra$environmentPanel(AntJavaPage antJavaPage) {
        return antJavaPage.environmentPanel;
    }

    static List ra$envNames(AntJavaPage antJavaPage) {
        return antJavaPage.envNames;
    }

    static List ra$envValues(AntJavaPage antJavaPage) {
        return antJavaPage.envValues;
    }

    static void wa$envNames(AntJavaPage antJavaPage, List list) {
        antJavaPage.envNames = list;
    }

    static void wa$envValues(AntJavaPage antJavaPage, List list) {
        antJavaPage.envValues = list;
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntJavaPage.mav$editJDK(AntJavaPage.this);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntJavaPage.ra$environmentPanel(AntJavaPage.this).setEnvironment(AntJavaPage.ra$envNames(AntJavaPage.this), AntJavaPage.ra$envValues(AntJavaPage.this));
            if (AntJavaPage.ra$environmentPanel(AntJavaPage.this).runDialog()) {
                AntJavaPage.wa$envNames(AntJavaPage.this, AntJavaPage.ra$environmentPanel(AntJavaPage.this).getNames());
                AntJavaPage.wa$envValues(AntJavaPage.this, AntJavaPage.ra$environmentPanel(AntJavaPage.this).getValues());
            }
        }
    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, propertyChangeEvent);
            }
        }

        private LocalChangeListener() {
        }

        static void wa$_panel(LocalChangeListener localChangeListener, LibraryPanel libraryPanel) {
            localChangeListener._panel = libraryPanel;
        }

        LocalChangeListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

