/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JScrollingLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;

public class AntMainPage
extends AntRunConfigurationPage {
    private ButtonGroup antVersionButtonGroup;
    private JRadioButton useDefaultAnt;
    private JRadioButton useAntHome;
    private JButton browseAntHomeButton;
    private JLabel antHomeLabel;
    private URLTextField antHomeField;
    private JScrollingLabel versionLabel;
    private JComboBox outputLevel;
    private JCheckBox keepGoingCheckBox;
    private JLabel inputFileLabel;
    private JCheckBox inputFileCheckBox;
    private URLTextField inputFileField;
    private JButton browseInputFileButton;
    private static final String[] OUTPUT_LEVEL_STRINGS = new String[]{AntArb.getString(92), AntArb.getString(93), AntArb.getString(94), AntArb.getString(95)};
    private static final int[] OUTPUT_LEVELS = new int[]{1, 2, 3, 4};
    private static final String[] PROPERTY_KEYS = new String[]{"antHome", "outputLevel", "keepGoing", "useInputFile", "inputFile"};

    public AntMainPage() {
        this.jbInit();
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antRunConfiguration) {
        URL uRL = antRunConfiguration.getAntHome();
        if (uRL != null) {
            this.useAntHome.setSelected(true);
            this.antHomeField.setURL(uRL);
        } else {
            this.useDefaultAnt.setSelected(true);
            this.antHomeField.setURL(null);
        }
        this.updateAntHome();
        int n = antRunConfiguration.getOutputLevel();
        this.outputLevel.setSelectedIndex(this.getIndexForLevel(n));
        this.keepGoingCheckBox.setSelected(antRunConfiguration.getKeepGoing());
        this.inputFileCheckBox.setSelected(antRunConfiguration.getUseInputFile());
        URL uRL2 = antRunConfiguration.getInputFile();
        this.inputFileField.setURL(uRL2);
        this.updateInputFile();
        URL uRL3 = antRunConfiguration.getBuildfile();
        if (uRL3 != null) {
            URL uRL4 = URLFileSystem.getParent((URL)uRL3);
            this.inputFileField.setDefaultChooserURL(uRL4);
        } else {
            this.inputFileField.setDefaultChooserURL(null);
        }
    }

    public void saveTo(AntRunConfiguration antRunConfiguration) {
        if (this.useDefaultAnt.isSelected()) {
            antRunConfiguration.setAntHome(null);
        } else {
            antRunConfiguration.setAntHome(this.antHomeField.getURL());
        }
        int n = this.outputLevel.getSelectedIndex();
        antRunConfiguration.setOutputLevel(OUTPUT_LEVELS[n]);
        antRunConfiguration.setKeepGoing(this.keepGoingCheckBox.isSelected());
        antRunConfiguration.setUseInputFile(this.inputFileCheckBox.isSelected());
        antRunConfiguration.setInputFile(this.inputFileField.getURL());
    }

    public Component getInitialFocus() {
        return this.useDefaultAnt;
    }

    public String getPageName() {
        return AntArb.getString(107);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        if (this.useAntHome.isSelected()) {
            AntVersion antVersion = null;
            URL uRL = this.antHomeField.getURL();
            if (uRL != null && URLFileSystem.isDirectory((URL)uRL)) {
                antVersion = AntVersion.createAntVersion(uRL);
            }
            if (antVersion == null) {
                MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(135), (String)AntArb.getString(136), null);
                return false;
            }
        }
        if (this.inputFileCheckBox.isSelected() && this.inputFileField.getURL() == null) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(100), (String)AntArb.getString(101), null);
            return false;
        }
        return true;
    }

    public String getPageHelpTopicID() {
        return "options_html";
    }

    private void jbInit() {
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>" + AntArb.getString(90) + "</html>");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(AntArb.getString(132)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.antVersionButtonGroup = new ButtonGroup();
        2 var3_3 = new 2();
        this.useDefaultAnt = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useDefaultAnt, (String)AntArb.getString(133));
        this.useDefaultAnt.addActionListener(var3_3);
        this.antVersionButtonGroup.add(this.useDefaultAnt);
        this.useAntHome = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useAntHome, (String)AntArb.getString(134));
        this.useAntHome.addActionListener(var3_3);
        this.antVersionButtonGroup.add(this.useAntHome);
        this.antHomeLabel = new JLabel();
        this.antHomeField = new URLTextField(null, true, false);
        this.antHomeField.setColumns(30);
        this.antHomeField.getDocument().addDocumentListener(new AntHomeListener(null));
        this.antHomeField.setDialogHelpContext("f1_idedurlchooserdir_html");
        ResourceUtils.resLabel((JLabel)this.antHomeLabel, (Component)this.antHomeField, (String)AntArb.getString(83));
        this.browseAntHomeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseAntHomeButton, (String)AntArb.getString(84));
        this.browseAntHomeButton.addActionListener((ActionListener)this.antHomeField);
        this.versionLabel = new JScrollingLabel();
        Font font = this.versionLabel.getFont();
        if (font != null) {
            this.versionLabel.setFont(font.deriveFont(1));
        }
        JLabel jLabel2 = new JLabel();
        this.outputLevel = new JComboBox<String>(OUTPUT_LEVEL_STRINGS);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.outputLevel, (String)AntArb.getString(91));
        this.keepGoingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.keepGoingCheckBox, (String)AntArb.getString(96));
        this.inputFileCheckBox = new JCheckBox();
        this.inputFileCheckBox.addItemListener(new 1());
        ResourceUtils.resButton((AbstractButton)this.inputFileCheckBox, (String)AntArb.getString(98));
        this.inputFileField = new URLTextField(null, false, false);
        this.inputFileField.setColumns(30);
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(AntArb.getString(64), ".properties");
        this.inputFileField.setFilter((URLFilter)defaultURLFilter);
        this.inputFileField.setDialogHelpContext("f1_idedurlchooserfile_html");
        this.inputFileLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.inputFileLabel, (Component)this.inputFileField, (String)AntArb.getString(99));
        this.browseInputFileButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseInputFileButton, (String)AntArb.getString(102));
        this.browseInputFileButton.addActionListener((ActionListener)this.inputFileField);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add(jLabel, gridBagConstraints);
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.useDefaultAnt, gridBagConstraints);
        jPanel.add((Component)this.useAntHome, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 8);
        jPanel.add((Component)this.antHomeLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel.add((Component)this.antHomeField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.browseAntHomeButton, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)this.versionLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.outputLevel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add(this.keepGoingCheckBox, gridBagConstraints);
        this.add(this.inputFileCheckBox, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 8);
        gridBagConstraints.gridwidth = 1;
        this.add(this.inputFileLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints.gridwidth = -1;
        this.add((Component)this.inputFileField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.browseInputFileButton, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(new JLabel(), gridBagConstraints);
    }

    private void updateInputFile() {
        boolean bl = this.inputFileCheckBox.isSelected();
        this.inputFileLabel.setEnabled(bl);
        this.inputFileField.setEnabled(bl);
        this.browseInputFileButton.setEnabled(bl);
    }

    private void updateAntHome() {
        AntVersion antVersion = null;
        boolean bl = this.useDefaultAnt.isSelected();
        if (bl) {
            antVersion = AntVersion.getDefaultAntVersion();
        } else {
            URL uRL = this.antHomeField.getURL();
            if (uRL != null && URLFileSystem.isDirectory((URL)uRL)) {
                antVersion = AntVersion.createAntVersion(uRL);
            }
        }
        if (antVersion != null) {
            this.versionLabel.setText(antVersion.getVersionString());
            boolean bl2 = antVersion.getVersion().isAfter(new VersionNumber("1.6"), true);
            this.keepGoingCheckBox.setEnabled(bl2);
            boolean bl3 = antVersion.getVersion().isAfter(new VersionNumber("1.5"), true);
            this.inputFileCheckBox.setEnabled(bl3);
            this.updateInputFile();
        } else {
            this.versionLabel.setText(null);
        }
        this.antHomeLabel.setEnabled(bl ^ true);
        this.antHomeField.setEnabled(bl ^ true);
        this.browseAntHomeButton.setEnabled(bl ^ true);
    }

    private int getIndexForLevel(int n) {
        if (n == 0) {
            n = 1;
        }
        int n2 = 0;
        while (n2 < OUTPUT_LEVELS.length) {
            if (n == OUTPUT_LEVELS[n2]) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    static void mav$updateAntHome(AntMainPage antMainPage) {
        antMainPage.updateAntHome();
    }

    static void mav$updateInputFile(AntMainPage antMainPage) {
        antMainPage.updateInputFile();
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }
    }

    public final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            AntMainPage.mav$updateInputFile(AntMainPage.this);
        }
    }

    private class AntHomeListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        private AntHomeListener() {
        }

        AntHomeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

