/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.sort.Sort;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.macro.MacroExpander;
import oracle.jdeveloper.externaltools.macro.MacroPicker;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.externaltools.AntExternalToolType;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;

public class AntPropertiesPage
extends AntRunConfigurationPage {
    private NiceTable propertyTable;
    private JPanel propertyPanel;
    private JList fileList;
    private JTextField propertyNameField;
    private JTextField propertyValueField;
    private JButton removePropertyButton;
    private JButton editPropertyButton;
    private JButton removeFileButton;
    private URL buildfile;
    private URL lastPropertyFile;
    private boolean inRemove;
    private static final String ADD_PROPERTY_HELP_TOPIC = "f1_ant_add_property_dlg_html";
    private static final String EDIT_PROPERTY_HELP_TOPIC = "f1_ant_edit_property_dlg_html";
    private static final int INDEX_NAME = 0;
    private static final int INDEX_VALUE = 1;
    private static final String[] PROPERTY_KEYS = new String[]{"propertyNames", "propertyValues", "propertyFiles"};

    void $init$() {
        this.inRemove = false;
    }

    public AntPropertiesPage() {
        this.$init$();
        this.jbInit();
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antRunConfiguration) {
        this.buildfile = antRunConfiguration.getBuildfile();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.propertyTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        Iterator iterator = antRunConfiguration.getPropertyNames().iterator();
        Iterator iterator2 = antRunConfiguration.getPropertyValues().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)iterator2.next();
            defaultTableModel.addRow(new String[]{string, string2});
        }
        if (defaultTableModel.getRowCount() > 0) {
            this.propertyTable.setRowSelectionInterval(0, 0);
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.fileList.getModel();
        defaultListModel.clear();
        Iterator iterator3 = antRunConfiguration.getPropertyFiles().iterator();
        while (iterator3.hasNext()) {
            defaultListModel.addElement((String)iterator3.next());
        }
        if (defaultListModel.size() > 0) {
            this.fileList.setSelectedIndex(0);
        }
        this.updatePropertyButtons();
        this.updateFileButtons();
    }

    public void saveTo(AntRunConfiguration antRunConfiguration) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.propertyTable.getModel();
        int n = defaultTableModel.getRowCount();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)defaultTableModel.getValueAt(n2, 0);
            stringArray2[n2] = (String)defaultTableModel.getValueAt(n2, 1);
            ++n2;
        }
        antRunConfiguration.setPropertyNames(Arrays.asList(stringArray));
        antRunConfiguration.setPropertyValues(Arrays.asList(stringArray2));
        ListModel listModel = this.fileList.getModel();
        int n3 = listModel.getSize();
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = (String)listModel.getElementAt(n4);
            ++n4;
        }
        antRunConfiguration.setPropertyFiles(Arrays.asList(stringArray3));
    }

    public Component getInitialFocus() {
        return this.propertyTable;
    }

    public String getPageName() {
        return AntArb.getString(47);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        return true;
    }

    public String getPageHelpTopicID() {
        return "properties_html";
    }

    private void jbInit() {
        JLabel jLabel = new JLabel();
        jLabel.setText("<html>" + AntArb.getString(48) + "</html>");
        this.propertyTable = new NiceTable();
        this.propertyTable.setResizeColumnOnDoubleClick(false);
        this.propertyTable.setColumnSelectorAvailable(false);
        this.propertyTable.setSorted(false);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        Object[] objectArray = new Object[]{AntArb.getString(50), AntArb.getString(51)};
        this.propertyTable.setModel((TableModel)new 10(objectArray, 0));
        this.propertyTable.getColumnModel().getColumn(0).setCellRenderer(new PropertyCellRenderer(null));
        this.propertyTable.getSelectionModel().addListSelectionListener(new 9());
        JScrollPane jScrollPane = new JScrollPane((Component)this.propertyTable);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.propertyTable, (String)AntArb.getString(49));
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)AntArb.getString(52));
        jButton.addActionListener(new 8());
        buttonBar.add((Component)jButton);
        this.editPropertyButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editPropertyButton, (String)AntArb.getString(54));
        this.editPropertyButton.addActionListener(new 7());
        buttonBar.add((Component)this.editPropertyButton);
        this.removePropertyButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removePropertyButton, (String)AntArb.getString(53));
        this.removePropertyButton.addActionListener(new 6());
        buttonBar.add((Component)this.removePropertyButton);
        this.updatePropertyButtons();
        this.fileList = new JList(new DefaultListModel());
        this.fileList.getSelectionModel().addListSelectionListener(new 5());
        JScrollPane jScrollPane2 = new JScrollPane(this.fileList);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.propertyTable, (String)AntArb.getString(60));
        ButtonBar buttonBar2 = new ButtonBar();
        buttonBar2.setOrientation(1);
        buttonBar2.setAlignment(1);
        JButton jButton2 = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton2, (String)AntArb.getString(61));
        jButton2.addActionListener(new 4());
        buttonBar2.add((Component)jButton2);
        this.removeFileButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removeFileButton, (String)AntArb.getString(62));
        this.removeFileButton.addActionListener(new 3());
        buttonBar2.add((Component)this.removeFileButton);
        this.updateFileButtons();
        this.setLayout(new BorderLayout(0, 15));
        this.add(jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 0, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(8, 3));
        jPanel2.add((Component)jLabel2, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)buttonBar, "East");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(8, 3));
        jPanel3.add((Component)jLabel3, "North");
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel3.add((Component)buttonBar2, "East");
        jPanel.add(jPanel3);
        this.add(jPanel, "Center");
    }

    private void addProperty() {
        JEWTDialog jEWTDialog = this.createPropertyDialog(AntArb.getString(55), ADD_PROPERTY_HELP_TOPIC);
        try {
            this.propertyNameField.setText(null);
            this.propertyValueField.setText(null);
            if (jEWTDialog.runDialog()) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.propertyTable.getModel();
                defaultTableModel.addRow(new String[]{this.propertyNameField.getText(), this.propertyValueField.getText()});
                int n = defaultTableModel.getRowCount() - 1;
                this.propertyTable.setRowSelectionInterval(n, n);
                this.propertyTable.scrollToSelection();
            }
        }
        finally {
            jEWTDialog.dispose();
        }
    }

    private void removeProperty() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.propertyTable.getModel();
        int[] nArray = this.propertyTable.getSelectedRows();
        if (nArray != null) {
            try {
                this.inRemove = true;
                Sort.qSort((int[])nArray, (int)nArray.length, (boolean)false);
                int n = 0;
                int n2 = 0;
                while (n2 < nArray.length) {
                    n = nArray[n2];
                    defaultTableModel.removeRow(n);
                    ++n2;
                }
                if ((n = Math.min(n, this.propertyTable.getRowCount() - 1)) >= 0) {
                    this.propertyTable.setRowSelectionInterval(n, n);
                    this.propertyTable.scrollToSelection();
                }
            }
            finally {
                this.inRemove = false;
                this.updatePropertyButtons();
            }
        }
    }

    private void editProperty() {
        int[] nArray = this.propertyTable.getSelectedRows();
        if (nArray != null && nArray.length > 0) {
            int n = nArray[0];
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.propertyTable.getModel();
            JEWTDialog jEWTDialog = this.createPropertyDialog(AntArb.getString(56), EDIT_PROPERTY_HELP_TOPIC);
            try {
                this.propertyNameField.setText((String)defaultTableModel.getValueAt(n, 0));
                this.propertyValueField.setText((String)defaultTableModel.getValueAt(n, 1));
                if (jEWTDialog.runDialog()) {
                    defaultTableModel.setValueAt(this.propertyNameField.getText(), n, 0);
                    defaultTableModel.setValueAt(this.propertyValueField.getText(), n, 1);
                }
            }
            finally {
                jEWTDialog.dispose();
            }
        }
    }

    private JEWTDialog createPropertyDialog(String string, String string2) {
        if (this.propertyPanel == null) {
            this.propertyPanel = this.createPropertyPanel();
        }
        HelpUtils.setHelpID((JComponent)this.propertyPanel, (String)string2);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)((Object)this), (String)string, (int)7);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 2());
        jEWTDialog.setContent((Component)this.propertyPanel);
        jEWTDialog.setInitialFocus((Component)this.propertyNameField);
        return jEWTDialog;
    }

    private JPanel createPropertyPanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.propertyNameField = new JTextField(20);
        this.propertyValueField = new JTextField(20);
        JButton jButton = new JButton();
        jButton.addActionListener(new 1());
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.propertyNameField, (String)AntArb.getString(57));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.propertyValueField, (String)AntArb.getString(58));
        ResourceUtils.resButton((AbstractButton)jButton, (String)AntArb.getString(59));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.propertyNameField, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.propertyValueField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void chooseMacro(JTextField jTextField) {
        MacroRegistry macroRegistry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        MacroPicker macroPicker = macroRegistry.getPicker(new AntExternalToolType(), false);
        MacroExpander macroExpander = macroPicker.runDialog((Component)((Object)this));
        if (macroExpander != null) {
            try {
                jTextField.getDocument().insertString(jTextField.getCaretPosition(), macroExpander.toMacroString(), null);
            }
            catch (BadLocationException badLocationException) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)badLocationException);
            }
        }
    }

    private void updatePropertyButtons() {
        if (!this.inRemove) {
            int n = this.propertyTable.getSelectedRowCount();
            this.removePropertyButton.setEnabled(n > 0);
            this.editPropertyButton.setEnabled(n == 1);
        }
    }

    private void updateFileButtons() {
        if (!this.inRemove) {
            int n = this.fileList.getSelectedIndex();
            this.removeFileButton.setEnabled(n != -1);
        }
    }

    private void validateProperty(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = this.propertyNameField.getText();
        String string2 = this.propertyValueField.getText();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(76), (String)AntArb.getString(77), null);
            throw new PropertyVetoException("Name or value not specified", propertyChangeEvent);
        }
    }

    private void addPropertyFile() {
        URL uRL = this.lastPropertyFile;
        if (uRL == null && this.buildfile != null) {
            uRL = URLFileSystem.getParent((URL)this.buildfile);
        }
        URLChooser uRLChooser = uRL != null ? DialogUtil.newURLChooser((URL)uRL) : DialogUtil.newURLChooser();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(AntArb.getString(64), ".properties");
        uRLChooser.addChooseableURLFilter((URLFilter)defaultURLFilter);
        uRLChooser.setURLFilter((URLFilter)defaultURLFilter);
        int n = uRLChooser.showOpenDialog((Component)((Object)this), AntArb.getString(63));
        if (n == 0) {
            URL[] uRLArray = uRLChooser.getSelectedURLs();
            DefaultListModel defaultListModel = (DefaultListModel)this.fileList.getModel();
            int n2 = defaultListModel.size();
            int n3 = n2 + uRLArray.length - 1;
            int n4 = 0;
            while (n4 < uRLArray.length) {
                URL uRL2 = uRLArray[n4];
                String string = URLFileSystem.getPlatformPathName((URL)uRL2);
                if (!defaultListModel.contains(string)) {
                    defaultListModel.addElement(string);
                }
                ++n4;
            }
            this.fileList.setSelectionInterval(n2, n3);
            this.updateFileButtons();
            this.lastPropertyFile = URLFileSystem.getParent((URL)uRLArray[0]);
        }
    }

    private void removePropertyFile() {
        int[] nArray = this.fileList.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)this.fileList.getModel();
        try {
            this.inRemove = true;
            int n = 0;
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                n = nArray[n2];
                defaultListModel.remove(n);
                --n2;
            }
            if ((n = Math.min(n, this.fileList.getModel().getSize() - 1)) >= 0) {
                this.fileList.setSelectedIndex(n);
            }
        }
        finally {
            this.inRemove = false;
            this.updateFileButtons();
        }
    }

    static void mav$updatePropertyButtons(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.updatePropertyButtons();
    }

    static void mav$addProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.addProperty();
    }

    static void mav$editProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.editProperty();
    }

    static void mav$removeProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.removeProperty();
    }

    static void mav$updateFileButtons(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.updateFileButtons();
    }

    static void mav$addPropertyFile(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.addPropertyFile();
    }

    static void mav$removePropertyFile(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.removePropertyFile();
    }

    static void mav$validateProperty(AntPropertiesPage antPropertiesPage, PropertyChangeEvent propertyChangeEvent) {
        antPropertiesPage.validateProperty(propertyChangeEvent);
    }

    static JTextField ra$propertyValueField(AntPropertiesPage antPropertiesPage) {
        return antPropertiesPage.propertyValueField;
    }

    static void mav$chooseMacro(AntPropertiesPage antPropertiesPage, JTextField jTextField) {
        antPropertiesPage.chooseMacro(jTextField);
    }

    public final class 10
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public 10(Object[] objectArray, int n) {
            super(objectArray, n);
        }
    }

    public final class 9
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AntPropertiesPage.mav$updatePropertyButtons(AntPropertiesPage.this);
        }
    }

    public final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$addProperty(AntPropertiesPage.this);
        }
    }

    public final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$editProperty(AntPropertiesPage.this);
        }
    }

    public final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$removeProperty(AntPropertiesPage.this);
        }
    }

    public final class 5
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AntPropertiesPage.mav$updateFileButtons(AntPropertiesPage.this);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$addPropertyFile(AntPropertiesPage.this);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$removePropertyFile(AntPropertiesPage.this);
        }
    }

    public final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                AntPropertiesPage.mav$validateProperty(AntPropertiesPage.this, propertyChangeEvent);
            }
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            AntPropertiesPage.mav$chooseMacro(AntPropertiesPage.this, AntPropertiesPage.ra$propertyValueField(AntPropertiesPage.this));
        }
    }

    private class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setIcon(CommonIconsUtils.getPropertyIcon());
            return this;
        }

        private PropertyCellRenderer() {
        }

        PropertyCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

