/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.sort.Sort;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.externaltools.ExternalToolManager;
import oracle.jdeveloper.externaltools.macro.MacroExpander;
import oracle.jdeveloper.externaltools.macro.MacroPicker;
import oracle.jdeveloper.externaltools.macro.MacroRegistry;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.externaltools.AntExternalToolType;

public class EnvironmentPanel
extends JPanel {
    private NiceTable table;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JPanel variablePanel;
    private JTextField variableName;
    private JTextField variableValue;
    private boolean inRemove;
    private static final String HELP_TOPIC = "f1_ant_edit_environment_dlg_html";
    private static final String ADD_VARIABLE_HELP_TOPIC = "f1_ant_add_environmentvar_dlg_html";
    private static final String EDIT_VARIABLE_HELP_TOPIC = "f1_ant_edit_environmentvar_dlg_html";
    private static final int INDEX_NAME = 0;
    private static final int INDEX_VALUE = 1;

    void $init$() {
        this.inRemove = false;
    }

    public EnvironmentPanel() {
        this.$init$();
        this.jbInit();
    }

    public void setEnvironment(List list, List list2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        int n = 0;
        while (n < list.size()) {
            defaultTableModel.addRow(new String[]{(String)list.get(n), (String)list2.get(n)});
            ++n;
        }
        if (defaultTableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public List getNames() {
        return this.getColumn(0);
    }

    public List getValues() {
        return this.getColumn(1);
    }

    public boolean runDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.table, (String)AntArb.getString(114));
        jEWTDialog.setDefaultButton(1);
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    private void jbInit() {
        this.table = new NiceTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.table.setResizeColumnOnDoubleClick(false);
        this.table.setColumnSelectorAvailable(false);
        this.table.setSorted(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        Object[] objectArray = new Object[]{AntArb.getString(116), AntArb.getString(117)};
        this.table.setModel((TableModel)new 7(objectArray, 0));
        this.table.getSelectionModel().addListSelectionListener(new 6());
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.table, (String)AntArb.getString(115));
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setOrientation(1);
        buttonBar.setAlignment(1);
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)AntArb.getString(118));
        jButton.addActionListener(new 5());
        buttonBar.add((Component)jButton);
        this.editButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)AntArb.getString(120));
        this.editButton.addActionListener(new 4());
        buttonBar.add((Component)this.editButton);
        this.removeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)AntArb.getString(119));
        this.removeButton.addActionListener(new 3());
        buttonBar.add((Component)this.removeButton);
        this.updateButtons();
        this.setLayout(new BorderLayout(8, 3));
        this.add((Component)jLabel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)buttonBar, "East");
    }

    private void updateButtons() {
        if (!this.inRemove) {
            int n = this.table.getSelectedRowCount();
            this.removeButton.setEnabled(n > 0);
            this.editButton.setEnabled(n == 1);
        }
    }

    private void addVariable() {
        JEWTDialog jEWTDialog = this.createVariableDialog(AntArb.getString(121), ADD_VARIABLE_HELP_TOPIC);
        this.variableName.setText(null);
        this.variableValue.setText(null);
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
            defaultTableModel.addRow(new String[]{this.variableName.getText(), this.variableValue.getText()});
            int n = defaultTableModel.getRowCount() - 1;
            this.table.setRowSelectionInterval(n, n);
            this.table.scrollToSelection();
        }
    }

    private void editVariable() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            int n = nArray[0];
            JEWTDialog jEWTDialog = this.createVariableDialog(AntArb.getString(122), EDIT_VARIABLE_HELP_TOPIC);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
            this.variableName.setText((String)defaultTableModel.getValueAt(n, 0));
            this.variableValue.setText((String)defaultTableModel.getValueAt(n, 1));
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                defaultTableModel.setValueAt(this.variableName.getText(), n, 0);
                defaultTableModel.setValueAt(this.variableValue.getText(), n, 1);
                this.updateButtons();
            }
        }
    }

    private void removeVariable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int[] nArray = this.table.getSelectedRows();
        if (nArray != null) {
            try {
                this.inRemove = true;
                Sort.qSort((int[])nArray, (int)nArray.length, (boolean)false);
                int n = 0;
                int n2 = 0;
                while (n2 < nArray.length) {
                    n = nArray[n2];
                    defaultTableModel.removeRow(n);
                    ++n2;
                }
                if ((n = Math.min(n, this.table.getRowCount() - 1)) >= 0) {
                    this.table.setRowSelectionInterval(n, n);
                    this.table.scrollToSelection();
                }
            }
            finally {
                this.inRemove = false;
                this.updateButtons();
            }
        }
    }

    private List getColumn(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        int n2 = defaultTableModel.getRowCount();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            arrayList.add(defaultTableModel.getValueAt(n3, n));
            ++n3;
        }
        return arrayList;
    }

    private JEWTDialog createVariableDialog(String string, String string2) {
        if (this.variablePanel == null) {
            this.variablePanel = this.createVariablePanel();
        }
        HelpUtils.setHelpID((JComponent)this.variablePanel, (String)string2);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)this, (String)string, (int)7);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 2());
        jEWTDialog.setContent((Component)this.variablePanel);
        jEWTDialog.setInitialFocus((Component)this.variableName);
        return jEWTDialog;
    }

    private JPanel createVariablePanel() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.variableName = new JTextField(20);
        this.variableValue = new JTextField(20);
        JButton jButton = new JButton();
        jButton.addActionListener(new 1());
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.variableName, (String)AntArb.getString(123));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.variableValue, (String)AntArb.getString(124));
        ResourceUtils.resButton((AbstractButton)jButton, (String)AntArb.getString(125));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.variableName, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.variableValue, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private void chooseMacro(JTextField jTextField) {
        MacroRegistry macroRegistry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        MacroPicker macroPicker = macroRegistry.getPicker(new AntExternalToolType(), false);
        MacroExpander macroExpander = macroPicker.runDialog(this);
        if (macroExpander != null) {
            try {
                jTextField.getDocument().insertString(jTextField.getCaretPosition(), macroExpander.toMacroString(), null);
            }
            catch (BadLocationException badLocationException) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)badLocationException);
            }
        }
    }

    private void validateVariable(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string = this.variableName.getText();
        String string2 = this.variableValue.getText();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            MessageDialog.error((Component)this, (Object)AntArb.getString(76), (String)AntArb.getString(77), null);
            throw new PropertyVetoException("Name or value not specified", propertyChangeEvent);
        }
    }

    static void mav$updateButtons(EnvironmentPanel environmentPanel) {
        environmentPanel.updateButtons();
    }

    static void mav$addVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.addVariable();
    }

    static void mav$editVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.editVariable();
    }

    static void mav$removeVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.removeVariable();
    }

    static void mav$validateVariable(EnvironmentPanel environmentPanel, PropertyChangeEvent propertyChangeEvent) {
        environmentPanel.validateVariable(propertyChangeEvent);
    }

    static JTextField ra$variableValue(EnvironmentPanel environmentPanel) {
        return environmentPanel.variableValue;
    }

    static void mav$chooseMacro(EnvironmentPanel environmentPanel, JTextField jTextField) {
        environmentPanel.chooseMacro(jTextField);
    }

    public final class 7
    extends DefaultTableModel {
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public 7(Object[] objectArray, int n) {
            super(objectArray, n);
        }
    }

    public final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EnvironmentPanel.mav$updateButtons(EnvironmentPanel.this);
        }
    }

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            EnvironmentPanel.mav$addVariable(EnvironmentPanel.this);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            EnvironmentPanel.mav$editVariable(EnvironmentPanel.this);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            EnvironmentPanel.mav$removeVariable(EnvironmentPanel.this);
        }
    }

    public final class 2
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                EnvironmentPanel.mav$validateVariable(EnvironmentPanel.this, propertyChangeEvent);
            }
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            EnvironmentPanel.mav$chooseMacro(EnvironmentPanel.this, EnvironmentPanel.ra$variableValue(EnvironmentPanel.this));
        }
    }
}

