/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.validator;

import java.text.MessageFormat;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.validator.AntValidatorCallback;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class JavadocValidator
extends AntValidatorCallback {
    public boolean allRequiredAttributesHaveValue(Element element) {
        return this.hasDestDir(element) && this.hasSourcePath(element);
    }

    private boolean hasDestDir(Element element) {
        if (!this.hasChild(element, "doclet") && !this.hasAttribute(element, "doclet")) {
            return this.hasAttribute(element, "destdir");
        }
        return true;
    }

    private boolean hasSourcePath(Element element) {
        if (!(this.hasChild(element, "sourcepath") || this.hasChild(element, "fileset") || this.hasChild(element, "packageset"))) {
            return this.hasAttribute(element, "sourcepath") || this.hasAttribute(element, "sourcepathref") || this.hasAttribute(element, "sourcefiles");
        }
        return true;
    }

    public void validateElement(Element element, ErrorHandler errorHandler) {
        if (!this.hasDestDir(element)) {
            MessageFormat messageFormat = new MessageFormat(AntArb.getString(168));
            String string = messageFormat.format(new Object[]{element.getLocalName()});
            this.error(errorHandler, 0, string, element);
        }
        if (!this.hasSourcePath(element)) {
            MessageFormat messageFormat = new MessageFormat(AntArb.getString(169));
            String string = messageFormat.format(new Object[]{element.getLocalName()});
            this.error(errorHandler, 0, string, element);
        }
    }
}

