/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.validator;

import java.text.MessageFormat;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.validator.AntValidatorCallback;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class TypedefValidator
extends AntValidatorCallback {
    public boolean allRequiredAttributesHaveValue(Element element) {
        return this.hasName(element) && this.hasClassname(element);
    }

    private boolean hasFile(Element element) {
        return this.hasAttribute(element, "file") || this.hasAttribute(element, "resource");
    }

    private boolean hasName(Element element) {
        if (!this.hasFile(element)) {
            return this.hasAttribute(element, "name");
        }
        return true;
    }

    private boolean hasClassname(Element element) {
        if (!this.hasFile(element)) {
            return this.hasAttribute(element, "classname");
        }
        return true;
    }

    public void validateElement(Element element, ErrorHandler errorHandler) {
        boolean bl = this.hasName(element);
        if (!bl) {
            MessageFormat messageFormat = new MessageFormat(AntArb.getString(184));
            String string = messageFormat.format(new Object[]{element.getLocalName()});
            this.error(errorHandler, 0, string, element);
        }
        if (bl && !this.hasClassname(element)) {
            MessageFormat messageFormat = new MessageFormat(AntArb.getString(185));
            String string = messageFormat.format(new Object[]{element.getLocalName()});
            this.error(errorHandler, 0, string, element);
        }
    }
}

