/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.wizard;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.Target;
import oracle.jdeveloper.compiler.ant.AntConfiguration;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntBuildfileImpl;
import oracle.jdevimpl.ant.AntManagerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AntGenerator {
    private URL buildfile;
    private Project project;
    private Document document;
    private Element projectElement;
    private URL base;
    private boolean useProjectBuildfile;
    private URL propertyFile;

    public AntGenerator(URL uRL) {
        this(null, false, uRL, null);
    }

    public AntGenerator(Project project, boolean bl, URL uRL, URL uRL2) {
        this.project = project;
        this.useProjectBuildfile = bl;
        this.buildfile = uRL;
        this.propertyFile = uRL2;
    }

    public void generate(AntNode antNode) throws IOException {
        XmlModel xmlModel = antNode.getModel(this.project);
        xmlModel.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, IdeUtil.getIdeIanaEncoding(), null));
        try {
            xmlModel.startTransaction("Generate Ant buildfile");
            this.document = xmlModel.getDocument();
            if (this.project != null) {
                this.generateFromProject();
            } else {
                this.generateEmptyProject();
            }
            xmlModel.getDomModel().setUnspecifiedAttribute(this.document.getDocumentElement(), "http://www.w3.org/2000/xmlns/", "xmlns", "antlib:org.apache.tools.ant");
        }
        finally {
            try {
                xmlModel.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlModel.rollbackTransaction();
            }
            CommandProcessor.getInstance().flush((Object)antNode);
        }
        if (this.useProjectBuildfile) {
            this.setProjectBuildfile((Node)antNode);
        }
    }

    private void generateEmptyProject() throws IOException {
        this.projectElement = this.document.createElementNS("antlib:org.apache.tools.ant", "project");
        this.projectElement.setAttributeNS(null, "default", "init");
        this.document.appendChild(this.projectElement);
        AntBuildfileImpl antBuildfileImpl = new AntBuildfileImpl(this.buildfile, this.document);
        this.createInitTarget(antBuildfileImpl, false);
    }

    private void generateFromProject() throws IOException {
        AntBuildfileImpl antBuildfileImpl = new AntBuildfileImpl(this.buildfile, this.document);
        this.createHeader(antBuildfileImpl);
        this.createProject(antBuildfileImpl);
        this.createPropertyFile(antBuildfileImpl);
        this.createOracleHome(antBuildfileImpl);
        this.createOutputDir(antBuildfileImpl);
        this.createTargets(antBuildfileImpl);
        this.runGenerators(antBuildfileImpl);
        antBuildfileImpl.saveProperties(this.propertyFile);
    }

    private void runGenerators(AntBuildfile antBuildfile) {
        for (oracle.jdeveloper.ant.AntGenerator antGenerator : ((AntManagerImpl)AntManager.getAntManager()).getGenerators()) {
            antGenerator.generate(this.project, antBuildfile);
        }
    }

    private void createHeader(AntBuildfile antBuildfile) {
        this.createComment(this.document, AntArb.getString(16));
        String string = DateFormat.getDateTimeInstance().format(new Date());
        this.createComment(this.document, AntArb.format(17, string));
    }

    private void createProject(AntBuildfile antBuildfile) {
        String string = URLFileSystem.getName((URL)this.project.getURL());
        this.projectElement = this.document.createElementNS("antlib:org.apache.tools.ant", "project");
        this.projectElement.setAttributeNS(null, "name", string);
        this.projectElement.setAttributeNS(null, "default", "all");
        this.base = URLFileSystem.getParent((URL)this.project.getURL());
        String string2 = antBuildfile.getRelativePath(this.base);
        this.projectElement.setAttributeNS(null, "basedir", string2);
        this.document.appendChild(this.projectElement);
    }

    private void createPropertyFile(AntBuildfile antBuildfile) {
        Element element = this.document.createElementNS("antlib:org.apache.tools.ant", "property");
        element.setAttributeNS(null, "file", antBuildfile.getRelativePath(this.propertyFile));
        antBuildfile.appendBeforeTargets(element);
    }

    private void createOracleHome(AntBuildfile antBuildfile) {
        URL uRL;
        URL uRL2 = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        String string = URLFileSystem.toRelativeSpec((URL)uRL2, (URL)(uRL = URLFileSystem.getParent((URL)this.buildfile)), (boolean)false);
        if (string.equals(uRL2.getPath())) {
            string = URLFileSystem.getPlatformPathName((URL)uRL2);
        }
        antBuildfile.addGlobalProperty("oracle.home", string);
    }

    private void createOutputDir(AntBuildfile antBuildfile) {
        String string = antBuildfile.getRelativePath(JavaProject.getInstance(this.project).getOutputDirectory());
        antBuildfile.addGlobalProperty("output.dir", string);
    }

    private void createTargets(AntBuildfile antBuildfile) {
        this.createInitTarget(antBuildfile, true);
        antBuildfile.createTarget("all", "Build the project");
        this.createCleanTarget(antBuildfile);
    }

    private void createInitTarget(AntBuildfile antBuildfile, boolean bl) {
        Element element = antBuildfile.createTarget("init");
        Element element2 = this.document.createElementNS("antlib:org.apache.tools.ant", "tstamp");
        element.appendChild(element2);
        if (bl) {
            Element element3 = this.document.createElementNS("antlib:org.apache.tools.ant", "mkdir");
            element3.setAttributeNS(null, "dir", antBuildfile.createPropertyReference("output.dir"));
            element.appendChild(element3);
        }
    }

    private void createCleanTarget(AntBuildfile antBuildfile) {
        Element element = antBuildfile.createTarget("clean", "Clean the project");
        Element element2 = this.document.createElementNS("antlib:org.apache.tools.ant", "delete");
        element2.setAttributeNS(null, "includeemptydirs", "true");
        element2.setAttributeNS(null, "quiet", "true");
        Element element3 = this.document.createElementNS("antlib:org.apache.tools.ant", "fileset");
        element3.setAttributeNS(null, "dir", antBuildfile.createPropertyReference("output.dir"));
        element3.setAttributeNS(null, "includes", "**/*");
        element2.appendChild(element3);
        element.appendChild(element2);
    }

    private void createComment(org.w3c.dom.Node node, String string) {
        node.appendChild(this.document.createComment(string));
    }

    private void setProjectBuildfile(Node node) {
        AntConfiguration antConfiguration = AntConfiguration.getAntConfiguration((PropertyStorage)this.project);
        if (antConfiguration != null) {
            antConfiguration.setProjectBuildfile(node.getURL());
            antConfiguration.setMakeTarget("all");
            ArrayList<String> arrayList = new ArrayList<String>();
            AntContext antContext = AntManager.getAntManager().getAntContext(node.getURL(), this.project);
            if (antContext != null) {
                for (Target target : antContext.getTargets()) {
                    if (target.getDescription() == null) continue;
                    arrayList.add(target.getName());
                }
            }
            arrayList.trimToSize();
            Collections.sort(arrayList);
            antConfiguration.setTargetList(arrayList);
            this.project.markDirty(true);
        }
    }
}

