/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.BookmarkOptionsPanel;
import oracle.jdevimpl.bookmarks.GotoBookmarkPanel;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

public final class BookmarkAddin
implements ContextMenuListener,
Controller,
ShutdownHook,
Addin {
    private static String extensionID;
    private final IdeAction toggleBookmarkAction;
    private final JMenuItem toggleBookmarkMenuItem;
    private final JMenuItem toggleBookmarkPopupItem;
    private final IdeAction gotoBookmarkAction;
    private final JMenuItem gotoBookmarkMenuItem;
    private final IdeAction nextBookmarkAction;
    private final JMenuItem nextBookmarkMenuItem;
    private final IdeAction previousBookmarkAction;
    private final JMenuItem previousBookmarkMenuItem;
    private final IdeAction removeBookmarksFromFileAction;
    private final JMenuItem removeBookmarksFromFileMenuItem;
    private final IdeAction removeAllBookmarksAction;
    private final JMenuItem removeAllBookmarksMenuItem;
    private final BookmarkManager bookmarkManager;

    public BookmarkAddin() {
        extensionID = AddinManager.getAddinManager().getExtensionForAddin((Addin)this).getID();
        this.bookmarkManager = new BookmarkManager();
        this.toggleBookmarkAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.ToggleBookmarkCommand"), null, (String)BookmarkArb.getString(5), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(6), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)7, null, (boolean)false);
        this.toggleBookmarkAction.addController((Controller)this);
        this.gotoBookmarkAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.GotoBookmarkCommand"), null, (String)BookmarkArb.getString(8), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(9), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)10, null, (boolean)true);
        this.gotoBookmarkAction.addController((Controller)this);
        this.nextBookmarkAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.NextBookmarkCommand"), null, (String)BookmarkArb.getString(11), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(12), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)13, null, (boolean)false);
        this.nextBookmarkAction.addController((Controller)this);
        this.previousBookmarkAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.PreviousBookmarkCommand"), null, (String)BookmarkArb.getString(14), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(15), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)16, null, (boolean)false);
        this.previousBookmarkAction.addController((Controller)this);
        this.removeBookmarksFromFileAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.RemoveBookmarksFromFileCommand"), null, (String)BookmarkArb.getString(17), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(18), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)19, null, (boolean)false);
        this.removeBookmarksFromFileAction.addController((Controller)this);
        this.removeAllBookmarksAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojb.RemoveAllBookmarksCommand"), null, (String)BookmarkArb.getString(20), (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)BookmarkArb.getInteger(21), (ArrayResourceBundle)BookmarkArb.getInstance(), (int)22, null, (boolean)true);
        this.removeAllBookmarksAction.addController((Controller)this);
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"Navigate");
        this.toggleBookmarkMenuItem = menubar.createMenuItem((ToggleAction)this.toggleBookmarkAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_TOGGLE_BOOKMARK);
        menubar.add((Component)this.toggleBookmarkMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_BOOKMARK);
        this.gotoBookmarkMenuItem = menubar.createMenuItem((ToggleAction)this.gotoBookmarkAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_BOOKMARK);
        menubar.add((Component)this.gotoBookmarkMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        this.nextBookmarkMenuItem = menubar.createMenuItem((ToggleAction)this.nextBookmarkAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_BOOKMARK);
        menubar.add((Component)this.nextBookmarkMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        this.previousBookmarkMenuItem = menubar.createMenuItem((ToggleAction)this.previousBookmarkAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_BOOKMARK);
        menubar.add((Component)this.previousBookmarkMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_BOOKMARK);
        this.removeBookmarksFromFileMenuItem = menubar.createMenuItem((ToggleAction)this.removeBookmarksFromFileAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_REMOVE_BOOKMARKS_FROM_FILE);
        menubar.add((Component)this.removeBookmarksFromFileMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_BOOKMARK);
        this.removeAllBookmarksMenuItem = menubar.createMenuItem((ToggleAction)this.removeAllBookmarksAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_REMOVE_ALL_BOOKMARKS);
        menubar.add((Component)this.removeAllBookmarksMenuItem, jMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_BOOKMARK);
        this.toggleBookmarkPopupItem = menubar.createMenuItem((ToggleAction)this.toggleBookmarkAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_TOGGLE_BOOKMARK);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void initialize() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/bookmarks/accelerators.xml");
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)BookmarkAddin.getExtensionID());
        if (!clientSetting.hasData("BookmarkOptions")) {
            clientSetting.putData("BookmarkOptions", (Copyable)new BookmarkOptions());
        }
        String string = BookmarkArb.getString(30);
        Navigable navigable = new Navigable(string, BookmarkOptionsPanel.class);
        CodeEditorAddin codeEditorAddin = (CodeEditorAddin)AddinManager.getAddinManager().getAddin(CodeEditorAddin.class);
        if (codeEditorAddin != null) {
            Navigable navigable2 = codeEditorAddin.getEditorNavigable();
            navigable2.addChildNavigable(navigable);
        } else {
            ClientSetting.registerUI((Navigable)navigable);
        }
        BookmarkOptionsPanel.applyOptions((BookmarkOptions)clientSetting.getData("BookmarkOptions"));
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        this.bookmarkManager.shutdown();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == this.toggleBookmarkAction) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.toggleBookmark(codeEditor);
                this.update(this.gotoBookmarkAction, context);
                codeEditor.activate();
            } else if (view instanceof CodeEditorGutter.GutterView) {
                CodeEditor codeEditor = (CodeEditor)view.owner();
                int n = CodeEditorGutter.getLineForContext((Context)context);
                if (n != -1) {
                    this.bookmarkManager.toggleBookmark(codeEditor, n);
                    this.update(this.gotoBookmarkAction, context);
                }
            }
            return true;
        }
        if (ideAction == this.gotoBookmarkAction) {
            GotoBookmarkPanel.runDialog(this.bookmarkManager);
            this.update(this.gotoBookmarkAction, context);
            return true;
        }
        if (ideAction == this.nextBookmarkAction) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.gotoNextBookmark(codeEditor);
            }
            return true;
        }
        if (ideAction == this.previousBookmarkAction) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.gotoPreviousBookmark(codeEditor);
            }
            return true;
        }
        if (ideAction == this.removeBookmarksFromFileAction) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)view;
                this.bookmarkManager.removeAllBookmarks(codeEditor);
                this.update(this.gotoBookmarkAction, context);
            }
            return true;
        }
        if (ideAction == this.removeAllBookmarksAction) {
            this.bookmarkManager.removeAllBookmarks();
            this.update(this.gotoBookmarkAction, context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction == this.toggleBookmarkAction || ideAction == this.nextBookmarkAction || ideAction == this.previousBookmarkAction || ideAction == this.removeBookmarksFromFileAction) {
            CodeEditor codeEditor = null;
            View view = context.getView();
            if (view != null) {
                if (view instanceof CodeEditor) {
                    codeEditor = (CodeEditor)view;
                } else if (view instanceof CodeEditorGutter.GutterView) {
                    codeEditor = (CodeEditor)view.owner();
                }
            }
            if (codeEditor == null) {
                ideAction.setEnabled(false);
            } else if (ideAction == this.toggleBookmarkAction) {
                ideAction.setEnabled(true);
            } else if (ideAction == this.nextBookmarkAction) {
                ideAction.setEnabled(this.bookmarkManager.canGotoNextBookmark(codeEditor));
            } else if (ideAction == this.previousBookmarkAction) {
                ideAction.setEnabled(this.bookmarkManager.canGotoPreviousBookmark(codeEditor));
            } else if (ideAction == this.removeBookmarksFromFileAction) {
                ideAction.setEnabled(this.bookmarkManager.hasBookmarks(codeEditor));
            }
            return true;
        }
        if (ideAction == this.removeAllBookmarksAction) {
            ideAction.setEnabled(this.bookmarkManager.hasBookmarks());
            return true;
        }
        if (ideAction == this.gotoBookmarkAction) {
            ideAction.setEnabled(this.bookmarkManager.hasBookmarks());
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        int n;
        Context context = contextMenu.getContext();
        View view = context.getView();
        this.update(this.toggleBookmarkAction, context);
        if (!(view instanceof CodeEditor) && view instanceof CodeEditorGutter.GutterView && !CodeEditorGutter.isMarkDroppingDown((Context)context) && (n = CodeEditorGutter.getLineForContext((Context)context)) != -1) {
            contextMenu.add((Component)this.toggleBookmarkPopupItem, 2.0f);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    static String getExtensionID() {
        return extensionID;
    }
}

