/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkComparator;

public final class BookmarkList
implements Copyable {
    private List bookmarkList = new ArrayList();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.bookmarkList.size();
        stringBuffer.append("num bookmarks: " + n);
        stringBuffer.append("\n");
        int n2 = 0;
        while (n2 < n) {
            Bookmark bookmark = (Bookmark)this.bookmarkList.get(n2);
            stringBuffer.append(bookmark.toString());
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] getAllBookmarks() {
        Bookmark[] bookmarkArray;
        List list = this.bookmarkList;
        synchronized (list) {
            int n = this.bookmarkList.size();
            bookmarkArray = this.bookmarkList.toArray(new Bookmark[n]);
        }
        return bookmarkArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBookmarkCount() {
        List list = this.bookmarkList;
        synchronized (list) {
            int n = this.bookmarkList.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getNextBookmark(URL uRL, int n, boolean bl) {
        Bookmark bookmark = null;
        List list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator bookmarkComparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> list2 = this.bookmarkList;
            if (bl) {
                Bookmark[] bookmarkArray = this.findBookmarks(uRL);
                list2 = Arrays.asList(bookmarkArray);
            }
            int n2 = 0;
            Bookmark bookmark2 = new Bookmark(uRL, n);
            int n3 = list2.size();
            int n4 = 0;
            while (n4 < n3) {
                Bookmark bookmark3 = list2.get(n4);
                if (bookmarkComparator.compare(bookmark2, bookmark3) < 0) {
                    n2 = n4;
                    break;
                }
                ++n4;
            }
            if (n3 > 0) {
                bookmark = list2.get(n2);
            }
        }
        return bookmark;
    }

    public Bookmark getNextBookmark(Bookmark bookmark, boolean bl) {
        return this.getNextBookmark(bookmark.getURL(), bookmark.getLine(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark getPreviousBookmark(URL uRL, int n, boolean bl) {
        Bookmark bookmark = null;
        List list = this.bookmarkList;
        synchronized (list) {
            BookmarkComparator bookmarkComparator = BookmarkComparator.BOOKMARK_COMPARATOR;
            List<Bookmark> list2 = this.bookmarkList;
            if (bl) {
                Bookmark[] bookmarkArray = this.findBookmarks(uRL);
                list2 = Arrays.asList(bookmarkArray);
            }
            int n2 = list2.size();
            int n3 = n2 - 1;
            Bookmark bookmark2 = new Bookmark(uRL, n);
            int n4 = n3;
            while (n4 >= 0) {
                Bookmark bookmark3 = list2.get(n4);
                if (bookmarkComparator.compare(bookmark2, bookmark3) > 0) {
                    n3 = n4;
                    break;
                }
                --n4;
            }
            if (n2 > 0) {
                bookmark = list2.get(n3);
            }
        }
        return bookmark;
    }

    public Bookmark getPreviousBookmark(Bookmark bookmark, boolean bl) {
        return this.getPreviousBookmark(bookmark.getURL(), bookmark.getLine(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark[] findBookmarks(URL uRL) {
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        List list = this.bookmarkList;
        synchronized (list) {
            int n = this.bookmarkList.size();
            int n2 = 0;
            while (n2 < n) {
                Bookmark bookmark = (Bookmark)this.bookmarkList.get(n2);
                if (bookmark.matches(uRL)) {
                    arrayList.add(bookmark);
                }
                ++n2;
            }
        }
        int n = arrayList.size();
        return arrayList.toArray(new Bookmark[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark findBookmark(URL uRL, int n) {
        Bookmark bookmark = null;
        List list = this.bookmarkList;
        synchronized (list) {
            int n2 = this.bookmarkList.size();
            int n3 = 0;
            while (n3 < n2) {
                Bookmark bookmark2 = (Bookmark)this.bookmarkList.get(n3);
                if (bookmark2.matches(uRL, n)) {
                    bookmark = bookmark2;
                    break;
                }
                ++n3;
            }
        }
        return bookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bookmark addBookmark(URL uRL, int n) {
        Bookmark bookmark = this.findBookmark(uRL, n);
        if (bookmark != null) {
            return bookmark;
        }
        Bookmark bookmark2 = new Bookmark(uRL, n);
        List list = this.bookmarkList;
        synchronized (list) {
            this.insertBookmark(bookmark2);
        }
        return bookmark2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyBookmark(Bookmark bookmark, int n) {
        boolean bl;
        if (bookmark.getLine() == n) {
            return true;
        }
        List list = this.bookmarkList;
        synchronized (list) {
            this.removeBookmark(bookmark);
            bookmark.setLine(n);
            bl = this.insertBookmark(bookmark);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBookmark(Bookmark bookmark) {
        List list = this.bookmarkList;
        synchronized (list) {
            int n = this.bookmarkList.indexOf(bookmark);
            if (n != -1) {
                this.bookmarkList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBookmarks() {
        List list = this.bookmarkList;
        synchronized (list) {
            this.bookmarkList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertBookmark(Bookmark bookmark) {
        BookmarkComparator bookmarkComparator = BookmarkComparator.BOOKMARK_COMPARATOR;
        boolean bl = true;
        List list = this.bookmarkList;
        synchronized (list) {
            boolean bl2 = false;
            int n = this.bookmarkList.size();
            int n2 = 0;
            while (n2 < n) {
                Bookmark bookmark2 = (Bookmark)this.bookmarkList.get(n2);
                int n3 = bookmarkComparator.compare(bookmark, bookmark2);
                if (n3 < 0) {
                    this.bookmarkList.add(n2, bookmark);
                    bl2 = true;
                    break;
                }
                if (n3 == 0) {
                    bl2 = true;
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                this.bookmarkList.add(bookmark);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object copyTo(Object object) {
        BookmarkList bookmarkList = object != null ? (BookmarkList)object : new BookmarkList();
        List list = bookmarkList.bookmarkList;
        synchronized (list) {
            bookmarkList.bookmarkList.clear();
            bookmarkList.bookmarkList.addAll(this.bookmarkList);
        }
        return bookmarkList;
    }

    public List getBookmarkList() {
        return this.bookmarkList;
    }

    public void setBookmarkList(List list) {
        this.bookmarkList = list;
    }
}

