/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DTCache;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkAddin;
import oracle.jdevimpl.bookmarks.BookmarkList;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.OpenBookmark;
import oracle.jdevimpl.bookmarks.OpenEditor;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

final class BookmarkManager
implements GutterColumnListener,
EditorListener {
    private static final int VERY_BIG_LINE = 2000000000;
    private static Icon bookmarkIcon;
    private static final HighlightStyle bookmarkStyle;
    private static final String BOOKMARK_STYLE = "bookmark-style";
    private static final String BOOKMARK_COLUMN = "bookmark-column";
    private static final String BOOKMARKLIST_KEY = "ojb.BookmarkList";
    private BookmarkList bookmarkList;
    private List openEditorList;

    BookmarkManager() {
        this.$init$();
        this.startup();
    }

    private void startup() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.addEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.loadBookmarksFromStorage();
        }
    }

    void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.removeEditorListener((EditorListener)this);
        if (this.shouldRemoveBookmarksWhenShutdown()) {
            this.clearBookmarksFromStorage();
        } else {
            this.saveBookmarksToStorage();
        }
    }

    void toggleBookmark(CodeEditor codeEditor) {
        int n = codeEditor.getCaretLine();
        this.toggleBookmark(codeEditor, n);
    }

    void toggleBookmark(CodeEditor codeEditor, int n) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return;
        }
        Bookmark bookmark = this.bookmarkList.findBookmark(uRL, n);
        if (bookmark == null) {
            this.createBookmarkFor(uRL, n);
        } else {
            this.removeBookmark(bookmark);
        }
    }

    boolean hasBookmarks() {
        return this.bookmarkList.getBookmarkCount() != 0;
    }

    boolean hasBookmarks(CodeEditor codeEditor) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return false;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(uRL, 0, true);
        return bookmark != null;
    }

    Bookmark[] getAllBookmarks() {
        return this.bookmarkList.getAllBookmarks();
    }

    static {
        EditorProperties editorProperties = EditorProperties.getProperties();
        HighlightRegistry highlightRegistry = editorProperties.getHighlightRegistry();
        String string = BookmarkArb.getString(1);
        bookmarkStyle = highlightRegistry.createStyle(BOOKMARK_STYLE, string, 20, Color.black, new Color(153, 255, 255));
        FileOverviewMargin.setMarkColor((String)BOOKMARK_COLUMN, (HighlightStyle)bookmarkStyle);
    }

    boolean canGotoNextBookmark(CodeEditor codeEditor) {
        return this.gotoNextBookmark(codeEditor, false);
    }

    void gotoNextBookmark(CodeEditor codeEditor) {
        this.gotoNextBookmark(codeEditor, true);
    }

    boolean gotoNextBookmark(CodeEditor codeEditor, boolean bl) {
        boolean bl2 = this.shouldOnlyTraverseCurrent();
        boolean bl3 = this.shouldOnlyTraverseOpen();
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return false;
        }
        int n = codeEditor.getCaretLine();
        Bookmark bookmark = this.bookmarkList.getNextBookmark(uRL, n, bl2);
        if (bl3) {
            Bookmark bookmark2 = bookmark;
            while (bookmark != null) {
                URL uRL2 = bookmark.getURL();
                if (this.hasOpenEditorsFor(uRL2)) break;
                int n2 = Math.max(bookmark.getLine() + 1, 2000000000);
                if ((bookmark = this.bookmarkList.getNextBookmark(uRL2, n2, false)) != bookmark2) continue;
                bookmark = null;
            }
        }
        if (bookmark != null) {
            if (bl) {
                this.gotoBookmark(bookmark);
            }
            return true;
        }
        return false;
    }

    boolean canGotoPreviousBookmark(CodeEditor codeEditor) {
        return this.gotoPreviousBookmark(codeEditor, false);
    }

    void gotoPreviousBookmark(CodeEditor codeEditor) {
        this.gotoPreviousBookmark(codeEditor, true);
    }

    boolean gotoPreviousBookmark(CodeEditor codeEditor, boolean bl) {
        boolean bl2 = this.shouldOnlyTraverseCurrent();
        boolean bl3 = this.shouldOnlyTraverseOpen();
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return false;
        }
        int n = codeEditor.getCaretLine();
        Bookmark bookmark = this.bookmarkList.getPreviousBookmark(uRL, n, bl2);
        if (bl3) {
            Bookmark bookmark2 = bookmark;
            while (bookmark != null) {
                URL uRL2 = bookmark.getURL();
                if (this.hasOpenEditorsFor(uRL2)) break;
                bookmark = this.bookmarkList.getPreviousBookmark(uRL2, 1, false);
                if (bookmark != bookmark2) continue;
                bookmark = null;
            }
        }
        if (bookmark != null) {
            if (bl) {
                this.gotoBookmark(bookmark);
            }
            return true;
        }
        return false;
    }

    void gotoBookmark(Bookmark bookmark) {
        Workspace workspace = Ide.getActiveWorkspace();
        Project project = Ide.getActiveProject();
        Context context = new Context(workspace, project);
        URL uRL = bookmark.getURL();
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            context.setNode(node);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, CodeEditor.class);
            EditorManager editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager.openEditor(openEditorOptions);
            if (editor instanceof CodeEditor) {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                Context context2 = editor.getContext();
                LineNavigationPoint lineNavigationPoint = new LineNavigationPoint(context2, bookmark.getLine(), 1, false);
                navigationManager.navigateTo((NavigationPoint)lineNavigationPoint);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void removeAllBookmarks() {
        Bookmark[] bookmarkArray = this.getAllBookmarks();
        int n = bookmarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.removeBookmark(bookmarkArray[n2]);
            ++n2;
        }
    }

    void removeAllBookmarks(CodeEditor codeEditor) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return;
        }
        Bookmark bookmark = this.bookmarkList.getNextBookmark(uRL, 0, true);
        while (bookmark != null) {
            this.removeBookmark(bookmark);
            bookmark = this.bookmarkList.getNextBookmark(uRL, 0, true);
        }
    }

    void removeBookmark(Bookmark bookmark) {
        this.bookmarkList.removeBookmark(bookmark);
        OpenBookmark[] openBookmarkArray = this.getOpenBookmarksFor(bookmark);
        int n = openBookmarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            OpenBookmark openBookmark = openBookmarkArray[n2];
            OpenEditor openEditor = this.getOpenEditorFor(openBookmark);
            if (openEditor != null) {
                openEditor.openBookmarkList.remove(openBookmark);
                openBookmark.guttermark.getGutterColumn().removeGutterMark(openBookmark.guttermark);
            }
            ++n2;
        }
    }

    void $init$() {
        this.bookmarkList = new BookmarkList();
        this.openEditorList = new ArrayList();
    }

    private static Icon getBookmarkIcon() {
        if (bookmarkIcon == null) {
            bookmarkIcon = BookmarkArb.getIcon(0);
        }
        return bookmarkIcon;
    }

    private void clearBookmarksFromStorage() {
        BookmarkList bookmarkList = new BookmarkList();
        DTCache dTCache = Ide.getDTCache();
        dTCache.putData(BOOKMARKLIST_KEY, (Copyable)bookmarkList);
    }

    private void createBookmarkFor(URL uRL, int n) {
        Bookmark bookmark = this.bookmarkList.addBookmark(uRL, n);
        OpenEditor[] openEditorArray = this.getOpenEditorsFor(uRL);
        int n2 = openEditorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            OpenEditor openEditor = openEditorArray[n3];
            this.createGutterColumnFor(openEditor.editor);
            OpenBookmark openBookmark = this.createOpenBookmarkFor(openEditor.gutter, bookmark);
            openEditor.openBookmarkList.add(openBookmark);
            ++n3;
        }
    }

    private boolean isBookmarkOnOpenList(Bookmark bookmark) {
        URL uRL = bookmark.getURL();
        return this.hasOpenEditorsFor(uRL);
    }

    private void loadBookmarksFromStorage() {
        DTCache dTCache = Ide.getDTCache();
        BookmarkList bookmarkList = (BookmarkList)dTCache.getData(BOOKMARKLIST_KEY);
        if (bookmarkList != null) {
            bookmarkList.copyTo(this.bookmarkList);
        }
    }

    private void saveBookmarksToStorage() {
        BookmarkList bookmarkList = (BookmarkList)this.bookmarkList.copyTo(null);
        DTCache dTCache = Ide.getDTCache();
        dTCache.putData(BOOKMARKLIST_KEY, (Copyable)bookmarkList);
    }

    private BookmarkOptions getBookmarkOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)BookmarkAddin.getExtensionID());
        BookmarkOptions bookmarkOptions = (BookmarkOptions)clientSetting.getData("BookmarkOptions");
        if (bookmarkOptions == null) {
            bookmarkOptions = new BookmarkOptions();
        }
        return bookmarkOptions;
    }

    private boolean shouldOnlyTraverseCurrent() {
        int n = this.getBookmarkOptions().getTraverseBehavior();
        return n == 1;
    }

    private boolean shouldOnlyTraverseOpen() {
        int n = this.getBookmarkOptions().getTraverseBehavior();
        return n == 2;
    }

    private boolean shouldRemoveBookmarksWhenEditorClose() {
        return this.getBookmarkOptions().getDiscardOnClose();
    }

    private boolean shouldRemoveBookmarksWhenShutdown() {
        return this.getBookmarkOptions().getDiscardOnExit();
    }

    private boolean shouldRemoveBookmarkForNonExistentLine() {
        int n = this.getBookmarkOptions().getMissingLineBehavior();
        return n == 2;
    }

    private OpenBookmark getOpenBookmarkFor(GutterMark gutterMark) {
        CodeEditorGutter codeEditorGutter = (CodeEditorGutter)gutterMark.getGutter();
        OpenEditor openEditor = this.getOpenEditorFor(codeEditorGutter);
        List list = openEditor.openBookmarkList;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            OpenBookmark openBookmark = (OpenBookmark)list.get(n2);
            if (openBookmark.guttermark == gutterMark) {
                return openBookmark;
            }
            ++n2;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(CodeEditorGutter codeEditorGutter) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.gutter == codeEditorGutter) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    private OpenBookmark[] getOpenBookmarksFor(Bookmark bookmark) {
        ArrayList<OpenBookmark> arrayList = new ArrayList<OpenBookmark>();
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            OpenBookmark openBookmark = this.getOpenBookmarkFor(openEditor, bookmark);
            if (openBookmark != null) {
                arrayList.add(openBookmark);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new OpenBookmark[n3]);
    }

    private OpenBookmark getOpenBookmarkFor(OpenEditor openEditor, Bookmark bookmark) {
        List list = openEditor.openBookmarkList;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            OpenBookmark openBookmark = (OpenBookmark)list.get(n2);
            if (openBookmark.bookmark == bookmark) {
                return openBookmark;
            }
            ++n2;
        }
        return null;
    }

    private OpenEditor getOpenEditorFor(OpenBookmark openBookmark) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.openBookmarkList.contains(openBookmark)) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    private boolean hasOpenEditorsFor(URL uRL) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.url.equals(uRL)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private OpenEditor[] getOpenEditorsFor(URL uRL) {
        ArrayList<OpenEditor> arrayList = new ArrayList<OpenEditor>();
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.url.equals(uRL)) {
                arrayList.add(openEditor);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        return arrayList.toArray(new OpenEditor[n3]);
    }

    private OpenEditor getOpenEditorFor(CodeEditor codeEditor) {
        int n = this.openEditorList.size();
        int n2 = 0;
        while (n2 < n) {
            OpenEditor openEditor = (OpenEditor)this.openEditorList.get(n2);
            if (openEditor.editor == codeEditor) {
                return openEditor;
            }
            ++n2;
        }
        return null;
    }

    private URL getURLFor(CodeEditor codeEditor) {
        Node node;
        Context context;
        if (codeEditor != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
            return node.getURL();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Bookmark[] getNormalizedBookmarksFor(CodeEditor var1_1, URL var2_2) {
        var3_3 = new ArrayList<Bookmark>();
        var4_4 = this.bookmarkList.findBookmarks(var2_2);
        var5_5 = var4_4.length;
        var6_6 = var1_1.getLineCount();
        var7_7 = 0;
        while (var7_7 < var5_5) {
            var8_8 = var4_4[var7_7];
            v0 = var9_9 = var8_8.getLine() > var6_6;
            if (!var9_9) ** GOTO lbl-1000
            if (this.isBookmarkOnOpenList(var8_8)) {
                throw new IllegalStateException("bad line open elsewhere");
            }
            var10_10 = this.shouldRemoveBookmarkForNonExistentLine();
            if (!var10_10 && !(var11_11 = this.bookmarkList.modifyBookmark(var8_8, var6_6))) {
                var10_10 = true;
            }
            if (var10_10) {
                this.bookmarkList.removeBookmark(var8_8);
                var4_4[var7_7] = null;
            } else lbl-1000:
            // 2 sources

            {
                var3_3.add(var8_8);
            }
            ++var7_7;
        }
        var12_12 = var3_3.size();
        return var3_3.toArray(new Bookmark[var12_12]);
    }

    private void createGutterColumnFor(CodeEditor codeEditor) {
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        if (codeEditorGutter.lookupGutterColumn(BOOKMARK_COLUMN) == null) {
            codeEditorGutter.createGutterColumn(BOOKMARK_COLUMN, (GutterColumnListener)this);
        }
    }

    private void removeGutterColumnFrom(CodeEditor codeEditor) {
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(BOOKMARK_COLUMN);
        if (gutterColumn != null) {
            codeEditorGutter.removeGutterColumn(gutterColumn);
        }
    }

    private OpenBookmark createOpenBookmarkFor(CodeEditorGutter codeEditorGutter, Bookmark bookmark) {
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(BOOKMARK_COLUMN);
        GutterMark gutterMark = gutterColumn.addGutterMark(bookmark.getLine(), BookmarkManager.getBookmarkIcon(), bookmarkStyle, 2000, 5);
        OpenBookmark openBookmark = new OpenBookmark(bookmark, gutterMark);
        return openBookmark;
    }

    private OpenEditor createOpenEditorFor(CodeEditor codeEditor) {
        URL uRL = this.getURLFor(codeEditor);
        if (uRL == null) {
            return null;
        }
        Bookmark[] bookmarkArray = this.getNormalizedBookmarksFor(codeEditor, uRL);
        int n = bookmarkArray.length;
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        ArrayList<OpenBookmark> arrayList = new ArrayList<OpenBookmark>();
        if (n > 0) {
            this.createGutterColumnFor(codeEditor);
            int n2 = 0;
            while (n2 < n) {
                Bookmark bookmark = bookmarkArray[n2];
                OpenBookmark openBookmark = this.createOpenBookmarkFor(codeEditorGutter, bookmark);
                arrayList.add(openBookmark);
                ++n2;
            }
        }
        OpenEditor openEditor = new OpenEditor(codeEditor, uRL, codeEditorGutter, arrayList);
        return openEditor;
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.createOpenEditorFor(codeEditor);
            this.openEditorList.add(openEditor);
        }
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            OpenEditor[] openEditorArray;
            URL uRL;
            CodeEditor codeEditor = (CodeEditor)editor;
            OpenEditor openEditor = this.getOpenEditorFor(codeEditor);
            this.removeGutterColumnFrom(codeEditor);
            this.openEditorList.remove(openEditor);
            if (this.shouldRemoveBookmarksWhenEditorClose() && (uRL = this.getURLFor(codeEditor)) != null && (openEditorArray = this.getOpenEditorsFor(uRL)).length == 0) {
                List list = openEditor.openBookmarkList;
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    OpenBookmark openBookmark = (OpenBookmark)list.get(n2);
                    Bookmark bookmark = openBookmark.bookmark;
                    this.removeBookmark(bookmark);
                    ++n2;
                }
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
        Bookmark bookmark;
        boolean bl;
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null && !(bl = this.bookmarkList.modifyBookmark(bookmark = openBookmark.bookmark, n2))) {
            this.removeBookmark(bookmark);
        }
    }

    public void markRemoved(GutterMark gutterMark, int n) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            this.removeBookmark(bookmark);
        }
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
        this.markRemoved(gutterMark, n);
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        OpenBookmark openBookmark = this.getOpenBookmarkFor(gutterMark);
        if (openBookmark != null) {
            Bookmark bookmark = openBookmark.bookmark;
            return BookmarkArb.format(2, Integer.toString(bookmark.getLine()));
        }
        return null;
    }
}

