/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.Ide;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.bookmarks.BookmarkOptions;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

public final class BookmarkOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_discardClose;
    private JCheckBox checkbox_discardExit;
    private JRadioButton radio_traverseCurrent;
    private JRadioButton radio_traverseOpen;
    private JRadioButton radio_traverseAll;
    private JRadioButton radio_missingMove;
    private JRadioButton radio_missingDiscard;

    public BookmarkOptionsPanel() {
        this.setHelpID("f1_idedidesetbookmarks_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        BookmarkOptions bookmarkOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(bookmarkOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        BookmarkOptions bookmarkOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(bookmarkOptions);
    }

    private BookmarkOptions findOptions(TraversableContext traversableContext) {
        BookmarkOptions bookmarkOptions = (BookmarkOptions)traversableContext.find("BookmarkOptions");
        return bookmarkOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        BookmarkOptions bookmarkOptions = this.findOptions(traversableContext);
        BookmarkOptionsPanel.applyOptions(bookmarkOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(BookmarkOptions bookmarkOptions) {
    }

    void loadSettingsFrom(BookmarkOptions bookmarkOptions) {
        boolean bl = bookmarkOptions.getDiscardOnClose();
        boolean bl2 = bookmarkOptions.getDiscardOnExit();
        int n = bookmarkOptions.getTraverseBehavior();
        int n2 = bookmarkOptions.getMissingLineBehavior();
        this.checkbox_discardClose.setSelected(bl);
        this.checkbox_discardExit.setSelected(bl2);
        switch (n) {
            case 1: {
                this.radio_traverseCurrent.setSelected(true);
                break;
            }
            case 2: {
                this.radio_traverseOpen.setSelected(true);
                break;
            }
            case 3: {
                this.radio_traverseAll.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("behavior: " + n);
            }
        }
        switch (n2) {
            case 1: {
                this.radio_missingMove.setSelected(true);
                break;
            }
            case 2: {
                this.radio_missingDiscard.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("behavior: " + n2);
            }
        }
    }

    void saveSettingsTo(BookmarkOptions bookmarkOptions) throws TraversalException {
        boolean bl = this.checkbox_discardClose.isSelected();
        boolean bl2 = this.checkbox_discardExit.isSelected();
        int n = 1;
        if (this.radio_traverseOpen.isSelected()) {
            n = 2;
        } else if (this.radio_traverseAll.isSelected()) {
            n = 3;
        }
        int n2 = 1;
        if (this.radio_missingDiscard.isSelected()) {
            n2 = 2;
        }
        bookmarkOptions.setDiscardOnClose(bl);
        bookmarkOptions.setDiscardOnExit(bl2);
        bookmarkOptions.setTraverseBehavior(n);
        bookmarkOptions.setMissingLineBehavior(n2);
    }

    private void initializeComponent() {
        String string = BookmarkArb.getString(31);
        this.checkbox_discardClose = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_discardClose, (String)string);
        String string2 = BookmarkArb.format(32, Ide.getProgramShortName());
        this.checkbox_discardExit = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_discardExit, (String)string2);
        String string3 = BookmarkArb.getString(33);
        JLabel jLabel = new JLabel(string3);
        String string4 = BookmarkArb.getString(34);
        String string5 = BookmarkArb.getString(35);
        String string6 = BookmarkArb.getString(36);
        this.radio_traverseCurrent = new JRadioButton();
        this.radio_traverseOpen = new JRadioButton();
        this.radio_traverseAll = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_traverseCurrent, (String)string4);
        ResourceUtils.resButton((AbstractButton)this.radio_traverseOpen, (String)string5);
        ResourceUtils.resButton((AbstractButton)this.radio_traverseAll, (String)string6);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radio_traverseCurrent);
        buttonGroup.add(this.radio_traverseOpen);
        buttonGroup.add(this.radio_traverseAll);
        String string7 = BookmarkArb.getString(37);
        JLabel jLabel2 = new JLabel(string7);
        String string8 = BookmarkArb.getString(38);
        String string9 = BookmarkArb.getString(39);
        this.radio_missingMove = new JRadioButton();
        this.radio_missingDiscard = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_missingMove, (String)string8);
        ResourceUtils.resButton((AbstractButton)this.radio_missingDiscard, (String)string9);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radio_missingMove);
        buttonGroup2.add(this.radio_missingDiscard);
        Insets insets = new Insets(0, 30, 2, 5);
        Insets insets2 = new Insets(2, 5, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_discardClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_discardExit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insets2, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.radio_traverseCurrent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.radio_traverseOpen, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.radio_traverseAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 1, insets2, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

