/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.bookmarks;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.bookmarks.Bookmark;
import oracle.jdevimpl.bookmarks.BookmarkManager;
import oracle.jdevimpl.bookmarks.resource.BookmarkArb;

final class GotoBookmarkPanel
extends JPanel
implements MouseListener,
ListSelectionListener,
ActionListener {
    private BookmarkManager bookmarkManager;
    private GotoDialog gotoDialog;
    private DefaultListModel listModel;
    private JButton button_remove;
    private JButton button_removeAll;
    private JList list_bookmarks;

    static void runDialog(BookmarkManager bookmarkManager) {
        Object e;
        GotoBookmarkPanel gotoBookmarkPanel = new GotoBookmarkPanel(bookmarkManager);
        HelpSystem.getHelpSystem().registerTopic((JComponent)gotoBookmarkPanel, "f1_idedgotobookmark_html");
        JList jList = gotoBookmarkPanel.list_bookmarks;
        String string = BookmarkArb.getString(23);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        GotoDialog gotoDialog = new GotoDialog((Frame)ideMainWindow, gotoBookmarkPanel, jList, string, null);
        gotoBookmarkPanel.setGotoDialog(gotoDialog);
        boolean bl = WizardLauncher.runDialog((JDialog)((Object)gotoDialog));
        if (bl && (e = gotoBookmarkPanel.list_bookmarks.getSelectedValue()) != null && e instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)e;
            bookmarkManager.gotoBookmark(bookmark);
        }
    }

    private GotoBookmarkPanel(BookmarkManager bookmarkManager) {
        super(new GridBagLayout());
        this.bookmarkManager = bookmarkManager;
        this.initializePanel();
    }

    private void setGotoDialog(GotoDialog gotoDialog) {
        this.gotoDialog = gotoDialog;
        this.updateButtonStatus();
    }

    private DefaultListModel createListModel(Object[] objectArray) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(objectArray[n2]);
            ++n2;
        }
        return defaultListModel;
    }

    private void initializePanel() {
        String string = BookmarkArb.getString(24);
        this.button_remove = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_remove, (String)string);
        this.button_remove.addActionListener(this);
        String string2 = BookmarkArb.getString(25);
        this.button_removeAll = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_removeAll, (String)string2);
        this.button_removeAll.addActionListener(this);
        String string3 = BookmarkArb.getString(28);
        JLabel jLabel = new JLabel();
        Object[] objectArray = this.bookmarkManager.getAllBookmarks();
        this.listModel = this.createListModel(objectArray);
        this.list_bookmarks = new JList(this.listModel);
        this.list_bookmarks.setCellRenderer(new Renderer(null));
        this.list_bookmarks.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.list_bookmarks, (String)string3);
        JScrollPane jScrollPane = new JScrollPane(this.list_bookmarks);
        if (this.listModel.size() > 0) {
            this.list_bookmarks.setSelectedIndex(0);
        }
        this.list_bookmarks.addListSelectionListener(this);
        this.list_bookmarks.addMouseListener(this);
        Insets insets = new Insets(0, 0, 3, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, insets, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 8), 0, 0);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.button_remove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(8, 0, 3, 0), 0, 0);
        this.add((Component)this.button_removeAll, gridBagConstraints);
    }

    private void updateButtonStatus() {
        Object e = this.list_bookmarks.getSelectedValue();
        boolean bl = e == null ^ true;
        this.button_remove.setEnabled(bl);
        this.gotoDialog.setOKButtonEnabled(bl);
        boolean bl2 = this.listModel.size() > 0;
        this.button_removeAll.setEnabled(bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button_remove) {
            int n;
            int n2 = this.list_bookmarks.getSelectedIndex();
            Object e = this.list_bookmarks.getSelectedValue();
            if (e != null && e instanceof Bookmark) {
                Bookmark bookmark = (Bookmark)e;
                this.bookmarkManager.removeBookmark(bookmark);
                this.listModel.removeElement(bookmark);
            }
            if ((n = this.listModel.size()) > 0) {
                n2 = Math.min(n2, n - 1);
                this.list_bookmarks.setSelectedIndex(n2);
            }
        } else if (object == this.button_removeAll) {
            this.bookmarkManager.removeAllBookmarks();
            this.listModel.removeAllElements();
        }
        this.updateButtonStatus();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtonStatus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            GotoDialog.mav$pressOK(this.gotoDialog);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private static final class Renderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            Bookmark bookmark = (Bookmark)object;
            if (bookmark != null) {
                URL uRL = bookmark.getURL();
                String string2 = URLFileSystem.getFileName((URL)uRL);
                String string3 = String.valueOf(bookmark.getLine());
                string = BookmarkArb.format(29, string2, string3);
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }

        private Renderer() {
        }

        Renderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class GotoDialog
    extends JEWTDialog {
        private GotoDialog(Frame frame, Component component, Component component2, String string) {
            super(frame, string, 7);
            this.setContent(component);
            if (component2 != null) {
                this.setInitialFocus(component2);
            }
            String string2 = BookmarkArb.getString(27);
            int n = StringUtils.getMnemonicKeyCode((String)string2);
            string2 = StringUtils.stripMnemonic((String)string2);
            this.setOKButtonText(string2);
            this.setOKButtonMnemonic(n);
            String string3 = BookmarkArb.getString(26);
            int n2 = StringUtils.getMnemonicKeyCode((String)string3);
            string3 = StringUtils.stripMnemonic((String)string3);
            this.setCancelButtonText(string3);
            this.setCancelButtonMnemonic(n2);
        }

        private void pressOK() {
            super.dismissDialog(false);
        }

        static void mav$pressOK(GotoDialog gotoDialog) {
            gotoDialog.pressOK();
        }

        GotoDialog(Frame frame, Component component, Component component2, String string, 1 var5_5) {
            this(frame, component, component2, string);
        }

        public final class 1 {
        }
    }
}

