/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cmt.CmtProperty;
import oracle.jdeveloper.cmt.CmtPropertyState;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdevimpl.cmtimpl.Res;

final class JbEventChooserPanel
extends JPanel
implements VetoableChangeListener {
    private CmtPropertyState state;
    private PropertyChangeSupport support;
    private String value;
    private JLabel promptLabel;
    private JLabel scopeLabel;
    private JTextField valueText;
    private JLabel argsLabel;
    private JLabel closeBraceLabel;
    private JLabel sampleLabel;
    private JTextPane sampleArea;
    private GridBagLayout mainLayout;

    void $init$() {
        this.support = new PropertyChangeSupport(this);
        this.promptLabel = new JLabel();
        this.scopeLabel = new JLabel();
        this.valueText = new JTextField();
        this.argsLabel = new JLabel();
        this.closeBraceLabel = new JLabel();
        this.sampleLabel = new JLabel();
        this.sampleArea = new JTextPane();
        this.mainLayout = new GridBagLayout();
    }

    public JbEventChooserPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guieventeditor_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setPropertyState(CmtPropertyState cmtPropertyState) {
        String string = null;
        this.state = cmtPropertyState;
        if (cmtPropertyState != null) {
            this.value = (String)cmtPropertyState.getValue();
            String string2 = string = this.value != null ? this.value.trim() : null;
            if (string == null || string.length() == 0) {
                CmtSubcomponent cmtSubcomponent = cmtPropertyState.getSubcomponent();
                CmtProperty cmtProperty = cmtPropertyState.getProperty();
                string = cmtSubcomponent != null && cmtProperty != null ? cmtSubcomponent.getName() + "_" + cmtProperty.getName() : "stub";
            }
        } else {
            this.value = null;
        }
        this.valueText.setText(string);
        this.valueText.selectAll();
        this.updateSample(null);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("closed".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            String string = this.valueText.getText().trim();
            if (string.length() > 0 && !IdeUtil.isJavaIdentifier((String)string)) {
                JOptionPane.showMessageDialog(this, Res.getString(54), Res.getString(48), 0);
                throw new PropertyVetoException(string, propertyChangeEvent);
            }
            this.support.firePropertyChange(null, this.value, string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.promptLabel.setText(Res.getString(52));
        ResourceUtils.resLabel((JLabel)this.scopeLabel, (Component)this.valueText, (String)"&void");
        this.valueText.setText("stub");
        this.valueText.addKeyListener(new 1());
        this.argsLabel.setText("(...) {");
        this.closeBraceLabel.setText("}");
        this.sampleLabel.setText(Res.getString(53));
        this.sampleArea.setEditable(false);
        this.sampleArea.setEnabled(false);
        this.sampleArea.setRequestFocusEnabled(false);
        this.sampleArea.setBackground(SystemColor.window);
        this.sampleArea.setEditorKit(new HTMLEditorKit());
        FontMetrics fontMetrics = this.sampleArea.getFontMetrics(this.sampleArea.getFont());
        int n = (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent()) * 5;
        Dimension dimension = this.sampleArea.getMinimumSize();
        this.add((Component)this.promptLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.scopeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.valueText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 2, 0, 0), 0, 0));
        this.add((Component)this.argsLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 2, 0, 5), 0, 0));
        this.add((Component)this.closeBraceLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.sampleLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.sampleArea, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, n));
    }

    private void updateSample(KeyEvent keyEvent) {
        String string = this.valueText.getText().trim();
        if (string.length() == 0) {
            this.sampleArea.setText("<html><head></head><body><br>" + Res.getString(55) + "<br></body></html>");
        } else {
            StringBuffer stringBuffer = new StringBuffer("<html><head></head><body>public void ");
            stringBuffer.append(this.state.getProperty().getName());
            stringBuffer.append("(...) {<br>&nbsp&nbsp<B>");
            stringBuffer.append(this.valueText.getText());
            stringBuffer.append("</B>(...);<br>}</body></html>");
            this.sampleArea.setText(stringBuffer.toString());
        }
    }

    static void mav$updateSample(JbEventChooserPanel jbEventChooserPanel, KeyEvent keyEvent) {
        jbEventChooserPanel.updateSample(keyEvent);
    }

    final class 1
    extends KeyAdapter {
        public void keyReleased(KeyEvent keyEvent) {
            JbEventChooserPanel.mav$updateSample(JbEventChooserPanel.this, keyEvent);
        }
    }
}

