/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Element;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSelectionEvent;
import oracle.jdeveloper.cmt.CmtSelectionListener;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdevimpl.cmtimpl.JbComponent;

public final class JbSelectionModel
implements CmtSelectionModel {
    private ArrayList selection;
    private ArrayList listeners;
    private JbComponent owner;
    private boolean stale;

    void $init$() {
        this.selection = new ArrayList();
        this.listeners = new ArrayList();
    }

    public JbSelectionModel(JbComponent jbComponent) {
        this.$init$();
        this.owner = jbComponent;
    }

    public boolean isSelected(CmtModelNode cmtModelNode) {
        this.refresh();
        return cmtModelNode != null && this.selection.contains(cmtModelNode);
    }

    public int getSelectionCount() {
        this.refresh();
        return this.selection.size();
    }

    public CmtModelNode[] getSelection() {
        this.refresh();
        CmtModelNode[] cmtModelNodeArray = new CmtModelNode[this.selection.size()];
        this.selection.toArray(cmtModelNodeArray);
        return cmtModelNodeArray;
    }

    public void clearSelection() {
        this.refresh();
        if (this.selection.size() > 0) {
            this.selection.clear();
            if (!this.stale) {
                this.owner.setLastDesignedNodes(null, null);
            }
            this.fireSelectionChanged(new CmtSelectionEvent((Object)this));
        }
    }

    public void setSelection(CmtModelNode[] cmtModelNodeArray) {
        this.refresh();
        boolean bl = false;
        if (cmtModelNodeArray != null) {
            if (cmtModelNodeArray.length == this.selection.size()) {
                int n = 0;
                while (n < cmtModelNodeArray.length) {
                    if (cmtModelNodeArray[n] != this.selection.get(n)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = true;
            }
        } else if (this.selection.size() > 0) {
            bl = true;
        }
        if (bl) {
            this.selection.clear();
            if (cmtModelNodeArray != null) {
                int n = 0;
                while (n < cmtModelNodeArray.length) {
                    this.selection.add(cmtModelNodeArray[n]);
                    ++n;
                }
            }
            this.owner.setLastDesignedNodes(null, (Element[])cmtModelNodeArray);
            this.fireSelectionChanged(new CmtSelectionEvent((Object)this));
        }
    }

    public void addCmtSelectionListener(CmtSelectionListener cmtSelectionListener) {
        if (!this.listeners.contains(cmtSelectionListener)) {
            this.listeners.add(cmtSelectionListener);
        }
    }

    public void removeCmtSelectionListener(CmtSelectionListener cmtSelectionListener) {
        if (this.listeners.contains(cmtSelectionListener)) {
            this.listeners.remove(cmtSelectionListener);
        }
    }

    void release() {
        this.stale = true;
        this.selection.clear();
    }

    private void refresh() {
        CmtModelNode[] cmtModelNodeArray;
        if (this.stale && !this.owner.isStale() && (cmtModelNodeArray = (CmtModelNode[])this.owner.getLastDesignedNodes(null)) != null) {
            int n = 0;
            while (n < cmtModelNodeArray.length) {
                this.selection.add(cmtModelNodeArray[n]);
                ++n;
            }
            this.stale = false;
        }
    }

    private void fireSelectionChanged(CmtSelectionEvent cmtSelectionEvent) {
        List list = (List)this.listeners.clone();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ((CmtSelectionListener)list.get(n2)).selectionChanged(cmtSelectionEvent);
            ++n2;
        }
    }
}

