/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Component;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.resource.CompareArb;

public class CompareController
implements Controller {
    private static CompareController _singleton;

    public static final CompareController getDefaultController() {
        if (_singleton == null) {
            _singleton = new CompareController();
        }
        return _singleton;
    }

    protected CompareView getCompareView(Context context) {
        if (context.getView() instanceof CompareViewOwner) {
            return ((CompareViewOwner)context.getView()).getCompareView();
        }
        return null;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        CompareView compareView = this.getCompareView(context);
        if (context.getView() instanceof CompareViewOwner) {
            if (n == CompareAddin.GO_FIRST_CMD_ID || n == CompareAddin.GO_LAST_CMD_ID) {
                ideAction.setEnabled(compareView instanceof NavigableView && compareView.getModel().getDifferenceCount() > 0);
                return true;
            }
            if (n == CompareAddin.GO_NEXT_CMD_ID) {
                ideAction.setEnabled(compareView instanceof NavigableView && ((NavigableView)compareView).hasNextDifference());
                return true;
            }
            if (n == CompareAddin.GO_PREVIOUS_CMD_ID) {
                ideAction.setEnabled(compareView instanceof NavigableView && ((NavigableView)compareView).hasPreviousDifference());
                return true;
            }
        }
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane basicEditorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (basicEditorPane == null) {
                return false;
            }
            if (n == 22) {
                ideAction.setEnabled(true);
                return true;
            }
            if (n == 18) {
                ideAction.setEnabled(basicEditorPane.canCopy());
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        CompareView compareView = this.getCompareView(context);
        if (compareView == null) {
            return false;
        }
        if (compareView instanceof EditorPaneView) {
            BasicEditorPane basicEditorPane = ((EditorPaneView)compareView).getCurrentEditorPane();
            if (basicEditorPane == null) {
                return false;
            }
            if (n == 22) {
                basicEditorPane.selectAll();
                return true;
            }
            if (n == 18) {
                basicEditorPane.copy();
                return true;
            }
        }
        if (compareView instanceof NavigableView) {
            NavigableView navigableView = (NavigableView)compareView;
            if (n == CompareAddin.GO_FIRST_CMD_ID) {
                navigableView.goToFirstDifference();
                return true;
            }
            if (n == CompareAddin.GO_NEXT_CMD_ID) {
                if (!navigableView.hasNextDifference()) {
                    return true;
                }
                boolean bl = navigableView.goToNextDifference();
                if (!bl && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString(36), (String)CompareArb.getString(35), null)) {
                    navigableView.goToFirstDifference();
                }
                return true;
            }
            if (n == CompareAddin.GO_PREVIOUS_CMD_ID) {
                if (!navigableView.hasPreviousDifference()) {
                    return true;
                }
                boolean bl = navigableView.goToPreviousDifference();
                if (!bl && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CompareArb.getString(34), (String)CompareArb.getString(33), null)) {
                    navigableView.goToLastDifference();
                }
                return true;
            }
            if (n == CompareAddin.GO_LAST_CMD_ID) {
                navigableView.goToLastDifference();
                return true;
            }
        }
        return false;
    }
}

