/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;
import oracle.jdeveloper.vcs.patch.CreatePatchCommand;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.resource.CompareArb;

public class CompareEditor
extends Editor
implements CompareViewOwner,
PopupManager,
FindableEditor,
StatusProvider {
    private JPanel _gui;
    private JLabel _statusLabel;
    private Toolbar _toolbar;
    private CompareView _view;

    void $init$() {
        this._gui = new JPanel();
        this._statusLabel = new JLabel();
        this._toolbar = new Toolbar();
        this._gui.setLayout(new BorderLayout());
        this._gui.add((Component)this._toolbar, "North");
    }

    public CompareView getCompareView() {
        return this._view;
    }

    private void compare(CompareModel compareModel) {
        int[] nArray = compareModel.getDifferenceTypeCounts();
        int n = compareModel.getDifferenceCount();
        if (n == 0) {
            this._statusLabel.setText(CompareArb.getString(31));
        } else {
            this._statusLabel.setText(MessageFormat.format(CompareArb.getString(32), String.valueOf(n), String.valueOf(nArray[0]), String.valueOf(nArray[1]), String.valueOf(nArray[2])));
        }
        this._view = CompareViewFactory.createCompareView((CompareModel)compareModel);
        this._toolbar.removeAll();
        if (this._view instanceof NavigableView) {
            ((NavigableView)this._view).goToFirstDifference();
            IdeAction ideAction = this.createLocalAction(Ide.findCmdID((String)"compare.navigatePrevious"));
            IdeAction ideAction2 = this.createLocalAction(Ide.findCmdID((String)"compare.navigateNext"));
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
            this._toolbar.add((ToggleAction)ideAction);
            this._toolbar.add((ToggleAction)ideAction2);
            this._toolbar.add((ToggleAction)this.createLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
            ((NavigableView)this._view).addPositionListener((ChangeListener)new 1(this, ideAction, ideAction2));
        }
        if (compareModel != null && compareModel.getContributor(ContributorKind.ANCESTOR) == null) {
            if (this._view instanceof NavigableView) {
                this._toolbar.addSeparator();
            }
            this._toolbar.add((ToggleAction)IdeAction.find((int)Ide.findCmdID((String)CreatePatchCommand.CREATE_PATCH_CMD)));
        }
        if (this._view instanceof EditorPaneView) {
            ((EditorPaneView)this._view).addPopupManager((PopupManager)this);
        }
        this._gui.add(this._view.getGUI(), "Center");
    }

    protected IdeAction createLocalAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        return ideAction.newLocalAction((View)this);
    }

    public Component getBottomComponent() {
        if (this._view instanceof CustomHorizontalScrollView) {
            return ((CustomHorizontalScrollView)this._view).getHorizontalScrollComponent();
        }
        return super.getBottomComponent();
    }

    public Object getEditorAttribute(String string) {
        if (this._view instanceof CustomHorizontalScrollView) {
            if ("scrollable".equals(string)) {
                return Boolean.FALSE;
            }
            if (string == "horizontal_scrollbar_policy") {
                return new Integer(31);
            }
            if (string == "vertical_scrollbar_policy") {
                return new Integer(21);
            }
        }
        if ("menu_id".equals(string)) {
            return CompareArb.getString(17);
        }
        return super.getEditorAttribute(string);
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        if (context != null) {
            context.setView((View)this);
            context.setElement((Element)context.getNode());
        }
        return context;
    }

    public void open() {
        this.compare(((CompareNode)this.getContext().getNode()).getModel());
        try {
            this.getContext().getNode().open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scscomparewindow_html");
    }

    public Component getGUI() {
        return this._gui;
    }

    public Controller getController() {
        return CompareController.getDefaultController();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._view instanceof EditorPaneView) {
            return ((EditorPaneView)this._view).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            Node node = context.getNode();
            context.setSelection(new Element[]{node});
            context.setElement((Element)node);
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup(BasicEditorPane basicEditorPane) {
    }

    public CompareEditor() {
        this.$init$();
    }

    public final class 1
    implements ChangeListener {
        private final /* synthetic */ IdeAction v$goToPreviousAction;
        private final /* synthetic */ IdeAction v$goToNextAction;
        final /* synthetic */ CompareEditor this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.v$goToPreviousAction.updateAction();
            this.v$goToNextAction.updateAction();
        }

        public 1(CompareEditor compareEditor, IdeAction ideAction, IdeAction ideAction2) {
            this.v$goToNextAction = ideAction2;
            this.v$goToPreviousAction = ideAction;
            this.this$0 = compareEditor;
        }
    }
}

