/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compare;

import java.awt.Window;
import java.net.URL;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.view.View;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compare.CompareContext;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.resource.CompareArb;

public class CompareIdeViewer
extends CompareViewer {
    private CompareAddin _compareAddin;
    private JMenu m_mainCompareMenu;
    private JMenu m_contextCompareMenu;
    private MenuListener m_menuListener;

    public CompareIdeViewer(CompareAddin compareAddin) {
        this._compareAddin = compareAddin;
    }

    public JMenu getMainCompareMenu() {
        if (this.m_mainCompareMenu == null) {
            this.m_mainCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(0)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(0))));
        }
        return this.m_mainCompareMenu;
    }

    public JMenu getContextCompareMenu() {
        if (this.m_contextCompareMenu == null) {
            this.m_contextCompareMenu = Ide.getMenubar().createSubMenu(StringUtils.stripMnemonic((String)CompareArb.getString(0)), new Integer(StringUtils.getMnemonicKeyCode((String)CompareArb.getString(0))), 0.2f, JDeveloperMenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            this.m_menuListener = new 1();
            this.m_contextCompareMenu.addMenuListener(this.m_menuListener);
        }
        return this.m_contextCompareMenu;
    }

    public void show(CompareContributor compareContributor, CompareContributor compareContributor2) {
        CompareModel compareModel = CompareUtil.createCompareModel(compareContributor, compareContributor2);
        if (compareModel == null) {
            return;
        }
        if (compareModel.getDifferences().length == 0 && !CompareUtil.confirmIdenticalCompare()) {
            return;
        }
        try {
            Context context = Context.newIdeContext();
            int n = 1;
            for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                if (!(editor instanceof CompareEditor)) continue;
                ++n;
            }
            URL uRL = CompareURLHelper.newCompareURL(compareContributor, compareContributor2, n);
            CompareNode compareNode = (CompareNode)NodeFactory.findOrCreate(CompareNode.class, (URL)uRL);
            compareNode.setSource(compareContributor);
            compareNode.setTarget(compareContributor2);
            compareNode.setModel(compareModel);
            context.setNode((Node)compareNode);
            context.setElement((Element)compareNode);
            CompareContext.setContributors(context, new CompareContributor[]{compareContributor, compareContributor2});
            EditorManager.getEditorManager().openEditorInFrame(CompareEditor.class, context);
        }
        catch (InstantiationException instantiationException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)illegalAccessException);
        }
    }

    static CompareAddin ra$_compareAddin(CompareIdeViewer compareIdeViewer) {
        return compareIdeViewer._compareAddin;
    }

    public final class 1
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            View view = Ide.getMainWindow().getLastActiveView();
            Context context = view.getContext((EventObject)menuEvent);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_eachOtherAction).updateAction(context);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_otherFileAction).updateAction(context);
            IdeAction.find((int)CompareIdeViewer.ra$_compareAddin((CompareIdeViewer)CompareIdeViewer.this).m_savedFileAction).updateAction(context);
        }
    }
}

