/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.URLPathField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.config.JProjectPaths;

public class JProjectPathsPanel
extends ProjectSettingsTraversablePanel {
    JLabel outputDirLabel;
    URLTextField outputDirTextField;
    JLabel additionalClassPathLabel;
    URLPathField additionalClassPathTextField;
    GridBagLayout gridBagLayout1;
    JButton outputDirButton;
    JButton additionalClassPathButton;
    JLabel spacerLabel;
    private static final String[] PROPERTY_KEYS = new String[]{"outputDirectory", "additionalClassPath"};

    void $init$() {
        this.outputDirLabel = new JLabel();
        this.outputDirTextField = new URLTextField(null, true, false);
        this.additionalClassPathLabel = new JLabel();
        this.additionalClassPathTextField = new URLPathField();
        this.gridBagLayout1 = new GridBagLayout();
        this.outputDirButton = new JButton();
        this.additionalClassPathButton = new JButton();
        this.spacerLabel = new JLabel();
    }

    public JProjectPathsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_idedprojsetpaths_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDataKey() {
        return JProjectPaths.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext traversableContext) {
        JavaProject javaProject = this.getJavaProject(traversableContext);
        JProjectPaths jProjectPaths = this.getJProjectPaths(traversableContext);
        boolean bl = JProjectPathsPanel.isDefaultProject((Namespace)traversableContext);
        this.loadFrom(javaProject, jProjectPaths, bl);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaProject javaProject = this.getJavaProject(traversableContext);
        JProjectPaths jProjectPaths = this.getJProjectPaths(traversableContext);
        boolean bl = JProjectPathsPanel.isDefaultProject((Namespace)traversableContext);
        this.commitTo(javaProject, jProjectPaths, bl);
    }

    private JavaProject getJavaProject(TraversableContext traversableContext) {
        Project project = (Project)traversableContext.find("Project");
        PropertyStorage propertyStorage = JProjectPathsPanel.getPropertyData((Namespace)traversableContext);
        return JavaProject.getInstance(project, propertyStorage.getProperties());
    }

    private JProjectPaths getJProjectPaths(TraversableContext traversableContext) {
        PropertyStorage propertyStorage = JProjectPathsPanel.getPropertyData((Namespace)traversableContext);
        return JProjectPaths.getInstance(propertyStorage);
    }

    private void loadFrom(JavaProject javaProject, JProjectPaths jProjectPaths, boolean bl) {
        URL uRL = javaProject.getOutputDirectory();
        if (bl) {
            URL uRL2 = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.outputDirTextField.setBaseURL(uRL2);
        } else {
            this.outputDirTextField.setBaseURL(null);
        }
        this.outputDirTextField.setURL(uRL);
        URLPath uRLPath = jProjectPaths.getAdditionalClassPath();
        this.additionalClassPathTextField.setURLPath(uRLPath);
    }

    private void commitTo(JavaProject javaProject, JProjectPaths jProjectPaths, boolean bl) throws TraversalException {
        URL uRL = this.outputDirTextField.getURL();
        if (bl) {
            URL uRL2 = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            if (uRL == null || URLFileSystem.toRelativeSpec((URL)uRL, (URL)uRL2, (boolean)true) == null) {
                throw new TraversalException(JProjectArb.format(135, JProjectArb.getString(136), this.outputDirTextField.getText()));
            }
            javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)uRL));
        } else {
            if (uRL == null) {
                if (!ModelUtil.hasLength((String)this.outputDirTextField.getText())) {
                    throw new TraversalException(JProjectArb.getString(146), JProjectArb.getString(143));
                }
                throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(144), this.outputDirTextField.getText().trim()), JProjectArb.getString(143));
            }
            if (URLFileSystem.isReadOnly((URL)uRL)) {
                throw new TraversalException(JProjectArb.getString(147), JProjectArb.getString(143));
            }
            if (!URLFileSystem.isValid((URL)uRL)) {
                String string = URLFileSystem.getPlatformPathName((URL)uRL);
                if (string.length() > 80) {
                    string = StringUtil.truncateFileNameForMessage((String)string);
                }
                this.outputDirTextField.requestFocus();
                throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(144), string), JProjectArb.getString(143));
            }
            javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)uRL));
        }
        try {
            URLPath uRLPath = this.additionalClassPathTextField.getURLPath();
            jProjectPaths.setAdditionalClassPath(uRLPath);
        }
        catch (URLPathField.BadEntryException badEntryException) {
            throw new TraversalException(ControlsArb.format(55, badEntryException.getBadEntry()));
        }
    }

    public static void promptForDirectoryValue(Component component, JTextField jTextField, String string) {
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)Context.newIdeContext());
        uRLChooser.setSelectionMode(0);
        uRLChooser.setSelectionScope(1);
        int n = uRLChooser.showOpenDialog(component);
        if (n == 0) {
            URL uRL = uRLChooser.getSelectedURL();
            if (uRL != null) {
                jTextField.setText(URLFileSystem.getPlatformPathName((URL)uRL));
            } else {
                jTextField.setText("");
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        ResourceUtils.resLabel((JLabel)this.outputDirLabel, (Component)this.outputDirTextField, (String)JProjectArb.getString(140));
        ResourceUtils.resLabel((JLabel)this.additionalClassPathLabel, (Component)this.additionalClassPathTextField, (String)JProjectArb.getString(139));
        ResourceUtils.resButton((AbstractButton)this.outputDirButton, (String)JProjectArb.getString(41));
        ResourceUtils.resButton((AbstractButton)this.additionalClassPathButton, (String)JProjectArb.getString(142));
        this.outputDirTextField.setDialogTitle(JProjectArb.getString(141));
        this.outputDirButton.addActionListener((ActionListener)this.outputDirTextField);
        this.additionalClassPathButton.addActionListener((ActionListener)this.additionalClassPathTextField);
        this.additionalClassPathTextField.setEditTitle(JProjectArb.getString(138));
        this.add(this.outputDirLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.outputDirTextField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.outputDirButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.additionalClassPathLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.additionalClassPathTextField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.additionalClassPathButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.spacerLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

