/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.log.MessagePage;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.debugger.ant.DebugAntArb;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpoint;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpointFileLine;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.ant.DebugAntClassInfo;
import oracle.jdevimpl.debugger.ant.DebugAntDataInfo;
import oracle.jdevimpl.debugger.ant.DebugAntMethodInfo;
import oracle.jdevimpl.debugger.ant.DebugAntStackFrameInfo;
import oracle.jdevimpl.debugger.ant.DebugAntThreadGroupInfo;
import oracle.jdevimpl.debugger.ant.DebugAntThreadInfo;
import oracle.jdevimpl.debugger.ant.DebugAntTransport;
import oracle.jdevimpl.debugger.ant.DebugAntVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedLocation;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class DebugAnt
implements DebugCapabilities,
DebugVirtualMachine {
    private volatile Thread runningThread;
    private boolean stopped;
    private boolean terminated;
    private boolean terminateRequested;
    private boolean disconnectRequested;
    private boolean pauseRequested;
    private Map properties;
    private DebugBreakpointLogListener bpLogListener;
    private DebugListener debugListener;
    private DebugAntTransport transport;
    private DebugAntVariableInfo[] variables;
    private IntHashMap breakpoints;
    private IntHashMap threads;
    protected int stoppedCount;
    private DebugAntThreadGroupInfo threadGroup;
    public static final int RESPONSE_Ok = 1;
    public static final int RESPONSE_NotOk = 2;
    public static final int COMMAND_Start = -1;
    public static final int COMMAND_Quit = 34;
    public static final int COMMAND_GetCurrentBreakpoint = 39;
    public static final int COMMAND_GetCurrentThread = 40;
    public static final int COMMAND_Run = 64;
    public static final int COMMAND_StepInto = 65;
    public static final int COMMAND_StepOver = 66;
    public static final int COMMAND_StepOut = 69;
    public static final int COMMAND_DidStepFinish = 71;
    public static final int COMMAND_ContinueStep = 72;
    public static final int COMMAND_GetThreads = 160;
    public static final int COMMAND_GetStackFrame = 165;
    public static final int COMMAND_PutBreakpointFileLine = 80;
    public static final int COMMAND_RemoveBreakpoint = 97;
    public static final int COMMAND_RemoveAllBreakpoints = 98;
    public static final int COMMAND_SetBreakpointThread = 99;
    public static final int COMMAND_SetBreakpointEnabled = 100;
    public static final int COMMAND_SetBreakpointStop = 101;
    public static final int COMMAND_SetBreakpointLog = 102;
    public static final int COMMAND_SetBreakpointName = 103;
    public static final int COMMAND_SetBreakpointEnableOtherBPs = 104;
    public static final int COMMAND_SetBreakpointDisableOtherBPs = 105;
    public static final int COMMAND_SetBreakpointPassCount = 106;
    public static final int COMMAND_SetBreakpointCondition = 107;
    public static final int COMMAND_SetBreakpointThreadNot = 108;
    public static final int COMMAND_GetStackFrames = 166;
    public static final int COMMAND_GetStackFrameCount = 175;
    public static final int COMMAND_GetLocals = 177;
    public static final int COMMAND_ModifyString = 191;
    public static final int NOTIFICATION_ProgramStopped = 240;
    public static final int NOTIFICATION_ProgramTerminated = 241;
    public static final int NOTIFICATION_DoYouWantToPause = 242;
    public static final int NOTIFICATION_BreakpointLog = 246;
    public static final int NOTIFICATION_BreakpointCondition = 251;
    public static final int NOTIFICATION_BreakpointEnabled = 255;

    void $init$() {
        this.properties = new HashMap();
        this.breakpoints = new IntHashMap();
        this.threads = new IntHashMap();
        this.threadGroup = new DebugAntThreadGroupInfo(this);
    }

    public DebugAnt(DebugAntTransport debugAntTransport) {
        this.$init$();
        this.transport = debugAntTransport;
    }

    public DebugAntThreadGroupInfo getThreadGroup() {
        return this.threadGroup;
    }

    public DebugCapabilities getCapabilities() {
        return this;
    }

    public void afterConnection(MessagePage messagePage) {
    }

    public synchronized void addDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.add(this.debugListener, debugListener);
    }

    public synchronized void removeDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.remove(this.debugListener, debugListener);
    }

    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.add(this.bpLogListener, debugBreakpointLogListener);
    }

    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.remove(this.bpLogListener, debugBreakpointLogListener);
    }

    public boolean isConnected() {
        return this.transport.isConnected();
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean wasRunning() {
        return false;
    }

    public void disconnect() {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean bl) {
        if (this.isRunning()) {
            this.terminateRequested = bl;
            this.disconnectRequested = true;
        } else {
            DebugAnt debugAnt = this;
            synchronized (debugAnt) {
                if (this.isConnected()) {
                    if (!this.terminated) {
                        this.transport.sendMessage(34, bl);
                    }
                    this.transport.disconnect();
                    this.incrementStoppedCount();
                }
            }
        }
    }

    public void addConnectionLog(Object object) {
    }

    public void removeConnectionLog(Object object) {
    }

    public String getName() {
        return "Apache Ant";
    }

    public int getLanguages() {
        return 8;
    }

    public String[] redefineClasses(Map map) {
        return null;
    }

    public void setNonDebuggablePackages(String string) {
    }

    public void setDebuggablePackages(String string, String string2) {
    }

    public void requestCodeCoverage(String string, String string2) {
    }

    public void unrequestCodeCoverage(String string, String string2) {
    }

    public void discardCodeCoverage() {
    }

    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String string, String string2, int n) {
        DebugAntBreakpointPackageFileLine debugAntBreakpointPackageFileLine = new DebugAntBreakpointPackageFileLine(this, string, string2, n);
        this.putBreakpoint(debugAntBreakpointPackageFileLine);
        return debugAntBreakpointPackageFileLine;
    }

    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String string, int n) {
        DebugAntBreakpointFileLine debugAntBreakpointFileLine = new DebugAntBreakpointFileLine(this, string, n);
        this.putBreakpoint(debugAntBreakpointFileLine);
        return debugAntBreakpointFileLine;
    }

    public DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointMethod putBreakpointMethod(String string) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointClass putBreakpointClass(String string) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointException putBreakpointException(String string) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointException putBreakpointException(String string, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointClassLoad putBreakpointClassLoad(String string) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int n) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointAllocationClass putBreakpointAllocationClass(String string) {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointDeadlock putBreakpointDeadlock() {
        throw new UnsupportedOperationException();
    }

    public DebugBreakpointWatchpoint putBreakpointWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        throw new UnsupportedOperationException();
    }

    public synchronized void removeAllBreakpoints() {
        this.throwIfRunning();
        this.transport.sendMessage(98);
    }

    public void setPauseInterval(int n) {
    }

    public void pauseProgram() {
        this.pauseRequested = true;
    }

    public void cancelPauseProgram() {
        this.pauseRequested = false;
    }

    public synchronized void resume() {
        this.doRunCommand(64, null);
    }

    public void start(boolean bl) {
        this.doRunCommand(-1, null);
    }

    public synchronized boolean didStepFinish() {
        this.throwIfRunning();
        this.transport.sendMessage(71);
        return this.transport.receiveBoolean();
    }

    public synchronized void continueStep() {
        this.doRunCommand(72, null);
    }

    private synchronized void doRunCommand(int n, DebugAntThreadInfo debugAntThreadInfo) {
        this.stopped = false;
        this.incrementStoppedCount();
        this.runningThread = new RunThread(n, debugAntThreadInfo);
        this.runningThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointLog() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugAntThreadInfo debugAntThreadInfo;
        int n;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            n = this.transport.receiveInteger();
            debugAntThreadInfo = this.receiveThread();
            debugStackFrameInfoArray = this.receiveStack(debugAntThreadInfo);
        }
        DebugAntBreakpointFileLine debugAntBreakpointFileLine = (DebugAntBreakpointFileLine)this.breakpoints.get(n);
        if (debugAntBreakpointFileLine != null) {
            if (debugStackFrameInfoArray.length > 0) {
                debugAntBreakpointFileLine.location = debugStackFrameInfoArray[0].getLocation();
                if (this.debugListener != null) {
                    this.debugListener.breakpointChanged(debugAntBreakpointFileLine);
                }
            }
            this.bpLogListener.logBreakpoint(debugAntBreakpointFileLine, debugAntThreadInfo, debugStackFrameInfoArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointCondition() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugAntThreadInfo debugAntThreadInfo;
        int n;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            n = this.transport.receiveInteger();
            debugAntThreadInfo = this.receiveThread();
            debugStackFrameInfoArray = this.receiveStack(debugAntThreadInfo);
            this.variables = this.receiveVariableInfos();
        }
        boolean bl = false;
        DebugAntBreakpointFileLine debugAntBreakpointFileLine = (DebugAntBreakpointFileLine)this.breakpoints.get(n);
        if (debugAntBreakpointFileLine != null && debugAntBreakpointFileLine.condition != null) {
            bl = debugAntBreakpointFileLine.condition.checkBreakpointCondition(debugAntBreakpointFileLine, this, debugAntThreadInfo, debugStackFrameInfoArray);
        }
        DebugAnt debugAnt2 = this;
        synchronized (debugAnt2) {
            this.transport.sendMessage(bl ? 1 : 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointEnabled() {
        boolean bl;
        int n;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            n = this.transport.receiveInteger();
            bl = this.transport.receiveBoolean();
        }
        DebugAntBreakpointFileLine debugAntBreakpointFileLine = (DebugAntBreakpointFileLine)this.breakpoints.get(n);
        if (debugAntBreakpointFileLine != null) {
            debugAntBreakpointFileLine.enabled = bl;
            if (this.debugListener != null) {
                this.debugListener.breakpointChanged(debugAntBreakpointFileLine);
            }
        }
    }

    public int getCurrentStatus() {
        if (this.stopped) {
            DebugBreakpoint debugBreakpoint = this.getCurrentBreakpoint();
            return debugBreakpoint != null ? 1 : 7;
        }
        return 0;
    }

    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        this.throwIfRunning();
        this.transport.sendMessage(39);
        return this.findBreakpoint(this.transport.receiveInteger());
    }

    public synchronized DebugThreadInfo getCurrentThread() {
        this.throwIfRunning();
        this.transport.sendMessage(40);
        return this.receiveThread();
    }

    public DebugDataObjectInfo getCurrentThrow() {
        return null;
    }

    public boolean isCurrentThrowHandled() {
        return false;
    }

    public DebugLocation getCurrentThrowHandler() {
        return null;
    }

    public DebugDataObjectInfo getWatchpointObject() {
        return null;
    }

    public DebugFieldInfo getWatchpointField() {
        return null;
    }

    public DebugDataInfo getWatchpointFieldFutureValue() {
        return null;
    }

    public synchronized DebugThreadInfo[] listThreads() {
        this.throwIfRunning();
        this.transport.sendMessage(160);
        return this.receiveThreads();
    }

    public DebugMonitorInfo[] listMonitorsInUse() {
        return null;
    }

    public DebugThreadInfo[] listWaitingThreads() {
        return null;
    }

    public DebugThreadInfo[] listBlockedThreads() {
        return null;
    }

    public DebugClassInfo[] listClasses() {
        return new DebugClassInfo[0];
    }

    public DebugClassInfo[] listClasses(boolean bl) {
        return new DebugClassInfo[0];
    }

    public int countClasses() {
        return 0;
    }

    public DebugClassInfo findFirstClassByName(String string) {
        return null;
    }

    public DebugClassInfo findFirstClassByName(String string, boolean bl) {
        return null;
    }

    public DebugClassLoaderInfo[] listClassLoaders() {
        return new DebugClassLoaderInfo[0];
    }

    public int countHeap(DebugHeapSubset debugHeapSubset) {
        return 0;
    }

    public DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset) {
        return null;
    }

    public DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset, int n) {
        return null;
    }

    public int getSizeOfAddress() {
        return 0;
    }

    public boolean isHeapAddressValid(long l) {
        return false;
    }

    public DebugHeapObjectInfo getHeapObjectAtAddress(long l) {
        return null;
    }

    public void doGarbageCollection() {
    }

    protected synchronized void removeBreakpoint(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.breakpoints.remove(debugAntBreakpoint.cookie);
        this.transport.sendMessage(97, debugAntBreakpoint.cookie);
    }

    protected synchronized void setBreakpointEnabled(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(100, debugAntBreakpoint.cookie, debugAntBreakpoint.enabled);
    }

    protected synchronized void setBreakpointStop(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(101, debugAntBreakpoint.cookie, debugAntBreakpoint.stop);
    }

    protected synchronized void setBreakpointLog(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(102, debugAntBreakpoint.cookie, debugAntBreakpoint.log);
    }

    protected synchronized void setBreakpointName(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(103, debugAntBreakpoint.name, debugAntBreakpoint.cookie);
    }

    protected synchronized void setBreakpointPassCount(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(106, debugAntBreakpoint.cookie, debugAntBreakpoint.passCount);
    }

    protected synchronized void setBreakpointThread(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(99, debugAntBreakpoint.threadname, debugAntBreakpoint.cookie);
    }

    protected synchronized void setBreakpointThreadNot(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(108, debugAntBreakpoint.threadnameNot, debugAntBreakpoint.cookie);
    }

    protected synchronized void setBreakpointCondition(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(107, debugAntBreakpoint.cookie, debugAntBreakpoint.condition != null);
    }

    protected synchronized void setBreakpointEnableOtherBPs(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(104, debugAntBreakpoint.enableOtherBPs, debugAntBreakpoint.cookie);
    }

    protected synchronized void setBreakpointDisableOtherBPs(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(105, debugAntBreakpoint.disableOtherBPs, debugAntBreakpoint.cookie);
    }

    public DebugThreadInfo[][] getDeadlockedThreads() {
        return DebugShared.getDeadlockedThreads(this);
    }

    public DebugThreadGroupInfo[] listTopThreadGroups() {
        return this.listAllThreadGroups();
    }

    public DebugThreadGroupInfo[] listAllThreadGroups() {
        return new DebugThreadGroupInfo[]{this.threadGroup};
    }

    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    public boolean canPutBreakpointFileLine() {
        return true;
    }

    public boolean canPutBreakpointMethodBytecode() {
        return false;
    }

    public boolean canPutBreakpointMethod() {
        return false;
    }

    public boolean canPutBreakpointClass() {
        return false;
    }

    public boolean canPutBreakpointException() {
        return false;
    }

    public boolean canPutBreakpointClassLoad() {
        return false;
    }

    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    public boolean canPutBreakpointDeadlock() {
        return false;
    }

    public boolean canPutBreakpointWatchpoint() {
        return false;
    }

    public boolean canSetDebuggablePackages() {
        return false;
    }

    public boolean canPauseProgram() {
        return true;
    }

    public boolean canRedefineClasses() {
        return false;
    }

    public boolean canCountObjectsOfClass() {
        return false;
    }

    public boolean canCountMemoryOfClass() {
        return false;
    }

    public boolean canSetDebuggableClass() {
        return false;
    }

    public boolean canGetHeap() {
        return false;
    }

    public boolean canDoGarbageCollection() {
        return false;
    }

    public boolean canDoCodeCoverage() {
        return false;
    }

    public boolean canDisassembleMethod() {
        return false;
    }

    public boolean canGetBytecodes() {
        return false;
    }

    public boolean canInvokeMethod() {
        return false;
    }

    public boolean canGetMonitors() {
        return false;
    }

    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    public boolean canListSlots() {
        return false;
    }

    public boolean canPopFrames() {
        return false;
    }

    public boolean canSuspendThread() {
        return false;
    }

    public boolean canResumeThread() {
        return false;
    }

    public boolean canListRegisters() {
        return false;
    }

    public boolean canListFloatRegisters() {
        return false;
    }

    public boolean canStepToEndOfMethod() {
        return false;
    }

    public boolean canContinueStep() {
        return false;
    }

    public boolean canGetReturnValue() {
        return false;
    }

    public boolean canGetReturnedValue() {
        return false;
    }

    public boolean canSetLocation() {
        return false;
    }

    public boolean canPin() {
        return false;
    }

    public boolean canGetAddresses() {
        return false;
    }

    public boolean canGetUniqueIDs() {
        return false;
    }

    protected synchronized String getValue(DebugAntDataInfo debugAntDataInfo) {
        if (this.properties.isEmpty()) {
            this.listLocals();
        }
        return (String)this.properties.get(debugAntDataInfo.getName());
    }

    protected synchronized boolean modifyString(DebugAntDataInfo debugAntDataInfo, String string) {
        this.throwIfRunning();
        this.transport.sendMessage(191, debugAntDataInfo.getName(), string);
        this.properties.put(debugAntDataInfo.getName(), string);
        return true;
    }

    protected void stepInto(DebugAntThreadInfo debugAntThreadInfo) {
        this.doRunCommand(65, debugAntThreadInfo);
    }

    protected void stepOver(DebugAntThreadInfo debugAntThreadInfo) {
        this.doRunCommand(66, debugAntThreadInfo);
    }

    protected void stepOut(DebugAntThreadInfo debugAntThreadInfo) {
        this.doRunCommand(69, debugAntThreadInfo);
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.breakpoints.clear();
    }

    private void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException(DebugAntArb.getString(5));
        }
    }

    private DebugAntBreakpoint findBreakpoint(int n) {
        if (n != 0) {
            return (DebugAntBreakpoint)this.breakpoints.get(n);
        }
        return null;
    }

    protected synchronized int getStackFrameCount(DebugAntThreadInfo debugAntThreadInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(175, debugAntThreadInfo.id);
        return this.transport.receiveInteger();
    }

    protected synchronized DebugAntStackFrameInfo getStackFrame(DebugAntThreadInfo debugAntThreadInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(165, debugAntThreadInfo.id, n);
        int n2 = this.transport.receiveMessage();
        return n2 == 1 ? this.receiveStackFrame(debugAntThreadInfo, n) : null;
    }

    protected synchronized DebugAntVariableInfo[] listLocals() {
        if (this.isRunning()) {
            return this.variables;
        }
        this.transport.sendMessage(177);
        return this.receiveVariableInfos();
    }

    protected synchronized DebugAntStackFrameInfo[] listStack(DebugAntThreadInfo debugAntThreadInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(166, debugAntThreadInfo.id);
        int n = this.transport.receiveMessage();
        return n == 1 ? this.receiveStack(debugAntThreadInfo) : null;
    }

    private synchronized DebugAntStackFrameInfo receiveStackFrame(DebugAntThreadInfo debugAntThreadInfo, int n) {
        DebugLocation debugLocation = this.receiveLocation();
        return new DebugAntStackFrameInfo(this, debugAntThreadInfo, n, debugLocation);
    }

    private synchronized DebugAntStackFrameInfo[] receiveStack(DebugAntThreadInfo debugAntThreadInfo) {
        int n = this.transport.receiveInteger();
        DebugAntStackFrameInfo[] debugAntStackFrameInfoArray = new DebugAntStackFrameInfo[n];
        int n2 = 0;
        while (n2 < n) {
            debugAntStackFrameInfoArray[n2] = this.receiveStackFrame(debugAntThreadInfo, n2);
            ++n2;
        }
        return debugAntStackFrameInfoArray;
    }

    private synchronized DebugAntVariableInfo[] receiveVariableInfos() {
        this.properties.clear();
        String string = DebugAntArb.getString(3);
        DebugAntClassInfo debugAntClassInfo = new DebugAntClassInfo(this, null, string, true);
        int n = this.transport.receiveInteger();
        DebugAntVariableInfo[] debugAntVariableInfoArray = new DebugAntVariableInfo[n];
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.transport.receiveString();
            String string3 = this.transport.receiveString();
            this.properties.put(string2, string3);
            DebugAntDataInfo debugAntDataInfo = new DebugAntDataInfo(this, debugAntClassInfo, string2);
            debugAntVariableInfoArray[n2] = new DebugAntVariableInfo(this, debugAntClassInfo, string2, debugAntDataInfo);
            ++n2;
        }
        return debugAntVariableInfoArray;
    }

    private void putBreakpoint(DebugAntBreakpoint debugAntBreakpoint) {
        this.throwIfRunning();
        if (debugAntBreakpoint instanceof DebugAntBreakpointFileLine) {
            DebugAntBreakpointFileLine debugAntBreakpointFileLine = (DebugAntBreakpointFileLine)debugAntBreakpoint;
            this.transport.sendMessage(80, debugAntBreakpointFileLine.getFilename(), debugAntBreakpointFileLine.getLine());
        }
        debugAntBreakpoint.cookie = this.transport.receiveInteger();
        this.breakpoints.put(debugAntBreakpoint.cookie, (Object)debugAntBreakpoint);
    }

    private synchronized boolean checkDisconnect() {
        if (this.disconnectRequested) {
            boolean bl = this.terminateRequested;
            this.disconnect(bl);
            return true;
        }
        return false;
    }

    private synchronized DebugAntThreadInfo[] receiveThreads() {
        int n = this.transport.receiveInteger();
        DebugAntThreadInfo[] debugAntThreadInfoArray = new DebugAntThreadInfo[n];
        int n2 = 0;
        while (n2 < n) {
            debugAntThreadInfoArray[n2] = this.receiveThread();
            ++n2;
        }
        return debugAntThreadInfoArray;
    }

    private synchronized DebugAntThreadInfo receiveThread() {
        int n = this.transport.receiveInteger();
        String string = this.transport.receiveString();
        DebugAntThreadInfo debugAntThreadInfo = (DebugAntThreadInfo)this.threads.get(n);
        if (debugAntThreadInfo == null) {
            debugAntThreadInfo = new DebugAntThreadInfo(this, n, string);
            this.threads.put(n, (Object)debugAntThreadInfo);
        }
        return debugAntThreadInfo;
    }

    private synchronized DebugLocation receiveLocation() {
        String string = this.transport.receiveString();
        int n = this.transport.receiveInteger();
        String string2 = this.transport.receiveString();
        File file = new File(string);
        DebugAntClassInfo debugAntClassInfo = new DebugAntClassInfo(this, file.getName(), file.getName(), false);
        return new DebugSharedLocation(new DebugAntMethodInfo(this, string2, debugAntClassInfo), 0L, 0, false, file.getPath(), string, n, true);
    }

    private void incrementStoppedCount() {
        this.properties.clear();
        ++this.stoppedCount;
    }

    static DebugAntTransport ra$transport(DebugAnt debugAnt) {
        return debugAnt.transport;
    }

    static void mav$notifiedBreakpointLog(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointLog();
    }

    static void wa$stopped(DebugAnt debugAnt, boolean bl) {
        debugAnt.stopped = bl;
    }

    static void wa$terminated(DebugAnt debugAnt, boolean bl) {
        debugAnt.terminated = bl;
    }

    static DebugListener ra$debugListener(DebugAnt debugAnt) {
        return debugAnt.debugListener;
    }

    static boolean ra$pauseRequested(DebugAnt debugAnt) {
        return debugAnt.pauseRequested;
    }

    static boolean ra$disconnectRequested(DebugAnt debugAnt) {
        return debugAnt.disconnectRequested;
    }

    static void wa$pauseRequested(DebugAnt debugAnt, boolean bl) {
        debugAnt.pauseRequested = bl;
    }

    static void mav$notifiedBreakpointCondition(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointCondition();
    }

    static void mav$notifiedBreakpointEnabled(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointEnabled();
    }

    static boolean ra$stopped(DebugAnt debugAnt) {
        return debugAnt.stopped;
    }

    static boolean ra$terminated(DebugAnt debugAnt) {
        return debugAnt.terminated;
    }

    static void wa$runningThread(DebugAnt debugAnt, Thread thread) {
        debugAnt.runningThread = thread;
    }

    static void mav$incrementStoppedCount(DebugAnt debugAnt) {
        debugAnt.incrementStoppedCount();
    }

    static boolean mav$checkDisconnect(DebugAnt debugAnt) {
        return debugAnt.checkDisconnect();
    }

    static boolean ra$terminateRequested(DebugAnt debugAnt) {
        return debugAnt.terminateRequested;
    }

    static void mav$connectionLost(DebugAnt debugAnt) {
        debugAnt.connectionLost();
    }

    private class RunThread
    extends Thread {
        private int command;
        private DebugAntThreadInfo thread;

        public RunThread(int n, DebugAntThreadInfo debugAntThreadInfo) {
            super("Ant Event Processor");
            this.command = n;
            this.thread = debugAntThreadInfo;
        }

        public void run() {
            if (this.thread != null) {
                DebugAnt.ra$transport(DebugAnt.this).sendMessage(this.command, this.thread.id);
            } else {
                DebugAnt.ra$transport(DebugAnt.this).sendMessage(this.command);
            }
            do {
                int n = DebugAnt.ra$transport(DebugAnt.this).receiveMessage();
                switch (n) {
                    case 246: {
                        DebugAnt.mav$notifiedBreakpointLog(DebugAnt.this);
                        break;
                    }
                    case 240: {
                        DebugAnt.wa$stopped(DebugAnt.this, true);
                        break;
                    }
                    case 241: {
                        DebugAnt.wa$terminated(DebugAnt.this, true);
                        if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                            DebugAnt.ra$debugListener(DebugAnt.this).programTerminating();
                        }
                        DebugAnt.ra$transport(DebugAnt.this).sendMessage(1);
                        break;
                    }
                    case 242: {
                        boolean bl = DebugAnt.ra$pauseRequested(DebugAnt.this);
                        if (!bl) {
                            bl = DebugAnt.ra$disconnectRequested(DebugAnt.this);
                        }
                        DebugAnt.wa$pauseRequested(DebugAnt.this, false);
                        DebugAnt.ra$transport(DebugAnt.this).sendBoolean(bl);
                        DebugAnt.ra$transport(DebugAnt.this).flush();
                        break;
                    }
                    case 251: {
                        DebugAnt.mav$notifiedBreakpointCondition(DebugAnt.this);
                        break;
                    }
                    case 255: {
                        DebugAnt.mav$notifiedBreakpointEnabled(DebugAnt.this);
                    }
                }
            } while (DebugAnt.this.isConnected() && !DebugAnt.ra$stopped(DebugAnt.this) && !DebugAnt.ra$terminated(DebugAnt.this));
            DebugAnt.wa$runningThread(DebugAnt.this, null);
            DebugAnt.mav$incrementStoppedCount(DebugAnt.this);
            if (DebugAnt.mav$checkDisconnect(DebugAnt.this)) {
                if (DebugAnt.ra$terminateRequested(DebugAnt.this) && DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programTerminated();
                }
            } else if (DebugAnt.ra$terminated(DebugAnt.this)) {
                if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programTerminated();
                }
                DebugAnt.this.disconnect(false);
            } else if (DebugAnt.ra$stopped(DebugAnt.this)) {
                if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programStopped();
                }
            } else {
                DebugAnt.mav$connectionLost(DebugAnt.this);
            }
        }
    }
}

