/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class DebugAntTransport {
    private Socket socket;
    private boolean isDebugger;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Object inputLock;
    private Object outputLock;
    private static final int HANDSHAKE_TIMEOUT = 3000;
    private static final String HANDSHAKE = "JDEV-ANT-DEBUGGER";

    void $init$() {
        this.inputLock = new Object();
        this.outputLock = new Object();
    }

    public DebugAntTransport(Socket socket, boolean bl) throws IOException {
        this.$init$();
        this.socket = socket;
        this.isDebugger = bl;
        this.doHandshake();
        socket.setTcpNoDelay(true);
        this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    public void disconnect() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }

    public void sendMessage(int n) {
        try {
            this.outputStream.writeByte(n);
            this.flush();
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    public int receiveMessage() {
        int n = 0;
        try {
            n = this.inputStream.readUnsignedByte();
        }
        catch (IOException iOException) {
            this.disconnect();
        }
        return n;
    }

    public boolean receiveBoolean() {
        boolean bl = false;
        try {
            bl = this.inputStream.readBoolean();
        }
        catch (IOException iOException) {
            this.disconnect();
        }
        return bl;
    }

    public int receiveInteger() {
        int n = 0;
        try {
            n = this.inputStream.readInt();
        }
        catch (IOException iOException) {
            this.disconnect();
        }
        return n;
    }

    public String receiveString() {
        String string = "";
        try {
            int n = this.inputStream.readInt();
            if (n > 0) {
                byte[] byArray = new byte[n];
                this.inputStream.readFully(byArray);
                string = new String(byArray, "UTF-8");
            }
        }
        catch (IOException iOException) {
            this.disconnect();
        }
        return string;
    }

    public void sendMessage(int n, int n2) {
        this.sendMessage(n);
        this.sendInteger(n2);
        this.flush();
    }

    public void sendMessage(int n, boolean bl) {
        this.sendMessage(n);
        this.sendBoolean(bl);
        this.flush();
    }

    public void sendMessage(int n, int n2, boolean bl) {
        this.sendMessage(n);
        this.sendInteger(n2);
        this.sendBoolean(bl);
        this.flush();
    }

    public void sendMessage(int n, String string) {
        this.sendMessage(n);
        this.sendString(string);
        this.flush();
    }

    public void sendMessage(int n, String string, String string2) {
        this.sendMessage(n);
        this.sendString(string);
        this.sendString(string2);
        this.flush();
    }

    public void sendMessage(int n, int n2, int n3) {
        this.sendMessage(n);
        this.sendInteger(n2);
        this.sendInteger(n3);
        this.flush();
    }

    public void sendMessage(int n, String string, int n2) {
        this.sendMessage(n);
        this.sendString(string);
        this.sendInteger(n2);
        this.flush();
    }

    public void sendMessage(int n, String string, int n2, int n3) {
        this.sendMessage(n);
        this.sendString(string);
        this.sendInteger(n2);
        this.sendInteger(n3);
        this.flush();
    }

    public void sendBoolean(boolean bl) {
        try {
            this.outputStream.writeBoolean(bl);
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    public void sendInteger(int n) {
        try {
            this.outputStream.writeInt(n);
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    public void sendString(String string) {
        try {
            if (string != null) {
                byte[] byArray = string.getBytes("UTF-8");
                this.outputStream.writeInt(byArray.length);
                this.outputStream.write(byArray);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (IOException iOException) {
            this.disconnect();
        }
    }

    private void doHandshake() throws IOException {
        this.socket.setSoTimeout(3000);
        byte[] byArray = HANDSHAKE.getBytes("UTF-8");
        if (this.isDebugger) {
            this.socket.getOutputStream().write(byArray);
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        InputStream inputStream = this.socket.getInputStream();
        while (n2 < n) {
            int n3 = inputStream.read(byArray2, n2, n - n2);
            if (n3 < 0) {
                this.socket.close();
                throw new IOException("Handshake failed.");
            }
            n2 += n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (byArray2[n4] != byArray[n4]) {
                throw new IOException("Handshake failed.");
            }
            ++n4;
        }
        if (!this.isDebugger) {
            this.socket.getOutputStream().write(byArray);
        }
        this.socket.setSoTimeout(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] byArray) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Transport not connected.");
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.outputStream.write(byArray);
            this.outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] receivePacket() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Transport not connected.");
        }
        Object object = this.inputLock;
        synchronized (object) {
            byte[] byArray = new byte[4];
            int n = this.inputStream.read();
            if (n < 0) {
                this.disconnect();
                byte[] byArray2 = null;
                return byArray2;
            }
            byArray[0] = (byte)n;
            this.inputStream.read(byArray, 1, 3);
            int n2 = this.getInt(byArray, 0);
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, 4);
            int n3 = 0;
            n = 4;
            while (n < n2) {
                n3 = this.inputStream.read(byArray3, n, n2 - n);
                if (n3 < 0) {
                    throw new IOException("Incomplete packet.");
                }
                n += n3;
            }
            byte[] byArray4 = byArray3;
            return byArray4;
        }
    }

    public int getMessage(byte[] byArray) {
        return this.getMessage(byArray, 4);
    }

    public int getMessage(byte[] byArray, int n) {
        return (byArray[n] << 8) + (byArray[n + 1] << 0);
    }

    public void putMessage(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 0 & 0xFF);
    }

    public int getInt(byte[] byArray, int n) {
        return (byArray[n] << 24) + (byArray[n + 1] << 16) + (byArray[n + 2] << 8) + (byArray[n + 3] << 0);
    }

    public void putInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 >>> 0 & 0xFF);
    }

    public String getString(byte[] byArray, int n) {
        int n2 = this.getInt(byArray, n);
        return new String(byArray, n + 4, n2);
    }
}

