/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdevimpl.ant.runner.AntLocation;
import oracle.jdevimpl.debugger.ant.DebugAntTransport;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class DebugBuildListener
implements BuildListener {
    private boolean suspended;
    private Object suspendLock;
    private int breakpoint;
    private DebugAntTransport transport;
    private HashMap breakpoints;
    private HashMap locations;
    private HashMap names;
    private HashMap threads;
    private HashMap ids;
    private int threadCount;
    private int breakpointCount;
    private int buildCount;
    private static Pattern sequencePattern;
    private static Method getTargetLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    void $init$() {
        this.suspendLock = new Object();
        this.breakpoints = new HashMap();
        this.locations = new HashMap();
        this.names = new HashMap();
        this.threads = new HashMap();
        this.ids = new HashMap();
        this.threadCount = 1;
        this.breakpointCount = 1;
    }

    static {
        $assertionsDisabled = DebugBuildListener.class.desiredAssertionStatus() ^ true;
        sequencePattern = Pattern.compile("Build sequence for target(?:\\(s\\))? `(?:.*)' is \\[(.*)\\]");
        try {
            getTargetLocation = Target.class.getMethod("getLocation", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.setCurrentProject(buildEvent.getProject());
        if (this.buildCount++ == 0) {
            try {
                this.connect();
                this.suspend();
            }
            catch (IOException iOException) {
                buildEvent.setException((Throwable)iOException);
            }
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (--this.buildCount == 0) {
            this.transport.sendMessage(241);
            this.transport.receiveMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetStarted(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            Target target = buildEvent.getTarget();
            if (target != null) {
                this.popImplicitTarget();
                this.pushDependencyTargets(target);
                AntLocation antLocation = this.getTargetLocation(target);
                this.push(target, antLocation);
                boolean bl = this.checkIfStepFinished(antLocation);
                if (!this.checkForBreakpoint(antLocation) && !this.checkPaused() && bl) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetFinished(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.updateThreads();
            Target target = buildEvent.getTarget();
            if (target != null) {
                this.pop(target);
                this.popDependencyTargets();
            }
            this.checkPaused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarted(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            Task task = buildEvent.getTask();
            if (task != null) {
                Target target = this.getOwningTarget(task);
                if (target == null) {
                    this.pushImplicitTarget();
                }
                AntLocation antLocation = new AntLocation(task.getLocation());
                this.updateLocation(target, antLocation);
                boolean bl = this.checkIfStepFinished(antLocation);
                if (!this.checkForBreakpoint(antLocation) && !this.checkPaused() && bl) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            this.checkPaused();
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        Matcher matcher = sequencePattern.matcher(buildEvent.getMessage());
        if (matcher.matches()) {
            ThreadInfo threadInfo = this.getCurrentThreadInfo();
            String[] stringArray = matcher.group(1).split(", ");
            threadInfo.setTargetOrder(stringArray);
        }
    }

    private Target getOwningTarget(Task task) {
        Target target = task.getOwningTarget();
        if (target != null && target.getName().length() == 0) {
            target = null;
        }
        return target;
    }

    private void push(Target target, AntLocation antLocation) {
        this.push(target, antLocation, false);
    }

    private void push(Target target, AntLocation antLocation, boolean bl) {
        StackFrame stackFrame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (stackFrame = (StackFrame)stack.peek()).getTarget() == target) {
            stackFrame.setLocation(antLocation);
            return;
        }
        stack.push(new StackFrame(target, antLocation, bl));
    }

    private boolean checkLocation(AntLocation antLocation) {
        return antLocation != null && antLocation != AntLocation.UNKNOWN_LOCATION && antLocation.getFileName() != null && antLocation.getFileName().length() != 0;
    }

    private void updateLocation(Target target, AntLocation antLocation) {
        if (this.checkLocation(antLocation)) {
            Stack stack = this.getCurrentStack();
            if (!$assertionsDisabled && stack.isEmpty()) {
                throw new AssertionError((Object)"Stack is empty.");
            }
            StackFrame stackFrame = (StackFrame)stack.peek();
            if (!$assertionsDisabled && stackFrame.getTarget() != target) {
                throw new AssertionError((Object)"Stack frame mismatch.");
            }
            stackFrame.setLocation(antLocation);
        }
    }

    private void pushImplicitTarget() {
        StackFrame stackFrame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (stackFrame = (StackFrame)stack.peek()).getTarget() == null) {
            return;
        }
        stack.push(new StackFrame(null, AntLocation.UNKNOWN_LOCATION, false));
    }

    private void popImplicitTarget() {
        StackFrame stackFrame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (stackFrame = (StackFrame)stack.peek()).getTarget() == null) {
            stack.pop();
            this.stepFinished(stackFrame);
        }
    }

    private void pop(Target target) {
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty()) {
            StackFrame stackFrame = (StackFrame)stack.pop();
            if (!$assertionsDisabled && stackFrame.getTarget() != target) {
                throw new AssertionError((Object)"Stack frame mismatch.");
            }
            this.stepFinished(stackFrame);
        }
    }

    private void stepFinished(StackFrame stackFrame) {
        ThreadInfo threadInfo = this.getCurrentThreadInfo();
        if (threadInfo.isStepping() && threadInfo.getStepFrame() == stackFrame) {
            threadInfo.setStepFinished(true);
        }
    }

    private void pushDependencyTargets(Target target) {
        Stack<Target> stack = new Stack<Target>();
        Project project = this.getCurrentProject();
        Hashtable hashtable = project.getTargets();
        String[] stringArray = this.getCurrentThreadInfo().getTargetOrder();
        Target target2 = null;
        int n = 0;
        while (n < stringArray.length) {
            Target target3 = (Target)hashtable.get(stringArray[n]);
            if (target2 != null) {
                if (this.dependsOn(target3, target2)) {
                    stack.push(target3);
                    target2 = target3;
                }
            } else if (target == target3) {
                target2 = target;
            }
            ++n;
        }
        while (!stack.isEmpty()) {
            Target target4 = (Target)stack.pop();
            AntLocation antLocation = this.getTargetLocation(target4);
            if (antLocation == AntLocation.UNKNOWN_LOCATION) continue;
            this.push(target4, this.getTargetLocation(target4), true);
        }
    }

    private void popDependencyTargets() {
        Stack stack = this.getCurrentStack();
        while (!stack.isEmpty()) {
            StackFrame stackFrame = (StackFrame)stack.peek();
            if (!stackFrame.isDependency()) break;
            stack.pop();
        }
    }

    private void updateThreads() {
        ArrayList arrayList = new ArrayList();
        Set set = this.threads.keySet();
        Iterator<Object> iterator = set.iterator();
        Thread thread = Thread.currentThread();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ThreadInfo threadInfo = (ThreadInfo)this.threads.get(k);
            Thread thread2 = threadInfo.getThread();
            if (thread2 == thread || thread2.isAlive()) continue;
            arrayList.add(k);
        }
        for (Object object : arrayList) {
            this.threads.remove(object);
        }
    }

    private void connect() throws IOException {
        int n = Integer.getInteger("jdev.ant.debug.port", 4000);
        ServerSocket serverSocket = new ServerSocket(n);
        Socket socket = serverSocket.accept();
        this.transport = new DebugAntTransport(socket, false);
    }

    private boolean isConnected() {
        return this.transport.isConnected();
    }

    private void stop() {
        this.transport.sendMessage(240);
        this.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (!this.suspended) {
                this.suspended = true;
                this.processMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspended) {
                this.suspended = false;
                this.suspendLock.notifyAll();
            }
        }
        this.breakpoint = 0;
    }

    private boolean checkPaused() {
        this.transport.sendMessage(242);
        boolean bl = this.transport.receiveBoolean();
        if (bl) {
            this.transport.sendMessage(240);
            this.suspend();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSuspended() {
        boolean bl;
        Object object = this.suspendLock;
        synchronized (object) {
            bl = this.suspended;
            while (this.suspended) {
                try {
                    this.suspendLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    private boolean checkIfStepFinished(AntLocation antLocation) {
        ThreadInfo threadInfo;
        if (this.checkLocation(antLocation) && (threadInfo = this.getCurrentThreadInfo()).isStepping()) {
            if (threadInfo.getStepCommand() == 66) {
                StackFrame stackFrame = (StackFrame)threadInfo.getStack().peek();
                if (threadInfo.getStepFrame() == stackFrame) {
                    threadInfo.setStepFinished(true);
                }
            } else if (threadInfo.getStepCommand() == 65) {
                threadInfo.setStepFinished(true);
            }
            if (threadInfo.isStepFinished()) {
                threadInfo.setStepping(false);
                threadInfo.setStepCommand(0);
                return true;
            }
        }
        return false;
    }

    private boolean checkForBreakpoint(AntLocation antLocation) {
        BreakPointLocation breakPointLocation;
        BreakPoint breakPoint;
        if (this.checkLocation(antLocation) && (breakPoint = (BreakPoint)this.locations.get(breakPointLocation = new BreakPointLocation(antLocation))) != null && breakPoint.isEnabled()) {
            this.breakpoint = breakPoint.getCookie();
            String string = Thread.currentThread().getName();
            String string2 = breakPoint.getThreadname();
            String string3 = breakPoint.getThreadnameNot();
            if (!(string2 != null && !string.equals(string2) || string3 != null && string.equals(string3) || breakPoint.getCondition() && !this.checkCondition(breakPoint))) {
                int n = breakPoint.getPassed() + 1;
                breakPoint.setPassed(n);
                if (n % breakPoint.getPassCount() == 0) {
                    if (breakPoint.isLog()) {
                        this.transport.sendMessage(246);
                        this.transport.sendInteger(breakPoint.getCookie());
                        this.sendCurrentThread();
                        this.sendCurrentStack();
                        this.transport.flush();
                    }
                    this.enableOtherBreakpoints(true, breakPoint.getEnableOtherBPs());
                    this.enableOtherBreakpoints(false, breakPoint.getDisableOtherBPs());
                    if (breakPoint.isStop()) {
                        this.transport.sendMessage(240);
                        this.suspend();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkCondition(BreakPoint breakPoint) {
        this.transport.sendMessage(251, BreakPoint.ra$cookie(breakPoint));
        this.sendCurrentThread();
        this.sendCurrentStack();
        this.sendProperties();
        this.transport.flush();
        int n = this.transport.receiveMessage();
        return n == 1;
    }

    private void enableOtherBreakpoints(boolean bl, String string) {
        List list;
        if (string != null && (list = (List)this.names.get(string)) != null) {
            for (BreakPoint breakPoint : list) {
                breakPoint.setEnabled(bl);
                this.transport.sendMessage(255, BreakPoint.ra$cookie(breakPoint), bl);
            }
        }
    }

    public void processMessages() {
        block27: do {
            int n = this.transport.receiveMessage();
            switch (n) {
                case 64: 
                case 72: {
                    this.resume();
                    break;
                }
                case 65: 
                case 66: 
                case 69: {
                    int n2 = this.transport.receiveInteger();
                    ThreadInfo threadInfo = (ThreadInfo)this.ids.get(new Integer(n2));
                    if (threadInfo != null) {
                        threadInfo.setStepping(true);
                        threadInfo.setStepCommand(n);
                    }
                    this.resume();
                    break;
                }
                case 71: {
                    this.transport.sendBoolean(this.getCurrentThreadInfo().isStepping() ^ true);
                    this.transport.flush();
                    break;
                }
                case 40: {
                    this.sendCurrentThread();
                    this.transport.flush();
                    break;
                }
                case 39: {
                    this.transport.sendInteger(this.breakpoint);
                    this.transport.flush();
                    break;
                }
                case 175: {
                    int n2 = this.transport.receiveInteger();
                    ThreadInfo threadInfo = (ThreadInfo)this.ids.get(new Integer(n2));
                    int n3 = 0;
                    if (threadInfo != null) {
                        n3 = threadInfo.getStack().size();
                    }
                    this.transport.sendInteger(n3);
                    this.transport.flush();
                    break;
                }
                case 165: {
                    Stack stack;
                    int n2 = this.transport.receiveInteger();
                    int n4 = this.transport.receiveInteger();
                    ThreadInfo threadInfo = (ThreadInfo)this.ids.get(new Integer(n2));
                    boolean bl = false;
                    if (threadInfo != null && n4 < (stack = threadInfo.getStack()).size()) {
                        this.transport.sendMessage(1);
                        this.sendStackFrame((StackFrame)stack.get(n4));
                        bl = true;
                    }
                    if (!bl) {
                        this.transport.sendMessage(2);
                    }
                    this.transport.flush();
                    break;
                }
                case 166: {
                    int n2 = this.transport.receiveInteger();
                    ThreadInfo threadInfo = (ThreadInfo)this.ids.get(new Integer(n2));
                    if (threadInfo != null) {
                        this.transport.sendMessage(1);
                        this.sendStack(threadInfo.getStack());
                    } else {
                        this.transport.sendMessage(2);
                    }
                    this.transport.flush();
                    break;
                }
                case 160: {
                    this.sendThreads();
                    this.transport.flush();
                    break;
                }
                case 97: {
                    List list;
                    int n5 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.remove(new Integer(n5));
                    if (breakPoint == null) continue block27;
                    this.locations.remove(breakPoint.getLocation());
                    String string = breakPoint.getName();
                    if (string == null || (list = (List)this.names.get(string)) == null) continue block27;
                    list.remove(breakPoint);
                    if (!list.isEmpty()) continue block27;
                    this.names.remove(string);
                    break;
                }
                case 98: {
                    this.breakpoints.clear();
                    this.locations.clear();
                    this.names.clear();
                    this.breakpointCount = 1;
                    break;
                }
                case 80: {
                    int n6;
                    String string = this.transport.receiveString();
                    int n7 = this.transport.receiveInteger();
                    ++this.breakpointCount;
                    BreakPointLocation breakPointLocation = new BreakPointLocation(string, n7);
                    BreakPoint breakPoint = new BreakPoint(breakPointLocation, n6);
                    this.breakpoints.put(new Integer(n6), breakPoint);
                    this.locations.put(breakPointLocation, breakPoint);
                    this.transport.sendInteger(n6);
                    this.transport.flush();
                    break;
                }
                case 100: {
                    int n8 = this.transport.receiveInteger();
                    boolean bl = this.transport.receiveBoolean();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n8));
                    if (breakPoint == null) continue block27;
                    breakPoint.setEnabled(bl);
                    break;
                }
                case 102: {
                    int n9 = this.transport.receiveInteger();
                    boolean bl = this.transport.receiveBoolean();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n9));
                    if (breakPoint == null) continue block27;
                    breakPoint.setLog(bl);
                    break;
                }
                case 101: {
                    int n10 = this.transport.receiveInteger();
                    boolean bl = this.transport.receiveBoolean();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n10));
                    if (breakPoint == null) continue block27;
                    breakPoint.setStop(bl);
                    break;
                }
                case 103: {
                    String string = this.transport.receiveString();
                    int n11 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n11));
                    if (breakPoint == null) continue block27;
                    breakPoint.setName(string);
                    break;
                }
                case 106: {
                    int n12 = this.transport.receiveInteger();
                    int n13 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n12));
                    if (breakPoint == null) continue block27;
                    breakPoint.setPassCount(n13);
                    break;
                }
                case 99: {
                    String string = this.transport.receiveString();
                    int n14 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n14));
                    if (breakPoint == null) continue block27;
                    breakPoint.setThreadname(string);
                    break;
                }
                case 108: {
                    String string = this.transport.receiveString();
                    int n15 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n15));
                    if (breakPoint == null) continue block27;
                    breakPoint.setThreadnameNot(string);
                    break;
                }
                case 107: {
                    int n16 = this.transport.receiveInteger();
                    boolean bl = this.transport.receiveBoolean();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n16));
                    if (breakPoint == null) continue block27;
                    breakPoint.setCondition(bl);
                    break;
                }
                case 104: {
                    String string = this.transport.receiveString();
                    int n17 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n17));
                    if (breakPoint == null) continue block27;
                    breakPoint.setEnableOtherBPs(string);
                    break;
                }
                case 105: {
                    String string = this.transport.receiveString();
                    int n18 = this.transport.receiveInteger();
                    BreakPoint breakPoint = (BreakPoint)this.breakpoints.get(new Integer(n18));
                    if (breakPoint == null) continue block27;
                    breakPoint.setDisableOtherBPs(string);
                    break;
                }
                case 34: {
                    boolean bl = this.transport.receiveBoolean();
                    if (bl) {
                        System.exit(0);
                        break;
                    }
                    this.transport.disconnect();
                    throw new BuildException("Program Terminated.");
                }
                case 177: {
                    this.sendProperties();
                    this.transport.flush();
                    break;
                }
                case 191: {
                    String string = this.transport.receiveString();
                    String string2 = this.transport.receiveString();
                    Project project = this.getCurrentProject();
                    Hashtable hashtable = project.getUserProperties();
                    if (hashtable.containsKey(string)) {
                        project.setUserProperty(string, string2);
                        break;
                    }
                    project.setProperty(string, string2);
                }
            }
        } while (this.isConnected() && this.suspended);
        if (this.suspended) {
            this.resume();
            throw new BuildException();
        }
    }

    private void sendCurrentThread() {
        Thread thread = Thread.currentThread();
        this.sendThread(this.getThreadInfo(thread));
    }

    private void sendThreads() {
        Set set = this.threads.keySet();
        this.transport.sendInteger(set.size());
        for (Object k : set) {
            this.sendThread((ThreadInfo)this.threads.get(k));
        }
    }

    private void sendThread(ThreadInfo threadInfo) {
        Thread thread = threadInfo.getThread();
        this.transport.sendInteger(threadInfo.getId());
        this.transport.sendString(thread.getName());
    }

    private void sendCurrentStack() {
        this.sendStack(Thread.currentThread());
    }

    private void sendStack(Thread thread) {
        ThreadInfo threadInfo = this.getThreadInfo(thread);
        Stack stack = threadInfo.getStack();
        this.sendStack(stack);
    }

    private void sendStack(Stack stack) {
        int n = stack.size();
        this.transport.sendInteger(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            this.sendStackFrame((StackFrame)stack.get(n2));
            --n2;
        }
    }

    private void sendStackFrame(StackFrame stackFrame) {
        AntLocation antLocation = stackFrame.getLocation();
        this.transport.sendString(antLocation.getFileName());
        this.transport.sendInteger(antLocation.getLineNumber());
        this.transport.sendString(stackFrame.getTargetName());
    }

    private void sendProperties() {
        Project project = this.getCurrentProject();
        Hashtable hashtable = project.getProperties();
        int n = hashtable.size();
        this.transport.sendInteger(n);
        this.transport.flush();
        ArrayList arrayList = new ArrayList(hashtable.size());
        arrayList.addAll(hashtable.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            String string2 = (String)hashtable.get(string);
            this.transport.sendString(string);
            this.transport.sendString(string2);
        }
    }

    private Stack getCurrentStack() {
        return this.getCurrentThreadInfo().getStack();
    }

    private Project getCurrentProject() {
        return this.getCurrentThreadInfo().getProject();
    }

    private void setCurrentProject(Project project) {
        this.getCurrentThreadInfo().setProject(project);
    }

    private ThreadInfo getCurrentThreadInfo() {
        return this.getThreadInfo(Thread.currentThread());
    }

    private ThreadInfo getThreadInfo(Thread thread) {
        ThreadInfo threadInfo = (ThreadInfo)this.threads.get(thread);
        if (threadInfo == null) {
            threadInfo = new ThreadInfo(thread, this.threadCount);
            this.threads.put(thread, threadInfo);
            this.ids.put(new Integer(this.threadCount++), threadInfo);
        }
        return threadInfo;
    }

    private AntLocation getTargetLocation(Target target) {
        if (getTargetLocation != null) {
            try {
                AntLocation antLocation = new AntLocation((Location)getTargetLocation.invoke((Object)target, null));
                return antLocation;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AntLocation.UNKNOWN_LOCATION;
    }

    private boolean dependsOn(Target target, Target target2) {
        String string = target2.getName();
        Enumeration enumeration = target.getDependencies();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public DebugBuildListener() {
        this.$init$();
    }

    static HashMap ra$names(DebugBuildListener debugBuildListener) {
        return debugBuildListener.names;
    }

    private class BreakPointLocation {
        private String filename;
        private int line;

        public BreakPointLocation(AntLocation antLocation) {
            this(antLocation.getFileName(), antLocation.getLineNumber());
        }

        public BreakPointLocation(String string, int n) {
            this.filename = string;
            this.line = n;
        }

        public String getFileName() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object object) {
            if (object instanceof BreakPointLocation) {
                BreakPointLocation breakPointLocation = (BreakPointLocation)object;
                File file = new File(this.filename);
                File file2 = new File(breakPointLocation.filename);
                return this.line == this.line && file.equals(file2);
            }
            return false;
        }

        public int hashCode() {
            return (this.filename + this.line).hashCode();
        }
    }

    private class BreakPoint {
        private BreakPointLocation location;
        private int cookie;
        private String name;
        private boolean enabled;
        private boolean stop;
        private boolean log;
        private int passCount;
        private int passed;
        private String threadname;
        private String threadnameNot;
        private boolean condition;
        private String enableOtherBPs;
        private String disableOtherBPs;

        void $init$() {
            this.enabled = true;
            this.stop = true;
            this.passCount = 1;
        }

        public BreakPoint(BreakPointLocation breakPointLocation, int n) {
            this.$init$();
            this.location = breakPointLocation;
            this.cookie = n;
        }

        public BreakPointLocation getLocation() {
            return this.location;
        }

        public int getCookie() {
            return this.cookie;
        }

        public void setName(String string) {
            List list;
            if (this.name != null && (list = (List)DebugBuildListener.ra$names(DebugBuildListener.this).get(string)) != null) {
                list.remove(this);
                if (list.isEmpty()) {
                    DebugBuildListener.ra$names(DebugBuildListener.this).remove(string);
                }
            }
            this.name = string;
            if (string != null) {
                ArrayList<BreakPoint> arrayList = (ArrayList<BreakPoint>)DebugBuildListener.ra$names(DebugBuildListener.this).get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<BreakPoint>();
                    DebugBuildListener.ra$names(DebugBuildListener.this).put(string, arrayList);
                }
                arrayList.add(this);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setLog(boolean bl) {
            this.log = bl;
        }

        public boolean isLog() {
            return this.log;
        }

        public void setStop(boolean bl) {
            this.stop = bl;
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setPassCount(int n) {
            this.passCount = n;
        }

        public int getPassCount() {
            return this.passCount;
        }

        public void setPassed(int n) {
            this.passed = n;
        }

        public int getPassed() {
            return this.passed;
        }

        public void setThreadname(String string) {
            this.threadname = string;
        }

        public String getThreadname() {
            return this.threadname;
        }

        public void setThreadnameNot(String string) {
            this.threadnameNot = string;
        }

        public String getThreadnameNot() {
            return this.threadnameNot;
        }

        public void setCondition(boolean bl) {
            this.condition = bl;
        }

        public boolean getCondition() {
            return this.condition;
        }

        public void setEnableOtherBPs(String string) {
            this.enableOtherBPs = string;
        }

        public String getEnableOtherBPs() {
            return this.enableOtherBPs;
        }

        public void setDisableOtherBPs(String string) {
            this.disableOtherBPs = string;
        }

        public String getDisableOtherBPs() {
            return this.disableOtherBPs;
        }

        static int ra$cookie(BreakPoint breakPoint) {
            return breakPoint.cookie;
        }
    }

    private class ThreadInfo {
        private Thread thread;
        private int id;
        private Project project;
        private Stack stack;
        private boolean stepping;
        private int stepCommand;
        private StackFrame stepFrame;
        private boolean stepFinished;
        private String[] targetOrder;

        void $init$() {
            this.stack = new Stack();
        }

        public ThreadInfo(Thread thread, int n) {
            this.$init$();
            this.thread = thread;
            this.id = n;
        }

        public Thread getThread() {
            return this.thread;
        }

        public int getId() {
            return this.id;
        }

        public Project getProject() {
            return this.project;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public Stack getStack() {
            return this.stack;
        }

        public int getStackLevel() {
            return this.stack.size();
        }

        public boolean isStepping() {
            return this.stepping;
        }

        public void setStepping(boolean bl) {
            this.stepping = bl;
            this.stepFrame = bl && !this.stack.isEmpty() ? (StackFrame)this.stack.peek() : null;
            this.stepFinished = false;
        }

        public StackFrame getStepFrame() {
            return this.stepFrame;
        }

        public int getStepCommand() {
            return this.stepCommand;
        }

        public void setStepCommand(int n) {
            this.stepCommand = n;
        }

        public void setStepFinished(boolean bl) {
            this.stepFinished = bl;
        }

        public boolean isStepFinished() {
            return this.stepFinished;
        }

        public String[] getTargetOrder() {
            return this.targetOrder;
        }

        public void setTargetOrder(String[] stringArray) {
            this.targetOrder = stringArray;
        }
    }

    private class StackFrame {
        private Target target;
        private AntLocation location;
        private boolean dependency;

        public StackFrame(Target target, AntLocation antLocation, boolean bl) {
            this.target = target;
            this.location = antLocation;
            this.dependency = bl;
        }

        public Target getTarget() {
            return this.target;
        }

        public String getTargetName() {
            return this.target != null ? this.target.getName() : "";
        }

        public AntLocation getLocation() {
            return this.location;
        }

        public void setLocation(AntLocation antLocation) {
            this.location = antLocation;
        }

        public boolean isDependency() {
            return this.dependency;
        }
    }
}

