/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.awt.List;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import oracle.ide.Ide;
import oracle.ide.log.MessagePage;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariArb;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariArrayElementInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpoint;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointAllocationClass;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointClass;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointClassLoad;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointDeadlock;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointException;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointFileLine;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointMethod;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariBreakpointWatchpoint;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataArrayInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataPrimitiveInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInPinTable;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInRegister;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInStack;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInStatic;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapObjectInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariMethodInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariMonitorInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariPinnedInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariRegisterInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStackFrameInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStackSlotInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadGroupInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariTransport;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassembleAssembly;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassembleBytecode;
import oracle.jdevimpl.debugger.shared.DebugSharedDisassembleJava;
import oracle.jdevimpl.debugger.shared.DebugSharedLocation;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetDescendants;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetRoots;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugFerrari
implements Runnable,
DebugCapabilities,
DebugVirtualMachine {
    static final int Debug_Protocol_Version = 531;
    static final int Extended_Protocol_Version_1 = 1;
    static final int Extended_Protocol_Version_2 = 2;
    static final int Extended_Protocol_Version_3 = 3;
    static final int Extended_Protocol_Version_4 = 4;
    static final int Extended_Protocol_Version_5 = 5;
    static final int Extended_Protocol_Version_6 = 6;
    static final int Extended_Protocol_Version_7 = 7;
    static final int Extended_Protocol_Version_8 = 8;
    static final int Extended_Protocol_Version_9 = 9;
    static final int Extended_Protocol_Version_10 = 10;
    static final int Extended_Protocol_Version_11 = 11;
    static final int Extended_Protocol_Version_12 = 12;
    static final int Extended_Protocol_Version_13 = 13;
    static final int Extended_Protocol_Version_14 = 14;
    static final int Extended_Protocol_Version_15 = 15;
    static final int Extended_Protocol_Version_16 = 16;
    static final int Extended_Protocol_Version_17 = 17;
    static final int Extended_Protocol_Version_18 = 18;
    static final int Extended_Protocol_Version_19 = 19;
    static final int Extended_Protocol_Version_20 = 20;
    static final int Extended_Protocol_Version_21 = 21;
    static final int Extended_Protocol_Version_22 = 22;
    static final int Extended_Protocol_Version_23 = 23;
    static final int Extended_Protocol_Version_24 = 24;
    static final int Extended_Protocol_Version_25 = 25;
    static final int Extended_Protocol_Version_26 = 26;
    static final int Extended_Protocol_Version_27 = 27;
    static final int Extended_Protocol_Version_28 = 28;
    static final int Extended_Protocol_Version_29 = 29;
    static final int Extended_Protocol_Version_30 = 30;
    static final int Extended_Protocol_Version_31 = 31;
    static final int Extended_Protocol_Version = 31;
    private static final int RESPONSE_Ok = 1;
    private static final int RESPONSE_NotOk = 2;
    private static final int RESPONSE_True = 4;
    private static final int RESPONSE_False = 5;
    private static final int RESPONSE_EndMultipleBlock = 6;
    private static final int RESPONSE_String = 16;
    private static final int RESPONSE_Integer = 17;
    private static final int RESPONSE_IS = 18;
    static final int RESPONSE_II = 19;
    private static final int RESPONSE_IIS = 20;
    private static final int RESPONSE_III = 21;
    private static final int RESPONSE_IIIS = 22;
    private static final int RESPONSE_IIII = 23;
    private static final int RESPONSE_IIIIS = 24;
    private static final int RESPONSE_IIIII = 25;
    private static final int RESPONSE_IIIIIS = 26;
    static final int COMMAND_IsOk = 32;
    private static final int COMMAND_FilenameCaseSensitivity = 33;
    static final int COMMAND_Quit = 34;
    private static final int COMMAND_SetPauseInterval = 35;
    private static final int COMMAND_GetSourceDirectory = 36;
    private static final int COMMAND_NonDebuggablePackages = 37;
    private static final int COMMAND_RequestCodeCoverage = 38;
    private static final int COMMAND_GetCurrentBreakpoint = 39;
    private static final int COMMAND_GetCurrentThread = 40;
    private static final int COMMAND_GetCurrentThrow = 41;
    private static final int COMMAND_IsCurrentThrowHandled = 42;
    private static final int COMMAND_IsDeadlockDetected = 43;
    private static final int COMMAND_GetExtendedProtocolVersion = 44;
    private static final int COMMAND_SetExtendedProtocolVersion = 45;
    private static final int COMMAND_DebuggablePackages = 46;
    private static final int COMMAND_GetVMName = 47;
    private static final int COMMAND_SpecialVM = 48;
    private static final int COMMAND_SpecialClass = 49;
    private static final int COMMAND_SpecialField = 50;
    private static final int COMMAND_SpecialMethod = 51;
    private static final int COMMAND_SpecialMonitor = 52;
    private static final int COMMAND_SpecialThread = 53;
    private static final int COMMAND_GetPointerSize = 54;
    private static final int COMMAND_GetAllMessages = 55;
    private static final int COMMAND_TestConnection = 56;
    private static final int COMMAND_GetWatchpointFieldOrFutureValue = 57;
    private static final int COMMAND_GetUniqueID = 58;
    private static final int COMMAND_Run = 64;
    private static final int COMMAND_StepInto = 65;
    private static final int COMMAND_StepOver = 66;
    private static final int COMMAND_StepIntoBC = 67;
    private static final int COMMAND_StepOverBC = 68;
    private static final int COMMAND_StepOut = 69;
    private static final int COMMAND_StepToEndOfMethod = 70;
    private static final int COMMAND_DidStepFinish = 71;
    private static final int COMMAND_ContinueStep = 72;
    private static final int COMMAND_ContinueRun = 73;
    private static final int COMMAND_IsAtEndOfMethod = 74;
    private static final int COMMAND_RedefineClass = 75;
    private static final int COMMAND_PopFrames = 76;
    private static final int COMMAND_PinUnpinReference = 77;
    private static final int COMMAND_CreateString = 78;
    private static final int COMMAND_InvokeMethod = 79;
    private static final int COMMAND_PutBreakpointFileLine = 80;
    private static final int COMMAND_PutBreakpointMethodBytecode = 81;
    private static final int COMMAND_PutBreakpointMethod = 82;
    private static final int COMMAND_PutBreakpointClass = 83;
    private static final int COMMAND_PutBreakpointException = 84;
    private static final int COMMAND_PutBreakpointClassLoad = 85;
    private static final int COMMAND_PutBreakpointAllocationSize = 86;
    private static final int COMMAND_PutBreakpointAllocationClass = 87;
    private static final int COMMAND_PutBreakpointDeadlock = 88;
    private static final int COMMAND_PutBreakpointWatchpoint = 89;
    private static final int COMMAND_PutBreakpointFirst = 80;
    private static final int COMMAND_PutBreakpointLast = 89;
    private static final int RESPONSE_BreakpointLocation = 96;
    private static final int COMMAND_RemoveBreakpoint = 97;
    private static final int COMMAND_RemoveAllBreakpoints = 98;
    private static final int COMMAND_SetBreakpointThread = 99;
    private static final int COMMAND_SetBreakpointEnabled = 100;
    private static final int COMMAND_SetBreakpointStop = 101;
    private static final int COMMAND_SetBreakpointLog = 102;
    private static final int COMMAND_SetBreakpointName = 103;
    private static final int COMMAND_SetBreakpointEnableOtherBPs = 104;
    private static final int COMMAND_SetBreakpointDisableOtherBPs = 105;
    private static final int COMMAND_SetBreakpointPassCount = 106;
    private static final int COMMAND_SetBreakpointCondition = 107;
    private static final int COMMAND_SetBreakpointThreadNot = 108;
    private static final int COMMAND_BreakpointInstanceFilter = 109;
    private static final int COMMAND_CountObjectsOfClass = 112;
    private static final int COMMAND_GetClassObject = 113;
    private static final int COMMAND_GetClassSuperClass = 114;
    private static final int COMMAND_CountClassMethods = 115;
    private static final int COMMAND_GetClassMethods = 116;
    private static final int COMMAND_CountClassStaticFields = 117;
    private static final int COMMAND_GetClassStaticFields = 118;
    private static final int COMMAND_CountClassFields = 119;
    private static final int COMMAND_GetClassFields = 120;
    private static final int COMMAND_IsClassDebuggable = 121;
    private static final int COMMAND_SetClassDebuggable = 122;
    private static final int COMMAND_GenerateSourceFile = 123;
    private static final int COMMAND_IsClassCodeCoverage = 124;
    private static final int COMMAND_SetClassCodeCoverage = 125;
    private static final int COMMAND_DiscardClassCodeCoverage = 126;
    private static final int COMMAND_GetClassInterfaces = 127;
    private static final int COMMAND_GetMethodLineRange = 128;
    private static final int COMMAND_GetMethodLines = 129;
    private static final int COMMAND_DisassembleMethod = 130;
    private static final int RESPONSE_JavaLine = 131;
    private static final int RESPONSE_BytecodeLine = 132;
    private static final int RESPONSE_AssemblyLine = 133;
    private static final int COMMAND_HasMethodChanged = 134;
    private static final int COMMAND_GetMethodAccess = 135;
    private static final int COMMAND_GetJavaLine = 136;
    private static final int COMMAND_GetLocation = 137;
    private static final int COMMAND_GetMethodCodeCoverage = 138;
    private static final int COMMAND_GetCodeCoverageRatio = 139;
    private static final int COMMAND_GetBytecodes = 140;
    private static final int COMMAND_GetBytecode = 141;
    private static final int COMMAND_IsClassObfuscated = 142;
    private static final int COMMAND_GetArrayElementClass = 143;
    private static final int COMMAND_GetThreadGroups = 144;
    private static final int COMMAND_GetThreadGroupObject = 145;
    private static final int COMMAND_GetThreadGroupParent = 146;
    private static final int COMMAND_GetThreadGroupGroups = 147;
    private static final int COMMAND_GetThreadGroupThreads = 148;
    private static final int COMMAND_GetClassLoaderObject = 149;
    private static final int COMMAND_GetFieldByName = 150;
    private static final int COMMAND_GetPrimarySourceFilename = 151;
    private static final int COMMAND_GetThreads = 160;
    private static final int COMMAND_GetThreadObject = 161;
    private static final int COMMAND_GetThreadRegisters = 162;
    private static final int COMMAND_GetThreadFloatRegisters = 163;
    private static final int COMMAND_ModifyThreadRegister = 164;
    private static final int COMMAND_GetStackFrame = 165;
    private static final int COMMAND_GetStackFrames = 166;
    private static final int COMMAND_IsThreadSuspended = 167;
    private static final int COMMAND_SuspendThread = 168;
    private static final int COMMAND_ResumeThread = 169;
    private static final int COMMAND_GetThread = 170;
    private static final int COMMAND_GetThreadGroup = 171;
    private static final int COMMAND_GetObjectFromAddress = 172;
    private static final int COMMAND_GetThreadStatus = 173;
    private static final int COMMAND_SetThreadIP = 174;
    private static final int COMMAND_GetStackFrameCount = 175;
    private static final int COMMAND_GetArgs = 176;
    private static final int COMMAND_GetLocals = 177;
    private static final int COMMAND_GetSlots = 178;
    private static final int COMMAND_ModifySlot = 179;
    private static final int COMMAND_CountFields = 180;
    private static final int COMMAND_GetFields = 181;
    private static final int COMMAND_CountArrayElements = 182;
    private static final int COMMAND_GetArrayElements = 183;
    private static final int COMMAND_ModifyData = 184;
    private static final int COMMAND_GetCourtesyInfo = 185;
    private static final int COMMAND_GetFieldData = 186;
    private static final int COMMAND_FindFieldValue = 187;
    private static final int COMMAND_GetArrayValues = 188;
    private static final int COMMAND_GetReturnValue = 189;
    private static final int COMMAND_GetReturnedValue = 190;
    private static final int COMMAND_ModifyString = 191;
    private static final int COMMAND_GarbageCollection = 192;
    private static final int COMMAND_DumpMemory = 193;
    private static final int COMMAND_IsHeapAddressValid = 194;
    private static final int COMMAND_GetHeapObject = 195;
    private static final int COMMAND_CountHeap = 196;
    private static final int COMMAND_GetHeap = 197;
    private static final int COMMAND_HeapSubsetClass = 198;
    private static final int COMMAND_HeapSubsetAncestors = 199;
    private static final int COMMAND_HeapSubsetDescendants = 200;
    private static final int COMMAND_HeapSubsetRoots = 201;
    private static final int COMMAND_GetHeapObjects = 204;
    private static final int COMMAND_PinObject = 205;
    private static final int COMMAND_UnpinObject = 206;
    private static final int COMMAND_WasPinnedObjectDiscarded = 207;
    private static final int RESPONSE_HeapAncestorInStack = 208;
    private static final int RESPONSE_HeapAncestorInRegister = 209;
    private static final int RESPONSE_HeapAncestorInPinTable = 210;
    private static final int RESPONSE_HeapAncestorInStatic = 211;
    private static final int COMMAND_GetWholeThing = 212;
    private static final int COMMAND_GetClassGenericSignature = 213;
    private static final int COMMAND_GetFieldGenericSignature = 214;
    private static final int COMMAND_GetLocalGenericSignature = 215;
    private static final int COMMAND_GetMonitorThreadWaitingFor = 224;
    private static final int COMMAND_GetMonitorThreadBlockedFor = 225;
    private static final int COMMAND_GetMonitors = 226;
    private static final int COMMAND_GetWaitingThreads = 227;
    private static final int COMMAND_GetBlockedThreads = 228;
    private static final int COMMAND_GetMonitorForObject = 229;
    private static final int COMMAND_GetObjectWithMonitor = 230;
    private static final int COMMAND_GetMonitorEntryLocation = 231;
    private static final int COMMAND_DoMonitorNotify = 232;
    private static final int NOTIFICATION_ProgramStopped = 240;
    private static final int NOTIFICATION_ProgramTerminated = 241;
    private static final int NOTIFICATION_DoYouWantToPause = 242;
    private static final int NOTIFICATION_ClassLoaded = 243;
    private static final int NOTIFICATION_ClassUnloaded = 244;
    private static final int NOTIFICATION_BreakpointChanged = 245;
    private static final int NOTIFICATION_BreakpointLog = 246;
    private static final int NOTIFICATION_ExceptionLog = 247;
    private static final int NOTIFICATION_ClassLoadLog = 248;
    private static final int NOTIFICATION_AllocationLog = 249;
    private static final int NOTIFICATION_DeadlockLog = 250;
    private static final int NOTIFICATION_BreakpointCondition = 251;
    private static final int NOTIFICATION_WatchpointLog = 252;
    private static final int COMMAND_Start = -1;
    private DebugFerrariTransport transport;
    private int extendedProtocolVersion;
    private boolean vmWasRunning;
    private DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    int stoppedCount;
    private java.util.List stoppedListeners;
    private Map dataInfosByPlace;
    private Map dataInfosByAddress;
    private Map threadInfosByThreadPtr;
    private int stoppedCountThreadContextClassLoaders;
    Map classLoaderInfosByAddress;
    Map classLoaderIds;
    private long systemClassLoaderAddress;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_STOPPED = 0;
    private static final int SYNC_PAUSE_REQUESTED = 1;
    private static final int SYNC_DISCONNECT_REQUESTED = 2;
    private static final int SYNC_TERMINATE_REQUESTED = 3;
    private static final int SYNC_TERMINATED = 4;
    private static final int SYNC_CONNECTION_LOGS = 5;
    private static final int SYNC_CONNECTION_LOST = 6;
    private static final int SYNC_SYSTEM_CLASS_LOADER = 7;
    private static final int SYNC_COUNT = 8;
    private int stoppedCountUpdateClassCounts;
    private java.util.List classes;
    private Map classesByPtr;
    private Map classesByName;
    private Map classesByNameWithoutPackage;
    private java.util.List breakpoints;
    private int runCommand;
    private long runCommandThreadPtr;
    private volatile Thread runningThread;
    private Thread testConnectionThread;
    private boolean talking;
    private java.util.List pins;
    private ByteArrayOutputStream baosJustInCase;
    private DeflaterOutputStream dosJustInCase;
    private java.util.List connectionLogs;
    volatile boolean logging;
    static final String LOG_SendMsg = "send    ";
    static final String LOG_Send = "s       ";
    static final String LOG_ReceivedMsg = "recv    ";
    static final String LOG_Received = "r       ";
    static final String LOG_Quote = "\"";
    private static final String LOG_ReceivedUnexpected = "recv Unexpected ";
    static String[] logStrings = new String[255];
    static final int Int1InMess = 1;
    static final int Int2InMess = 2;
    static final int Int3InMess = 4;
    static final int Int4InMess = 8;
    static final int Int5InMess = 16;
    static final int Ptr1InMess = 256;
    static final int Ptr2InMess = 512;
    static final int Ptr3InMess = 1024;
    static final int Ptr4InMess = 2048;
    static final int Ptr5InMess = 4096;
    static final int StrInMess = 65536;
    static final int BytesInMess = 131072;
    static final int PtrArrInMess = 0x100000;
    static final int ARGS_NONE = 0;
    static final int ARGS_S = 65536;
    static final int ARGS_I = 1;
    static final int ARGS_P = 256;
    static final int ARGS_IS = 65537;
    static final int ARGS_PS = 65792;
    static final int ARGS_PB = 131328;
    static final int ARGS_II = 3;
    static final int ARGS_PI = 258;
    static final int ARGS_PP = 768;
    static final int ARGS_IIS = 65539;
    static final int ARGS_PIS = 65794;
    static final int ARGS_PPS = 66304;
    static final int ARGS_III = 7;
    static final int ARGS_PII = 262;
    static final int ARGS_PPI = 772;
    static final int ARGS_IIIS = 65543;
    static final int ARGS_PPPS = 67328;
    static final int ARGS_IIII = 15;
    static final int ARGS_PIII = 270;
    static final int ARGS_PPIP = 2820;
    static final int ARGS_IIIIS = 65551;
    static final int ARGS_PIIIS = 65806;
    static final int ARGS_IIIII = 31;
    static final int ARGS_PIIII = 286;
    static final int ARGS_PPIIP = 4876;
    static final int ARGS_IIIIIS = 65567;
    static final int ARGS_PA = 0x100000;
    private static final int FIELDS_NoFinal = 1;
    private static final int FIELDS_NoStatic = 2;
    private static final int FIELDS_NonNullCompositesOnly = 4;
    private static final int eventId_OJVM_GET_FIELDS = 3789;
    private static final boolean eventOn_OJVM_GET_FIELDS;
    private Map savedLocations;

    static {
        int n = logStrings.length - 1;
        while (n >= 0) {
            DebugFerrari.logStrings[n] = "0x" + Integer.toHexString(n).toUpperCase() + " ";
            --n;
        }
        logStrings[1] = logStrings[1] + "Ok";
        logStrings[2] = logStrings[2] + "NotOk";
        logStrings[4] = logStrings[4] + "True";
        logStrings[5] = logStrings[5] + "False";
        logStrings[6] = logStrings[6] + "EndMultipleBlock";
        logStrings[16] = logStrings[16] + "String";
        logStrings[17] = logStrings[17] + "Integer";
        logStrings[18] = logStrings[18] + "IS";
        logStrings[19] = logStrings[19] + "II";
        logStrings[20] = logStrings[20] + "IIS";
        logStrings[21] = logStrings[21] + "III";
        logStrings[22] = logStrings[22] + "IIIS";
        logStrings[23] = logStrings[23] + "IIII";
        logStrings[24] = logStrings[24] + "IIIIS";
        logStrings[25] = logStrings[25] + "IIIII";
        logStrings[26] = logStrings[26] + "IIIIIS";
        logStrings[32] = logStrings[32] + "IsOk";
        logStrings[33] = logStrings[33] + "FilenameCaseSensitivity";
        logStrings[34] = logStrings[34] + "Quit";
        logStrings[35] = logStrings[35] + "SetPauseInterval";
        logStrings[36] = logStrings[36] + "GetSourceDirectory";
        logStrings[37] = logStrings[37] + "NonDebuggablePackages";
        logStrings[38] = logStrings[38] + "RequestCodeCoverage";
        logStrings[39] = logStrings[39] + "GetCurrentBreakpoint";
        logStrings[40] = logStrings[40] + "GetCurrentThread";
        logStrings[41] = logStrings[41] + "GetCurrentThrow";
        logStrings[42] = logStrings[42] + "IsCurrentThrowHandled";
        logStrings[43] = logStrings[43] + "IsDeadlockDetected";
        logStrings[44] = logStrings[44] + "GetExtendedProtocolVersion";
        logStrings[45] = logStrings[45] + "SetExtendedProtocolVersion";
        logStrings[46] = logStrings[46] + "DebuggablePackages";
        logStrings[48] = logStrings[48] + "SpecialVM";
        logStrings[49] = logStrings[49] + "SpecialClass";
        logStrings[50] = logStrings[50] + "SpecialField";
        logStrings[51] = logStrings[51] + "SpecialMethod";
        logStrings[52] = logStrings[52] + "SpecialMonitor";
        logStrings[53] = logStrings[53] + "SpecialThread";
        logStrings[54] = logStrings[54] + "GetPointerSize";
        logStrings[55] = logStrings[55] + "GetAllMessages";
        logStrings[56] = logStrings[56] + "TestConnection";
        logStrings[57] = logStrings[57] + "GetWatchpointFieldOrFutureValue";
        logStrings[58] = logStrings[58] + "GetUniqueID";
        logStrings[64] = logStrings[64] + "Run";
        logStrings[65] = logStrings[65] + "StepInto";
        logStrings[66] = logStrings[66] + "StepOver";
        logStrings[67] = logStrings[67] + "StepIntoBC";
        logStrings[68] = logStrings[68] + "StepOverBC";
        logStrings[69] = logStrings[69] + "StepOut";
        logStrings[70] = logStrings[70] + "StepToEndOfMethod";
        logStrings[71] = logStrings[71] + "DidStepFinish";
        logStrings[72] = logStrings[72] + "ContinueStep";
        logStrings[73] = logStrings[73] + "ContinueRun";
        logStrings[74] = logStrings[74] + "IsAtEndOfMethod";
        logStrings[75] = logStrings[75] + "RedefineClass";
        logStrings[76] = logStrings[76] + "PopFrames";
        logStrings[77] = logStrings[77] + "PinUnpinReference";
        logStrings[78] = logStrings[78] + "CreateString";
        logStrings[79] = logStrings[79] + "InvokeMethod";
        logStrings[80] = logStrings[80] + "PutBreakpointFileLine";
        logStrings[81] = logStrings[81] + "PutBreakpointMethodBytecode";
        logStrings[82] = logStrings[82] + "PutBreakpointMethod";
        logStrings[83] = logStrings[83] + "PutBreakpointClass";
        logStrings[84] = logStrings[84] + "PutBreakpointException";
        logStrings[85] = logStrings[85] + "PutBreakpointClassLoad";
        logStrings[86] = logStrings[86] + "PutBreakpointAllocationSize";
        logStrings[87] = logStrings[87] + "PutBreakpointAllocationClass";
        logStrings[88] = logStrings[88] + "PutBreakpointDeadlock";
        logStrings[89] = logStrings[89] + "PutBreakpointWatchpoint";
        logStrings[96] = logStrings[96] + "BreakpointLocation";
        logStrings[97] = logStrings[97] + "RemoveBreakpoint";
        logStrings[98] = logStrings[98] + "RemoveAllBreakpoints";
        logStrings[99] = logStrings[99] + "SetBreakpointThread";
        logStrings[100] = logStrings[100] + "SetBreakpointEnabled";
        logStrings[101] = logStrings[101] + "SetBreakpointStop";
        logStrings[102] = logStrings[102] + "SetBreakpointLog";
        logStrings[103] = logStrings[103] + "SetBreakpointName";
        logStrings[104] = logStrings[104] + "SetBreakpointEnableOtherBPs";
        logStrings[105] = logStrings[105] + "SetBreakpointDisableOtherBPs";
        logStrings[106] = logStrings[106] + "SetBreakpointPassCount";
        logStrings[107] = logStrings[107] + "SetBreakpointCondition";
        logStrings[108] = logStrings[108] + "SetBreakpointThreadNot";
        logStrings[109] = logStrings[109] + "BreakpointInstanceFilter";
        logStrings[112] = logStrings[112] + "CountObjectsOfClass";
        logStrings[113] = logStrings[113] + "GetClassObject";
        logStrings[114] = logStrings[114] + "GetClassSuperClass";
        logStrings[115] = logStrings[115] + "CountClassMethods";
        logStrings[116] = logStrings[116] + "GetClassMethods";
        logStrings[117] = logStrings[117] + "CountClassStaticFields";
        logStrings[118] = logStrings[118] + "GetClassStaticFields";
        logStrings[119] = logStrings[119] + "CountClassFields";
        logStrings[120] = logStrings[120] + "GetClassFields";
        logStrings[121] = logStrings[121] + "IsClassDebuggable";
        logStrings[122] = logStrings[122] + "SetClassDebuggable";
        logStrings[123] = logStrings[123] + "GenerateSourceFile";
        logStrings[124] = logStrings[124] + "IsClassCodeCoverage";
        logStrings[125] = logStrings[125] + "SetClassCodeCoverage";
        logStrings[126] = logStrings[126] + "DiscardClassCodeCoverage";
        logStrings[127] = logStrings[127] + "GetClassInterfaces";
        logStrings[128] = logStrings[128] + "GetMethodLineRange";
        logStrings[129] = logStrings[129] + "GetMethodLines";
        logStrings[130] = logStrings[130] + "DisassembleMethod";
        logStrings[131] = logStrings[131] + "JavaLine";
        logStrings[132] = logStrings[132] + "BytecodeLine";
        logStrings[133] = logStrings[133] + "AssemblyLine";
        logStrings[134] = logStrings[134] + "HasMethodChanged";
        logStrings[135] = logStrings[135] + "GetMethodAccess";
        logStrings[136] = logStrings[136] + "GetJavaLine";
        logStrings[137] = logStrings[137] + "GetLocation";
        logStrings[138] = logStrings[138] + "GetMethodCodeCoverage";
        logStrings[139] = logStrings[139] + "GetCodeCoverageRatio";
        logStrings[140] = logStrings[140] + "GetBytecodes";
        logStrings[141] = logStrings[141] + "GetBytecode";
        logStrings[142] = logStrings[142] + "IsClassObfuscated";
        logStrings[143] = logStrings[143] + "GetArrayElementClass";
        logStrings[144] = logStrings[144] + "GetThreadGroups";
        logStrings[145] = logStrings[145] + "GetThreadGroupObject";
        logStrings[146] = logStrings[146] + "GetThreadGroupParent";
        logStrings[147] = logStrings[147] + "GetThreadGroupGroups";
        logStrings[148] = logStrings[148] + "GetThreadGroupThreads";
        logStrings[149] = logStrings[149] + "GetClassLoaderObject";
        logStrings[150] = logStrings[150] + "GetFieldByName";
        logStrings[151] = logStrings[151] + "GetPrimarySourceFilename";
        logStrings[160] = logStrings[160] + "GetThreads";
        logStrings[161] = logStrings[161] + "GetThreadObject";
        logStrings[162] = logStrings[162] + "GetThreadRegisters";
        logStrings[163] = logStrings[163] + "GetThreadFloatRegisters";
        logStrings[164] = logStrings[164] + "ModifyThreadRegister";
        logStrings[165] = logStrings[165] + "GetStackFrame";
        logStrings[166] = logStrings[166] + "GetStackFrames";
        logStrings[167] = logStrings[167] + "IsThreadSuspended";
        logStrings[168] = logStrings[168] + "SuspendThread";
        logStrings[169] = logStrings[169] + "ResumeThread";
        logStrings[170] = logStrings[170] + "GetThread";
        logStrings[171] = logStrings[171] + "GetThreadGroup";
        logStrings[172] = logStrings[172] + "GetObjectFromAddress";
        logStrings[173] = logStrings[173] + "GetThreadStatus";
        logStrings[175] = logStrings[175] + "GetStackFrameCount";
        logStrings[176] = logStrings[176] + "GetArgs";
        logStrings[177] = logStrings[177] + "GetLocals";
        logStrings[178] = logStrings[178] + "GetSlots";
        logStrings[179] = logStrings[179] + "ModifySlot";
        logStrings[180] = logStrings[180] + "countFields";
        logStrings[181] = logStrings[181] + "GetFields";
        logStrings[182] = logStrings[182] + "CountArrayElements";
        logStrings[183] = logStrings[183] + "GetArrayElements";
        logStrings[184] = logStrings[184] + "ModifyData";
        logStrings[185] = logStrings[185] + "GetCourtesyInfo";
        logStrings[186] = logStrings[186] + "GetFieldData";
        logStrings[187] = logStrings[187] + "FindFieldValue";
        logStrings[188] = logStrings[188] + "GetArrayValues";
        logStrings[189] = logStrings[189] + "GetReturnValue";
        logStrings[190] = logStrings[190] + "GetReturnedValue";
        logStrings[191] = logStrings[191] + "ModifyString";
        logStrings[192] = logStrings[192] + "GarbageCollection";
        logStrings[193] = logStrings[193] + "DumpMemory";
        logStrings[194] = logStrings[194] + "IsHeapAddressValid";
        logStrings[195] = logStrings[195] + "GetHeapObject";
        logStrings[196] = logStrings[196] + "CountHeap";
        logStrings[197] = logStrings[197] + "GetHeap";
        logStrings[198] = logStrings[198] + "HeapSubsetClass";
        logStrings[199] = logStrings[199] + "HeapSubsetAncestors";
        logStrings[200] = logStrings[200] + "HeapSubsetDescendants";
        logStrings[201] = logStrings[201] + "HeapSubsetRoots";
        logStrings[204] = logStrings[204] + "GetHeapObjects";
        logStrings[205] = logStrings[205] + "PinObject";
        logStrings[206] = logStrings[206] + "UnpinObject";
        logStrings[207] = logStrings[207] + "WasPinnedObjectDiscarded";
        logStrings[208] = logStrings[208] + "HeapAncestorInStack";
        logStrings[209] = logStrings[209] + "HeapAncestorInRegister";
        logStrings[210] = logStrings[210] + "HeapAncestorInPinTable";
        logStrings[211] = logStrings[211] + "HeapAncestorInStatic";
        logStrings[212] = logStrings[212] + "GetWholeThing";
        logStrings[213] = logStrings[213] + "GetClassGenericSignature";
        logStrings[214] = logStrings[214] + "GetFieldGenericSignature";
        logStrings[215] = logStrings[215] + "GetLocalGenericSignature";
        logStrings[224] = logStrings[224] + "GetMonitorThreadWaitingFor";
        logStrings[225] = logStrings[225] + "GetMonitorThreadBlockedFor";
        logStrings[226] = logStrings[226] + "GetMonitors";
        logStrings[227] = logStrings[227] + "GetWaitingThreads";
        logStrings[228] = logStrings[228] + "GetBlockedThreads";
        logStrings[229] = logStrings[229] + "GetMonitorForObject";
        logStrings[230] = logStrings[230] + "GetObjectWithMonitor";
        logStrings[231] = logStrings[231] + "GetMonitorEntryLocation";
        logStrings[232] = logStrings[232] + "DoMonitorNotify";
        logStrings[240] = logStrings[240] + "ProgramStopped";
        logStrings[241] = logStrings[241] + "ProgramTerminated";
        logStrings[242] = logStrings[242] + "DoYouWantToPause";
        logStrings[243] = logStrings[243] + "ClassLoaded";
        logStrings[244] = logStrings[244] + "ClassUnloaded";
        logStrings[245] = logStrings[245] + "BreakpointChanged";
        logStrings[246] = logStrings[246] + "BreakpointLog";
        logStrings[247] = logStrings[247] + "ExceptionLog";
        logStrings[248] = logStrings[248] + "ClassLoadLog";
        logStrings[249] = logStrings[249] + "AllocationLog";
        logStrings[250] = logStrings[250] + "DeadlockLog";
        logStrings[251] = logStrings[251] + "BreakpointCondition";
        logStrings[252] = logStrings[252] + "WatchpointLog";
        eventOn_OJVM_GET_FIELDS = IdeProfile.isEventActive((int)3789);
    }

    DebugFerrari(DebugFerrariTransport debugFerrariTransport, boolean bl) {
        this.initSync();
        this.transport = debugFerrariTransport;
        this.vmWasRunning = bl;
        debugFerrariTransport.df = this;
        this.stoppedCount = 0;
        this.stoppedListeners = new ArrayList();
        this.dataInfosByPlace = new HashMap();
        this.dataInfosByAddress = new HashMap();
        this.threadInfosByThreadPtr = new HashMap();
        this.classLoaderInfosByAddress = new HashMap();
        this.classLoaderIds = new HashMap();
        this.initSavedLocations();
        this.classes = new ArrayList();
        this.classesByPtr = new HashMap();
        this.classesByName = new HashMap();
        this.classesByNameWithoutPackage = new HashMap();
        this.breakpoints = new ArrayList();
        this.pins = new ArrayList();
        try {
            String string = Ide.getProperty((String)"DebuggerConnectionLog");
            if (string != null) {
                if (string.equals("System.out")) {
                    this.addConnectionLog(System.out);
                } else if (string.equals("System.err")) {
                    this.addConnectionLog(System.err);
                } else if (string.equals("file")) {
                    this.addConnectionLog(File.createTempFile("ojvm", null, new File(Ide.getBinDirectory())));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        debugFerrariTransport.sendMessage(44);
        int n = debugFerrariTransport.receiveMessage();
        if (n == 2) {
            this.extendedProtocolVersion = 0;
        } else if (n == 17) {
            int n2 = debugFerrariTransport.receiveInt();
            this.extendedProtocolVersion = n2 < 31 ? n2 : 31;
            if (n2 != 31) {
                // empty if block
            }
            debugFerrariTransport.sendMessage(45, this.extendedProtocolVersion);
            this.receiveResponse();
        }
        if (this.extendedProtocolVersion >= 12) {
            debugFerrariTransport.sendMessage(54);
            int n3 = this.receiveIntegerResponse();
            debugFerrariTransport.setPointerSize(n3);
        }
        boolean bl2 = true;
        debugFerrariTransport.sendMessage(33, 1);
        this.receiveResponse();
        if (bl) {
            this.setSyncValue(1, true);
            this.doRunCommand(73, null);
        }
    }

    public void afterConnection(MessagePage messagePage) {
    }

    public synchronized void addDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.add(this.debugListener, debugListener);
    }

    public synchronized void removeDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.remove(this.debugListener, debugListener);
    }

    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.add(this.bpLogListener, debugBreakpointLogListener);
    }

    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.remove(this.bpLogListener, debugBreakpointLogListener);
    }

    public boolean isConnected() {
        return this.transport.isConnected();
    }

    private synchronized boolean testConnection() {
        if (this.extendedProtocolVersion >= 22) {
            try {
                this.transport.sendMessage(56);
                boolean bl = this.receiveResponse();
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    int messageArguments(int n) {
        if (this.extendedProtocolVersion >= 31) {
            switch (n) {
                case 213: {
                    return 256;
                }
                case 214: {
                    return 256;
                }
                case 215: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 30) {
            switch (n) {
                case 150: {
                    return 66304;
                }
            }
        }
        if (this.extendedProtocolVersion >= 26) {
            switch (n) {
                case 89: {
                    return 65794;
                }
                case 109: {
                    return 772;
                }
                case 58: {
                    return 256;
                }
                case 252: {
                    return 256;
                }
                case 57: {
                    return 1;
                }
            }
        }
        if (this.extendedProtocolVersion >= 25) {
            switch (n) {
                case 77: {
                    return 258;
                }
                case 78: {
                    return 65536;
                }
                case 79: {
                    return 258;
                }
            }
        }
        if (this.extendedProtocolVersion >= 24) {
            switch (n) {
                case 232: {
                    return 258;
                }
            }
        }
        if (this.extendedProtocolVersion >= 23) {
            switch (n) {
                case 75: {
                    return 1;
                }
            }
        }
        if (this.extendedProtocolVersion >= 22) {
            switch (n) {
                case 56: {
                    return 0;
                }
            }
        }
        if (this.extendedProtocolVersion >= 21) {
            switch (n) {
                case 137: {
                    return 65794;
                }
                case 151: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 20) {
            switch (n) {
                case 75: {
                    return 131328;
                }
                case 76: {
                    return 258;
                }
            }
        }
        if (this.extendedProtocolVersion >= 19) {
            switch (n) {
                case 150: {
                    return 65792;
                }
            }
        }
        if (this.extendedProtocolVersion >= 18) {
            switch (n) {
                case 175: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 17) {
            switch (n) {
                case 204: {
                    return 0x100000;
                }
            }
        }
        if (this.extendedProtocolVersion >= 16) {
            switch (n) {
                case 149: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 15) {
            switch (n) {
                case 174: {
                    return 768;
                }
            }
        }
        if (this.extendedProtocolVersion >= 14) {
            switch (n) {
                case 47: {
                    return 0;
                }
            }
        }
        if (this.extendedProtocolVersion >= 13) {
            switch (n) {
                case 143: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 12) {
            switch (n) {
                case 54: {
                    return 0;
                }
                case 55: {
                    return 0;
                }
            }
        }
        if (this.extendedProtocolVersion >= 9) {
            switch (n) {
                case 46: {
                    return 65536;
                }
                case 108: {
                    return 65792;
                }
                case 142: {
                    return 256;
                }
                case 212: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 8) {
            switch (n) {
                case 84: {
                    return 65794;
                }
                case 247: {
                    return 65794;
                }
            }
        }
        if (this.extendedProtocolVersion >= 7) {
            switch (n) {
                case 205: {
                    return 256;
                }
                case 206: {
                    return 256;
                }
                case 207: {
                    return 258;
                }
            }
        }
        if (this.extendedProtocolVersion >= 6) {
            switch (n) {
                case 208: {
                    return 256;
                }
                case 211: {
                    return 768;
                }
            }
        }
        if (this.extendedProtocolVersion >= 5) {
            switch (n) {
                case 127: {
                    return 258;
                }
            }
        }
        if (this.extendedProtocolVersion >= 4) {
            switch (n) {
                case 117: {
                    return 262;
                }
                case 118: {
                    return 270;
                }
            }
        }
        if (this.extendedProtocolVersion >= 3) {
            switch (n) {
                case 191: {
                    return 67328;
                }
            }
        }
        if (this.extendedProtocolVersion >= 2) {
            switch (n) {
                case 173: {
                    return 256;
                }
            }
        }
        if (this.extendedProtocolVersion >= 1) {
            switch (n) {
                case 45: {
                    return 1;
                }
                case 46: {
                    return 65536;
                }
                case 107: {
                    return 258;
                }
                case 172: {
                    return 256;
                }
                case 199: {
                    return 262;
                }
                case 210: {
                    return 768;
                }
                case 211: {
                    return 256;
                }
                case 249: {
                    return 2820;
                }
                case 251: {
                    return 256;
                }
            }
        }
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0;
            }
            case 16: {
                return 65536;
            }
            case 17: {
                return 1;
            }
            case 18: {
                return 65537;
            }
            case 19: {
                return 3;
            }
            case 20: {
                return 65539;
            }
            case 21: {
                return 7;
            }
            case 22: {
                return 65543;
            }
            case 23: {
                return 15;
            }
            case 24: {
                return 65551;
            }
            case 25: {
                return 31;
            }
            case 26: {
                return 65567;
            }
            case 32: {
                return 0;
            }
            case 33: {
                return 1;
            }
            case 34: {
                return 1;
            }
            case 35: {
                return 1;
            }
            case 36: {
                return 0;
            }
            case 37: {
                return 65536;
            }
            case 38: {
                return 65537;
            }
            case 39: {
                return 0;
            }
            case 40: {
                return 0;
            }
            case 41: {
                return 0;
            }
            case 42: {
                return 0;
            }
            case 43: {
                return 0;
            }
            case 44: {
                return 0;
            }
            case 48: {
                return 1;
            }
            case 49: {
                return 258;
            }
            case 50: {
                return 772;
            }
            case 51: {
                return 258;
            }
            case 52: {
                return 258;
            }
            case 53: {
                return 258;
            }
            case 64: {
                return 0;
            }
            case 65: {
                return 256;
            }
            case 66: {
                return 256;
            }
            case 67: {
                return 256;
            }
            case 68: {
                return 256;
            }
            case 69: {
                return 256;
            }
            case 70: {
                return 256;
            }
            case 71: {
                return 0;
            }
            case 72: {
                return 0;
            }
            case 73: {
                return 0;
            }
            case 74: {
                return 256;
            }
            case 80: {
                return 65794;
            }
            case 81: {
                return 65794;
            }
            case 82: {
                return 65792;
            }
            case 83: {
                return 65792;
            }
            case 84: {
                return 65792;
            }
            case 85: {
                return 65792;
            }
            case 86: {
                return 258;
            }
            case 87: {
                return 65792;
            }
            case 88: {
                return 256;
            }
            case 96: {
                return 286;
            }
            case 97: {
                return 256;
            }
            case 98: {
                return 1;
            }
            case 99: {
                return 65792;
            }
            case 100: {
                return 258;
            }
            case 101: {
                return 258;
            }
            case 102: {
                return 258;
            }
            case 103: {
                return 65792;
            }
            case 104: {
                return 65792;
            }
            case 105: {
                return 65792;
            }
            case 106: {
                return 258;
            }
            case 112: {
                return 256;
            }
            case 113: {
                return 256;
            }
            case 114: {
                return 258;
            }
            case 115: {
                return 256;
            }
            case 116: {
                return 256;
            }
            case 117: {
                return 256;
            }
            case 118: {
                return 258;
            }
            case 119: {
                return 262;
            }
            case 120: {
                return 270;
            }
            case 121: {
                return 256;
            }
            case 122: {
                return 258;
            }
            case 123: {
                return 256;
            }
            case 124: {
                return 256;
            }
            case 125: {
                return 258;
            }
            case 126: {
                return 256;
            }
            case 128: {
                return 256;
            }
            case 129: {
                return 256;
            }
            case 130: {
                return 258;
            }
            case 131: {
                return 1;
            }
            case 132: {
                return 65537;
            }
            case 133: {
                return 65792;
            }
            case 134: {
                return 256;
            }
            case 135: {
                return 256;
            }
            case 136: {
                return 768;
            }
            case 137: {
                return 258;
            }
            case 138: {
                return 256;
            }
            case 139: {
                return 768;
            }
            case 140: {
                return 256;
            }
            case 141: {
                return 258;
            }
            case 144: {
                return 1;
            }
            case 145: {
                return 256;
            }
            case 146: {
                return 256;
            }
            case 147: {
                return 256;
            }
            case 148: {
                return 256;
            }
            case 160: {
                return 0;
            }
            case 161: {
                return 256;
            }
            case 162: {
                return 256;
            }
            case 163: {
                return 256;
            }
            case 164: {
                return 65794;
            }
            case 165: {
                return 258;
            }
            case 166: {
                return 256;
            }
            case 167: {
                return 256;
            }
            case 168: {
                return 256;
            }
            case 169: {
                return 256;
            }
            case 170: {
                return 256;
            }
            case 171: {
                return 256;
            }
            case 176: {
                return 258;
            }
            case 177: {
                return 258;
            }
            case 178: {
                return 258;
            }
            case 179: {
                return 65792;
            }
            case 180: {
                return 262;
            }
            case 181: {
                return 270;
            }
            case 182: {
                return 258;
            }
            case 183: {
                return 270;
            }
            case 184: {
                return 67328;
            }
            case 185: {
                return 258;
            }
            case 186: {
                return 256;
            }
            case 187: {
                return 65792;
            }
            case 188: {
                return 256;
            }
            case 189: {
                return 256;
            }
            case 190: {
                return 256;
            }
            case 192: {
                return 0;
            }
            case 193: {
                return 65794;
            }
            case 194: {
                return 256;
            }
            case 195: {
                return 256;
            }
            case 196: {
                return 0;
            }
            case 197: {
                return 1;
            }
            case 198: {
                return 258;
            }
            case 199: {
                return 258;
            }
            case 200: {
                return 256;
            }
            case 201: {
                return 0;
            }
            case 208: {
                return 0;
            }
            case 209: {
                return 0;
            }
            case 210: {
                return 0;
            }
            case 211: {
                return 768;
            }
            case 224: {
                return 256;
            }
            case 225: {
                return 256;
            }
            case 226: {
                return 256;
            }
            case 227: {
                return 256;
            }
            case 228: {
                return 256;
            }
            case 229: {
                return 256;
            }
            case 230: {
                return 256;
            }
            case 231: {
                return 256;
            }
            case 240: {
                return 0;
            }
            case 241: {
                return 0;
            }
            case 242: {
                return 0;
            }
            case 243: {
                return 65806;
            }
            case 244: {
                return 256;
            }
            case 245: {
                return 0;
            }
            case 246: {
                return 256;
            }
            case 247: {
                return 65792;
            }
            case 248: {
                return 65792;
            }
            case 249: {
                return 4876;
            }
            case 250: {
                return 256;
            }
        }
        return 0;
    }

    public boolean isRunning() {
        return this.runningThread != null;
    }

    public boolean isStopped() {
        return this.getSyncValue(0);
    }

    public boolean isTerminated() {
        this.throwIfRunning();
        return this.getSyncValue(4);
    }

    public boolean wasRunning() {
        return this.vmWasRunning;
    }

    public void disconnect() {
        this.disconnect(this.vmWasRunning ^ true);
    }

    public void disconnect(boolean bl) {
        if (this.isRunning()) {
            this.setSyncValue(3, bl);
            this.setSyncValue(2, true);
        } else {
            this.disconnectWhileStopped(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectWhileStopped(boolean bl) {
        this.killTestConnectionThread();
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            if (this.isConnected()) {
                if (!this.getSyncValue(4)) {
                    if (bl) {
                        this.pins.clear();
                        this.transport.sendMessage(34, 1);
                    } else {
                        this.unpinAll();
                        this.transport.sendMessage(34, 0);
                    }
                }
                this.transport.disconnect();
                this.incrementStoppedCount(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionLog(Object object) {
        Object object2 = this.syncObjects[5];
        synchronized (object2) {
            this.logging = true;
            if (this.connectionLogs == null) {
                this.connectionLogs = new ArrayList();
            }
            this.connectionLogs.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionLog(Object object) {
        Object object2 = this.syncObjects[5];
        synchronized (object2) {
            if (this.connectionLogs != null) {
                this.connectionLogs.remove(object);
                if (this.connectionLogs.size() == 0) {
                    this.connectionLogs = null;
                    this.logging = false;
                }
            }
        }
    }

    public synchronized String getName() {
        if (this.extendedProtocolVersion >= 14) {
            this.throwIfRunning();
            this.transport.sendMessage(47);
            return this.receiveStringResponse();
        }
        return null;
    }

    public int getLanguages() {
        return 1;
    }

    public synchronized String[] redefineClasses(Map map) {
        this.throwIfRunning();
        ArrayList arrayList = new ArrayList();
        boolean bl = true;
        if (this.extendedProtocolVersion >= 20) {
            try {
                HashMap hashMap = new HashMap();
                ArrayList<DebugFerrariClassInfo> arrayList2 = new ArrayList<DebugFerrariClassInfo>();
                for (Object k : map.keySet()) {
                    Object v = map.get(k);
                    Object v2 = this.classesByName.get(k);
                    if (v2 instanceof DebugFerrariClassInfo) {
                        DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)v2;
                        if (debugFerrariClassInfo.classPtr == 0L || hashMap.containsKey(debugFerrariClassInfo)) continue;
                        hashMap.put(debugFerrariClassInfo, v);
                        arrayList2.add(debugFerrariClassInfo);
                        continue;
                    }
                    if (!(v2 instanceof java.util.List)) continue;
                    for (DebugFerrariClassInfo debugFerrariClassInfo : (java.util.List)v2) {
                        if (debugFerrariClassInfo.classPtr == 0L || hashMap.containsKey(debugFerrariClassInfo)) continue;
                        hashMap.put(debugFerrariClassInfo, v);
                        arrayList2.add(debugFerrariClassInfo);
                    }
                }
                int n = arrayList2.size();
                if (this.extendedProtocolVersion >= 23) {
                    this.transport.sendMessage(75, n);
                }
                int n2 = 0;
                for (DebugFerrariClassInfo debugFerrariClassInfo : hashMap.keySet()) {
                    byte[] byArray;
                    if (!this.redefineClass(debugFerrariClassInfo, byArray = (byte[])hashMap.get(debugFerrariClassInfo), arrayList)) {
                        bl = false;
                    }
                    ++n2;
                }
                if (this.extendedProtocolVersion >= 23 && !this.receiveRedefineClassResults(arrayList, null)) {
                    bl = false;
                }
                if (bl) {
                    int n3 = 0;
                    while (n3 < n) {
                        DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)arrayList2.get(n3);
                        debugFerrariClassInfo.redefinedClass();
                        ++n3;
                    }
                    if (this.extendedProtocolVersion < 23) {
                        int n4 = this.breakpoints.size() - 1;
                        while (n4 >= 0) {
                            DebugFerrariBreakpoint debugFerrariBreakpoint = (DebugFerrariBreakpoint)this.breakpoints.get(n4);
                            this.putBreakpoint(debugFerrariBreakpoint);
                            --n4;
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean redefineClass(DebugFerrariClassInfo debugFerrariClassInfo, byte[] byArray, java.util.List list) {
        if (this.extendedProtocolVersion >= 23) {
            this.transport.sendPointer(debugFerrariClassInfo.classPtr);
            this.transport.sendBytes(byArray);
            return true;
        }
        this.transport.sendMessage(75, debugFerrariClassInfo.classPtr, byArray);
        return this.receiveRedefineClassResults(list, debugFerrariClassInfo);
    }

    private boolean receiveRedefineClassResults(java.util.List list, DebugFerrariClassInfo debugFerrariClassInfo) {
        while (true) {
            int n;
            if ((n = this.transport.receiveMessage()) == 245) {
                this.notifiedBreakpointChanged();
                continue;
            }
            if (n == 17) {
                DebugFerrariClassInfo debugFerrariClassInfo2 = this.findClass(this.transport.receivePointer());
                list.add(DebugFerrariArb.format(7, debugFerrariClassInfo2.name));
                continue;
            }
            if (n == 18) {
                DebugFerrariClassInfo debugFerrariClassInfo3 = this.findClass(this.transport.receivePointer());
                String string = this.transport.receiveString();
                if (string.equals("java/lang/IncompatibleClassChangeError")) {
                    list.add(DebugFerrariArb.format(9, debugFerrariClassInfo3.name));
                    continue;
                }
                list.add(DebugFerrariArb.format(8, debugFerrariClassInfo3.name, string));
                continue;
            }
            if (n == 2) {
                if (debugFerrariClassInfo != null) {
                    list.add(DebugFerrariArb.format(7, debugFerrariClassInfo.name));
                }
                return false;
            }
            if (n == 1) {
                return true;
            }
            this.unexpectedResponse(n, "class " + debugFerrariClassInfo.name);
        }
    }

    void log(String string) {
        this.log(string, null, null, null, null, null, null);
    }

    void log(String string, String string2) {
        this.log(string, string2, null, null, null, null, null);
    }

    void log(String string, String string2, String string3) {
        this.log(string, string2, string3, null, null, null, null);
    }

    void log(String string, String string2, String string3, String string4) {
        this.log(string, string2, string3, string4, null, null, null);
    }

    void log(String string, String string2, String string3, String string4, String string5) {
        this.log(string, string2, string3, string4, string5, null, null);
    }

    void log(String string, String string2, String string3, String string4, String string5, String string6) {
        this.log(string, string2, string3, string4, string5, string6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                int n = this.connectionLogs.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.connectionLogs.get(n2);
                    try {
                        if (e instanceof List) {
                            List list = (List)e;
                            list.add(string);
                            if (string2 != null) {
                                list.add(string2);
                            }
                            if (string3 != null) {
                                list.add(string3);
                            }
                            if (string4 != null) {
                                list.add(string4);
                            }
                            if (string5 != null) {
                                list.add(string5);
                            }
                            if (string6 != null) {
                                list.add(string6);
                            }
                            if (string7 != null) {
                                list.add(string7);
                            }
                            list.makeVisible(list.getItemCount() - 1);
                        } else if (e instanceof PrintStream) {
                            PrintStream printStream = (PrintStream)e;
                            printStream.println(string);
                            if (string2 != null) {
                                printStream.println(string2);
                            }
                            if (string3 != null) {
                                printStream.println(string3);
                            }
                            if (string4 != null) {
                                printStream.println(string4);
                            }
                            if (string5 != null) {
                                printStream.println(string5);
                            }
                            if (string6 != null) {
                                printStream.println(string6);
                            }
                            if (string7 != null) {
                                printStream.println(string7);
                            }
                            printStream.flush();
                        } else if (e instanceof File) {
                            String string8 = ((File)e).getAbsolutePath();
                            PrintWriter printWriter = new PrintWriter(new FileWriter(string8, true));
                            printWriter.println(string);
                            if (string2 != null) {
                                printWriter.println(string2);
                            }
                            if (string3 != null) {
                                printWriter.println(string3);
                            }
                            if (string4 != null) {
                                printWriter.println(string4);
                            }
                            if (string5 != null) {
                                printWriter.println(string5);
                            }
                            if (string6 != null) {
                                printWriter.println(string6);
                            }
                            if (string7 != null) {
                                printWriter.println(string7);
                            }
                            printWriter.flush();
                            printWriter.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }

    private synchronized boolean receiveResponse() {
        int n = this.transport.receiveMessage();
        if (n != 1 && n != 2) {
            this.unexpectedResponse(n);
        }
        return n == 1;
    }

    private synchronized void unexpectedResponse(int n) {
        this.unexpectedResponse(n, null);
    }

    private synchronized void unexpectedResponse(int n, String string) {
        String string2 = LOG_ReceivedUnexpected + logStrings[n];
        if (string != null) {
            string2 = string2 + " (" + string + ")";
        }
        if (this.logging) {
            this.log(string2);
        }
        this.transport.disconnect();
        boolean bl = this.setSyncValue(6, true);
        if (!bl) {
            new 2("OJVM Connection Lost").start();
        }
        throw new RuntimeException(string2);
    }

    private synchronized boolean receiveBooleanResponse() {
        boolean bl = false;
        int n = this.transport.receiveMessage();
        if (n == 4) {
            bl = true;
        } else if (n == 5) {
            bl = false;
        } else {
            this.unexpectedResponse(n);
        }
        return bl;
    }

    private synchronized int receiveIntegerResponse() {
        int n = 0;
        int n2 = this.transport.receiveMessage();
        if (n2 == 17) {
            n = this.transport.receiveInt();
        } else {
            this.unexpectedResponse(n2);
        }
        return n;
    }

    private synchronized long receivePointerResponse() {
        long l = 0L;
        int n = this.transport.receiveMessage();
        if (n == 17) {
            l = this.transport.receivePointer();
        } else {
            this.unexpectedResponse(n);
        }
        return l;
    }

    private synchronized String receiveStringResponse() {
        String string = null;
        int n = this.transport.receiveMessage();
        if (n == 16) {
            string = this.transport.receiveString();
        } else if (n != 5) {
            this.unexpectedResponse(n);
        }
        return string;
    }

    private synchronized void throwIfRunning() {
        if (this.runningThread != null && !this.talking) {
            throw new IllegalStateException(DebugFerrariArb.getString(5));
        }
    }

    public synchronized void setNonDebuggablePackages(String string) {
        this.throwIfRunning();
        this.transport.sendMessage(37, string);
        this.receiveResponse();
    }

    public synchronized void setDebuggablePackages(String string, String string2) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 9) {
            this.transport.sendMessage(46, string);
            this.receiveResponse();
            this.transport.sendMessage(37, string2);
            this.receiveResponse();
        } else {
            this.transport.sendMessage(37, string2);
            this.receiveResponse();
            if (this.extendedProtocolVersion >= 1) {
                this.transport.sendMessage(46, string);
                this.receiveResponse();
            }
        }
    }

    public synchronized void requestCodeCoverage(String string, String string2) {
        String string3 = string + " " + string2;
        this.transport.sendMessage(38, 1, string3);
        this.receiveResponse();
    }

    public synchronized void unrequestCodeCoverage(String string, String string2) {
        String string3 = string + " " + string2;
        this.transport.sendMessage(38, 0, string3);
        this.receiveResponse();
    }

    public synchronized void discardCodeCoverage() {
        long l = 0L;
        this.transport.sendMessage(126, l);
        this.receiveResponse();
    }

    private boolean isBreakpointCommand(int n) {
        return n >= 80 && n <= 89;
    }

    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String string, String string2, int n) {
        DebugFerrariBreakpointPackageFileLine debugFerrariBreakpointPackageFileLine = new DebugFerrariBreakpointPackageFileLine(this, string, string2, n);
        this.breakpoints.add(debugFerrariBreakpointPackageFileLine);
        this.putBreakpoint(debugFerrariBreakpointPackageFileLine);
        return debugFerrariBreakpointPackageFileLine;
    }

    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String string, int n) {
        DebugFerrariBreakpointFileLine debugFerrariBreakpointFileLine = new DebugFerrariBreakpointFileLine(this, string, n);
        this.breakpoints.add(debugFerrariBreakpointFileLine);
        this.putBreakpoint(debugFerrariBreakpointFileLine);
        return debugFerrariBreakpointFileLine;
    }

    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String string, int n) {
        DebugFerrariBreakpointMethodBytecode debugFerrariBreakpointMethodBytecode = new DebugFerrariBreakpointMethodBytecode(this, string, n);
        this.breakpoints.add(debugFerrariBreakpointMethodBytecode);
        this.putBreakpoint(debugFerrariBreakpointMethodBytecode);
        return debugFerrariBreakpointMethodBytecode;
    }

    public synchronized DebugBreakpointMethod putBreakpointMethod(String string) {
        DebugFerrariBreakpointMethod debugFerrariBreakpointMethod = new DebugFerrariBreakpointMethod(this, string);
        this.breakpoints.add(debugFerrariBreakpointMethod);
        this.putBreakpoint(debugFerrariBreakpointMethod);
        return debugFerrariBreakpointMethod;
    }

    public synchronized DebugBreakpointClass putBreakpointClass(String string) {
        DebugFerrariBreakpointClass debugFerrariBreakpointClass = new DebugFerrariBreakpointClass(this, string);
        this.breakpoints.add(debugFerrariBreakpointClass);
        this.putBreakpoint(debugFerrariBreakpointClass);
        return debugFerrariBreakpointClass;
    }

    public synchronized DebugBreakpointException putBreakpointException(String string) {
        return this.putBreakpointException(string, true, true);
    }

    public synchronized DebugBreakpointException putBreakpointException(String string, boolean bl, boolean bl2) {
        DebugFerrariBreakpointException debugFerrariBreakpointException = new DebugFerrariBreakpointException(this, string, bl, bl2);
        this.breakpoints.add(debugFerrariBreakpointException);
        this.putBreakpoint(debugFerrariBreakpointException);
        return debugFerrariBreakpointException;
    }

    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String string) {
        DebugFerrariBreakpointClassLoad debugFerrariBreakpointClassLoad = new DebugFerrariBreakpointClassLoad(this, string);
        this.breakpoints.add(debugFerrariBreakpointClassLoad);
        this.putBreakpoint(debugFerrariBreakpointClassLoad);
        return debugFerrariBreakpointClassLoad;
    }

    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int n) {
        DebugFerrariBreakpointAllocationThreshold debugFerrariBreakpointAllocationThreshold = new DebugFerrariBreakpointAllocationThreshold(this, n);
        this.breakpoints.add(debugFerrariBreakpointAllocationThreshold);
        this.putBreakpoint(debugFerrariBreakpointAllocationThreshold);
        return debugFerrariBreakpointAllocationThreshold;
    }

    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String string) {
        DebugFerrariBreakpointAllocationClass debugFerrariBreakpointAllocationClass = new DebugFerrariBreakpointAllocationClass(this, string);
        this.breakpoints.add(debugFerrariBreakpointAllocationClass);
        this.putBreakpoint(debugFerrariBreakpointAllocationClass);
        return debugFerrariBreakpointAllocationClass;
    }

    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        DebugFerrariBreakpointDeadlock debugFerrariBreakpointDeadlock = new DebugFerrariBreakpointDeadlock(this);
        this.breakpoints.add(debugFerrariBreakpointDeadlock);
        this.putBreakpoint(debugFerrariBreakpointDeadlock);
        return debugFerrariBreakpointDeadlock;
    }

    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        if (this.extendedProtocolVersion >= 26) {
            DebugFerrariBreakpointWatchpoint debugFerrariBreakpointWatchpoint = new DebugFerrariBreakpointWatchpoint(this, string, string2, bl, bl2);
            this.breakpoints.add(debugFerrariBreakpointWatchpoint);
            this.putBreakpoint(debugFerrariBreakpointWatchpoint);
            return debugFerrariBreakpointWatchpoint;
        }
        return null;
    }

    synchronized void putBreakpoint(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        boolean bl;
        this.throwIfRunning();
        boolean bl2 = bl = debugFerrariBreakpoint.bpPtr == 0L;
        if (!bl) {
            debugFerrariBreakpoint.locations = null;
        }
        if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointPackageFileLine) {
            DebugFerrariBreakpointPackageFileLine debugFerrariBreakpointPackageFileLine = (DebugFerrariBreakpointPackageFileLine)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointPackageFileLine.pkg + ' ' + debugFerrariBreakpointPackageFileLine.filename;
            int n = debugFerrariBreakpointPackageFileLine.line;
            this.transport.sendMessage(80, debugFerrariBreakpoint.bpPtr, n, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointFileLine) {
            DebugFerrariBreakpointFileLine debugFerrariBreakpointFileLine = (DebugFerrariBreakpointFileLine)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointFileLine.filename;
            int n = debugFerrariBreakpointFileLine.line;
            this.transport.sendMessage(80, debugFerrariBreakpoint.bpPtr, n, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointMethodBytecode) {
            DebugFerrariBreakpointMethodBytecode debugFerrariBreakpointMethodBytecode = (DebugFerrariBreakpointMethodBytecode)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointMethodBytecode.method;
            int n = debugFerrariBreakpointMethodBytecode.bytecodeOffset;
            this.transport.sendMessage(81, debugFerrariBreakpoint.bpPtr, n, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointMethod) {
            DebugFerrariBreakpointMethod debugFerrariBreakpointMethod = (DebugFerrariBreakpointMethod)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointMethod.method;
            this.transport.sendMessage(82, debugFerrariBreakpoint.bpPtr, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointClass) {
            DebugFerrariBreakpointClass debugFerrariBreakpointClass = (DebugFerrariBreakpointClass)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointClass.classname;
            this.transport.sendMessage(83, debugFerrariBreakpoint.bpPtr, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointException) {
            DebugFerrariBreakpointException debugFerrariBreakpointException = (DebugFerrariBreakpointException)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointException.exception;
            if (this.extendedProtocolVersion >= 8) {
                int n = 0;
                if (debugFerrariBreakpointException.caught) {
                    n |= 1;
                }
                if (debugFerrariBreakpointException.uncaught) {
                    n |= 2;
                }
                this.transport.sendMessage(84, debugFerrariBreakpoint.bpPtr, n, string);
            } else {
                this.transport.sendMessage(84, debugFerrariBreakpoint.bpPtr, string);
            }
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointClassLoad) {
            DebugFerrariBreakpointClassLoad debugFerrariBreakpointClassLoad = (DebugFerrariBreakpointClassLoad)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointClassLoad.classname;
            this.transport.sendMessage(85, debugFerrariBreakpoint.bpPtr, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointAllocationThreshold) {
            DebugFerrariBreakpointAllocationThreshold debugFerrariBreakpointAllocationThreshold = (DebugFerrariBreakpointAllocationThreshold)debugFerrariBreakpoint;
            int n = debugFerrariBreakpointAllocationThreshold.threshold;
            this.transport.sendMessage(86, debugFerrariBreakpoint.bpPtr, n);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointAllocationClass) {
            DebugFerrariBreakpointAllocationClass debugFerrariBreakpointAllocationClass = (DebugFerrariBreakpointAllocationClass)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointAllocationClass.classname;
            this.transport.sendMessage(87, debugFerrariBreakpoint.bpPtr, string);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointDeadlock) {
            this.transport.sendMessage(88, debugFerrariBreakpoint.bpPtr);
        } else if (debugFerrariBreakpoint instanceof DebugFerrariBreakpointWatchpoint) {
            DebugFerrariBreakpointWatchpoint debugFerrariBreakpointWatchpoint = (DebugFerrariBreakpointWatchpoint)debugFerrariBreakpoint;
            String string = debugFerrariBreakpointWatchpoint.classname + ' ' + debugFerrariBreakpointWatchpoint.fieldname;
            int n = 0;
            if (debugFerrariBreakpointWatchpoint.access) {
                n |= 1;
            }
            if (debugFerrariBreakpointWatchpoint.modify) {
                n |= 2;
            }
            this.transport.sendMessage(89, debugFerrariBreakpoint.bpPtr, n, string);
        }
        while (true) {
            int n;
            if ((n = this.transport.receiveMessage()) == 245) {
                n = this.transport.receiveMessage();
                if (!this.isBreakpointCommand(n)) continue;
                debugFerrariBreakpoint.bpPtr = this.transport.receivePointer();
                this.receiveAndUpdateBreakpoint(n, debugFerrariBreakpoint.bpPtr);
                continue;
            }
            if (n == 17) break;
        }
        debugFerrariBreakpoint.bpPtr = this.transport.receivePointer();
    }

    private synchronized DebugFerrariBreakpoint receiveAndUpdateBreakpoint(int n, long l) {
        DebugFerrariBreakpoint debugFerrariBreakpoint = null;
        switch (n) {
            case 80: {
                int n2 = this.transport.receiveInt();
                String string = this.transport.receiveString();
                int n3 = string.indexOf(32);
                if (n3 == -1) {
                    debugFerrariBreakpoint = new DebugFerrariBreakpointFileLine(null, string, n2);
                    break;
                }
                String string2 = string.substring(0, n3);
                String string3 = string.substring(n3 + 1);
                debugFerrariBreakpoint = new DebugFerrariBreakpointPackageFileLine(null, string2, string3, n2);
                break;
            }
            case 81: {
                int n2 = this.transport.receiveInt();
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointMethodBytecode(null, string, n2);
                break;
            }
            case 82: {
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointMethod(null, string);
                break;
            }
            case 83: {
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointClass(null, string);
                break;
            }
            case 84: {
                int n2;
                boolean bl = true;
                boolean bl2 = true;
                if (this.extendedProtocolVersion >= 8) {
                    n2 = this.transport.receiveInt();
                    if ((n2 & 1) == 0) {
                        bl = false;
                    }
                    if ((n2 & 2) == 0) {
                        bl2 = false;
                    }
                }
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointException(null, string, bl, bl2);
                break;
            }
            case 85: {
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointClassLoad(null, string);
                break;
            }
            case 86: {
                int n2 = this.transport.receiveInt();
                debugFerrariBreakpoint = new DebugFerrariBreakpointAllocationThreshold(null, n2);
                break;
            }
            case 87: {
                String string = this.transport.receiveString();
                debugFerrariBreakpoint = new DebugFerrariBreakpointAllocationClass(null, string);
                break;
            }
            case 88: {
                debugFerrariBreakpoint = new DebugFerrariBreakpointDeadlock(null);
                break;
            }
            case 89: {
                boolean bl = true;
                boolean bl3 = true;
                int n2 = this.transport.receiveInt();
                if ((n2 & 1) == 0) {
                    bl = false;
                }
                if ((n2 & 2) == 0) {
                    bl3 = false;
                }
                String string = this.transport.receiveString();
                int n3 = string.indexOf(32);
                debugFerrariBreakpoint = new DebugFerrariBreakpointWatchpoint(null, string.substring(0, n3), string.substring(n3 + 1), bl, bl3);
            }
        }
        n = this.transport.receiveMessage();
        if (n == 24) {
            debugFerrariBreakpoint.enabled = this.transport.receiveInt() != 0;
            debugFerrariBreakpoint.passCount = this.transport.receiveInt();
            if (debugFerrariBreakpoint.passCount == 0) {
                debugFerrariBreakpoint.passCount = 1;
            }
            debugFerrariBreakpoint.stop = this.transport.receiveInt() != 0;
            debugFerrariBreakpoint.log = this.transport.receiveInt() != 0;
            debugFerrariBreakpoint.name = this.transport.receiveString();
            n = this.transport.receiveMessage();
            if (n == 16) {
                debugFerrariBreakpoint.enableOtherBPs = this.transport.receiveString();
                n = this.transport.receiveMessage();
                if (n == 16) {
                    debugFerrariBreakpoint.disableOtherBPs = this.transport.receiveString();
                    n = this.transport.receiveMessage();
                    if (n == 16) {
                        debugFerrariBreakpoint.threadname = this.transport.receiveString();
                        if (this.extendedProtocolVersion >= 9 && (n = this.transport.receiveMessage()) == 16) {
                            debugFerrariBreakpoint.threadnameNot = this.transport.receiveString();
                        }
                        n = this.transport.receiveMessage();
                        while (n == 96) {
                            DebugLocation debugLocation = this.receiveLocation(false);
                            debugFerrariBreakpoint.addLocation(debugLocation);
                            n = this.transport.receiveMessage();
                        }
                        if (n == 6) {
                            int n4 = this.breakpoints.size() - 1;
                            while (n4 >= 0) {
                                DebugFerrariBreakpoint debugFerrariBreakpoint2 = (DebugFerrariBreakpoint)this.breakpoints.get(n4);
                                if (debugFerrariBreakpoint2.bpPtr == l) {
                                    debugFerrariBreakpoint2.updateChanges(debugFerrariBreakpoint);
                                    return debugFerrariBreakpoint2;
                                }
                                --n4;
                            }
                            throw new RuntimeException("Unable to update breakpoint, bpPtr does not match any known breakpoints");
                        }
                        this.unexpectedResponse(n);
                    } else {
                        this.unexpectedResponse(n);
                    }
                } else {
                    this.unexpectedResponse(n);
                }
            } else {
                this.unexpectedResponse(n);
            }
        } else {
            this.unexpectedResponse(n);
        }
        return null;
    }

    synchronized boolean removeBreakpoint(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        long l = debugFerrariBreakpoint.bpPtr;
        this.breakpoints.remove(debugFerrariBreakpoint);
        debugFerrariBreakpoint.disconnect();
        this.transport.sendMessage(97, l);
        return this.receiveResponse();
    }

    private void disconnectBreakpoints() {
        int n = this.breakpoints.size() - 1;
        while (n >= 0) {
            DebugFerrariBreakpoint debugFerrariBreakpoint = (DebugFerrariBreakpoint)this.breakpoints.get(n);
            debugFerrariBreakpoint.disconnect();
            --n;
        }
        this.breakpoints.clear();
    }

    public synchronized void removeAllBreakpoints() {
        this.throwIfRunning();
        this.disconnectBreakpoints();
        this.transport.sendMessage(98, 0);
        this.receiveResponse();
    }

    synchronized boolean setBreakpointThread(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(99, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.threadname);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointThreadNot(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        if (this.extendedProtocolVersion >= 9) {
            this.throwIfRunning();
            this.transport.sendMessage(108, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.threadnameNot);
            return this.receiveResponse();
        }
        return false;
    }

    synchronized boolean setBreakpointEnabled(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(100, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.enabled ? 1 : 0);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointStop(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(101, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.stop ? 1 : 0);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointLog(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(102, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.log ? 1 : 0);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointName(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(103, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.name);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointEnableOtherBPs(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(104, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.enableOtherBPs);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointDisableOtherBPs(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(105, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.disableOtherBPs);
        return this.receiveResponse();
    }

    synchronized boolean setBreakpointCondition(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 1) {
            this.transport.sendMessage(107, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.condition != null ? 1 : 0);
            return this.receiveResponse();
        }
        return false;
    }

    synchronized boolean setBreakpointPassCount(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.throwIfRunning();
        this.transport.sendMessage(106, debugFerrariBreakpoint.bpPtr, debugFerrariBreakpoint.passCount);
        return this.receiveResponse();
    }

    synchronized boolean modifyBreakpointInstanceFilter(DebugFerrariBreakpoint debugFerrariBreakpoint, DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo, boolean bl) {
        if (debugFerrariDataCompositeInfo.address == 0L) {
            return false;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 26) {
            this.transport.sendMessage(109, debugFerrariBreakpoint.bpPtr, debugFerrariDataCompositeInfo.address, bl ? 1 : -1);
            return this.receiveResponse();
        }
        return false;
    }

    synchronized boolean modifyBreakpointInstanceFilter(DebugFerrariBreakpoint debugFerrariBreakpoint, long l, boolean bl) {
        if (l == 0L) {
            return false;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 26) {
            this.transport.sendMessage(109, debugFerrariBreakpoint.bpPtr, l, bl ? 1 : -1);
            return this.receiveResponse();
        }
        return false;
    }

    public synchronized void setPauseInterval(int n) {
        this.throwIfRunning();
        this.transport.sendMessage(35, n);
        this.receiveResponse();
    }

    public void pauseProgram() {
        this.setSyncValue(1, true);
    }

    public void cancelPauseProgram() {
        this.setSyncValue(1, false);
    }

    public synchronized void resume() {
        this.doRunCommand(64, null);
    }

    public synchronized void start(boolean bl) {
        if (this.stoppedCount == 0) {
            if (bl) {
                this.doRunCommand(66, null);
            } else {
                this.doRunCommand(65, null);
            }
        } else {
            this.doRunCommand(-1, null);
        }
    }

    synchronized void stepInto(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(65, debugFerrariThreadInfo);
    }

    synchronized void stepOver(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(66, debugFerrariThreadInfo);
    }

    synchronized void stepIntoBC(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(67, debugFerrariThreadInfo);
    }

    synchronized void stepOverBC(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(68, debugFerrariThreadInfo);
    }

    synchronized void stepOut(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(69, debugFerrariThreadInfo);
    }

    synchronized void stepToEndOfMethod(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.doRunCommand(70, debugFerrariThreadInfo);
    }

    synchronized boolean isAtEndOfMethod(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(74, debugFerrariThreadInfo.threadPtr);
        return this.receiveBooleanResponse();
    }

    public synchronized boolean didStepFinish() {
        this.throwIfRunning();
        this.transport.sendMessage(71);
        boolean bl = false;
        int n = this.transport.receiveMessage();
        if (n == 4) {
            bl = true;
        } else if (n == 5) {
            bl = false;
        } else {
            if (n == 2) {
                throw new IllegalStateException(DebugFerrariArb.getString(6));
            }
            this.unexpectedResponse(n);
        }
        return bl;
    }

    public synchronized void continueStep() {
        this.doRunCommand(72, null);
    }

    private synchronized void doRunCommand(int n, DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.throwIfRunning();
        this.runCommand = n;
        this.runCommandThreadPtr = debugFerrariThreadInfo != null && !debugFerrariThreadInfo.exited ? debugFerrariThreadInfo.threadPtr : 0L;
        this.setSyncValue(0, false);
        this.incrementStoppedCount(false);
        if (n == 73) {
            this.runningThread = Thread.currentThread();
            this.run();
        } else {
            this.runningThread = new Thread((Runnable)this, "OJVM Event Processor");
            this.runningThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.killTestConnectionThread();
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            if (this.runCommand == 64 || this.runCommand == 72 || this.runCommand == 73) {
                this.transport.sendMessage(this.runCommand);
            } else if (this.runCommand != -1) {
                this.transport.sendMessage(this.runCommand, this.runCommandThreadPtr);
            }
        }
        ArrayList arrayList = new ArrayList();
        if (this.runCommand == -1) {
            this.setSyncValue(0, true);
        } else {
            do {
                DebugFerrari debugFerrari2 = this;
                synchronized (debugFerrari2) {
                    int n = this.transport.receiveMessage();
                    switch (n) {
                        case 243: {
                            this.notifiedClassLoaded(arrayList);
                            break;
                        }
                        case 244: {
                            this.notifiedClassUnloaded();
                            break;
                        }
                        case 245: {
                            this.notifiedBreakpointChanged();
                            break;
                        }
                        case 246: {
                            this.notifiedBreakpointLog();
                            break;
                        }
                        case 247: {
                            this.notifiedExceptionLog();
                            break;
                        }
                        case 248: {
                            this.notifiedClassLoadLog();
                            break;
                        }
                        case 249: {
                            this.notifiedAllocationLog();
                            break;
                        }
                        case 250: {
                            this.notifiedDeadlockLog();
                            break;
                        }
                        case 252: {
                            this.notifiedWatchpointLog();
                            break;
                        }
                        case 251: {
                            this.notifiedBreakpointCondition();
                            break;
                        }
                        case 242: {
                            try {
                                Thread.sleep(10);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.notifiedDoYouWantToPause();
                            break;
                        }
                        case 240: {
                            this.setSyncValue(0, true);
                            break;
                        }
                        case 241: {
                            this.notifiedProgramTerminating();
                            this.setSyncValue(4, true);
                        }
                    }
                }
            } while (this.isConnected() && !this.getSyncValue(0) && !this.getSyncValue(4));
        }
        this.runningThread = null;
        this.incrementStoppedCount(true);
        if (this.checkDisconnect()) {
            if (this.getSyncValue(3) && this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            return;
        }
        if (this.getSyncValue(4)) {
            this.pins.clear();
            if (this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.disconnect(false);
            this.disconnectBreakpoints();
        } else if (this.getSyncValue(0)) {
            if (this.runCommand != 73) {
                this.checkClassLoaders(arrayList);
                this.checkPinnedObjects();
                if (this.debugListener != null) {
                    this.debugListener.programStopped();
                }
                if (this.runningThread == null) {
                    this.startTestConnectionThread();
                }
            }
        } else {
            this.setSyncValue(6, true);
            this.connectionLost();
        }
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.disconnectBreakpoints();
    }

    private void startTestConnectionThread() {
        if (this.extendedProtocolVersion >= 22) {
            this.testConnectionThread = new 1("OJVM Test Connection Thread");
            this.testConnectionThread.start();
        }
    }

    private void killTestConnectionThread() {
        Thread thread = this.testConnectionThread;
        if (thread != null) {
            while (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean checkDisconnect() {
        if (this.getSyncValue(2)) {
            boolean bl = this.getSyncValue(3);
            this.disconnect(bl);
            this.disconnectBreakpoints();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedClassLoaded(java.util.List list) {
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            long l = this.transport.receivePointer();
            int n = this.transport.receiveInt();
            int n2 = this.transport.receiveInt();
            boolean bl = this.transport.receiveInt() != 0;
            String string = this.transport.receiveString();
            String string2 = null;
            int n3 = this.transport.receiveMessage();
            if (n3 == 16) {
                string2 = this.transport.receiveString();
            } else if (n3 == 4) {
                int n4 = string.lastIndexOf(46) + 1;
                int n5 = string.indexOf(36, n4);
                if (n5 == -1) {
                    n5 = string.length();
                }
                string2 = string.substring(n4, n5) + ".java";
            } else if (n3 == 5) {
                string2 = "";
            } else {
                this.unexpectedResponse(n3, "class " + string);
            }
            long l2 = 0L;
            long l3 = 0L;
            boolean bl2 = false;
            if (this.extendedProtocolVersion >= 27) {
                n3 = this.transport.receiveMessage();
                if (n3 == 19) {
                    l2 = this.transport.receivePointer();
                    l3 = this.transport.receivePointer();
                    bl2 = true;
                } else if (n3 == 5) {
                    bl2 = true;
                } else {
                    this.unexpectedResponse(n3, "class " + string);
                }
            }
            DebugFerrariClassInfo debugFerrariClassInfo = new DebugFerrariClassInfo(this, l, n, n2, bl, string, string2);
            if (bl2) {
                debugFerrariClassInfo.setClassLoader(l2, l3);
            }
            list.add(0, debugFerrariClassInfo);
            this.classes.add(debugFerrariClassInfo);
            this.classesByPtr.put(new Long(l), debugFerrariClassInfo);
            DebugShared.putClass(this.classesByName, string, debugFerrariClassInfo);
            DebugShared.putClass(this.classesByNameWithoutPackage, debugFerrariClassInfo.getNameWithoutPackage(), debugFerrariClassInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedClassUnloaded() {
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            long l = this.transport.receivePointer();
            Long l2 = new Long(l);
            DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)this.classesByPtr.get(l2);
            if (debugFerrariClassInfo != null) {
                this.classes.remove(debugFerrariClassInfo);
                this.classesByPtr.remove(l2);
                DebugShared.removeClass(this.classesByName, debugFerrariClassInfo.getName(), debugFerrariClassInfo);
                DebugShared.removeClass(this.classesByNameWithoutPackage, debugFerrariClassInfo.getNameWithoutPackage(), debugFerrariClassInfo);
                debugFerrariClassInfo.expired = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointChanged() {
        DebugFerrariBreakpoint debugFerrariBreakpoint = null;
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            int n = this.transport.receiveMessage();
            if (this.isBreakpointCommand(n)) {
                long l = this.transport.receivePointer();
                debugFerrariBreakpoint = this.receiveAndUpdateBreakpoint(n, l);
            }
        }
        if (debugFerrariBreakpoint != null && this.debugListener != null) {
            this.debugListener.breakpointChanged(debugFerrariBreakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointLog() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
        }
        if (this.bpLogListener != null) {
            this.bpLogListener.logBreakpoint(debugFerrariBreakpoint, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedExceptionLog() {
        String string;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        String string2 = null;
        DebugFerrariThreadInfo debugFerrariThreadInfo = null;
        DebugStackFrameInfo[] debugStackFrameInfoArray = null;
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            if (this.extendedProtocolVersion >= 8) {
                boolean bl = this.transport.receiveInt() != 0;
            } else {
                boolean bl = false;
            }
            string = this.transport.receiveString();
            int n = this.transport.receiveMessage();
            if (n == 16) {
                string2 = this.transport.receiveString();
                debugFerrariThreadInfo = this.receiveThread(true);
                debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
            } else {
                this.unexpectedResponse(n);
            }
        }
        if (debugFerrariThreadInfo != null && this.bpLogListener != null) {
            this.bpLogListener.logException(debugFerrariBreakpoint, string, string2, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedClassLoadLog() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        String string;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            string = this.transport.receiveString();
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
        }
        if (this.bpLogListener != null) {
            this.bpLogListener.logClassLoad(debugFerrariBreakpoint, string, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedAllocationLog() {
        DebugFerrariHeapObjectInfo debugFerrariHeapObjectInfo;
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            long l = this.transport.receivePointer();
            if (this.extendedProtocolVersion < 1) {
                int n = this.transport.receiveInt();
            }
            int n = this.transport.receiveInt();
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
            debugFerrariHeapObjectInfo = new DebugFerrariHeapObjectInfo(this, l, false, n, debugFerrariClassInfo);
        }
        if (this.bpLogListener != null) {
            this.bpLogListener.logAllocation(debugFerrariBreakpoint, debugFerrariHeapObjectInfo, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedDeadlockLog() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
        }
        if (this.bpLogListener != null) {
            this.bpLogListener.logDeadlock(debugFerrariBreakpoint, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedWatchpointLog() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        DebugFerrariDataInfo debugFerrariDataInfo;
        DebugFerrariFieldInfo debugFerrariFieldInfo;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            debugFerrariFieldInfo = this.receiveFieldInfo();
            debugFerrariDataInfo = this.receiveDataInfo(false);
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
        }
        if (this.bpLogListener != null) {
            this.bpLogListener.logWatchpoint(debugFerrariBreakpoint, debugFerrariFieldInfo, debugFerrariDataInfo, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointCondition() {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        DebugFerrariBreakpoint debugFerrariBreakpoint;
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
            debugFerrariBreakpoint = this.findBreakpoint(this.transport.receivePointer());
            debugFerrariThreadInfo = this.receiveThread(true);
            debugStackFrameInfoArray = this.receiveStack(debugFerrariThreadInfo);
        }
        boolean bl = true;
        if (debugFerrariBreakpoint.condition != null) {
            bl = debugFerrariBreakpoint.condition.checkBreakpointCondition(debugFerrariBreakpoint, this, debugFerrariThreadInfo, debugStackFrameInfoArray);
        }
        this.incrementStoppedCount(false);
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(bl ? 4 : 5);
            this.talking = false;
        }
    }

    private synchronized void notifiedDoYouWantToPause() {
        boolean bl = this.setSyncValue(1, false);
        if (!bl) {
            bl = this.getSyncValue(2);
        }
        if (bl) {
            this.transport.sendMessage(4);
        } else {
            this.transport.sendMessage(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedProgramTerminating() {
        DebugFerrari debugFerrari = this;
        synchronized (debugFerrari) {
            this.talking = true;
        }
        if (this.debugListener != null) {
            this.debugListener.programTerminating();
        }
        DebugFerrari debugFerrari2 = this;
        synchronized (debugFerrari2) {
            this.transport.sendMessage(1);
            this.talking = false;
        }
    }

    synchronized void updateClassCounts() {
        this.throwIfRunning();
        if (this.stoppedCountUpdateClassCounts != this.stoppedCount) {
            for (DebugFerrariClassInfo debugFerrariClassInfo : this.classes) {
                if (debugFerrariClassInfo.classPtr == 0L) continue;
                this.transport.sendMessage(112, debugFerrariClassInfo.classPtr);
                int n = this.transport.receiveMessage();
                if (n != 19) continue;
                debugFerrariClassInfo.countObjects = this.transport.receiveInt();
                debugFerrariClassInfo.countMemory = this.transport.receiveInt();
            }
            this.stoppedCountUpdateClassCounts = this.stoppedCount;
        }
    }

    public int getCurrentStatus() {
        if (this.getSyncValue(0)) {
            DebugBreakpoint debugBreakpoint = this.getCurrentBreakpoint();
            if (debugBreakpoint != null) {
                if (debugBreakpoint instanceof DebugBreakpointPackageFileLine || debugBreakpoint instanceof DebugBreakpointFileLine || debugBreakpoint instanceof DebugBreakpointMethodBytecode || debugBreakpoint instanceof DebugBreakpointMethod || debugBreakpoint instanceof DebugBreakpointClass) {
                    return 1;
                }
                if (debugBreakpoint instanceof DebugBreakpointException) {
                    return 2;
                }
                if (debugBreakpoint instanceof DebugBreakpointClassLoad) {
                    return 3;
                }
                if (debugBreakpoint instanceof DebugBreakpointAllocationClass || debugBreakpoint instanceof DebugBreakpointAllocationThreshold) {
                    return 4;
                }
                if (debugBreakpoint instanceof DebugBreakpointDeadlock) {
                    return 5;
                }
                if (debugBreakpoint instanceof DebugBreakpointWatchpoint) {
                    return 10;
                }
            } else {
                if (this.getCurrentThread() == null) {
                    return 8;
                }
                if (this.getCurrentThrow() != null && this.getCurrentThrowHandler() == null) {
                    return 6;
                }
                if (this.isDeadlockDetected()) {
                    return 9;
                }
                return 7;
            }
        }
        return 0;
    }

    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        this.throwIfRunning();
        this.transport.sendMessage(39);
        return this.findBreakpoint(this.receivePointerResponse());
    }

    private DebugFerrariBreakpoint findBreakpoint(long l) {
        if (l != 0L) {
            int n = this.breakpoints.size() - 1;
            while (n >= 0) {
                DebugFerrariBreakpoint debugFerrariBreakpoint = (DebugFerrariBreakpoint)this.breakpoints.get(n);
                if (debugFerrariBreakpoint.bpPtr == l) {
                    return debugFerrariBreakpoint;
                }
                --n;
            }
        }
        return null;
    }

    public synchronized DebugThreadInfo getCurrentThread() {
        this.throwIfRunning();
        this.transport.sendMessage(40);
        return this.receiveThread(true);
    }

    public synchronized DebugDataObjectInfo getCurrentThrow() {
        this.throwIfRunning();
        this.transport.sendMessage(41);
        return (DebugDataObjectInfo)((Object)this.receiveDataInfo(true));
    }

    public synchronized boolean isCurrentThrowHandled() {
        return this.getCurrentThrowHandler() != null;
    }

    public synchronized DebugLocation getCurrentThrowHandler() {
        this.throwIfRunning();
        this.transport.sendMessage(42);
        int n = this.transport.receiveMessage();
        if (n == 25) {
            return this.receiveLocation(true);
        }
        if (n != 4 && n != 5) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    public DebugDataObjectInfo getWatchpointObject() {
        DebugFerrariFieldInfo debugFerrariFieldInfo = (DebugFerrariFieldInfo)this.getWatchpointField();
        if (debugFerrariFieldInfo != null && debugFerrariFieldInfo.data != null) {
            if (debugFerrariFieldInfo.data.owner != 0L) {
                return (DebugDataObjectInfo)((Object)this.getObjectFromAddress(debugFerrariFieldInfo.data.owner));
            }
            return new DebugFerrariDataObjectInfo(this, debugFerrariFieldInfo.declaringClass, 0L, 0L, "null", "");
        }
        return null;
    }

    public DebugFieldInfo getWatchpointField() {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 26) {
            this.transport.sendMessage(57, 0);
            return this.receiveFieldInfo();
        }
        return null;
    }

    public DebugDataInfo getWatchpointFieldFutureValue() {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 26) {
            this.transport.sendMessage(57, 1);
            return this.receiveDataInfo(false);
        }
        return null;
    }

    private synchronized boolean isDeadlockDetected() {
        this.throwIfRunning();
        this.transport.sendMessage(43);
        return this.receiveBooleanResponse();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    synchronized DebugLocation receiveLocation(boolean bl) {
        void var14_15;
        long l = this.transport.receivePointer();
        int n = this.transport.receiveInt();
        boolean bl2 = this.transport.receiveInt() != 0;
        int n2 = this.transport.receiveInt();
        boolean bl3 = this.transport.receiveInt() != 0;
        int n3 = this.transport.receiveMessage();
        if (n3 != 22) {
            this.unexpectedResponse(n3);
            return null;
        }
        DebugFerrariMethodInfo debugFerrariMethodInfo = this.receiveMethod();
        String string = null;
        String string2 = debugFerrariMethodInfo.clazz.getSourceFilename();
        int n4 = n2;
        boolean bl4 = bl3;
        if (this.extendedProtocolVersion >= 21) {
            n3 = this.transport.receiveMessage();
            if (n3 == 18) {
                n4 = this.transport.receiveInt();
                string2 = this.transport.receiveString();
                bl4 = true;
                n3 = this.transport.receiveMessage();
                if (n3 == 16) {
                    string = this.transport.receiveString();
                } else if (n3 != 5) {
                    // empty if block
                }
            } else if (n3 != 5) {
                this.unexpectedResponse(n3, "filename " + string2 + ", line " + n4);
            }
        }
        DebugSharedLocation debugSharedLocation = new DebugSharedLocation(debugFerrariMethodInfo, l, n, bl2, string, string2, n4, bl4);
        if (bl) {
            DebugLocation debugLocation = this.checkSavedLocations(debugSharedLocation);
        }
        return var14_15;
    }

    synchronized DebugFerrariMethodInfo receiveMethod() {
        long l = this.transport.receivePointer();
        DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
        int n = this.transport.receiveInt();
        String string = this.transport.receiveString();
        return debugFerrariClassInfo.getMethod(l, n, string);
    }

    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        return DebugShared.getDeadlockedThreads(this);
    }

    synchronized int getClassMethodCount(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return 0;
        }
        this.throwIfRunning();
        this.transport.sendMessage(115, debugFerrariClassInfo.classPtr);
        return this.receiveIntegerResponse();
    }

    synchronized DebugFerrariMethodInfo[] getClassMethods(DebugFerrariClassInfo debugFerrariClassInfo) {
        int n;
        if (debugFerrariClassInfo.classPtr == 0L) {
            return new DebugFerrariMethodInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(116, debugFerrariClassInfo.classPtr);
        ArrayList<DebugFerrariMethodInfo> arrayList = new ArrayList<DebugFerrariMethodInfo>();
        while ((n = this.transport.receiveMessage()) == 22) {
            DebugFerrariMethodInfo debugFerrariMethodInfo = this.receiveMethod();
            arrayList.add(debugFerrariMethodInfo);
        }
        if (n != 6) {
            this.unexpectedResponse(n, "class " + debugFerrariClassInfo.name);
        }
        DebugFerrariMethodInfo[] debugFerrariMethodInfoArray = new DebugFerrariMethodInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariMethodInfoArray);
    }

    private synchronized DebugFerrariFieldInfo receiveFieldInfo() {
        int n = this.transport.receiveMessage();
        if (n == 24) {
            long l = this.transport.receivePointer();
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            int n2 = this.transport.receiveInt();
            DebugFerrariClassInfo debugFerrariClassInfo2 = this.findClass(this.transport.receivePointer());
            String string = this.transport.receiveString();
            if (debugFerrariClassInfo2 == null && (debugFerrariClassInfo2 = this.receiveTypeAndMakeClass()) == null) {
                return null;
            }
            DebugFerrariDataInfo debugFerrariDataInfo = this.receiveDataInfo(true);
            return new DebugFerrariFieldInfo(this, l, debugFerrariClassInfo, n2, debugFerrariClassInfo2, string, debugFerrariDataInfo);
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized DebugFerrariFieldInfo[] receiveFieldInfos() {
        DebugFerrariFieldInfo debugFerrariFieldInfo;
        ArrayList<DebugFerrariFieldInfo> arrayList = new ArrayList<DebugFerrariFieldInfo>();
        while ((debugFerrariFieldInfo = this.receiveFieldInfo()) != null) {
            arrayList.add(debugFerrariFieldInfo);
        }
        DebugFerrariFieldInfo[] debugFerrariFieldInfoArray = new DebugFerrariFieldInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariFieldInfoArray);
    }

    synchronized int getClassStaticFieldCount(DebugFerrariClassInfo debugFerrariClassInfo, int n, boolean bl) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return 0;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 4) {
            this.transport.sendMessage(117, debugFerrariClassInfo.classPtr, n, bl ? 1 : 0);
        } else {
            this.transport.sendMessage(117, debugFerrariClassInfo.classPtr);
        }
        return this.receiveIntegerResponse();
    }

    synchronized DebugFerrariFieldInfo[] getClassStaticFields(DebugFerrariClassInfo debugFerrariClassInfo, int n, boolean bl, int n2) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return new DebugFerrariFieldInfo[0];
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 4) {
            this.transport.sendMessage(118, debugFerrariClassInfo.classPtr, n, bl ? 1 : 0, n2);
        } else {
            this.transport.sendMessage(118, debugFerrariClassInfo.classPtr, n2);
        }
        return this.receiveFieldInfos();
    }

    synchronized int getClassFieldCount(DebugFerrariClassInfo debugFerrariClassInfo, int n, boolean bl, boolean bl2) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return 0;
        }
        this.throwIfRunning();
        this.transport.sendMessage(119, debugFerrariClassInfo.classPtr, n, (bl ? 1 : 0) | (bl2 ? 2 : 0));
        return this.receiveIntegerResponse();
    }

    synchronized DebugFerrariFieldInfo[] getClassFields(DebugFerrariClassInfo debugFerrariClassInfo, int n, boolean bl, boolean bl2, int n2) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return new DebugFerrariFieldInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(120, debugFerrariClassInfo.classPtr, n, (bl ? 1 : 0) | (bl2 ? 2 : 0), n2);
        return this.receiveFieldInfos();
    }

    synchronized boolean isClassDebuggable(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return true;
        }
        this.throwIfRunning();
        this.transport.sendMessage(121, debugFerrariClassInfo.classPtr);
        return this.receiveBooleanResponse();
    }

    synchronized void setClassDebuggable(DebugFerrariClassInfo debugFerrariClassInfo, boolean bl) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(122, debugFerrariClassInfo.classPtr, bl ? 1 : 0);
        this.receiveResponse();
    }

    synchronized boolean isClassObfuscated(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return false;
        }
        if (this.extendedProtocolVersion >= 9) {
            this.throwIfRunning();
            this.transport.sendMessage(142, debugFerrariClassInfo.classPtr);
            return this.receiveBooleanResponse();
        }
        return false;
    }

    synchronized DebugFerrariClassInfo getArrayElementClass(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return null;
        }
        if (this.extendedProtocolVersion >= 13) {
            this.throwIfRunning();
            this.transport.sendMessage(143, debugFerrariClassInfo.classPtr);
            return this.receiveClassInfo();
        }
        return null;
    }

    synchronized boolean isClassCodeCoverage(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return false;
        }
        this.throwIfRunning();
        this.transport.sendMessage(124, debugFerrariClassInfo.classPtr);
        return this.receiveBooleanResponse();
    }

    synchronized void setClassCodeCoverage(DebugFerrariClassInfo debugFerrariClassInfo, boolean bl) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(125, debugFerrariClassInfo.classPtr, bl ? 1 : 0);
        this.receiveResponse();
    }

    synchronized void discardClassCodeCoverage(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(126, debugFerrariClassInfo.classPtr);
        this.receiveResponse();
    }

    synchronized int[] getMethodLineRange(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(128, debugFerrariMethodInfo.methodPtr);
        int n = this.transport.receiveMessage();
        if (n == 19) {
            int n2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            int[] nArray = new int[]{n2, n3};
            return nArray;
        }
        this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        return null;
    }

    synchronized int[] getMethodLines(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(129, debugFerrariMethodInfo.methodPtr);
        int n = this.transport.receiveMessage();
        if (n == 17) {
            int n2 = this.transport.receiveInt();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = this.transport.receiveInt();
                ++n3;
            }
            return nArray;
        }
        this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        return null;
    }

    synchronized DebugLocation getMethodLocation(DebugFerrariMethodInfo debugFerrariMethodInfo, String string, int n) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 21) {
            this.transport.sendMessage(137, debugFerrariMethodInfo.methodPtr, n, string);
            int n2 = this.transport.receiveMessage();
            if (n2 == 25) {
                return this.receiveLocation(true);
            }
            if (n2 == 5) {
                return null;
            }
            this.unexpectedResponse(n2, "method " + debugFerrariMethodInfo.name + ", line " + n + ", filename " + string);
        } else {
            int[] nArray;
            if (string == null) {
                string = debugFerrariMethodInfo.clazz.getSourceFilename();
            }
            if (n == 0 && (nArray = this.getMethodLineRange(debugFerrariMethodInfo)) != null && nArray.length == 2) {
                n = nArray[0];
            }
            if (!ModelUtil.areEqual((Object)string, (Object)debugFerrariMethodInfo.clazz.getSourceFilename())) {
                return null;
            }
            this.transport.sendMessage(137, debugFerrariMethodInfo.methodPtr, n);
            int n3 = this.transport.receiveMessage();
            if (n3 == 19) {
                int n4 = this.transport.receiveInt();
                long l = this.transport.receivePointer();
                if (n4 == -1 || debugFerrariMethodInfo.isCompiled() && l == 0L) {
                    return null;
                }
                return new DebugSharedLocation(debugFerrariMethodInfo, l, n4, true, null, string, n, true);
            }
            this.unexpectedResponse(n3, "method " + debugFerrariMethodInfo.name + ", line " + n + ", filename " + string);
        }
        return null;
    }

    synchronized int[] getMethodCodeCoverage(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(138, debugFerrariMethodInfo.methodPtr);
        int n = this.transport.receiveMessage();
        if (n == 17) {
            int n2 = this.transport.receiveInt();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = this.transport.receiveInt();
                ++n3;
            }
            return nArray;
        }
        if (n == 5) {
            return new int[0];
        }
        this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        return null;
    }

    synchronized double getMethodCodeCoverageRatio(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        long l = 0L;
        this.transport.sendMessage(139, l, debugFerrariMethodInfo.methodPtr);
        int n = this.transport.receiveMessage();
        if (n == 19) {
            int n2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            if (n2 != 0) {
                return (double)n3 / (double)n2;
            }
        } else {
            this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        }
        return 0.0;
    }

    synchronized double getClassCodeCoverageRatio(DebugFerrariClassInfo debugFerrariClassInfo) {
        this.throwIfRunning();
        long l = 0L;
        this.transport.sendMessage(139, debugFerrariClassInfo.classPtr, l);
        int n = this.transport.receiveMessage();
        if (n == 19) {
            int n2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            if (n2 != 0) {
                return (double)n3 / (double)n2;
            }
        } else {
            this.unexpectedResponse(n, "class " + debugFerrariClassInfo.name);
        }
        return 0.0;
    }

    synchronized DebugClassInfo[] getClassInterfaces(DebugFerrariClassInfo debugFerrariClassInfo, int n) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return new DebugClassInfo[0];
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 5) {
            this.transport.sendMessage(127, debugFerrariClassInfo.classPtr, n);
            return this.receiveClassInfos();
        }
        return new DebugClassInfo[0];
    }

    private synchronized DebugFerrariClassInfo[] receiveClassInfos() {
        DebugFerrariClassInfo debugFerrariClassInfo;
        ArrayList<DebugFerrariClassInfo> arrayList = new ArrayList<DebugFerrariClassInfo>();
        while ((debugFerrariClassInfo = this.receiveClassInfo()) != null) {
            arrayList.add(debugFerrariClassInfo);
        }
        DebugFerrariClassInfo[] debugFerrariClassInfoArray = new DebugFerrariClassInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariClassInfoArray);
    }

    synchronized DebugDisassembleInfo[] disassembleMethod(DebugFerrariMethodInfo debugFerrariMethodInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(130, debugFerrariMethodInfo.methodPtr, n);
        ArrayList<DebugDisassembleInfo> arrayList = new ArrayList<DebugDisassembleInfo>();
        while (this.isConnected()) {
            int n2 = this.transport.receiveMessage();
            if (n2 == 131) {
                int n3 = this.transport.receiveInt();
                arrayList.add(new DebugSharedDisassembleJava(n3));
                continue;
            }
            if (n2 == 132) {
                int n4 = this.transport.receiveInt();
                String string = this.transport.receiveString();
                arrayList.add(new DebugSharedDisassembleBytecode(n4, string));
                continue;
            }
            if (n2 == 133) {
                long l = this.transport.receivePointer();
                String string = this.transport.receiveString();
                arrayList.add(new DebugSharedDisassembleAssembly(l, string));
                continue;
            }
            if (n2 == 6) break;
            this.unexpectedResponse(n2, "method " + debugFerrariMethodInfo.name);
        }
        DebugDisassembleInfo[] debugDisassembleInfoArray = new DebugDisassembleInfo[arrayList.size()];
        return arrayList.toArray(debugDisassembleInfoArray);
    }

    synchronized boolean hasMethodChanged(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(134, debugFerrariMethodInfo.methodPtr);
        return this.receiveBooleanResponse();
    }

    synchronized int getMethodAccess(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(135, debugFerrariMethodInfo.methodPtr);
        return this.receiveIntegerResponse();
    }

    synchronized byte[] getMethodBytecodes(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(140, debugFerrariMethodInfo.methodPtr);
        int n = this.transport.receiveMessage();
        if (n == 17) {
            int n2 = this.transport.receiveInt();
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray[n3] = (byte)this.transport.receiveByte();
                ++n3;
            }
            return byArray;
        }
        this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        return new byte[0];
    }

    synchronized byte getMethodBytecode(DebugFerrariMethodInfo debugFerrariMethodInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(141, debugFerrariMethodInfo.methodPtr, n);
        int n2 = this.transport.receiveMessage();
        if (n2 == 17) {
            byte by = (byte)this.transport.receiveInt();
            return by;
        }
        if (n2 != 5) {
            this.unexpectedResponse(n2, "method " + debugFerrariMethodInfo.name + ", offset " + n);
        }
        return 0;
    }

    synchronized String getInvokeSignature(DebugFerrariMethodInfo debugFerrariMethodInfo) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 25) {
            this.transport.sendMessage(79, debugFerrariMethodInfo.methodPtr, 0);
            int n = this.transport.receiveMessage();
            if (n == 16) {
                String string = this.transport.receiveString();
                return string;
            }
            this.unexpectedResponse(n, "method " + debugFerrariMethodInfo.name);
        }
        return null;
    }

    synchronized void pinAllReferences(java.util.List list) {
        for (Object k : this.dataInfosByAddress.keySet()) {
            Object v = this.dataInfosByAddress.get(k);
            if (!(v instanceof DebugFerrariDataCompositeInfo) || !this.pinUnpin((DebugFerrariDataCompositeInfo)v, true)) continue;
            list.add(v);
        }
    }

    synchronized void unpinAll(java.util.List list) {
        while (!list.isEmpty()) {
            DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo = (DebugFerrariDataCompositeInfo)list.remove(0);
            this.pinUnpin(debugFerrariDataCompositeInfo, false);
        }
    }

    synchronized boolean pinUnpin(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo, boolean bl) {
        if (debugFerrariDataCompositeInfo.address == 0L) {
            return false;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 25) {
            this.transport.sendMessage(77, debugFerrariDataCompositeInfo.address, bl ? 1 : -1);
            return this.receiveResponse();
        }
        return false;
    }

    synchronized DebugFerrariDataInfo createString(String string) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 25) {
            this.transport.sendMessage(78, string);
            return this.receiveDataInfo(false);
        }
        return null;
    }

    synchronized DebugFerrariDataInfo invokeMethod(DebugFerrariMethodInfo debugFerrariMethodInfo, Object[] objectArray) {
        this.throwIfRunning();
        DebugFerrariDataInfo debugFerrariDataInfo = null;
        ArrayList arrayList = new ArrayList();
        if (this.extendedProtocolVersion >= 25) {
            this.transport.sendMessage(79, debugFerrariMethodInfo.methodPtr, 1);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object == null) {
                    this.transport.sendPointer(0L);
                } else if (object instanceof Boolean) {
                    this.transport.sendJBoolean((Boolean)object);
                } else if (object instanceof Character) {
                    this.transport.sendJChar((Character)object);
                } else if (object instanceof Byte) {
                    this.transport.sendJByte((Byte)object);
                } else if (object instanceof Short) {
                    this.transport.sendJShort((Short)object);
                } else if (object instanceof Integer) {
                    this.transport.sendJInt((Integer)object);
                } else if (object instanceof Long) {
                    this.transport.sendJLong((Long)object);
                } else if (object instanceof Float) {
                    this.transport.sendJFloat((Float)object);
                } else if (object instanceof Double) {
                    this.transport.sendJDouble((Double)object);
                } else if (object instanceof DebugFerrariDataCompositeInfo) {
                    this.transport.sendPointer(((DebugFerrariDataCompositeInfo)object).address);
                }
                ++n2;
            }
            this.transport.flush();
            while (true) {
                int n3;
                if ((n3 = this.transport.receiveMessage()) == 243) {
                    this.notifiedClassLoaded(arrayList);
                    continue;
                }
                if (n3 == 244) {
                    this.notifiedClassUnloaded();
                    continue;
                }
                if (n3 == 245) {
                    this.notifiedBreakpointChanged();
                    continue;
                }
                if (n3 == 1) {
                    DebugFerrariVariableInfo debugFerrariVariableInfo = this.receiveVariableInfo(0);
                    if (debugFerrariVariableInfo == null) break;
                    debugFerrariDataInfo = debugFerrariVariableInfo.data;
                    break;
                }
                if (n3 == 2) break;
                this.unexpectedResponse(n3, "method " + debugFerrariMethodInfo.name);
            }
        }
        this.checkClassLoaders(arrayList);
        return debugFerrariDataInfo;
    }

    private synchronized DebugFerrariThreadGroupInfo receiveThreadGroup() {
        int n = this.transport.receiveMessage();
        if (n == 18) {
            long l = this.transport.receivePointer();
            String string = this.transport.receiveString();
            DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo = new DebugFerrariThreadGroupInfo(this, l, string);
            return debugFerrariThreadGroupInfo;
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized DebugFerrariThreadGroupInfo[] receiveThreadGroups() {
        DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo;
        ArrayList<DebugFerrariThreadGroupInfo> arrayList = new ArrayList<DebugFerrariThreadGroupInfo>();
        while ((debugFerrariThreadGroupInfo = this.receiveThreadGroup()) != null) {
            arrayList.add(debugFerrariThreadGroupInfo);
        }
        DebugFerrariThreadGroupInfo[] debugFerrariThreadGroupInfoArray = new DebugFerrariThreadGroupInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariThreadGroupInfoArray);
    }

    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        this.throwIfRunning();
        this.transport.sendMessage(144, 0);
        return this.receiveThreadGroups();
    }

    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        this.throwIfRunning();
        this.transport.sendMessage(144, 1);
        return this.receiveThreadGroups();
    }

    synchronized DebugDataObjectInfo getThreadGroupObject(DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(145, debugFerrariThreadGroupInfo.groupPtr);
        return (DebugFerrariDataObjectInfo)this.receiveDataInfo(true);
    }

    synchronized DebugFerrariThreadGroupInfo getThreadGroupParent(DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(146, debugFerrariThreadGroupInfo.groupPtr);
        return this.receiveThreadGroup();
    }

    synchronized DebugFerrariThreadGroupInfo[] listThreadGroupGroups(DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(147, debugFerrariThreadGroupInfo.groupPtr);
        return this.receiveThreadGroups();
    }

    synchronized DebugFerrariThreadInfo[] listThreadGroupThreads(DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(148, debugFerrariThreadGroupInfo.groupPtr);
        return this.receiveThreads();
    }

    private synchronized DebugFerrariThreadInfo[] receiveThreads() {
        DebugFerrariThreadInfo debugFerrariThreadInfo;
        ArrayList<DebugFerrariThreadInfo> arrayList = new ArrayList<DebugFerrariThreadInfo>();
        while ((debugFerrariThreadInfo = this.receiveThread(true)) != null) {
            arrayList.add(debugFerrariThreadInfo);
        }
        DebugFerrariThreadInfo[] debugFerrariThreadInfoArray = new DebugFerrariThreadInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariThreadInfoArray);
    }

    public synchronized DebugThreadInfo[] listThreads() {
        this.throwIfRunning();
        this.transport.sendMessage(160);
        return this.receiveThreads();
    }

    private synchronized DebugFerrariThreadInfo receiveThread(boolean bl) {
        int n = this.transport.receiveMessage();
        if (n == 18) {
            long l = this.transport.receivePointer();
            String string = this.transport.receiveString();
            n = this.transport.receiveMessage();
            if (n == 16) {
                String string2 = this.transport.receiveString();
                DebugFerrariThreadInfo debugFerrariThreadInfo = new DebugFerrariThreadInfo(this, l, string, string2);
                if (bl) {
                    Long l2 = new Long(l);
                    DebugFerrariThreadInfo debugFerrariThreadInfo2 = (DebugFerrariThreadInfo)this.threadInfosByThreadPtr.get(l2);
                    if (debugFerrariThreadInfo2 != null) {
                        debugFerrariThreadInfo2.updateName(debugFerrariThreadInfo.name, debugFerrariThreadInfo.groupName);
                        debugFerrariThreadInfo = debugFerrariThreadInfo2;
                    } else {
                        this.threadInfosByThreadPtr.put(l2, debugFerrariThreadInfo);
                    }
                }
                return debugFerrariThreadInfo;
            }
            this.unexpectedResponse(n);
        } else if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    synchronized DebugThreadGroupInfo getThreadGroup(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(171, debugFerrariThreadInfo.threadPtr);
        return this.receiveThreadGroup();
    }

    synchronized int getThreadStatus(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return 6;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 2) {
            this.transport.sendMessage(173, debugFerrariThreadInfo.threadPtr);
            return this.receiveIntegerResponse();
        }
        return 5;
    }

    synchronized boolean isThreadSuspended(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return false;
        }
        this.throwIfRunning();
        this.transport.sendMessage(167, debugFerrariThreadInfo.threadPtr);
        return this.receiveBooleanResponse();
    }

    synchronized void suspendThread(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 29) {
            this.transport.sendMessage(168, debugFerrariThreadInfo.threadPtr);
            this.receiveResponse();
        }
    }

    synchronized void resumeThread(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 29) {
            this.transport.sendMessage(169, debugFerrariThreadInfo.threadPtr);
            this.receiveResponse();
        }
    }

    synchronized void updateThread(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(170, debugFerrariThreadInfo.threadPtr);
        DebugFerrariThreadInfo debugFerrariThreadInfo2 = this.receiveThread(false);
        if (debugFerrariThreadInfo2 != null) {
            debugFerrariThreadInfo.updateName(debugFerrariThreadInfo2.name, debugFerrariThreadInfo2.groupName);
        } else {
            this.threadInfosByThreadPtr.remove(new Long(debugFerrariThreadInfo.threadPtr));
            debugFerrariThreadInfo.exited = true;
        }
    }

    private synchronized void updateThreads() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.threadInfosByThreadPtr.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            this.updateThread((DebugFerrariThreadInfo)arrayList.get(n));
            --n;
        }
    }

    synchronized int getStackFrameCount(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return 0;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 18) {
            this.transport.sendMessage(175, debugFerrariThreadInfo.threadPtr);
            return this.receiveIntegerResponse();
        }
        return this.listStack(debugFerrariThreadInfo).length;
    }

    synchronized DebugFerrariStackFrameInfo getStackFrame(DebugFerrariThreadInfo debugFerrariThreadInfo, int n) {
        if (debugFerrariThreadInfo.exited) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(165, debugFerrariThreadInfo.threadPtr, n);
        return this.receiveStackFrame(debugFerrariThreadInfo, n);
    }

    synchronized DebugFerrariStackFrameInfo[] listStack(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return new DebugFerrariStackFrameInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(166, debugFerrariThreadInfo.threadPtr);
        return this.receiveStack(debugFerrariThreadInfo);
    }

    private synchronized DebugFerrariStackFrameInfo[] receiveStack(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        DebugFerrariStackFrameInfo debugFerrariStackFrameInfo;
        ArrayList<DebugFerrariStackFrameInfo> arrayList = new ArrayList<DebugFerrariStackFrameInfo>();
        int n = 0;
        while ((debugFerrariStackFrameInfo = this.receiveStackFrame(debugFerrariThreadInfo, n)) != null) {
            arrayList.add(debugFerrariStackFrameInfo);
            ++n;
        }
        DebugFerrariStackFrameInfo[] debugFerrariStackFrameInfoArray = new DebugFerrariStackFrameInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariStackFrameInfoArray);
    }

    private synchronized DebugFerrariStackFrameInfo receiveStackFrame(DebugFerrariThreadInfo debugFerrariThreadInfo, int n) {
        int n2 = this.transport.receiveMessage();
        if (n2 == 25) {
            DebugLocation debugLocation = this.receiveLocation(true);
            return new DebugFerrariStackFrameInfo(this, debugFerrariThreadInfo, n, debugLocation);
        }
        if (n2 == 4) {
            return new DebugFerrariStackFrameInfo(this, debugFerrariThreadInfo, n);
        }
        if (n2 == 5) {
            return null;
        }
        if (n2 != 6) {
            this.unexpectedResponse(n2, "thread " + debugFerrariThreadInfo.name + ", group " + debugFerrariThreadInfo.groupName);
        }
        return null;
    }

    synchronized DebugFerrariDataObjectInfo getThreadObject(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(161, debugFerrariThreadInfo.threadPtr);
        return (DebugFerrariDataObjectInfo)this.receiveDataInfo(true);
    }

    synchronized boolean setThreadIP(DebugFerrariThreadInfo debugFerrariThreadInfo, long l) {
        if (this.extendedProtocolVersion >= 15) {
            this.throwIfRunning();
            this.transport.sendMessage(174, debugFerrariThreadInfo.threadPtr, l);
            return this.receiveResponse();
        }
        DebugFerrariRegisterInfo[] debugFerrariRegisterInfoArray = this.listRegisters(debugFerrariThreadInfo);
        if (debugFerrariRegisterInfoArray != null) {
            int n = 0;
            while (n < debugFerrariRegisterInfoArray.length) {
                if (debugFerrariRegisterInfoArray[n].getName().equals("Eip")) {
                    String string = Long.toString(l);
                    return debugFerrariRegisterInfoArray[n].modifyRegister(string);
                }
                ++n;
            }
        }
        return false;
    }

    private synchronized DebugFerrariMonitorInfo receiveMonitor() {
        int n = this.transport.receiveMessage();
        if (n == 23) {
            long l = this.transport.receivePointer();
            int n2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            int n4 = this.transport.receiveInt();
            DebugFerrariThreadInfo debugFerrariThreadInfo = this.receiveThread(true);
            return new DebugFerrariMonitorInfo(this, l, n2, n3, n4, debugFerrariThreadInfo);
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized DebugFerrariMonitorInfo[] receiveMonitors() {
        DebugFerrariMonitorInfo debugFerrariMonitorInfo;
        ArrayList<DebugFerrariMonitorInfo> arrayList = new ArrayList<DebugFerrariMonitorInfo>();
        while ((debugFerrariMonitorInfo = this.receiveMonitor()) != null) {
            arrayList.add(debugFerrariMonitorInfo);
        }
        DebugFerrariMonitorInfo[] debugFerrariMonitorInfoArray = new DebugFerrariMonitorInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariMonitorInfoArray);
    }

    synchronized DebugFerrariMonitorInfo getMonitorThreadWaitingFor(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(224, debugFerrariThreadInfo.threadPtr);
        return this.receiveMonitor();
    }

    synchronized DebugFerrariMonitorInfo getMonitorThreadBlockedFor(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(225, debugFerrariThreadInfo.threadPtr);
        return this.receiveMonitor();
    }

    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        this.throwIfRunning();
        long l = 0L;
        this.transport.sendMessage(226, l);
        return this.receiveMonitors();
    }

    public synchronized DebugMonitorInfo[] listMonitors(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return new DebugMonitorInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(226, debugFerrariThreadInfo.threadPtr);
        return this.receiveMonitors();
    }

    public synchronized DebugThreadInfo[] listWaitingThreads() {
        this.throwIfRunning();
        long l = 0L;
        this.transport.sendMessage(227, l);
        return this.receiveThreads();
    }

    public synchronized DebugThreadInfo[] listBlockedThreads() {
        this.throwIfRunning();
        long l = 0L;
        this.transport.sendMessage(228, l);
        return this.receiveThreads();
    }

    synchronized DebugFerrariThreadInfo[] listWaitingThreads(DebugFerrariMonitorInfo debugFerrariMonitorInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(227, debugFerrariMonitorInfo.monitorPtr);
        return this.receiveThreads();
    }

    synchronized DebugFerrariThreadInfo[] listBlockedThreads(DebugFerrariMonitorInfo debugFerrariMonitorInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(228, debugFerrariMonitorInfo.monitorPtr);
        return this.receiveThreads();
    }

    synchronized DebugFerrariDataCompositeInfo getObjectAssociatedWithMonitor(DebugFerrariMonitorInfo debugFerrariMonitorInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(230, debugFerrariMonitorInfo.monitorPtr);
        return (DebugFerrariDataCompositeInfo)this.receiveDataInfo(true);
    }

    synchronized DebugLocation getMonitorEntryLocation(DebugFerrariMonitorInfo debugFerrariMonitorInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(231, debugFerrariMonitorInfo.monitorPtr);
        int n = this.transport.receiveMessage();
        if (n == 25) {
            return this.receiveLocation(true);
        }
        if (n != 4 && n != 5) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    boolean canDoMonitorNotify() {
        return this.extendedProtocolVersion >= 24;
    }

    synchronized void doMonitorNotify(DebugFerrariMonitorInfo debugFerrariMonitorInfo, boolean bl) {
        if (this.extendedProtocolVersion >= 24) {
            this.throwIfRunning();
            this.transport.sendMessage(232, debugFerrariMonitorInfo.monitorPtr, bl ? 1 : 0);
            DebugFerrariMonitorInfo debugFerrariMonitorInfo2 = this.receiveMonitor();
            if (debugFerrariMonitorInfo2 != null) {
                debugFerrariMonitorInfo.copyFrom(debugFerrariMonitorInfo2);
            }
        }
    }

    private synchronized DebugFerrariClassInfo receiveTypeAndMakeClass() {
        int n = this.transport.receiveMessage();
        if (n == 16) {
            String string = this.transport.receiveString();
            return new DebugFerrariClassInfo(this, 0L, 0, 0, false, string, null);
        }
        this.unexpectedResponse(n);
        return null;
    }

    private void clearSavedDataInfos() {
        ArrayList arrayList = new ArrayList();
        for (Object k : this.dataInfosByPlace.keySet()) {
            DebugFerrariDataInfo debugFerrariDataInfo = (DebugFerrariDataInfo)this.dataInfosByPlace.get(k);
            if (debugFerrariDataInfo.isStaticFieldData()) continue;
            arrayList.add(k);
        }
        int n = arrayList.size() - 1;
        while (n >= 0) {
            this.dataInfosByPlace.remove(arrayList.get(n));
            --n;
        }
        arrayList.clear();
        for (Object k : this.dataInfosByAddress.keySet()) {
            DebugFerrariDataInfo debugFerrariDataInfo = (DebugFerrariDataInfo)this.dataInfosByAddress.get(k);
            if (debugFerrariDataInfo.isStaticFieldData()) continue;
            arrayList.add(k);
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            this.dataInfosByAddress.remove(arrayList.get(n2));
            --n2;
        }
    }

    private synchronized DebugFerrariDataInfo receiveDataInfo(boolean bl) {
        int n = this.transport.receiveMessage();
        if (n == 21 || n == 19) {
            long l;
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            long l2 = this.transport.receivePointer();
            long l3 = l = n == 21 ? this.transport.receivePointer() : 0L;
            if (debugFerrariClassInfo == null && (debugFerrariClassInfo = this.receiveTypeAndMakeClass()) == null) {
                return null;
            }
            n = this.transport.receiveMessage();
            if (n == 16) {
                String string = this.transport.receiveString();
                n = this.transport.receiveMessage();
                if (n == 16) {
                    String string2 = this.transport.receiveString().toUpperCase();
                    DebugFerrariDataInfo debugFerrariDataInfo = debugFerrariClassInfo.isPrimitive() ? new DebugFerrariDataPrimitiveInfo(this, debugFerrariClassInfo, l2, l, string, string2) : (debugFerrariClassInfo.isObject() || debugFerrariClassInfo.isInterface() ? new DebugFerrariDataObjectInfo(this, debugFerrariClassInfo, l2, l, string, string2) : (debugFerrariClassInfo.isArray() ? new DebugFerrariDataArrayInfo(this, debugFerrariClassInfo, l2, l, string, string2) : new DebugFerrariDataInfo(this, debugFerrariClassInfo, l2, l, string, string2)));
                    if (bl) {
                        long l4;
                        DebugFerrariDataInfo debugFerrariDataInfo2 = null;
                        Long l5 = null;
                        Long l6 = null;
                        if (l2 != 0L) {
                            l5 = new Long(l2);
                        } else if (debugFerrariDataInfo instanceof DebugFerrariDataCompositeInfo && (l4 = ((DebugFerrariDataCompositeInfo)debugFerrariDataInfo).address) != 0L) {
                            l6 = new Long(l4);
                        }
                        if (l5 != null) {
                            debugFerrariDataInfo2 = (DebugFerrariDataInfo)this.dataInfosByPlace.get(l5);
                        } else if (l6 != null) {
                            debugFerrariDataInfo2 = (DebugFerrariDataInfo)this.dataInfosByAddress.get(l6);
                        }
                        if (debugFerrariDataInfo2 != null) {
                            debugFerrariDataInfo2.updateInfo(debugFerrariDataInfo);
                            debugFerrariDataInfo = debugFerrariDataInfo2;
                        } else if (l5 != null) {
                            this.dataInfosByPlace.put(l5, debugFerrariDataInfo);
                        } else if (l6 != null) {
                            this.dataInfosByAddress.put(l6, debugFerrariDataInfo);
                        }
                    }
                    return debugFerrariDataInfo;
                }
                this.unexpectedResponse(n);
            } else {
                this.unexpectedResponse(n);
            }
        } else if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized DebugFerrariDataInfo[] receiveDataInfos() {
        DebugFerrariDataInfo debugFerrariDataInfo;
        ArrayList<DebugFerrariDataInfo> arrayList = new ArrayList<DebugFerrariDataInfo>();
        while ((debugFerrariDataInfo = this.receiveDataInfo(true)) != null) {
            arrayList.add(debugFerrariDataInfo);
        }
        DebugFerrariDataInfo[] debugFerrariDataInfoArray = new DebugFerrariDataInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariDataInfoArray);
    }

    private synchronized DebugFerrariVariableInfo receiveVariableInfo(int n) {
        int n2 = this.transport.receiveMessage();
        if (n2 == 18 || n2 == 20) {
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            long l = 0L;
            if (n2 == 20) {
                l = this.transport.receivePointer();
            }
            String string = this.transport.receiveString();
            if (debugFerrariClassInfo == null && (debugFerrariClassInfo = this.receiveTypeAndMakeClass()) == null) {
                return null;
            }
            DebugFerrariDataInfo debugFerrariDataInfo = this.receiveDataInfo(true);
            return new DebugFerrariVariableInfo(this, debugFerrariClassInfo, l, string, debugFerrariDataInfo, n);
        }
        if (n2 != 5 && n2 != 6) {
            this.unexpectedResponse(n2, "varType " + n);
        }
        return null;
    }

    private synchronized DebugFerrariVariableInfo[] receiveVariableInfos(int n) {
        DebugFerrariVariableInfo debugFerrariVariableInfo;
        ArrayList<DebugFerrariVariableInfo> arrayList = new ArrayList<DebugFerrariVariableInfo>();
        while ((debugFerrariVariableInfo = this.receiveVariableInfo(n)) != null) {
            arrayList.add(debugFerrariVariableInfo);
        }
        DebugFerrariVariableInfo[] debugFerrariVariableInfoArray = new DebugFerrariVariableInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariVariableInfoArray);
    }

    synchronized DebugFerrariVariableInfo[] listArguments(DebugFerrariStackFrameInfo debugFerrariStackFrameInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(176, debugFerrariStackFrameInfo.thread.threadPtr, debugFerrariStackFrameInfo.frame);
        return this.receiveVariableInfos(1);
    }

    synchronized DebugFerrariVariableInfo[] listLocals(DebugFerrariStackFrameInfo debugFerrariStackFrameInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(177, debugFerrariStackFrameInfo.thread.threadPtr, debugFerrariStackFrameInfo.frame);
        return this.receiveVariableInfos(2);
    }

    synchronized DebugFerrariVariableInfo getReturnValue(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(189, debugFerrariThreadInfo.threadPtr);
        return this.receiveVariableInfo(3);
    }

    synchronized DebugFerrariVariableInfo getReturnedValue(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(190, debugFerrariThreadInfo.threadPtr);
        return this.receiveVariableInfo(4);
    }

    synchronized boolean popBackToHere(DebugFerrariStackFrameInfo debugFerrariStackFrameInfo) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 20) {
            if (debugFerrariStackFrameInfo.frame > 0) {
                this.transport.sendMessage(76, debugFerrariStackFrameInfo.thread.threadPtr, debugFerrariStackFrameInfo.frame);
            }
            return this.receiveResponse();
        }
        return false;
    }

    synchronized int getFieldCount(DebugFerrariDataObjectInfo debugFerrariDataObjectInfo, int n, boolean bl, boolean bl2, boolean bl3) {
        if (debugFerrariDataObjectInfo.address == 0L) {
            return 0;
        }
        this.throwIfRunning();
        this.transport.sendMessage(180, debugFerrariDataObjectInfo.address, n, (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0));
        return this.receiveIntegerResponse();
    }

    synchronized DebugFerrariFieldInfo[] listFields(DebugFerrariDataObjectInfo debugFerrariDataObjectInfo, int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        if (debugFerrariDataObjectInfo.address == 0L) {
            return new DebugFerrariFieldInfo[0];
        }
        this.throwIfRunning();
        int n3 = -1;
        if (eventOn_OJVM_GET_FIELDS) {
            n3 = IdeProfile.startEvent((int)3789, (String)("0x" + Long.toHexString(debugFerrariDataObjectInfo.address)));
        }
        this.transport.sendMessage(181, debugFerrariDataObjectInfo.address, n, (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0), n2);
        DebugFerrariFieldInfo[] debugFerrariFieldInfoArray = this.receiveFieldInfos();
        if (eventOn_OJVM_GET_FIELDS) {
            IdeProfile.endEvent((int)n3, (String)(" - " + (debugFerrariFieldInfoArray != null ? debugFerrariFieldInfoArray.length : 0) + " fields"));
        }
        return debugFerrariFieldInfoArray;
    }

    boolean canGetFieldByName() {
        return this.extendedProtocolVersion >= 19;
    }

    synchronized DebugFerrariFieldInfo getFieldByName(DebugFerrariDataObjectInfo debugFerrariDataObjectInfo, String string, DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariDataObjectInfo.address != 0L) {
            this.throwIfRunning();
            if (this.extendedProtocolVersion >= 30) {
                long l = debugFerrariClassInfo != null ? debugFerrariClassInfo.classPtr : 0L;
                this.transport.sendMessage(150, debugFerrariDataObjectInfo.address, l, string);
                return this.receiveFieldInfo();
            }
            if (this.extendedProtocolVersion >= 19) {
                this.transport.sendMessage(150, debugFerrariDataObjectInfo.address, string);
                return this.receiveFieldInfo();
            }
        }
        return null;
    }

    synchronized int getArrayCount(DebugFerrariDataArrayInfo debugFerrariDataArrayInfo, boolean bl) {
        if (debugFerrariDataArrayInfo.address == 0L) {
            return 0;
        }
        this.throwIfRunning();
        this.transport.sendMessage(182, debugFerrariDataArrayInfo.address, bl ? 1 : 0);
        return this.receiveIntegerResponse();
    }

    synchronized DebugFerrariArrayElementInfo[] listArray(DebugFerrariDataArrayInfo debugFerrariDataArrayInfo, int n, int n2, boolean bl) {
        if (debugFerrariDataArrayInfo.address == 0L) {
            return new DebugFerrariArrayElementInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(183, debugFerrariDataArrayInfo.address, bl ? 1 : 0, n, n2);
        return this.receiveArrayElementInfos();
    }

    private synchronized DebugFerrariArrayElementInfo receiveArrayElementInfo() {
        int n = this.transport.receiveMessage();
        if (n == 19) {
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            int n2 = this.transport.receiveInt();
            DebugFerrariDataInfo debugFerrariDataInfo = this.receiveDataInfo(true);
            return new DebugFerrariArrayElementInfo(this, debugFerrariClassInfo, n2, debugFerrariDataInfo);
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized DebugFerrariArrayElementInfo[] receiveArrayElementInfos() {
        DebugFerrariArrayElementInfo debugFerrariArrayElementInfo;
        ArrayList<DebugFerrariArrayElementInfo> arrayList = new ArrayList<DebugFerrariArrayElementInfo>();
        while ((debugFerrariArrayElementInfo = this.receiveArrayElementInfo()) != null) {
            arrayList.add(debugFerrariArrayElementInfo);
        }
        DebugFerrariArrayElementInfo[] debugFerrariArrayElementInfoArray = new DebugFerrariArrayElementInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariArrayElementInfoArray);
    }

    synchronized long getUniqueID(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo) {
        if (debugFerrariDataCompositeInfo.address == 0L) {
            return 0L;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 26) {
            this.transport.sendMessage(58, debugFerrariDataCompositeInfo.address);
            return this.receiveIntegerResponse();
        }
        return 0L;
    }

    synchronized String getCourtesyInfo(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo) {
        if (debugFerrariDataCompositeInfo == null || debugFerrariDataCompositeInfo.address == 0L) {
            return null;
        }
        this.throwIfRunning();
        try {
            this.transport.sendMessage(185, debugFerrariDataCompositeInfo.address, 100);
            String string = this.receiveStringResponse();
            return string;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    boolean canGetWholeThing(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo) {
        DebugClassInfo debugClassInfo;
        if (debugFerrariDataCompositeInfo == null || debugFerrariDataCompositeInfo.address == 0L) {
            return false;
        }
        if (this.extendedProtocolVersion >= 9 && (debugClassInfo = debugFerrariDataCompositeInfo.getClassInfo()) != null) {
            String string = debugClassInfo.getName();
            if (string.equals("char[]") || string.equals("java.lang.String") || string.equals("java.lang.StringBuffer")) {
                return true;
            }
            if (this.extendedProtocolVersion >= 11 ? string.equals("byte[]") || string.equals("short[]") || string.equals("int[]") || string.equals("long[]") : this.extendedProtocolVersion >= 10 && string.equals("byte[]")) {
                return true;
            }
        }
        return false;
    }

    synchronized Object getWholeThing(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo) {
        if (debugFerrariDataCompositeInfo == null || debugFerrariDataCompositeInfo.address == 0L) {
            return null;
        }
        if (this.extendedProtocolVersion >= 9) {
            this.throwIfRunning();
            try {
                this.transport.sendMessage(212, debugFerrariDataCompositeInfo.address);
                int n = this.transport.receiveMessage();
                if (n == 16) {
                    String string = this.transport.receiveString();
                    return string;
                }
                if (n == 5) {
                    Object var9_4 = null;
                    return var9_4;
                }
                if (this.extendedProtocolVersion >= 11) {
                    if (n == 19) {
                        int n2 = this.transport.receiveInt();
                        int n3 = this.transport.receiveInt();
                        switch (n3) {
                            case 1: {
                                byte[] byArray = this.transport.receiveByteArray(n2);
                                return byArray;
                            }
                            case 2: {
                                short[] sArray = this.transport.receiveShortArray(n2);
                                return sArray;
                            }
                            case 4: {
                                int[] nArray = this.transport.receiveIntArray(n2);
                                return nArray;
                            }
                            case 8: {
                                long[] lArray = this.transport.receiveLongArray(n2);
                                return lArray;
                            }
                        }
                    } else {
                        this.unexpectedResponse(n, "data class " + (debugFerrariDataCompositeInfo.clazz == null ? "null" : debugFerrariDataCompositeInfo.clazz.name));
                    }
                } else if (this.extendedProtocolVersion >= 10) {
                    if (n == 17) {
                        byte[] byArray;
                        int n4 = this.transport.receiveInt();
                        byte[] byArray2 = byArray = this.transport.receiveByteArray(n4);
                        return byArray2;
                    }
                    this.unexpectedResponse(n, "data class " + (debugFerrariDataCompositeInfo.clazz == null ? "null" : debugFerrariDataCompositeInfo.clazz.name));
                } else {
                    this.unexpectedResponse(n, "data class " + (debugFerrariDataCompositeInfo.clazz == null ? "null" : debugFerrariDataCompositeInfo.clazz.name));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private synchronized Object findFieldValue(long l, String string) {
        this.transport.sendMessage(187, l, string);
        int n = this.transport.receiveMessage();
        if (n == 17) {
            int n2 = this.transport.receiveInt();
            return new Integer(n2);
        }
        if (n == 19) {
            long l2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            long l3 = l2 << 32 | (long)n3 & 0xFFFFFFFFL;
            return new Long(l3);
        }
        if (n != 5) {
            this.unexpectedResponse(n, "fieldName " + string);
        }
        return null;
    }

    private synchronized Integer findFieldValueInt(long l, String string) {
        Object object = this.findFieldValue(l, string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return null;
    }

    private synchronized Long findFieldValueLong(long l, String string) {
        Object object = this.findFieldValue(l, string);
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    private synchronized Object getArrayValues(long l) {
        this.transport.sendMessage(188, l);
        int n = this.transport.receiveMessage();
        if (n == 19) {
            int n2 = this.transport.receiveInt();
            int n3 = this.transport.receiveInt();
            if (n3 == 1) {
                byte[] byArray = new byte[n2];
                int n4 = 0;
                while (n4 < n2) {
                    byArray[n4] = (byte)this.transport.receiveByte();
                    ++n4;
                }
                return byArray;
            }
            if (n3 == 2) {
                short[] sArray = new short[n2];
                int n5 = 0;
                while (n5 < n2) {
                    sArray[n5] = this.transport.receiveShort();
                    ++n5;
                }
                return sArray;
            }
            if (n3 == 4) {
                int[] nArray = new int[n2];
                int n6 = 0;
                while (n6 < n2) {
                    nArray[n6] = this.transport.receiveInt();
                    ++n6;
                }
                return nArray;
            }
            if (n3 == 8) {
                long[] lArray = new long[n2];
                int n7 = 0;
                while (n7 < n2) {
                    lArray[n7] = this.transport.receiveLong();
                    ++n7;
                }
                return lArray;
            }
        } else if (n != 5) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    private synchronized byte[] getArrayValuesBytes(long l) {
        Object object = this.getArrayValues(l);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return null;
    }

    synchronized boolean modifyData(DebugFerrariDataInfo debugFerrariDataInfo, String string) {
        this.throwIfRunning();
        if (debugFerrariDataInfo.place == 0L) {
            return false;
        }
        this.clearSavedDataInfos();
        this.transport.sendMessage(184, debugFerrariDataInfo.declaredClass.classPtr, debugFerrariDataInfo.place, debugFerrariDataInfo.owner, string);
        DebugFerrariDataInfo debugFerrariDataInfo2 = this.receiveDataInfo(false);
        if (debugFerrariDataInfo2 != null) {
            debugFerrariDataInfo.updateInfo(debugFerrariDataInfo2);
            this.updateThreads();
            return true;
        }
        return false;
    }

    synchronized boolean modifyString(DebugFerrariDataInfo debugFerrariDataInfo, String string) {
        this.throwIfRunning();
        if (debugFerrariDataInfo.place == 0L) {
            return false;
        }
        if (this.extendedProtocolVersion >= 3) {
            this.clearSavedDataInfos();
            this.transport.sendMessage(191, debugFerrariDataInfo.declaredClass.classPtr, debugFerrariDataInfo.place, debugFerrariDataInfo.owner, string);
            DebugFerrariDataInfo debugFerrariDataInfo2 = this.receiveDataInfo(false);
            if (debugFerrariDataInfo2 != null) {
                debugFerrariDataInfo.updateInfo(debugFerrariDataInfo2);
                this.updateThreads();
                --this.stoppedCountUpdateClassCounts;
                return true;
            }
        }
        return false;
    }

    synchronized DebugPinnedInfo pinObject(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo, DebugPinListener debugPinListener) {
        if (debugFerrariDataCompositeInfo.address == 0L) {
            return null;
        }
        if (debugPinListener == null) {
            return null;
        }
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 7) {
            this.transport.sendMessage(205, debugFerrariDataCompositeInfo.address);
            int n = this.transport.receiveMessage();
            if (n == 17) {
                int n2 = this.transport.receiveInt();
                DebugFerrariPinnedInfo debugFerrariPinnedInfo = new DebugFerrariPinnedInfo(this, debugFerrariDataCompositeInfo.address, n2, debugPinListener);
                this.pins.add(debugFerrariPinnedInfo);
                return debugFerrariPinnedInfo;
            }
        }
        return null;
    }

    synchronized void unpinObject(DebugFerrariPinnedInfo debugFerrariPinnedInfo) {
        if (this.pins.remove(debugFerrariPinnedInfo)) {
            if (debugFerrariPinnedInfo.address == 0L) {
                return;
            }
            this.throwIfRunning();
            if (this.extendedProtocolVersion >= 7) {
                this.transport.sendMessage(206, debugFerrariPinnedInfo.address);
                this.receiveResponse();
            }
        }
    }

    private void unpinAll() {
        int n = this.pins.size() - 1;
        while (n >= 0) {
            DebugFerrariPinnedInfo debugFerrariPinnedInfo = (DebugFerrariPinnedInfo)this.pins.get(n);
            this.unpinObject(debugFerrariPinnedInfo);
            --n;
        }
    }

    private void checkClassLoaders(java.util.List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)list.get(n2);
            debugFerrariClassInfo.getClassLoader();
            ++n2;
        }
    }

    private synchronized void checkPinnedObjects() {
        if (this.extendedProtocolVersion >= 7) {
            ArrayList<DebugFerrariPinnedInfo> arrayList = new ArrayList<DebugFerrariPinnedInfo>();
            int n = this.pins.size() - 1;
            while (n >= 0) {
                DebugFerrariPinnedInfo debugFerrariPinnedInfo = (DebugFerrariPinnedInfo)this.pins.get(n);
                this.transport.sendMessage(207, debugFerrariPinnedInfo.address, debugFerrariPinnedInfo.hashcode);
                boolean bl = this.receiveBooleanResponse();
                if (bl) {
                    debugFerrariPinnedInfo.discarded = true;
                    arrayList.add(debugFerrariPinnedInfo);
                }
                --n;
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                DebugFerrariPinnedInfo debugFerrariPinnedInfo = (DebugFerrariPinnedInfo)arrayList.get(n2);
                this.pins.remove(debugFerrariPinnedInfo);
                debugFerrariPinnedInfo.pinListener.pinnedObjectDiscarded(this, debugFerrariPinnedInfo);
                ++n2;
            }
        }
    }

    synchronized void updateStaticFieldData(DebugFerrariDataInfo debugFerrariDataInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(186, debugFerrariDataInfo.staticField.fieldPtr);
        DebugFerrariDataInfo debugFerrariDataInfo2 = this.receiveDataInfo(false);
        if (debugFerrariDataInfo2 != null) {
            debugFerrariDataInfo.stoppedCount = this.stoppedCount;
            debugFerrariDataInfo.clazz = debugFerrariDataInfo2.clazz;
            debugFerrariDataInfo.value = debugFerrariDataInfo2.value;
            debugFerrariDataInfo.hexValue = debugFerrariDataInfo2.hexValue;
        }
    }

    DebugFerrariClassInfo findClass(long l) {
        if (l == 0L) {
            return null;
        }
        return (DebugFerrariClassInfo)this.classesByPtr.get(new Long(l));
    }

    DebugFerrariClassInfo findClassByName(String string) {
        if (string == null) {
            return null;
        }
        return (DebugFerrariClassInfo)DebugShared.getFirstClass(this.classesByName, string);
    }

    public synchronized DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    public DebugClassInfo[] listClasses(boolean bl) {
        this.throwIfRunning();
        DebugFerrariClassInfo[] debugFerrariClassInfoArray = new DebugFerrariClassInfo[this.classes.size()];
        return this.classes.toArray(debugFerrariClassInfoArray);
    }

    public synchronized int countClasses() {
        this.throwIfRunning();
        return this.classes.size();
    }

    public DebugClassInfo findFirstClassByName(String string) {
        return this.findFirstClassByName(string, false);
    }

    public DebugClassInfo findFirstClassByName(String string, boolean bl) {
        this.throwIfRunning();
        return DebugShared.getFirstClass(bl ? this.classesByNameWithoutPackage : this.classesByName, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getThreadContextClassLoaders() {
        Map map = this.threadInfosByThreadPtr;
        synchronized (map) {
            if (this.stoppedCountThreadContextClassLoaders == this.stoppedCount) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.threadInfosByThreadPtr.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (DebugFerrariThreadInfo debugFerrariThreadInfo : arrayList) {
                debugFerrariThreadInfo.getContextClassLoader();
            }
            this.stoppedCountThreadContextClassLoaders = this.stoppedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugClassLoaderInfo[] listClassLoaders() {
        this.getThreadContextClassLoaders();
        ArrayList arrayList = new ArrayList();
        Map map = this.classLoaderInfosByAddress;
        synchronized (map) {
            Iterator iterator = this.classLoaderInfosByAddress.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList.toArray(new DebugClassLoaderInfo[arrayList.size()]);
    }

    synchronized DebugFerrariClassInfo getClassSuperClass(DebugFerrariClassInfo debugFerrariClassInfo, int n) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(114, debugFerrariClassInfo.classPtr, n);
        return this.receiveClassInfo();
    }

    private synchronized DebugFerrariClassInfo receiveClassInfo() {
        int n = this.transport.receiveMessage();
        if (n == 17) {
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            return debugFerrariClassInfo;
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    synchronized DebugFerrariDataObjectInfo getClassObject(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(113, debugFerrariClassInfo.classPtr);
        return (DebugFerrariDataObjectInfo)this.receiveDataInfo(true);
    }

    synchronized DebugFerrariDataObjectInfo getClassLoaderObject(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (this.extendedProtocolVersion >= 16) {
            if (debugFerrariClassInfo.classPtr == 0L) {
                return null;
            }
            this.throwIfRunning();
            this.transport.sendMessage(149, debugFerrariClassInfo.classPtr);
            return (DebugFerrariDataObjectInfo)this.receiveDataInfo(true);
        }
        return null;
    }

    synchronized String[] getClassPrimarySourceFilename(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (this.extendedProtocolVersion >= 21) {
            if (debugFerrariClassInfo.classPtr == 0L) {
                return null;
            }
            this.throwIfRunning();
            this.transport.sendMessage(151, debugFerrariClassInfo.classPtr);
            int n = this.transport.receiveMessage();
            if (n == 16) {
                String[] stringArray = new String[2];
                stringArray[0] = this.transport.receiveString();
                n = this.transport.receiveMessage();
                if (n == 16) {
                    stringArray[1] = this.transport.receiveString();
                } else if (n == 5) {
                    // empty if block
                }
                return stringArray;
            }
            if (n == 5) {
                return null;
            }
            this.unexpectedResponse(n, "class " + debugFerrariClassInfo.name);
        }
        return null;
    }

    private boolean sendHeapSubsetInfo(DebugHeapSubset debugHeapSubset) {
        if (debugHeapSubset instanceof DebugHeapSubsetClasses) {
            DebugHeapSubsetClasses debugHeapSubsetClasses = (DebugHeapSubsetClasses)debugHeapSubset;
            String[] stringArray = debugHeapSubsetClasses.getClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                int n3 = debugHeapSubsetClasses.getIncludeSubclasses(string) ? 1 : 0;
                Object v = this.classesByName.get(string);
                if (v != null) {
                    if (v instanceof DebugFerrariClassInfo) {
                        DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)v;
                        this.transport.sendMessage(198, debugFerrariClassInfo.classPtr, n3);
                        if (!this.receiveResponse()) {
                            return false;
                        }
                    } else if (v instanceof java.util.List) {
                        java.util.List list = (java.util.List)v;
                        int n4 = list.size();
                        int n5 = 0;
                        while (n5 < n4) {
                            DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)list.get(n5);
                            this.transport.sendMessage(198, debugFerrariClassInfo.classPtr, n3);
                            if (!this.receiveResponse()) {
                                return false;
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
        } else if (debugHeapSubset instanceof DebugHeapSubsetAncestors) {
            DebugHeapSubsetAncestors debugHeapSubsetAncestors = (DebugHeapSubsetAncestors)debugHeapSubset;
            long l = debugHeapSubsetAncestors.getAddress();
            int n = debugHeapSubsetAncestors.getDepth();
            int n6 = debugHeapSubsetAncestors.getIgnoreLevel();
            if (this.extendedProtocolVersion >= 1) {
                this.transport.sendMessage(199, l, n, n6);
            } else {
                this.transport.sendMessage(199, l, n);
            }
            if (!this.receiveResponse()) {
                return false;
            }
        } else if (debugHeapSubset instanceof DebugHeapSubsetDescendants) {
            long l = ((DebugHeapSubsetDescendants)debugHeapSubset).getAddress();
            this.transport.sendMessage(200, l);
            if (!this.receiveResponse()) {
                return false;
            }
        } else if (debugHeapSubset instanceof DebugHeapSubsetRoots) {
            this.transport.sendMessage(201);
            if (!this.receiveResponse()) {
                return false;
            }
        }
        return true;
    }

    public synchronized int countHeap(DebugHeapSubset debugHeapSubset) {
        this.throwIfRunning();
        if (!this.sendHeapSubsetInfo(debugHeapSubset)) {
            return 0;
        }
        this.transport.sendMessage(196);
        return this.receiveIntegerResponse();
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset) {
        return this.getHeap(debugHeapSubset, 0);
    }

    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset, int n) {
        this.throwIfRunning();
        if (!this.sendHeapSubsetInfo(debugHeapSubset)) {
            return null;
        }
        this.transport.sendMessage(197, n);
        DebugFerrariHeapAncestorOutsideHeap[] debugFerrariHeapAncestorOutsideHeapArray = this.receiveHeapAncestorsOutsideHeap();
        long[] lArray = new long[]{};
        int[] nArray = null;
        int n2 = this.transport.receiveMessage();
        if (n2 == 17) {
            int n3 = this.transport.receiveInt();
            lArray = new long[n3];
            int n4 = 0;
            while (n4 < n3) {
                lArray[n4] = this.transport.receivePointer();
                ++n4;
            }
        } else {
            this.unexpectedResponse(n2, "subset " + (debugHeapSubset == null ? "null" : debugHeapSubset.getClass().getName()));
        }
        if (this.extendedProtocolVersion >= 1) {
            n2 = this.transport.receiveMessage();
            if (n2 == 17) {
                int n5 = this.transport.receiveInt();
                nArray = new int[n5];
                int n6 = 0;
                while (n6 < n5) {
                    nArray[n6] = this.transport.receiveInt();
                    ++n6;
                }
            } else {
                this.unexpectedResponse(n2, "subset " + (debugHeapSubset == null ? "null" : debugHeapSubset.getClass().getName()));
            }
        }
        return new DebugFerrariHeapInfo(this, debugHeapSubset, debugFerrariHeapAncestorOutsideHeapArray, lArray, nArray);
    }

    private synchronized DebugFerrariHeapAncestorOutsideHeap[] receiveHeapAncestorsOutsideHeap() {
        block16: {
            int n;
            ArrayList<DebugFerrariHeapAncestorOutsideHeap> arrayList = new ArrayList<DebugFerrariHeapAncestorOutsideHeap>();
            while (true) {
                if ((n = this.transport.receiveMessage()) == 208) {
                    long l = 0L;
                    if (this.extendedProtocolVersion >= 6) {
                        l = this.transport.receivePointer();
                    }
                    DebugFerrariThreadInfo debugFerrariThreadInfo = this.receiveThread(true);
                    DebugFerrariStackFrameInfo debugFerrariStackFrameInfo = null;
                    DebugFerrariVariableInfo debugFerrariVariableInfo = null;
                    if (this.extendedProtocolVersion < 1) {
                        n = this.transport.receiveMessage();
                        if (n != 17) {
                            this.unexpectedResponse(n);
                            break block16;
                        }
                        long l2 = this.transport.receivePointer();
                    }
                    if ((n = this.transport.receiveMessage()) == 17) {
                        int n2 = this.transport.receiveInt();
                        debugFerrariStackFrameInfo = this.receiveStackFrame(debugFerrariThreadInfo, n2);
                        debugFerrariVariableInfo = this.receiveVariableInfo(0);
                    } else if (n != 5) {
                        this.unexpectedResponse(n);
                        break block16;
                    }
                    if (l == 0L || debugFerrariThreadInfo == null) continue;
                    arrayList.add(new DebugFerrariHeapAncestorInStack(this, l, debugFerrariThreadInfo, debugFerrariStackFrameInfo, debugFerrariVariableInfo));
                    continue;
                }
                if (n == 209) {
                    long l;
                    DebugFerrariThreadInfo debugFerrariThreadInfo = this.receiveThread(true);
                    DebugFerrariRegisterInfo debugFerrariRegisterInfo = this.receiveRegister(debugFerrariThreadInfo);
                    if (debugFerrariThreadInfo == null || debugFerrariRegisterInfo == null || (l = DebugSharedPrimitives.longFromHexString(debugFerrariRegisterInfo.getHexValue())) == 0L) continue;
                    arrayList.add(new DebugFerrariHeapAncestorInRegister(this, l, debugFerrariThreadInfo, debugFerrariRegisterInfo));
                    continue;
                }
                if (n == 210) {
                    DebugFerrariClassInfo debugFerrariClassInfo = null;
                    long l = 0L;
                    if (this.extendedProtocolVersion >= 1) {
                        debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
                        l = this.transport.receivePointer();
                    }
                    if (l == 0L || debugFerrariClassInfo == null) continue;
                    arrayList.add(new DebugFerrariHeapAncestorInPinTable(this, l, debugFerrariClassInfo));
                    continue;
                }
                if (n != 211) break;
                DebugFerrariClassInfo debugFerrariClassInfo = null;
                DebugFerrariFieldInfo debugFerrariFieldInfo = null;
                long l = 0L;
                if (this.extendedProtocolVersion >= 6) {
                    debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
                    l = this.transport.receivePointer();
                } else if (this.extendedProtocolVersion >= 1) {
                    debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
                } else {
                    debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
                    long l3 = this.transport.receivePointer();
                }
                debugFerrariFieldInfo = this.receiveFieldInfo();
                if (l == 0L || debugFerrariClassInfo == null) continue;
                arrayList.add(new DebugFerrariHeapAncestorInStatic(this, l, debugFerrariClassInfo, debugFerrariFieldInfo));
            }
            if (n == 6) {
                DebugFerrariHeapAncestorOutsideHeap[] debugFerrariHeapAncestorOutsideHeapArray = new DebugFerrariHeapAncestorOutsideHeap[arrayList.size()];
                return arrayList.toArray(debugFerrariHeapAncestorOutsideHeapArray);
            }
            this.unexpectedResponse(n);
        }
        return new DebugFerrariHeapAncestorOutsideHeap[0];
    }

    synchronized DebugFerrariMonitorInfo getMonitor(DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo) {
        if (debugFerrariDataCompositeInfo.address == 0L) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(229, debugFerrariDataCompositeInfo.address);
        return this.receiveMonitor();
    }

    public int getSizeOfAddress() {
        return this.transport.getPointerSize();
    }

    public synchronized boolean isHeapAddressValid(long l) {
        if (l == 0L) {
            return false;
        }
        this.throwIfRunning();
        this.transport.sendMessage(194, l);
        return this.receiveBooleanResponse();
    }

    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long l) {
        if (l == 0L) {
            return null;
        }
        this.throwIfRunning();
        this.transport.sendMessage(195, l);
        return this.receiveHeapObject(l);
    }

    private synchronized DebugHeapObjectInfo receiveHeapObject(long l) {
        int n = this.transport.receiveMessage();
        if (n == 21 || n == 19) {
            boolean bl = this.extendedProtocolVersion >= 1 ? this.transport.receiveInt() != 0 : (this.transport.receiveInt() & 0x40000000) != 0;
            DebugFerrariClassInfo debugFerrariClassInfo = this.findClass(this.transport.receivePointer());
            int n2 = n == 21 ? this.transport.receiveInt() : debugFerrariClassInfo.sizeOfObject;
            return new DebugFerrariHeapObjectInfo(this, l, bl, n2, debugFerrariClassInfo);
        }
        if (n != 5) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    synchronized DebugHeapObjectInfo[] getHeapObjects(long[] lArray, int n, int n2) {
        long l = System.currentTimeMillis();
        if (this.extendedProtocolVersion >= 17) {
            if (lArray == null) {
                return null;
            }
            if (lArray.length == 0) {
                return new DebugHeapObjectInfo[0];
            }
            this.throwIfRunning();
            if (n != 0 || n2 != lArray.length) {
                long[] lArray2 = new long[n2];
                System.arraycopy(lArray, n, lArray2, 0, n2);
                lArray = lArray2;
            }
            this.transport.sendMessage(204, lArray);
            return this.receiveHeapObjects(lArray);
        }
        DebugHeapObjectInfo[] debugHeapObjectInfoArray = new DebugHeapObjectInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            debugHeapObjectInfoArray[n3] = this.getHeapObjectAtAddress(lArray[n + n3]);
            ++n3;
        }
        return debugHeapObjectInfoArray;
    }

    private synchronized DebugHeapObjectInfo[] receiveHeapObjects(long[] lArray) {
        ArrayList<DebugHeapObjectInfo> arrayList = new ArrayList<DebugHeapObjectInfo>();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugHeapObjectInfo debugHeapObjectInfo = this.receiveHeapObject(lArray[n2]);
            if (debugHeapObjectInfo != null) {
                arrayList.add(debugHeapObjectInfo);
            }
            ++n2;
        }
        DebugHeapObjectInfo[] debugHeapObjectInfoArray = new DebugHeapObjectInfo[arrayList.size()];
        return arrayList.toArray(debugHeapObjectInfoArray);
    }

    public synchronized void doGarbageCollection() {
        int n;
        this.throwIfRunning();
        this.transport.sendMessage(192);
        while (true) {
            if ((n = this.transport.receiveMessage()) == 244) {
                this.notifiedClassUnloaded();
                continue;
            }
            if (n != 245) break;
            this.notifiedBreakpointChanged();
        }
        if (n != 1 && n != 2) {
            this.unexpectedResponse(n);
        }
        --this.stoppedCountUpdateClassCounts;
        this.checkPinnedObjects();
    }

    public synchronized void dumpMemory(long l, int n, String string) {
        this.throwIfRunning();
        this.transport.sendMessage(193, l, n, string);
        this.receiveResponse();
    }

    synchronized DebugFerrariRegisterInfo[] listRegisters(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return new DebugFerrariRegisterInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(162, debugFerrariThreadInfo.threadPtr);
        return this.receiveRegisters(debugFerrariThreadInfo);
    }

    synchronized DebugFerrariRegisterInfo[] listFloatRegisters(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        if (debugFerrariThreadInfo.exited) {
            return new DebugFerrariRegisterInfo[0];
        }
        this.throwIfRunning();
        this.transport.sendMessage(163, debugFerrariThreadInfo.threadPtr);
        return this.receiveRegisters(debugFerrariThreadInfo);
    }

    private synchronized DebugFerrariRegisterInfo[] receiveRegisters(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        DebugFerrariRegisterInfo debugFerrariRegisterInfo;
        ArrayList<DebugFerrariRegisterInfo> arrayList = new ArrayList<DebugFerrariRegisterInfo>();
        while ((debugFerrariRegisterInfo = this.receiveRegister(debugFerrariThreadInfo)) != null) {
            arrayList.add(debugFerrariRegisterInfo);
        }
        DebugFerrariRegisterInfo[] debugFerrariRegisterInfoArray = new DebugFerrariRegisterInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariRegisterInfoArray);
    }

    private synchronized DebugFerrariRegisterInfo receiveRegister(DebugFerrariThreadInfo debugFerrariThreadInfo) {
        int n = this.transport.receiveMessage();
        if (n == 18) {
            int n2 = this.transport.receiveInt();
            String string = this.transport.receiveString();
            n = this.transport.receiveMessage();
            if (n == 16) {
                String string2 = this.transport.receiveString();
                n = this.transport.receiveMessage();
                if (n == 16) {
                    String string3 = this.transport.receiveString().toUpperCase();
                    return new DebugFerrariRegisterInfo(this, debugFerrariThreadInfo, n2, string, string2, string3);
                }
                this.unexpectedResponse(n, "thread " + debugFerrariThreadInfo.name + ", group " + debugFerrariThreadInfo.groupName);
            } else {
                this.unexpectedResponse(n, "thread " + debugFerrariThreadInfo.name + ", group " + debugFerrariThreadInfo.groupName);
            }
        } else if (n != 5 && n != 6) {
            this.unexpectedResponse(n, "thread " + debugFerrariThreadInfo.name + ", group " + debugFerrariThreadInfo.groupName);
        }
        return null;
    }

    synchronized boolean modifyRegister(DebugFerrariRegisterInfo debugFerrariRegisterInfo, String string) {
        this.throwIfRunning();
        this.transport.sendMessage(164, debugFerrariRegisterInfo.thread.threadPtr, debugFerrariRegisterInfo.offset, string);
        return this.receiveResponse();
    }

    synchronized DebugFerrariDataCompositeInfo getObjectFromAddress(long l) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 1) {
            this.transport.sendMessage(172, l);
            return (DebugFerrariDataCompositeInfo)this.receiveDataInfo(true);
        }
        return null;
    }

    synchronized DebugFerrariStackSlotInfo[] listSlots(DebugFerrariStackFrameInfo debugFerrariStackFrameInfo) {
        this.throwIfRunning();
        this.transport.sendMessage(178, debugFerrariStackFrameInfo.thread.threadPtr, debugFerrariStackFrameInfo.frame);
        return this.receiveSlots();
    }

    private synchronized DebugFerrariStackSlotInfo[] receiveSlots() {
        DebugFerrariStackSlotInfo debugFerrariStackSlotInfo;
        ArrayList<DebugFerrariStackSlotInfo> arrayList = new ArrayList<DebugFerrariStackSlotInfo>();
        while ((debugFerrariStackSlotInfo = this.receiveSlot()) != null) {
            arrayList.add(debugFerrariStackSlotInfo);
        }
        DebugFerrariStackSlotInfo[] debugFerrariStackSlotInfoArray = new DebugFerrariStackSlotInfo[arrayList.size()];
        return arrayList.toArray(debugFerrariStackSlotInfoArray);
    }

    private synchronized DebugFerrariStackSlotInfo receiveSlot() {
        int n = this.transport.receiveMessage();
        if (n == 20) {
            int n2 = this.transport.receiveInt();
            long l = this.transport.receivePointer();
            String string = this.transport.receiveString().toUpperCase();
            DebugFerrariVariableInfo debugFerrariVariableInfo = this.receiveVariableInfo(0);
            return new DebugFerrariStackSlotInfo(this, n2, l, string, debugFerrariVariableInfo);
        }
        if (n != 5 && n != 6) {
            this.unexpectedResponse(n);
        }
        return null;
    }

    synchronized boolean modifySlot(DebugFerrariStackSlotInfo debugFerrariStackSlotInfo, String string) {
        this.throwIfRunning();
        this.clearSavedDataInfos();
        this.transport.sendMessage(179, debugFerrariStackSlotInfo.place, string);
        return this.receiveResponse();
    }

    public synchronized String getSourceDirectory() {
        this.throwIfRunning();
        this.transport.sendMessage(36);
        return this.receiveStringResponse();
    }

    synchronized boolean generateSourceFile(DebugFerrariClassInfo debugFerrariClassInfo) {
        if (debugFerrariClassInfo.classPtr == 0L || debugFerrariClassInfo.isPrimitive || debugFerrariClassInfo.isArray()) {
            return false;
        }
        this.throwIfRunning();
        this.transport.sendMessage(123, debugFerrariClassInfo.classPtr);
        int n = this.transport.receiveMessage();
        if (n == 16) {
            debugFerrariClassInfo.sourceFilename = this.transport.receiveString();
            this.updateSavedLocations(debugFerrariClassInfo);
            return true;
        }
        if (n != 5) {
            this.unexpectedResponse(n, "class " + debugFerrariClassInfo.name);
        }
        return false;
    }

    private synchronized void updateLocation(DebugSharedLocation debugSharedLocation) {
        this.throwIfRunning();
        DebugFerrariMethodInfo debugFerrariMethodInfo = (DebugFerrariMethodInfo)debugSharedLocation.getMethod();
        long l = debugSharedLocation.getAddress();
        if (this.extendedProtocolVersion >= 23 && l == 0L) {
            return;
        }
        this.transport.sendMessage(136, debugFerrariMethodInfo.methodPtr, l);
        int n = this.transport.receiveMessage();
        if (n == 19) {
            int n2 = this.transport.receiveInt();
            boolean bl = this.transport.receiveInt() != 0;
            debugSharedLocation.setLine(n2);
            debugSharedLocation.setLineExact(bl);
        } else {
            this.unexpectedResponse(n);
        }
    }

    private void initSavedLocations() {
        this.savedLocations = new HashMap();
    }

    private DebugLocation checkSavedLocations(DebugLocation debugLocation) {
        DebugLocation debugLocation2 = (DebugLocation)this.savedLocations.get(debugLocation);
        if (debugLocation2 != null) {
            return debugLocation2;
        }
        this.savedLocations.put(debugLocation, debugLocation);
        return debugLocation;
    }

    private void clearSavedLocations() {
        this.savedLocations.clear();
    }

    private void updateSavedLocations(DebugClassInfo debugClassInfo) {
        for (DebugSharedLocation debugSharedLocation : this.savedLocations.keySet()) {
            if (!debugClassInfo.equals(debugSharedLocation.getClassInfo())) continue;
            this.updateLocation(debugSharedLocation);
        }
        int n = this.breakpoints.size() - 1;
        while (n >= 0) {
            DebugFerrariBreakpoint debugFerrariBreakpoint = (DebugFerrariBreakpoint)this.breakpoints.get(n);
            if (debugFerrariBreakpoint.locations != null) {
                int n2 = debugFerrariBreakpoint.locations.size() - 1;
                while (n2 >= 0) {
                    DebugSharedLocation debugSharedLocation = (DebugSharedLocation)debugFerrariBreakpoint.locations.get(n2);
                    if (debugClassInfo.equals(debugSharedLocation.getClassInfo())) {
                        this.updateLocation(debugSharedLocation);
                    }
                    --n2;
                }
            }
            --n;
        }
    }

    public synchronized void special(int n) {
        this.throwIfRunning();
        this.transport.sendMessage(48, n);
        this.receiveResponse();
    }

    synchronized void special(DebugFerrariClassInfo debugFerrariClassInfo, int n) {
        if (debugFerrariClassInfo.classPtr == 0L) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(49, debugFerrariClassInfo.classPtr, n);
        this.receiveResponse();
    }

    synchronized void special(DebugFerrariFieldInfo debugFerrariFieldInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(50, debugFerrariFieldInfo.fieldPtr, debugFerrariFieldInfo.data.place, n);
        this.receiveResponse();
    }

    synchronized void special(DebugFerrariMethodInfo debugFerrariMethodInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(51, debugFerrariMethodInfo.methodPtr, n);
        this.receiveResponse();
    }

    synchronized void special(DebugFerrariMonitorInfo debugFerrariMonitorInfo, int n) {
        this.throwIfRunning();
        this.transport.sendMessage(52, debugFerrariMonitorInfo.monitorPtr, n);
        this.receiveResponse();
    }

    synchronized void special(DebugFerrariThreadInfo debugFerrariThreadInfo, int n) {
        if (debugFerrariThreadInfo.exited) {
            return;
        }
        this.throwIfRunning();
        this.transport.sendMessage(53, debugFerrariThreadInfo.threadPtr, n);
        this.receiveResponse();
    }

    public DebugCapabilities getCapabilities() {
        return this;
    }

    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    public boolean canPutBreakpointFileLine() {
        return true;
    }

    public boolean canPutBreakpointMethodBytecode() {
        return true;
    }

    public boolean canPutBreakpointMethod() {
        return true;
    }

    public boolean canPutBreakpointClass() {
        return true;
    }

    public boolean canPutBreakpointException() {
        return true;
    }

    public boolean canPutBreakpointClassLoad() {
        return true;
    }

    public boolean canPutBreakpointAllocationThreshold() {
        return true;
    }

    public boolean canPutBreakpointAllocationClass() {
        return true;
    }

    public boolean canPutBreakpointDeadlock() {
        return true;
    }

    public boolean canPutBreakpointWatchpoint() {
        return this.extendedProtocolVersion >= 26;
    }

    public boolean canSetDebuggablePackages() {
        return true;
    }

    public boolean canPauseProgram() {
        return true;
    }

    public boolean canRedefineClasses() {
        return this.extendedProtocolVersion >= 20;
    }

    public boolean canCountObjectsOfClass() {
        return true;
    }

    public boolean canCountMemoryOfClass() {
        return true;
    }

    public boolean canSetDebuggableClass() {
        return true;
    }

    public boolean canGetHeap() {
        return true;
    }

    public boolean canDoGarbageCollection() {
        return true;
    }

    public boolean canDoCodeCoverage() {
        return true;
    }

    public boolean canDisassembleMethod() {
        return true;
    }

    public boolean canGetBytecodes() {
        return true;
    }

    public boolean canInvokeMethod() {
        return this.extendedProtocolVersion >= 25;
    }

    public boolean canGetMonitors() {
        return true;
    }

    public boolean canGetMonitorEntryLocation() {
        return true;
    }

    public boolean canListSlots() {
        return true;
    }

    public boolean canPopFrames() {
        int n;
        if (this.extendedProtocolVersion >= 28) {
            if (!this.isRunning()) {
                this.transport.sendMessage(76, 0L, 0);
                return this.receiveBooleanResponse();
            }
        } else if (this.extendedProtocolVersion >= 20 && ((n = this.getCurrentStatus()) == 1 || n == 10 || n == 7)) {
            return true;
        }
        return false;
    }

    public boolean canSuspendThread() {
        return this.extendedProtocolVersion >= 29;
    }

    public boolean canResumeThread() {
        return this.extendedProtocolVersion >= 29;
    }

    public boolean canListRegisters() {
        return true;
    }

    public boolean canListFloatRegisters() {
        return true;
    }

    public boolean canStepToEndOfMethod() {
        return true;
    }

    public boolean canContinueStep() {
        return true;
    }

    public boolean canGetReturnValue() {
        return true;
    }

    public boolean canGetReturnedValue() {
        return true;
    }

    public boolean canSetLocation() {
        return true;
    }

    public boolean canPin() {
        return true;
    }

    public boolean canGetAddresses() {
        return true;
    }

    public boolean canGetUniqueIDs() {
        return this.extendedProtocolVersion >= 26;
    }

    private void initSync() {
        this.syncObjects = new Object[8];
        int n = 0;
        while (n < 8) {
            this.syncObjects[n] = new Integer(n);
            ++n;
        }
        this.syncValues = new boolean[8];
        int n2 = 0;
        while (n2 < 8) {
            this.syncValues[n2] = false;
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int n, boolean bl) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl2 = this.syncValues[n];
            this.syncValues[n] = bl;
            boolean bl3 = bl2;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int n) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl = this.syncValues[n];
            return bl;
        }
    }

    void addStoppedListener(DebugFerrariStoppedListener debugFerrariStoppedListener) {
        this.stoppedListeners.add(debugFerrariStoppedListener);
    }

    void removeStoppedListener(DebugFerrariStoppedListener debugFerrariStoppedListener) {
        this.stoppedListeners.remove(debugFerrariStoppedListener);
    }

    private void incrementStoppedCount(boolean bl) {
        this.clearSavedDataInfos();
        this.clearSavedLocations();
        ++this.stoppedCount;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.stoppedListeners);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            DebugFerrariStoppedListener debugFerrariStoppedListener = (DebugFerrariStoppedListener)arrayList.get(n);
            debugFerrariStoppedListener.stoppedOrResuming(bl);
            --n;
        }
    }

    int getPointerSlotSize() {
        return this.transport.getPointerSize() / 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSystemClassLoaderAddress() {
        Object object = this.syncObjects[7];
        synchronized (object) {
            DebugFerrariDataObjectInfo debugFerrariDataObjectInfo;
            DebugFerrariClassInfo debugFerrariClassInfo;
            if (this.systemClassLoaderAddress == 0L && (debugFerrariClassInfo = this.findClassByName("java.lang.ClassLoader")) != null && (debugFerrariDataObjectInfo = (DebugFerrariDataObjectInfo)DebugShared.getSystemClassLoaderObject(debugFerrariClassInfo)) != null) {
                this.systemClassLoaderAddress = debugFerrariDataObjectInfo.address;
            }
            long l = this.systemClassLoaderAddress;
            return l;
        }
    }

    synchronized String getGenericSignature(DebugFerrariClassInfo debugFerrariClassInfo) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 31 && debugFerrariClassInfo.classPtr != 0L) {
            this.transport.sendMessage(213, debugFerrariClassInfo.classPtr);
            return this.receiveStringResponse();
        }
        return null;
    }

    synchronized String getGenericSignature(DebugFerrariFieldInfo debugFerrariFieldInfo) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 31 && debugFerrariFieldInfo.fieldPtr != 0L) {
            this.transport.sendMessage(214, debugFerrariFieldInfo.fieldPtr);
            return this.receiveStringResponse();
        }
        return null;
    }

    synchronized String getGenericSignature(DebugFerrariVariableInfo debugFerrariVariableInfo) {
        this.throwIfRunning();
        if (this.extendedProtocolVersion >= 31) {
            if (debugFerrariVariableInfo.localDescPtr != 0L) {
                this.transport.sendMessage(215, debugFerrariVariableInfo.localDescPtr);
            }
            return this.receiveStringResponse();
        }
        return null;
    }

    static void wa$baosJustInCase(DebugFerrari debugFerrari, ByteArrayOutputStream byteArrayOutputStream) {
        debugFerrari.baosJustInCase = byteArrayOutputStream;
    }

    static ByteArrayOutputStream ra$baosJustInCase(DebugFerrari debugFerrari) {
        return debugFerrari.baosJustInCase;
    }

    static void wa$dosJustInCase(DebugFerrari debugFerrari, DeflaterOutputStream deflaterOutputStream) {
        debugFerrari.dosJustInCase = deflaterOutputStream;
    }

    static DeflaterOutputStream ra$dosJustInCase(DebugFerrari debugFerrari) {
        return debugFerrari.dosJustInCase;
    }

    static void mav$connectionLost(DebugFerrari debugFerrari) {
        debugFerrari.connectionLost();
    }

    static boolean mav$testConnection(DebugFerrari debugFerrari) {
        return debugFerrari.testConnection();
    }

    static boolean mav$setSyncValue(DebugFerrari debugFerrari, int n, boolean bl) {
        return debugFerrari.setSyncValue(n, bl);
    }

    public final class 4
    implements Runnable {
        public void run() {
            DebugFerrari.wa$baosJustInCase(DebugFerrari.this, new ByteArrayOutputStream());
            DebugFerrari.wa$dosJustInCase(DebugFerrari.this, new DeflaterOutputStream(DebugFerrari.ra$baosJustInCase(DebugFerrari.this)));
            DebugFerrari.this.addConnectionLog(new PrintStream(DebugFerrari.ra$dosJustInCase(DebugFerrari.this)));
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            if (DebugFerrari.ra$dosJustInCase(DebugFerrari.this) != null && DebugFerrari.ra$baosJustInCase(DebugFerrari.this) != null) {
                try {
                    DebugFerrari.ra$dosJustInCase(DebugFerrari.this).close();
                    DebugFerrari.wa$dosJustInCase(DebugFerrari.this, null);
                    byte[] byArray = DebugFerrari.ra$baosJustInCase(DebugFerrari.this).toByteArray();
                    DebugFerrari.wa$baosJustInCase(DebugFerrari.this, null);
                    File file = File.createTempFile("debugger", null, new File(Ide.getBinDirectory()));
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Inflater inflater = new Inflater();
                    inflater.setInput(byArray, 0, byArray.length);
                    byte[] byArray2 = new byte[32000];
                    int n = 0;
                    while (inflater.getRemaining() > 0) {
                        int n2 = inflater.inflate(byArray2);
                        fileOutputStream.write(byArray2, 0, n2);
                        n += n2;
                    }
                    inflater.end();
                    new Exception("Stack trace").printStackTrace(new PrintStream(fileOutputStream));
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DebugFerrari.wa$baosJustInCase(DebugFerrari.this, null);
                DebugFerrari.wa$dosJustInCase(DebugFerrari.this, null);
            }
        }
    }

    public final class 2
    extends Thread {
        public void run() {
            DebugFerrari.mav$connectionLost(DebugFerrari.this);
        }

        public 2(String string) {
            super(string);
        }
    }

    public final class 1
    extends Thread {
        public void run() {
            try {
                do {
                    Thread.sleep(3000L);
                } while (DebugFerrari.mav$testConnection(DebugFerrari.this));
                boolean bl = DebugFerrari.mav$setSyncValue(DebugFerrari.this, 6, true);
                if (!bl) {
                    DebugFerrari.mav$connectionLost(DebugFerrari.this);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public 1(String string) {
            super(string);
        }
    }
}

