/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

class DebugFerrariBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint {
    DebugFerrari df;
    String threadname;
    String threadnameNot;
    boolean enabled;
    boolean stop;
    boolean log;
    String name;
    String enableOtherBPs;
    String disableOtherBPs;
    int passCount;
    DebugBreakpointCondition condition;
    long bpPtr;
    List locations;
    List instanceFilters_id;
    List instanceFilters_address;

    DebugFerrariBreakpoint(DebugFerrari debugFerrari) {
        this.df = debugFerrari;
        this.stop = true;
        this.enabled = true;
        this.passCount = 1;
        this.bpPtr = 0L;
        this.instanceFilters_id = new ArrayList();
        this.instanceFilters_address = new ArrayList();
    }

    public void remove() {
        if (this.df != null) {
            this.df.removeBreakpoint(this);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadname = string;
        if (this.df != null) {
            this.df.setBreakpointThread(this);
        }
        if (string != null && this.threadnameNot != null) {
            this.threadnameNot = null;
            if (this.df != null) {
                this.df.setBreakpointThreadNot(this);
            }
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadnameNot = string;
        if (this.df != null) {
            this.df.setBreakpointThreadNot(this);
        }
        if (string != null && this.threadname != null) {
            this.threadname = null;
            if (this.df != null) {
                this.df.setBreakpointThread(this);
            }
        }
    }

    public synchronized boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.df != null) {
            this.df.setBreakpointEnabled(this);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
        if (this.df != null) {
            this.df.setBreakpointStop(this);
        }
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean bl) {
        this.log = bl;
        if (this.df != null) {
            this.df.setBreakpointLog(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        if (this.df != null) {
            this.df.setBreakpointName(this);
        }
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String string) {
        this.enableOtherBPs = string;
        if (this.df != null) {
            this.df.setBreakpointEnableOtherBPs(this);
        }
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String string) {
        this.disableOtherBPs = string;
        if (this.df != null) {
            this.df.setBreakpointDisableOtherBPs(this);
        }
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition debugBreakpointCondition) {
        this.condition = debugBreakpointCondition;
        if (this.df != null) {
            this.df.setBreakpointCondition(this);
        }
    }

    public synchronized int getPassCount() {
        return this.passCount;
    }

    public synchronized void setPassCount(int n) {
        this.passCount = n;
        if (this.df != null) {
            this.df.setBreakpointPassCount(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
        Long l = new Long(debugDataObjectInfo.getUniqueID());
        List list = this.instanceFilters_id;
        synchronized (list) {
            if (!this.instanceFilters_id.contains(l)) {
                this.instanceFilters_id.add(l);
                Long l2 = new Long(((DebugFerrariDataObjectInfo)debugDataObjectInfo).address);
                this.instanceFilters_address.add(l2);
            }
        }
        this.df.modifyBreakpointInstanceFilter(this, (DebugFerrariDataObjectInfo)debugDataObjectInfo, true);
    }

    public void removeInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
        this.removeInstanceFilter(debugDataObjectInfo.getUniqueID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(long l) {
        Long l2 = new Long(l);
        Long l3 = null;
        List list = this.instanceFilters_id;
        synchronized (list) {
            int n = this.instanceFilters_id.indexOf(l2);
            if (n != -1) {
                this.instanceFilters_id.remove(n);
                l3 = (Long)this.instanceFilters_address.remove(n);
            }
        }
        if (l3 != null) {
            this.df.modifyBreakpointInstanceFilter(this, l3, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceFilterSet(DebugDataObjectInfo debugDataObjectInfo) {
        Long l = new Long(debugDataObjectInfo.getUniqueID());
        List list = this.instanceFilters_id;
        synchronized (list) {
            if (this.instanceFilters_id.contains(l)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceFilters() {
        List list = this.instanceFilters_id;
        synchronized (list) {
            long[] lArray = new long[this.instanceFilters_id.size()];
            int n = 0;
            Iterator iterator = this.instanceFilters_id.iterator();
            while (iterator.hasNext()) {
                lArray[n++] = (Long)iterator.next();
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
    }

    public synchronized DebugLocation[] getLocations() {
        if (this.locations == null) {
            return new DebugLocation[0];
        }
        int n = this.locations.size();
        DebugLocation[] debugLocationArray = new DebugLocation[n];
        int n2 = 0;
        while (n2 < n) {
            debugLocationArray[n2] = (DebugLocation)this.locations.get(n2);
            ++n2;
        }
        return debugLocationArray;
    }

    synchronized void addLocation(DebugLocation debugLocation) {
        if (this.locations == null) {
            this.locations = new ArrayList();
        }
        this.locations.add(debugLocation);
    }

    synchronized void disconnect() {
        this.df = null;
        this.bpPtr = 0L;
        this.locations = null;
    }

    synchronized void updateChanges(DebugFerrariBreakpoint debugFerrariBreakpoint) {
        this.enabled = debugFerrariBreakpoint.enabled;
        this.passCount = debugFerrariBreakpoint.passCount;
        this.locations = debugFerrariBreakpoint.locations;
    }
}

