/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassLoaderInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariMethodInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugFerrariClassInfo
implements DebugFerrariStoppedListener,
DebugClassInfo {
    DebugFerrari df;
    int stoppedCount;
    boolean expired;
    long classPtr;
    int access;
    int sizeOfObject;
    boolean isPrimitive;
    String name;
    String primarySourceFilename;
    String sourceFilename;
    int countObjects;
    int countMemory;
    String justPackage;
    String packagePath;
    String nameWithoutPackage;
    private boolean stoppedListener;
    private SoftReference sfFields;
    private HashMap methodsCache;
    private boolean classLoaderInfoReceived;
    private long classLoaderAddress;
    private long classLoaderClassPtr;
    private int hashCode;

    DebugFerrariClassInfo(DebugFerrari debugFerrari, long l, int n, int n2, boolean bl, String string, String string2) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.expired = false;
        this.classPtr = l;
        this.access = n;
        this.isPrimitive = bl;
        this.name = string;
        this.sourceFilename = string2;
        this.sizeOfObject = n2;
        this.countObjects = 0;
        this.countMemory = 0;
    }

    void setClassLoader(long l, long l2) {
        this.classLoaderAddress = l;
        this.classLoaderClassPtr = l2;
        this.classLoaderInfoReceived = true;
    }

    public void stoppedOrResuming(boolean bl) {
        this.sfFields = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    public boolean hasExpired() {
        return this.classPtr == 0L && this.df.stoppedCount != this.stoppedCount || this.expired;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Class has expired: " + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage(this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath(this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage(this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        return this.df.getGenericSignature(this);
    }

    public int getAccess() {
        return this.access;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isObject() {
        return !this.isInterface() && !this.isPrimitive && !this.name.endsWith("]");
    }

    public boolean isArray() {
        return !this.isInterface() && !this.isPrimitive && this.name.endsWith("]");
    }

    public int getSizeOfObject() {
        return this.sizeOfObject;
    }

    public int countObjectsOfClass() {
        this.throwIfExpired();
        this.df.updateClassCounts();
        return this.countObjects;
    }

    public int countMemoryOfClass() {
        this.throwIfExpired();
        this.df.updateClassCounts();
        return this.countMemory;
    }

    public DebugDataObjectInfo getClassObject() {
        this.throwIfExpired();
        return this.df.getClassObject(this);
    }

    long getClassLoaderAddress() {
        if (!this.classLoaderInfoReceived) {
            this.getClassLoaderObject();
        }
        return this.classLoaderAddress;
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        if (!this.isPrimitive) {
            DebugFerrariDataObjectInfo debugFerrariDataObjectInfo;
            if (this.classLoaderInfoReceived) {
                DebugFerrariClassInfo debugFerrariClassInfo = this.df.findClass(this.classLoaderClassPtr);
                debugFerrariDataObjectInfo = new DebugFerrariDataObjectInfo(this.df, debugFerrariClassInfo, 0L, 0L, "", Long.toHexString(this.classLoaderAddress).toUpperCase());
            } else {
                debugFerrariDataObjectInfo = this.df.getClassLoaderObject(this);
                if (debugFerrariDataObjectInfo != null) {
                    this.classLoaderAddress = debugFerrariDataObjectInfo.address;
                    this.classLoaderClassPtr = debugFerrariDataObjectInfo.clazz.classPtr;
                }
                this.classLoaderInfoReceived = true;
            }
            return debugFerrariDataObjectInfo;
        }
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        this.throwIfExpired();
        if (!this.classLoaderInfoReceived) {
            this.getClassLoaderObject();
        }
        DebugFerrariClassInfo debugFerrariClassInfo = this.df.findClass(this.classLoaderClassPtr);
        return DebugFerrariClassLoaderInfo.makeClassLoaderInfo(this.df, this.classLoaderAddress, debugFerrariClassInfo);
    }

    public String getPrimarySourceFilename() {
        this.throwIfExpired();
        if (this.primarySourceFilename == null) {
            String[] stringArray = this.df.getClassPrimarySourceFilename(this);
            if (stringArray != null) {
                this.primarySourceFilename = stringArray[0];
            }
            if (this.primarySourceFilename == null) {
                this.primarySourceFilename = this.sourceFilename;
            }
        }
        return this.primarySourceFilename;
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    public DebugClassInfo getSuperClass(int n) {
        this.throwIfExpired();
        return this.df.getClassSuperClass(this, n);
    }

    public int getMethodCount() {
        this.throwIfExpired();
        return this.df.getClassMethodCount(this);
    }

    public DebugMethodInfo[] getMethods() {
        this.throwIfExpired();
        return this.df.getClassMethods(this);
    }

    DebugFerrariMethodInfo getMethod(long l, int n, String string) {
        DebugFerrariMethodInfo debugFerrariMethodInfo;
        Long l2 = new Long(l);
        if (this.methodsCache != null) {
            SoftReference softReference = (SoftReference)this.methodsCache.get(l2);
            if (softReference != null && (debugFerrariMethodInfo = (DebugFerrariMethodInfo)softReference.get()) != null) {
                debugFerrariMethodInfo.updateMethod(n);
                return debugFerrariMethodInfo;
            }
        } else {
            this.methodsCache = new HashMap();
        }
        debugFerrariMethodInfo = new DebugFerrariMethodInfo(this.df, l, this, n, string);
        this.methodsCache.put(l2, new SoftReference<DebugFerrariMethodInfo>(debugFerrariMethodInfo));
        return debugFerrariMethodInfo;
    }

    void redefinedClass() {
        this.sfFields = null;
        if (this.methodsCache != null) {
            this.methodsCache.clear();
        }
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int n) {
        return this.getStaticField(0, false, n);
    }

    public int getStaticFieldCount(int n) {
        return this.getStaticFieldCount(n, false);
    }

    public DebugFieldInfo[] getStaticFields(int n) {
        return this.getStaticFields(n, false);
    }

    public DebugFieldInfo getStaticField(int n, int n2) {
        return this.getStaticField(n, false, n2);
    }

    public int getStaticFieldCount(int n, boolean bl) {
        this.throwIfExpired();
        return this.df.getClassStaticFieldCount(this, n, bl);
    }

    public DebugFieldInfo[] getStaticFields(int n, boolean bl) {
        Object t;
        this.throwIfExpired();
        if (n == -1 && !bl && this.sfFields != null && (t = this.sfFields.get()) != null) {
            return (DebugFieldInfo[])t;
        }
        DebugFieldInfo[] debugFieldInfoArray = this.df.getClassStaticFields(this, n, bl, -1);
        if (n == -1 && !bl) {
            this.sfFields = new SoftReference<DebugFieldInfo[]>(debugFieldInfoArray);
            if (!this.stoppedListener) {
                this.stoppedListener = true;
                this.df.addStoppedListener(this);
            }
        }
        return debugFieldInfoArray;
    }

    public DebugFieldInfo getStaticField(int n, boolean bl, int n2) {
        this.throwIfExpired();
        DebugFerrariFieldInfo[] debugFerrariFieldInfoArray = this.df.getClassStaticFields(this, n, bl, n2);
        if (debugFerrariFieldInfoArray != null && debugFerrariFieldInfoArray.length == 1) {
            return debugFerrariFieldInfoArray[0];
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String string) {
        return null;
    }

    public int getFieldCount(int n) {
        return this.getFieldCount(n, false, false);
    }

    public DebugFieldInfo[] getFields(int n) {
        return this.getFields(n, false, false);
    }

    public DebugFieldInfo getField(int n, int n2) {
        return this.getField(n, false, false, n2);
    }

    public int getFieldCount(int n, boolean bl) {
        return this.getFieldCount(n, bl, false);
    }

    public DebugFieldInfo[] getFields(int n, boolean bl) {
        return this.getFields(n, bl, false);
    }

    public DebugFieldInfo getField(int n, boolean bl, int n2) {
        return this.getField(n, bl, false, n2);
    }

    public int getFieldCount(int n, boolean bl, boolean bl2) {
        this.throwIfExpired();
        return this.df.getClassFieldCount(this, n, bl, bl2);
    }

    public DebugFieldInfo[] getFields(int n, boolean bl, boolean bl2) {
        this.throwIfExpired();
        return this.df.getClassFields(this, n, bl, bl2, -1);
    }

    public DebugFieldInfo getField(int n, boolean bl, boolean bl2, int n2) {
        this.throwIfExpired();
        DebugFerrariFieldInfo[] debugFerrariFieldInfoArray = this.df.getClassFields(this, n, bl, bl2, n2);
        if (debugFerrariFieldInfoArray != null && debugFerrariFieldInfoArray.length == 1) {
            return debugFerrariFieldInfoArray[0];
        }
        return null;
    }

    public boolean isDebuggable() {
        this.throwIfExpired();
        return this.df.isClassDebuggable(this);
    }

    public void setDebuggable(boolean bl) {
        this.throwIfExpired();
        this.df.setClassDebuggable(this, bl);
    }

    public boolean isObfuscated() {
        this.throwIfExpired();
        return this.df.isClassObfuscated(this);
    }

    public boolean isCodeCoverage() {
        this.throwIfExpired();
        return this.df.isClassCodeCoverage(this);
    }

    public void setCodeCoverage(boolean bl) {
        this.throwIfExpired();
        this.df.setClassCodeCoverage(this, bl);
    }

    public void discardCodeCoverage() {
        this.throwIfExpired();
        this.df.discardClassCodeCoverage(this);
    }

    public double getCodeCoverageRatio() {
        this.throwIfExpired();
        return this.df.getClassCodeCoverageRatio(this);
    }

    public DebugClassInfo[] getInterfaces() {
        return this.getInterfaces(0);
    }

    public DebugClassInfo[] getInterfaces(int n) {
        this.throwIfExpired();
        return this.df.getClassInterfaces(this, n);
    }

    public boolean generateSourceFile() {
        this.throwIfExpired();
        return this.df.generateSourceFile(this);
    }

    public int getLanguage() {
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.classPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariClassInfo) {
            DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)object;
            if (!this.hasExpired()) {
                return !debugFerrariClassInfo.hasExpired() && this.classPtr == debugFerrariClassInfo.classPtr;
            }
            return debugFerrariClassInfo.hasExpired() && this.classPtr == debugFerrariClassInfo.classPtr && this.access == debugFerrariClassInfo.access && this.isPrimitive == debugFerrariClassInfo.isPrimitive && this.name.equals(debugFerrariClassInfo.name) && (this.sourceFilename == null ? debugFerrariClassInfo.sourceFilename == null : this.sourceFilename.equals(debugFerrariClassInfo.sourceFilename));
        }
        return false;
    }

    public void special(int n) {
        this.throwIfExpired();
        this.df.special(this, n);
    }
}

