/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Map;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;

final class DebugFerrariClassLoaderInfo
implements DebugClassLoaderInfo {
    private DebugFerrari df;
    private long address;
    private DebugFerrariClassInfo clazz;
    private DebugFerrariClassLoaderInfo parent;
    private String className;
    private int id;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugFerrariClassLoaderInfo makeClassLoaderInfo(DebugFerrari debugFerrari, long l, DebugFerrariClassInfo debugFerrariClassInfo) {
        Map map = debugFerrari.classLoaderInfosByAddress;
        synchronized (map) {
            Long l2 = new Long(l);
            DebugFerrariClassLoaderInfo debugFerrariClassLoaderInfo = (DebugFerrariClassLoaderInfo)debugFerrari.classLoaderInfosByAddress.get(l2);
            if (debugFerrariClassLoaderInfo == null) {
                debugFerrariClassLoaderInfo = new DebugFerrariClassLoaderInfo(debugFerrari, l, debugFerrariClassInfo);
                debugFerrari.classLoaderInfosByAddress.put(l2, debugFerrariClassLoaderInfo);
            }
            DebugFerrariClassLoaderInfo debugFerrariClassLoaderInfo2 = debugFerrariClassLoaderInfo;
            return debugFerrariClassLoaderInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebugFerrariClassLoaderInfo(DebugFerrari debugFerrari, long l, DebugFerrariClassInfo debugFerrariClassInfo) {
        this.df = debugFerrari;
        this.address = l;
        this.clazz = debugFerrariClassInfo;
        if (debugFerrariClassInfo != null) {
            this.className = debugFerrariClassInfo.name;
            if (!this.className.equals("sun.reflect.DelegatingClassLoader")) {
                DebugShared.exploreClassLoaderParents(this);
            }
            Map map = debugFerrari.classLoaderIds;
            synchronized (map) {
                Integer n = (Integer)debugFerrari.classLoaderIds.get(this.className);
                this.id = n == null ? 1 : n + 1;
                n = new Integer(this.id);
                debugFerrari.classLoaderIds.put(this.className, n);
            }
        }
    }

    public boolean hasExpired() {
        return false;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ClassLoader has expired");
        }
    }

    public String getClassName() {
        this.throwIfExpired();
        return this.className;
    }

    public int getId() {
        this.throwIfExpired();
        return this.id;
    }

    public DebugClassInfo[] listDefinedClasses() {
        this.throwIfExpired();
        ArrayList<DebugFerrariClassInfo> arrayList = new ArrayList<DebugFerrariClassInfo>();
        DebugClassInfo[] debugClassInfoArray = this.df.listClasses();
        int n = debugClassInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugFerrariClassInfo debugFerrariClassInfo = (DebugFerrariClassInfo)debugClassInfoArray[n2];
            if (debugFerrariClassInfo.getClassLoaderAddress() == this.address) {
                arrayList.add(debugFerrariClassInfo);
            }
            ++n2;
        }
        DebugClassInfo[] debugClassInfoArray2 = new DebugClassInfo[arrayList.size()];
        return arrayList.toArray(debugClassInfoArray2);
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        if (this.address != 0L) {
            return new DebugFerrariDataObjectInfo(this.df, this.clazz, 0L, 0L, "", Long.toHexString(this.address).toUpperCase());
        }
        return null;
    }

    public DebugClassLoaderInfo getParent() {
        DebugFerrariDataObjectInfo debugFerrariDataObjectInfo;
        DebugDataObjectInfo debugDataObjectInfo;
        this.throwIfExpired();
        if (this.parent == null && (debugDataObjectInfo = this.getClassLoaderObject()) != null && (debugFerrariDataObjectInfo = (DebugFerrariDataObjectInfo)DebugShared.getParentClassLoaderObject(debugDataObjectInfo)) != null) {
            this.parent = DebugFerrariClassLoaderInfo.makeClassLoaderInfo(this.df, debugFerrariDataObjectInfo.address, debugFerrariDataObjectInfo.clazz);
        }
        return this.parent;
    }

    public boolean isSystemClassLoader() {
        this.throwIfExpired();
        return this.address != 0L && this.address == this.df.getSystemClassLoaderAddress();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariClassLoaderInfo) {
            DebugFerrariClassLoaderInfo debugFerrariClassLoaderInfo = (DebugFerrariClassLoaderInfo)object;
            return this.address == debugFerrariClassLoaderInfo.address;
        }
        return false;
    }
}

