/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariArb;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnectArg;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnection;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariTransport;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugFerrariConnector
implements DebugFerrariConnection,
DebugConnector {
    private DebugFerrariConnection connection;
    private Socket clientSock;

    public static String getVersion() {
        int n = 2;
        int n2 = 19;
        return Integer.toString(n) + "." + Integer.toString(n2);
    }

    public DebugFerrariConnector() {
        this(null);
    }

    public DebugFerrariConnector(DebugFerrariConnection debugFerrariConnection) {
        this.connection = debugFerrariConnection != null ? debugFerrariConnection : this;
    }

    public synchronized DebugConnectArg[] getConnectArgs() {
        DebugConnectArg[] debugConnectArgArray = new DebugFerrariConnectArg[]{new DebugFerrariConnectArg(0, "hostname", DebugFerrariArb.getString(0), true), new DebugFerrariConnectArg(0, "port", DebugFerrariArb.getString(1), false), new DebugFerrariConnectArg(0, "timeout", DebugFerrariArb.getString(2), true)};
        return debugConnectArgArray;
    }

    public synchronized DebugVirtualMachine connect(DebugConnectArg[] debugConnectArgArray) throws Exception {
        String string = debugConnectArgArray[0].getValue();
        int n = Integer.parseInt(debugConnectArgArray[1].getValue());
        int n2 = 0;
        try {
            n2 = Integer.parseInt(debugConnectArgArray[2].getValue()) * 1000;
        }
        catch (Exception exception) {
            // empty catch block
        }
        DebugFerrariTransport debugFerrariTransport = null;
        boolean bl = false;
        try {
            this.connection.openConnection(string, n, n2);
            debugFerrariTransport = new DebugFerrariTransport(this.connection);
            debugFerrariTransport.sendMessage(32);
            int n3 = debugFerrariTransport.receiveMessage();
            if (n3 == 19) {
                int n4 = debugFerrariTransport.receiveInt();
                boolean bl2 = bl = debugFerrariTransport.receiveInt() != 0;
                if (n4 == 531) {
                    DebugFerrari debugFerrari = new DebugFerrari(debugFerrariTransport, bl);
                    return debugFerrari;
                }
                String string2 = DebugFerrariArb.format(3, Integer.toHexString(n4).toUpperCase(), Integer.toHexString(531).toUpperCase());
                throw new Exception(string2);
            }
            throw new Exception(DebugFerrariArb.getString(4));
        }
        catch (Exception exception) {
            if (debugFerrariTransport != null && debugFerrariTransport.isConnected()) {
                boolean bl3 = bl ^ true;
                debugFerrariTransport.sendMessage(34, bl3 ? 1 : 0);
                debugFerrariTransport.disconnect();
            }
            throw (Exception)exception.fillInStackTrace();
        }
    }

    public synchronized void startListening(DebugConnectArg[] debugConnectArgArray, DebugConnectionListener debugConnectionListener) throws Exception {
        throw new UnsupportedOperationException("Can not listen. Not supported.");
    }

    public synchronized void stopListening() {
        throw new IllegalStateException("Can not stop listening. Not currently listening.");
    }

    public void openConnection(String string, int n, int n2) throws IOException {
        this.clientSock = new Socket();
        InetAddress inetAddress = InetAddress.getByName(string);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.clientSock.connect(inetSocketAddress, n2);
        this.clientSock.setTcpNoDelay(true);
    }

    public InputStream getInputStream() throws IOException {
        return this.clientSock.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.clientSock.getOutputStream();
    }

    public void closeConnection() throws IOException {
        this.clientSock = null;
    }
}

