/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

class DebugFerrariDataCompositeInfo
extends DebugFerrariDataInfo
implements DebugDataCompositeInfo {
    long address = 0L;
    private int hashCode;

    DebugFerrariDataCompositeInfo(DebugFerrari debugFerrari, DebugFerrariClassInfo debugFerrariClassInfo, long l, long l2, String string, String string2) {
        super(debugFerrari, debugFerrariClassInfo, l, l2, string, "");
        if (string2.length() > 0) {
            try {
                this.address = DebugSharedPrimitives.longFromHexString(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void updateInfo(DebugFerrariDataInfo debugFerrariDataInfo) {
        super.updateInfo(debugFerrariDataInfo);
        if (debugFerrariDataInfo instanceof DebugFerrariDataCompositeInfo) {
            this.address = ((DebugFerrariDataCompositeInfo)debugFerrariDataInfo).address;
        }
    }

    public boolean isNull() {
        this.hasExpired();
        return this.address == 0L;
    }

    public long getAddressOfObject() {
        this.hasExpired();
        return this.address;
    }

    public boolean canSetAddressOfObject() {
        return this.place != 0L;
    }

    public boolean canSetAddressOfObjectToNull() {
        return this.place != 0L;
    }

    public boolean setAddressOfObject(long l) {
        this.throwIfExpired();
        return this.df.modifyData(this, Long.toString(l));
    }

    public DebugPinnedInfo pinObject(DebugPinListener debugPinListener) {
        this.throwIfExpired();
        return this.df.pinObject(this, debugPinListener);
    }

    public long getUniqueID() {
        this.throwIfExpired();
        return this.df.getUniqueID(this);
    }

    public String getCourtesyValue() {
        this.throwIfExpired();
        return this.df.getCourtesyInfo(this);
    }

    public boolean canGetWholeThing() {
        this.throwIfExpired();
        return this.df.canGetWholeThing(this);
    }

    public Object getWholeThing() {
        this.throwIfExpired();
        return this.df.getWholeThing(this);
    }

    public DebugMonitorInfo getMonitor() {
        this.throwIfExpired();
        return this.df.getMonitor(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode() + (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariDataCompositeInfo) {
            DebugFerrariDataCompositeInfo debugFerrariDataCompositeInfo = (DebugFerrariDataCompositeInfo)object;
            return super.equals(object) && this.address == debugFerrariDataCompositeInfo.address;
        }
        return false;
    }
}

