/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugFerrariDataInfo
implements DebugDataInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariClassInfo clazz;
    long place;
    long owner;
    String value;
    String hexValue;
    DebugFerrariFieldInfo staticField;
    DebugFerrariClassInfo declaredClass;
    private int hashCode;

    DebugFerrariDataInfo(DebugFerrari debugFerrari, DebugFerrariClassInfo debugFerrariClassInfo, long l, long l2, String string, String string2) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.clazz = debugFerrariClassInfo;
        this.place = l;
        this.owner = l2;
        this.value = string;
        this.hexValue = string2;
        this.declaredClass = debugFerrariClassInfo;
    }

    void setStaticField(DebugFerrariFieldInfo debugFerrariFieldInfo) {
        this.staticField = debugFerrariFieldInfo;
    }

    void setDeclaredClass(DebugFerrariClassInfo debugFerrariClassInfo) {
        this.declaredClass = debugFerrariClassInfo;
    }

    void updateInfo(DebugFerrariDataInfo debugFerrariDataInfo) {
        this.stoppedCount = debugFerrariDataInfo.stoppedCount;
        this.clazz = debugFerrariDataInfo.clazz;
        this.place = debugFerrariDataInfo.place;
        this.owner = debugFerrariDataInfo.owner;
        this.value = debugFerrariDataInfo.value;
        this.hexValue = debugFerrariDataInfo.hexValue;
    }

    public DebugVirtualMachine getVM() {
        return this.df;
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount && this.staticField != null && !this.staticField.hasExpired()) {
            this.df.updateStaticFieldData(this);
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Data has expired");
        }
    }

    boolean isStaticFieldData() {
        return this.staticField != null;
    }

    public DebugClassInfo getClassInfo() {
        this.hasExpired();
        return this.clazz;
    }

    public String getValue() {
        this.hasExpired();
        return this.value;
    }

    public String getHexValue() {
        this.hasExpired();
        return this.hexValue;
    }

    public boolean canModifyDataWithString() {
        return this.place != 0L && (this.declaredClass.isPrimitive || this.declaredClass.name.equals("java.lang.String"));
    }

    public boolean modifyDataWithString(String string) {
        this.throwIfExpired();
        if (this.place != 0L) {
            if (this.declaredClass.isPrimitive) {
                return this.df.modifyData(this, string);
            }
            if (this.declaredClass.name.equals("java.lang.String")) {
                return this.df.modifyString(this, string);
            }
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.place != 0L;
    }

    public boolean modifyDataWithData(DebugDataInfo debugDataInfo) {
        this.throwIfExpired();
        String string = debugDataInfo instanceof DebugFerrariDataCompositeInfo ? Long.toString(((DebugFerrariDataCompositeInfo)debugDataInfo).address) : ((DebugFerrariDataInfo)debugDataInfo).value;
        return this.df.modifyData(this, string);
    }

    public boolean canModifyDataWithNewObject() {
        return false;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo debugMethodInfo, String[] stringArray) {
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.clazz.hashCode() + this.value.hashCode() + this.hexValue.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariDataInfo) {
            DebugFerrariDataInfo debugFerrariDataInfo = (DebugFerrariDataInfo)object;
            return this.df.equals(debugFerrariDataInfo.df) && this.clazz.equals(debugFerrariDataInfo.clazz) && this.value.equals(debugFerrariDataInfo.value) && this.hexValue.equals(debugFerrariDataInfo.hexValue);
        }
        return false;
    }
}

