/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;

final class DebugFerrariDataPrimitiveInfo
extends DebugFerrariDataInfo
implements DebugDataPrimitiveInfo {
    DebugFerrariDataPrimitiveInfo(DebugFerrari debugFerrari, DebugFerrariClassInfo debugFerrariClassInfo, long l, long l2, String string, String string2) {
        super(debugFerrari, debugFerrariClassInfo, l, l2, string, string2);
        if (debugFerrariClassInfo != null) {
            try {
                if (debugFerrariClassInfo.name.equals("double")) {
                    double d = Double.longBitsToDouble(DebugSharedPrimitives.longFromHexString(string2));
                    this.value = Double.toString(d);
                } else if (debugFerrariClassInfo.name.equals("float")) {
                    float f = Float.intBitsToFloat(DebugSharedPrimitives.intFromHexString(string2));
                    this.value = Float.toString(f);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean modifyDataWithString(String string) {
        if (this.clazz != null) {
            try {
                if (this.clazz.name.equals("double")) {
                    string = Double.toString(DebugSharedPrimitives.doubleDecode(string));
                } else if (this.clazz.name.equals("float")) {
                    string = Float.toString(DebugSharedPrimitives.floatDecode(string));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.modifyDataWithString(string);
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariDataPrimitiveInfo) {
            return super.equals(object);
        }
        return false;
    }

    Object promoteValue(char c) throws Exception {
        if (this.clazz != null) {
            switch (c) {
                case 'Z': {
                    if (!this.clazz.name.equals("boolean")) break;
                    return new Boolean(DebugSharedPrimitives.booleanDecode(this.value));
                }
                case 'C': {
                    if (!this.clazz.name.equals("char")) break;
                    return new Character(DebugSharedPrimitives.charDecode(this.value));
                }
                case 'B': {
                    if (!this.clazz.name.equals("byte")) break;
                    return new Byte(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'S': {
                    if (this.clazz.name.equals("short")) {
                        return new Short(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Short(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'I': {
                    if (this.clazz.name.equals("int")) {
                        return new Integer(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Integer(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Integer(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'J': {
                    if (this.clazz.name.equals("long")) {
                        return new Long(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Long(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Long(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Long(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'F': {
                    if (this.clazz.name.equals("float")) {
                        return new Float(DebugSharedPrimitives.floatDecode(this.value));
                    }
                    if (this.clazz.name.equals("long")) {
                        return new Float(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Float(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Float(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Float(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'D': {
                    if (this.clazz.name.equals("double")) {
                        return new Double(DebugSharedPrimitives.doubleDecode(this.value));
                    }
                    if (this.clazz.name.equals("float")) {
                        return new Double(DebugSharedPrimitives.floatDecode(this.value));
                    }
                    if (this.clazz.name.equals("long")) {
                        return new Double(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Double(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Double(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Double(DebugSharedPrimitives.byteDecode(this.value));
                }
            }
        }
        throw new Exception("Unable to promote value");
    }
}

