/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;

public final class DebugFerrariFieldInfo
implements DebugFieldInfo {
    DebugFerrari df;
    int stoppedCount;
    long fieldPtr;
    DebugFerrariClassInfo declaringClass;
    int access;
    DebugFerrariClassInfo clazz;
    String name;
    DebugFerrariDataInfo data;
    private int hashCode;

    DebugFerrariFieldInfo(DebugFerrari debugFerrari, long l, DebugFerrariClassInfo debugFerrariClassInfo, int n, DebugFerrariClassInfo debugFerrariClassInfo2, String string, DebugFerrariDataInfo debugFerrariDataInfo) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.fieldPtr = l;
        this.declaringClass = debugFerrariClassInfo;
        this.access = n;
        this.clazz = debugFerrariClassInfo2;
        this.name = string;
        this.data = debugFerrariDataInfo;
        if (debugFerrariDataInfo != null) {
            debugFerrariDataInfo.setDeclaredClass(debugFerrariClassInfo2);
        }
        if ((n & 8) != 0) {
            debugFerrariDataInfo.setStaticField(this);
        }
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount) {
            if ((this.access & 8) == 0) {
                this.data = null;
            }
            if (!this.declaringClass.hasExpired()) {
                this.stoppedCount = this.df.stoppedCount;
            }
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Field has expired: " + this.name);
        }
    }

    public int getAccess() {
        this.hasExpired();
        return this.access;
    }

    public boolean isStatic() {
        this.hasExpired();
        return (this.access & 8) != 0;
    }

    public boolean isFinal() {
        this.hasExpired();
        return (this.access & 0x10) != 0;
    }

    public DebugClassInfo getClassInfo() {
        this.hasExpired();
        return this.clazz;
    }

    public String getGenericSignature() {
        return this.df.getGenericSignature(this);
    }

    public DebugClassInfo getDeclaringClassInfo() {
        this.hasExpired();
        return this.declaringClass;
    }

    public String getName() {
        this.hasExpired();
        return this.name;
    }

    public DebugDataInfo getDataInfo() {
        this.hasExpired();
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.fieldPtr + this.access + this.clazz.hashCode() + this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariFieldInfo) {
            DebugFerrariFieldInfo debugFerrariFieldInfo = (DebugFerrariFieldInfo)object;
            return this.fieldPtr == debugFerrariFieldInfo.fieldPtr && this.access == debugFerrariFieldInfo.access && this.clazz.equals(debugFerrariFieldInfo.clazz) && this.name.equals(debugFerrariFieldInfo.name) && (this.data == null ? debugFerrariFieldInfo.data == null : this.data.equals(debugFerrariFieldInfo.data));
        }
        return false;
    }

    public void special(int n) {
        this.throwIfExpired();
        this.df.special(this, n);
    }
}

