/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;

abstract class DebugFerrariHeapAncestor
implements DebugHeapAncestor {
    DebugFerrari df;
    long address;
    int depth;
    int stoppedCount;
    DebugFerrariDataCompositeInfo data;

    DebugFerrariHeapAncestor(DebugFerrari debugFerrari, long l) {
        this.df = debugFerrari;
        this.address = l;
        this.stoppedCount = debugFerrari.stoppedCount;
    }

    void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public long getAddress() {
        return this.address;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapAncestor has expired");
        }
    }

    public DebugDataCompositeInfo getDataInfo() {
        if (this.data != null) {
            return this.data;
        }
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.df.getObjectFromAddress(this.address);
        }
        return this.data;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariHeapAncestor) {
            DebugFerrariHeapAncestor debugFerrariHeapAncestor = (DebugFerrariHeapAncestor)object;
            return this.df.equals(debugFerrariHeapAncestor.df) && this.address == debugFerrariHeapAncestor.address;
        }
        return false;
    }
}

