/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;

final class DebugFerrariHeapInfo
implements DebugHeapInfo {
    DebugFerrari df;
    DebugHeapSubset subset;
    int stoppedCount;
    DebugFerrariHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap;
    long[] heapAddresses;
    int[] depths;
    DebugFerrariHeapAncestorInsideHeap[] heapAncestorsInsideHeap;
    private int hashCode;

    DebugFerrariHeapInfo(DebugFerrari debugFerrari, DebugHeapSubset debugHeapSubset, DebugFerrariHeapAncestorOutsideHeap[] debugFerrariHeapAncestorOutsideHeapArray, long[] lArray, int[] nArray) {
        this.df = debugFerrari;
        this.subset = debugHeapSubset;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.heapAddresses = lArray;
        this.depths = nArray;
        ArrayList<DebugFerrariHeapAncestorOutsideHeap> arrayList = new ArrayList<DebugFerrariHeapAncestorOutsideHeap>();
        int n = -1;
        if (debugHeapSubset instanceof DebugHeapSubsetAncestors) {
            n = ((DebugHeapSubsetAncestors)debugHeapSubset).getDepth();
        }
        int n2 = debugFerrariHeapAncestorOutsideHeapArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DebugFerrariHeapAncestorOutsideHeap debugFerrariHeapAncestorOutsideHeap = debugFerrariHeapAncestorOutsideHeapArray[n3];
            long l = debugFerrariHeapAncestorOutsideHeap.getAddress();
            int n4 = this.getDepth(l) + 1;
            if (n == -1 || n4 <= n) {
                debugFerrariHeapAncestorOutsideHeap.setDepth(n4);
                arrayList.add(debugFerrariHeapAncestorOutsideHeap);
            }
            ++n3;
        }
        this.heapAncestorsOutsideHeap = arrayList.toArray(new DebugFerrariHeapAncestorOutsideHeap[arrayList.size()]);
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapInfo has expired");
        }
    }

    public DebugHeapAncestorOutsideHeap[] getAncestorsOutsideHeap() {
        return this.heapAncestorsOutsideHeap;
    }

    public DebugHeapAncestorInsideHeap[] getAncestorsInsideHeap() {
        if (this.heapAncestorsInsideHeap == null) {
            if (this.subset instanceof DebugHeapSubsetAncestors) {
                int n = this.heapAddresses.length;
                if (this.depths != null && this.depths.length == n) {
                    1HeapAddressAndDepth[] heapAddressAndDepthArray = new 1HeapAddressAndDepth[this.heapAddresses.length];
                    int n2 = 0;
                    while (n2 < n) {
                        heapAddressAndDepthArray[n2] = new 1HeapAddressAndDepth(this.heapAddresses[n2], this.depths[n2]);
                        ++n2;
                    }
                    Arrays.sort(heapAddressAndDepthArray, new 1());
                    this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[n];
                    int n3 = 0;
                    while (n3 < n) {
                        this.heapAncestorsInsideHeap[n3] = new DebugFerrariHeapAncestorInsideHeap(this.df, heapAddressAndDepthArray[n3].heapAddress);
                        this.heapAncestorsInsideHeap[n3].setDepth(heapAddressAndDepthArray[n3].depth);
                        ++n3;
                    }
                } else {
                    this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[0];
                }
            } else {
                this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[0];
            }
        }
        return this.heapAncestorsInsideHeap;
    }

    public long[] getHeapAddresses() {
        return this.heapAddresses;
    }

    public int[] getHeapAncestorDepths() {
        return this.depths;
    }

    public int getDepth(long l) {
        if (this.subset instanceof DebugHeapSubsetAncestors) {
            int n;
            long l2 = ((DebugHeapSubsetAncestors)this.subset).getAddress();
            if (l == l2) {
                return 0;
            }
            if (this.depths != null && (n = Arrays.binarySearch(this.heapAddresses, l)) >= 0) {
                return this.depths[n];
            }
        }
        return -1;
    }

    public int getDepth(DebugDataCompositeInfo debugDataCompositeInfo) {
        return this.getDepth(debugDataCompositeInfo.getAddressOfObject());
    }

    public DebugHeapObjectInfo[] getHeapObjects(int n, int n2) {
        this.throwIfExpired();
        if (n == 0 && n2 == 0) {
            n2 = this.heapAddresses.length;
        }
        if (n + n2 > this.heapAddresses.length) {
            n2 = this.heapAddresses.length - n;
        }
        return this.df.getHeapObjects(this.heapAddresses, n, n2);
    }

    public int countHeapObjects() {
        return this.heapAddresses.length;
    }

    public DebugHeapSubset getHeapSubset() {
        return this.subset;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.subset != null) {
            this.hashCode = this.subset.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariHeapInfo) {
            DebugFerrariHeapInfo debugFerrariHeapInfo = (DebugFerrariHeapInfo)object;
            return this.df.equals(debugFerrariHeapInfo.df) && (this.subset == null ? debugFerrariHeapInfo.subset == null : this.subset.equals(debugFerrariHeapInfo.subset));
        }
        return false;
    }

    class 1HeapAddressAndDepth {
        long heapAddress;
        int depth;

        1HeapAddressAndDepth(long l, int n) {
            this.heapAddress = l;
            this.depth = n;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((1HeapAddressAndDepth)object).depth - ((1HeapAddressAndDepth)object2).depth;
        }
    }
}

