/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataArrayInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;

final class DebugFerrariHeapObjectInfo
implements DebugHeapObjectInfo {
    DebugFerrari df;
    int stoppedCount;
    long address;
    boolean root;
    int size;
    DebugFerrariClassInfo clazz;
    DebugFerrariDataCompositeInfo data;
    private int hashCode;

    DebugFerrariHeapObjectInfo(DebugFerrari debugFerrari, long l, boolean bl, int n, DebugFerrariClassInfo debugFerrariClassInfo) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.address = l;
        this.root = bl;
        this.size = n;
        this.clazz = debugFerrariClassInfo;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapObjectInfo has expired");
        }
    }

    public long getAddressOfObject() {
        return this.address;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int getSize() {
        return this.size;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public DebugDataCompositeInfo getDataInfo() {
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.clazz.isObject() ? new DebugFerrariDataObjectInfo(this.df, this.clazz, 0L, 0L, "", Long.toHexString(this.address).toUpperCase()) : (this.clazz.isArray() ? new DebugFerrariDataArrayInfo(this.df, this.clazz, 0L, 0L, "", Long.toHexString(this.address).toUpperCase()) : new DebugFerrariDataCompositeInfo(this.df, this.clazz, 0L, 0L, "", Long.toHexString(this.address).toUpperCase()));
        }
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariHeapObjectInfo) {
            DebugFerrariHeapObjectInfo debugFerrariHeapObjectInfo = (DebugFerrariHeapObjectInfo)object;
            return this.address == debugFerrariHeapObjectInfo.address;
        }
        return false;
    }
}

