/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataPrimitiveInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugFerrariMethodInfo
implements DebugMethodInfo {
    private static final int ACC_COMPILED = 0x10000000;
    DebugFerrari df;
    int stoppedCount;
    long methodPtr;
    DebugFerrariClassInfo clazz;
    int access;
    String name;
    int[] range;
    private SoftReference sfLocationsCache;
    private int hashCode;

    DebugFerrariMethodInfo(DebugFerrari debugFerrari, long l, DebugFerrariClassInfo debugFerrariClassInfo, int n, String string) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.methodPtr = l;
        this.clazz = debugFerrariClassInfo;
        this.access = n;
        this.name = string;
    }

    public DebugVirtualMachine getVM() {
        return this.df;
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount && !this.clazz.hasExpired()) {
            this.updateMethod();
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    void updateMethod() {
        this.updateMethod(this.df.getMethodAccess(this));
    }

    void updateMethod(int n) {
        this.access = n;
        this.stoppedCount = this.df.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public boolean isCompiled() {
        this.hasExpired();
        return (this.access & 0x10000000) != 0;
    }

    public String getName() {
        this.hasExpired();
        return this.name;
    }

    public String getNameWithoutClass() {
        this.hasExpired();
        return DebugShared.getNameWithoutClass(this.name);
    }

    public String getNameWithoutSignature() {
        this.hasExpired();
        return DebugShared.getNameWithoutSignature(this.name);
    }

    public String getNameWithoutClassOrSignature() {
        this.hasExpired();
        return DebugShared.getNameWithoutClassOrSignature(this.name);
    }

    public String getParameterSignature() {
        this.hasExpired();
        return DebugShared.getMethodParameterSignature(this.name);
    }

    public int getAccess() {
        this.hasExpired();
        return this.access;
    }

    public int[] getMethodLineRange() {
        this.throwIfExpired();
        if (this.range == null) {
            this.range = this.df.getMethodLineRange(this);
        }
        return this.range;
    }

    public int[] getMethodLines() {
        this.throwIfExpired();
        return this.df.getMethodLines(this);
    }

    public int[] getCodeCoverage() {
        this.throwIfExpired();
        return this.df.getMethodCodeCoverage(this);
    }

    public double getCodeCoverageRatio() {
        this.throwIfExpired();
        return this.df.getMethodCodeCoverageRatio(this);
    }

    private IntHashMap getLocationsCache() {
        IntHashMap intHashMap;
        if (this.sfLocationsCache != null && (intHashMap = (IntHashMap)this.sfLocationsCache.get()) != null) {
            return intHashMap;
        }
        intHashMap = new IntHashMap();
        this.sfLocationsCache = new SoftReference<IntHashMap>(intHashMap);
        return intHashMap;
    }

    public DebugLocation getFirstLocation() {
        this.throwIfExpired();
        return this.df.getMethodLocation(this, null, 0);
    }

    public DebugLocation getLocation(String string, int n) {
        this.throwIfExpired();
        IntHashMap intHashMap = null;
        if (ModelUtil.areEqual((Object)string, (Object)this.clazz.getSourceFilename()) && n != 0) {
            intHashMap = this.getLocationsCache();
        }
        if (intHashMap != null) {
            Object object = intHashMap.get(n);
            if (object == Boolean.FALSE) {
                return null;
            }
            if (object != null) {
                return (DebugLocation)object;
            }
        }
        DebugLocation debugLocation = this.df.getMethodLocation(this, string, n);
        if (intHashMap != null) {
            if (debugLocation == null) {
                intHashMap.put(n, (Object)Boolean.FALSE);
            } else {
                intHashMap.put(n, (Object)debugLocation);
            }
        }
        return debugLocation;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean bl, boolean bl2, boolean bl3, Project project) {
        this.throwIfExpired();
        int n = 0;
        if (bl) {
            n |= 1;
        }
        if (bl2) {
            n |= 2;
        }
        if (bl3) {
            n |= 4;
        }
        return this.df.disassembleMethod(this, n);
    }

    public boolean hasMethodChanged() {
        this.throwIfExpired();
        return this.df.hasMethodChanged(this);
    }

    public byte[] getBytecodes() {
        this.throwIfExpired();
        return this.df.getMethodBytecodes(this);
    }

    public byte getBytecode(int n) {
        this.throwIfExpired();
        return this.df.getMethodBytecode(this, n);
    }

    private Object[] makeArgArray(String string, List list, List list2) {
        int n = string.length();
        if (list.size() == n) {
            Object[] objectArray = new Object[n];
            try {
                int n2 = 0;
                while (n2 < n) {
                    Object e = list.get(n2);
                    char c = string.charAt(n2);
                    switch (c) {
                        case 'Z': {
                            if (e instanceof Boolean) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad boolean");
                        }
                        case 'B': {
                            if (e instanceof Byte) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad byte");
                        }
                        case 'C': {
                            if (e instanceof Character) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad char");
                        }
                        case 'F': {
                            if (e instanceof Float) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad float");
                        }
                        case 'I': {
                            if (e instanceof Integer) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad int");
                        }
                        case 'S': {
                            if (e instanceof Short) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad short");
                        }
                        case 'J': {
                            if (e instanceof Long) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad long");
                        }
                        case 'D': {
                            if (e instanceof Double) {
                                objectArray[n2] = e;
                                break;
                            }
                            if (e instanceof DebugFerrariDataPrimitiveInfo) {
                                objectArray[n2] = ((DebugFerrariDataPrimitiveInfo)e).promoteValue(c);
                                break;
                            }
                            throw new Exception("bad double");
                        }
                        case 'L': {
                            if (e == null) {
                                objectArray[n2] = null;
                                break;
                            }
                            if (e instanceof String) {
                                objectArray[n2] = this.df.createString((String)e);
                                if (!(objectArray[n2] instanceof DebugFerrariDataCompositeInfo) || !this.df.pinUnpin((DebugFerrariDataCompositeInfo)objectArray[n2], true)) break;
                                list2.add(objectArray[n2]);
                                break;
                            }
                            if (e instanceof DebugFerrariDataCompositeInfo) {
                                objectArray[n2] = e;
                                break;
                            }
                            throw new Exception("bad object");
                        }
                        case '[': {
                            if (e == null) {
                                objectArray[n2] = null;
                                break;
                            }
                            if (e instanceof DebugFerrariDataCompositeInfo) {
                                objectArray[n2] = e;
                                break;
                            }
                            throw new Exception("bad array");
                        }
                    }
                    ++n2;
                }
                Object[] objectArray2 = objectArray;
                return objectArray2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugDataInfo invoke(List list) {
        this.throwIfExpired();
        DebugFerrariDataInfo debugFerrariDataInfo = null;
        String string = this.df.getInvokeSignature(this);
        if (string != null) {
            ArrayList arrayList = new ArrayList();
            this.df.pinAllReferences(arrayList);
            Object[] objectArray = this.makeArgArray(string, list, arrayList);
            if (objectArray != null) {
                debugFerrariDataInfo = this.df.invokeMethod(this, objectArray);
            }
            this.df.unpinAll(arrayList);
        }
        return debugFerrariDataInfo;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.methodPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariMethodInfo) {
            DebugFerrariMethodInfo debugFerrariMethodInfo = (DebugFerrariMethodInfo)object;
            if (!this.clazz.hasExpired()) {
                return !debugFerrariMethodInfo.clazz.hasExpired() && this.methodPtr == debugFerrariMethodInfo.methodPtr;
            }
            return this.clazz.equals(debugFerrariMethodInfo.clazz) && this.methodPtr == debugFerrariMethodInfo.methodPtr && this.access == debugFerrariMethodInfo.access && this.name.equals(debugFerrariMethodInfo.name);
        }
        return false;
    }

    public void special(int n) {
        this.throwIfExpired();
        this.df.special(this, n);
    }
}

