/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;

final class DebugFerrariRegisterInfo
implements DebugRegisterInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariThreadInfo thread;
    int offset;
    String name;
    String value;
    String hexValue;
    private int hashCode;

    DebugFerrariRegisterInfo(DebugFerrari debugFerrari, DebugFerrariThreadInfo debugFerrariThreadInfo, int n, String string, String string2, String string3) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.thread = debugFerrariThreadInfo;
        this.offset = n;
        this.name = string;
        this.value = string2;
        this.hexValue = string3;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("RegisterInfo has expired");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public boolean modifyRegister(String string) {
        this.throwIfExpired();
        return this.df.modifyRegister(this, string);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thread.hashCode() + this.offset;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariRegisterInfo) {
            DebugFerrariRegisterInfo debugFerrariRegisterInfo = (DebugFerrariRegisterInfo)object;
            return this.df.equals(debugFerrariRegisterInfo.df) && this.thread.equals(debugFerrariRegisterInfo.thread) && this.offset == debugFerrariRegisterInfo.offset;
        }
        return false;
    }
}

