/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStackSlotInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariVariableInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariStackFrameInfo
implements DebugFerrariStoppedListener,
DebugStackFrameInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariThreadInfo thread;
    int frame;
    DebugLocation location;
    private boolean stoppedListener;
    private SoftReference sfArguments;
    private SoftReference sfLocals;
    private SoftReference sfSlots;
    private int hashCode;

    DebugFerrariStackFrameInfo(DebugFerrari debugFerrari, DebugFerrariThreadInfo debugFerrariThreadInfo, int n, DebugLocation debugLocation) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.thread = debugFerrariThreadInfo;
        this.frame = n;
        this.location = debugLocation;
    }

    public void stoppedOrResuming(boolean bl) {
        this.sfArguments = null;
        this.sfLocals = null;
        this.sfSlots = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    DebugFerrariStackFrameInfo(DebugFerrari debugFerrari, DebugFerrariThreadInfo debugFerrariThreadInfo, int n) {
        this.df = debugFerrari;
        this.thread = debugFerrariThreadInfo;
        this.frame = n;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackFrame has expired");
        }
    }

    public int getFrameNumber() {
        return this.frame;
    }

    public DebugLocation getLocation() {
        return this.location;
    }

    public DebugVariableInfo[] listArguments() {
        Object t;
        this.throwIfExpired();
        if (this.sfArguments != null && (t = this.sfArguments.get()) != null) {
            return (DebugVariableInfo[])t;
        }
        DebugVariableInfo[] debugVariableInfoArray = this.df.listArguments(this);
        this.sfArguments = new SoftReference<DebugFerrariVariableInfo[]>((DebugFerrariVariableInfo[])debugVariableInfoArray);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return debugVariableInfoArray;
    }

    public DebugVariableInfo[] listLocals() {
        Object t;
        this.throwIfExpired();
        if (this.sfLocals != null && (t = this.sfLocals.get()) != null) {
            return (DebugVariableInfo[])t;
        }
        DebugVariableInfo[] debugVariableInfoArray = this.df.listLocals(this);
        this.sfLocals = new SoftReference<DebugFerrariVariableInfo[]>((DebugFerrariVariableInfo[])debugVariableInfoArray);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return debugVariableInfoArray;
    }

    public DebugVariableInfo getVariable(String string) {
        return null;
    }

    public DebugStackSlotInfo[] listSlots() {
        Object t;
        this.throwIfExpired();
        if (this.sfSlots != null && (t = this.sfSlots.get()) != null) {
            return (DebugStackSlotInfo[])t;
        }
        DebugStackSlotInfo[] debugStackSlotInfoArray = this.df.listSlots(this);
        this.sfSlots = new SoftReference<DebugFerrariStackSlotInfo[]>((DebugFerrariStackSlotInfo[])debugStackSlotInfoArray);
        if (!this.stoppedListener) {
            this.stoppedListener = true;
            this.df.addStoppedListener(this);
        }
        return debugStackSlotInfoArray;
    }

    public int getLanguage() {
        return 1;
    }

    public boolean popBackToHere() {
        this.throwIfExpired();
        if (this.df.canPopFrames()) {
            return this.df.popBackToHere(this);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thread.hashCode() + this.frame;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariStackFrameInfo) {
            DebugFerrariStackFrameInfo debugFerrariStackFrameInfo = (DebugFerrariStackFrameInfo)object;
            return this.df.equals(debugFerrariStackFrameInfo.df) && this.thread.equals(debugFerrariStackFrameInfo.thread) && this.frame == debugFerrariStackFrameInfo.frame && (this.location == null ? debugFerrariStackFrameInfo.location == null : this.location.equals(debugFerrariStackFrameInfo.location));
        }
        return false;
    }
}

