/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariStackSlotInfo
implements DebugStackSlotInfo {
    DebugFerrari df;
    int stoppedCount;
    int index;
    long place;
    String hexValue;
    DebugFerrariVariableInfo variable;
    long possibleAddress;
    String decValue;
    DebugFerrariDataCompositeInfo data;
    private int hashCode;

    DebugFerrariStackSlotInfo(DebugFerrari debugFerrari, int n, long l, String string, DebugFerrariVariableInfo debugFerrariVariableInfo) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.index = n;
        this.place = l;
        this.hexValue = string;
        this.variable = debugFerrariVariableInfo;
        this.possibleAddress = 0L;
        this.decValue = "";
        if (string.length() > 0) {
            try {
                this.possibleAddress = DebugSharedPrimitives.longFromHexString(string);
                this.decValue = Long.toString(this.possibleAddress);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("StackSlot has expired");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public String getValue() {
        return this.decValue;
    }

    public String getHexValue() {
        return this.hexValue;
    }

    public DebugDataCompositeInfo getDataInfo() {
        if (this.data != null) {
            return this.data;
        }
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.df.getObjectFromAddress(this.possibleAddress);
        }
        return this.data;
    }

    public DebugVariableInfo getVariableInfo() {
        return this.variable;
    }

    public boolean modifySlot(String string) {
        this.throwIfExpired();
        if (this.variable != null && this.variable.data != null) {
            return this.variable.data.modifyDataWithString(string);
        }
        return this.df.modifySlot(this, string);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.index + (int)this.place;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariStackSlotInfo) {
            DebugFerrariStackSlotInfo debugFerrariStackSlotInfo = (DebugFerrariStackSlotInfo)object;
            return this.df.equals(debugFerrariStackSlotInfo.df) && this.index == debugFerrariStackSlotInfo.index && this.place == debugFerrariStackSlotInfo.place;
        }
        return false;
    }
}

