/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

final class DebugFerrariThreadGroupInfo
implements DebugThreadGroupInfo {
    DebugFerrari df;
    int stoppedCount;
    long groupPtr;
    String name;
    private int hashCode;

    DebugFerrariThreadGroupInfo(DebugFerrari debugFerrari, long l, String string) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.groupPtr = l;
        this.name = string;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ThreadGroup has expired");
        }
    }

    public String getName() {
        return this.name;
    }

    public DebugDataObjectInfo getThreadGroupObject() {
        this.throwIfExpired();
        return this.df.getThreadGroupObject(this);
    }

    public DebugThreadGroupInfo getParent() {
        this.throwIfExpired();
        return this.df.getThreadGroupParent(this);
    }

    public DebugThreadGroupInfo[] listGroups() {
        this.throwIfExpired();
        return this.df.listThreadGroupGroups(this);
    }

    public DebugThreadInfo[] listThreads() {
        this.throwIfExpired();
        return this.df.listThreadGroupThreads(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.groupPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariThreadGroupInfo) {
            DebugFerrariThreadGroupInfo debugFerrariThreadGroupInfo = (DebugFerrariThreadGroupInfo)object;
            return this.groupPtr == debugFerrariThreadGroupInfo.groupPtr;
        }
        return false;
    }
}

