/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassLoaderInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStackFrameInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

public final class DebugFerrariThreadInfo
implements DebugThreadInfo {
    DebugFerrari df;
    int stoppedCount;
    boolean exited;
    long threadPtr;
    String name;
    String groupName;
    int status;
    int frameCount;
    private int hashCode;

    DebugFerrariThreadInfo(DebugFerrari debugFerrari, long l, String string, String string2) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.exited = false;
        this.threadPtr = l;
        this.name = string;
        this.groupName = string2;
        this.status = 0;
        this.frameCount = 0;
    }

    void updateName(String string, String string2) {
        this.name = string;
        this.groupName = string2;
    }

    public boolean hasExited() {
        if (!this.exited && this.df.stoppedCount != this.stoppedCount) {
            this.status = 0;
            this.frameCount = 0;
            this.df.updateThread(this);
            this.stoppedCount = this.df.stoppedCount;
        }
        return this.exited;
    }

    public long getThreadId() {
        this.hasExited();
        return this.threadPtr;
    }

    public String getName() {
        this.hasExited();
        return this.name;
    }

    public String getGroupName() {
        this.hasExited();
        return this.groupName;
    }

    public DebugThreadGroupInfo getThreadGroup() {
        this.hasExited();
        return this.df.getThreadGroup(this);
    }

    public int getStatus() {
        this.hasExited();
        if (this.status == 0) {
            this.status = this.df.getThreadStatus(this);
        }
        return this.status;
    }

    public boolean isThreadSuspended() {
        this.hasExited();
        return this.df.isThreadSuspended(this);
    }

    public void suspendThread() {
        this.hasExited();
        this.df.suspendThread(this);
    }

    public void resumeThread() {
        this.hasExited();
        this.df.resumeThread(this);
    }

    public DebugDataObjectInfo getThreadObject() {
        this.hasExited();
        return this.df.getThreadObject(this);
    }

    public void stepInto() {
        this.hasExited();
        this.df.stepInto(this);
    }

    public void stepOver() {
        this.hasExited();
        this.df.stepOver(this);
    }

    public void stepIntoBC() {
        this.hasExited();
        this.df.stepIntoBC(this);
    }

    public void stepOverBC() {
        this.hasExited();
        this.df.stepOverBC(this);
    }

    public void stepOut() {
        this.hasExited();
        this.df.stepOut(this);
    }

    public boolean isAtEndOfMethod() {
        this.hasExited();
        return this.df.isAtEndOfMethod(this);
    }

    public void stepToEndOfMethod() {
        this.hasExited();
        this.df.stepToEndOfMethod(this);
    }

    public int getStackFrameCount() {
        this.hasExited();
        if (this.frameCount == 0) {
            this.frameCount = this.df.getStackFrameCount(this);
        }
        return this.frameCount;
    }

    public DebugStackFrameInfo getStackFrame(int n) {
        this.hasExited();
        return this.df.getStackFrame(this, n);
    }

    public DebugStackFrameInfo[] listStack() {
        this.hasExited();
        return this.df.listStack(this);
    }

    public DebugMonitorInfo[] listOwnedMonitors() {
        this.hasExited();
        return this.df.listMonitors(this);
    }

    public DebugMonitorInfo getMonitorThreadWaitingFor() {
        this.hasExited();
        return this.df.getMonitorThreadWaitingFor(this);
    }

    public DebugMonitorInfo getMonitorThreadBlockedFor() {
        this.hasExited();
        return this.df.getMonitorThreadBlockedFor(this);
    }

    public DebugRegisterInfo[] listRegisters() {
        this.hasExited();
        return this.df.listRegisters(this);
    }

    public DebugRegisterInfo[] listFloatRegisters() {
        this.hasExited();
        return this.df.listFloatRegisters(this);
    }

    public DebugVariableInfo getReturnValue() {
        this.hasExited();
        return this.df.getReturnValue(this);
    }

    public DebugVariableInfo getReturnedValue() {
        this.hasExited();
        return this.df.getReturnedValue(this);
    }

    public boolean setLocation(DebugLocation debugLocation) {
        DebugLocation debugLocation2;
        this.hasExited();
        DebugFerrariStackFrameInfo debugFerrariStackFrameInfo = this.df.getStackFrame(this, 0);
        if (debugFerrariStackFrameInfo != null && (debugLocation2 = debugFerrariStackFrameInfo.getLocation()) != null && debugLocation2.getMethod().equals(debugLocation.getMethod())) {
            return this.df.setThreadIP(this, debugLocation.getAddress());
        }
        return false;
    }

    public DebugDataObjectInfo getContextClassLoaderObject() {
        this.hasExited();
        return DebugShared.getContextClassLoaderObject(this);
    }

    public DebugClassLoaderInfo getContextClassLoader() {
        this.hasExited();
        DebugFerrariDataObjectInfo debugFerrariDataObjectInfo = (DebugFerrariDataObjectInfo)this.getContextClassLoaderObject();
        if (debugFerrariDataObjectInfo != null) {
            return DebugFerrariClassLoaderInfo.makeClassLoaderInfo(this.df, debugFerrariDataObjectInfo.address, debugFerrariDataObjectInfo.clazz);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.threadPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariThreadInfo) {
            DebugFerrariThreadInfo debugFerrariThreadInfo = (DebugFerrariThreadInfo)object;
            return this.threadPtr == debugFerrariThreadInfo.threadPtr;
        }
        return false;
    }

    public void special(int n) {
        this.hasExited();
        this.df.special(this, n);
    }
}

