/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IdeProfile;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnection;

final class DebugFerrariTransport {
    private DebugFerrariConnection connection;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private int pointerSize;
    DebugFerrari df;
    private static final boolean loggingSend = true;
    private static final boolean loggingReceived = true;
    private static final int eventId_OJVM_SEND_MESSAGE = 3799;
    private static final boolean eventOn_OJVM_SEND_MESSAGE = IdeProfile.isEventActive((int)3799);
    private static final int eventId_OJVM_RECV_MESSAGE = 3798;
    private static final boolean eventOn_OJVM_RECV_MESSAGE = IdeProfile.isEventActive((int)3798);

    DebugFerrariTransport(DebugFerrariConnection debugFerrariConnection) throws IOException {
        this.connection = debugFerrariConnection;
        this.inputStream = new DataInputStream(new BufferedInputStream(debugFerrariConnection.getInputStream(), 16384));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(debugFerrariConnection.getOutputStream()));
        this.pointerSize = 4;
    }

    int getPointerSize() {
        return this.pointerSize;
    }

    void setPointerSize(int n) {
        this.pointerSize = n;
    }

    boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    synchronized void disconnect() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.connection != null) {
                this.connection.closeConnection();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inputStream = null;
        this.outputStream = null;
        this.connection = null;
    }

    private synchronized void sendStringImpl(String string) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                this.outputStream.writeInt(byArray.length);
                this.outputStream.write(byArray);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized String receiveString() {
        String string = "";
        try {
            int n = this.inputStream.readInt();
            if (n != 0) {
                byte[] byArray = new byte[n];
                this.inputStream.readFully(byArray);
                string = new String(byArray, "UTF8");
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       \"" + string + "\"");
        }
        return string;
    }

    private synchronized void sendBytesImpl(byte[] byArray) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (byArray != null) {
                this.outputStream.writeInt(byArray.length);
                this.outputStream.write(byArray);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendBytes(byte[] byArray) {
        this.sendBytesImpl(byArray);
        this.flush();
    }

    private synchronized void sendByteImpl(int n) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeByte(n);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized int receiveByte() {
        int n = 0;
        try {
            n = this.inputStream.readUnsignedByte();
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + n);
        }
        return n;
    }

    synchronized byte[] receiveByteArray(int n) {
        byte[] byArray = null;
        try {
            byArray = new byte[n];
            if (n != 0) {
                this.inputStream.readFully(byArray);
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       byte[" + n + "]");
        }
        return byArray;
    }

    synchronized short[] receiveShortArray(int n) {
        short[] sArray = null;
        try {
            sArray = new short[n];
            int n2 = 0;
            while (n2 < n) {
                sArray[n2] = this.inputStream.readShort();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       short[" + n + "]");
        }
        return sArray;
    }

    synchronized int[] receiveIntArray(int n) {
        int[] nArray = null;
        try {
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.inputStream.readInt();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       int[" + n + "]");
        }
        return nArray;
    }

    private synchronized void sendPointerArrayImpl(long[] lArray) {
        if (this.outputStream == null) {
            return;
        }
        try {
            int n = lArray.length;
            this.outputStream.writeInt(n);
            if (this.pointerSize == 8) {
                int n2 = 0;
                while (n2 < n) {
                    this.outputStream.writeLong(lArray[n2]);
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    this.outputStream.writeInt((int)lArray[n3]);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized long[] receivePointerArray(int n) {
        long[] lArray = null;
        try {
            lArray = new long[n];
            if (this.pointerSize == 8) {
                int n2 = 0;
                while (n2 < n) {
                    lArray[n2] = this.inputStream.readLong();
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = this.inputStream.readInt();
                    lArray[n3] = n4 < 0 ? (long)n4 - -4294967296L : (long)n4;
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       pointer[" + n + "]");
        }
        return lArray;
    }

    synchronized long[] receiveLongArray(int n) {
        long[] lArray = null;
        try {
            lArray = new long[n];
            int n2 = 0;
            while (n2 < n) {
                lArray[n2] = this.inputStream.readLong();
                ++n2;
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       long[" + n + "]");
        }
        return lArray;
    }

    private synchronized void sendIntImpl(int n) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(n);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized int receiveInt() {
        int n = 0;
        try {
            n = this.inputStream.readInt();
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + n);
        }
        return n;
    }

    private synchronized void sendPointerImpl(long l) {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (this.pointerSize == 8) {
                this.outputStream.writeLong(l);
            } else {
                this.outputStream.writeInt((int)l);
            }
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendPointer(long l) {
        this.sendPointerImpl(l);
        this.flush();
    }

    synchronized long receivePointer() {
        long l = 0L;
        try {
            int n;
            l = this.pointerSize == 8 ? this.inputStream.readLong() : ((n = this.inputStream.readInt()) < 0 ? (long)n - -4294967296L : (long)n);
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       0x" + Long.toHexString(l));
        }
        return l;
    }

    synchronized short receiveShort() {
        short s = 0;
        try {
            s = this.inputStream.readShort();
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + s);
        }
        return s;
    }

    synchronized long receiveLong() {
        long l = 0L;
        try {
            l = this.inputStream.readLong();
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (this.df != null && this.df.logging) {
            this.df.log("r       " + l);
        }
        return l;
    }

    synchronized void flush() {
        try {
            this.outputStream.flush();
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    private void sendMessageByte(int n) {
        if (eventOn_OJVM_SEND_MESSAGE) {
            IdeProfile.pulseEvent((int)3799, (String)DebugFerrari.logStrings[n]);
        }
        this.sendByteImpl(n);
    }

    synchronized void sendMessage(int n) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 0) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n]);
            }
        }
        this.sendMessageByte(n);
        this.flush();
    }

    synchronized void sendMessage(int n, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65536) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 1) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2);
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.flush();
    }

    synchronized void sendMessage(int n, long l) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 256) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l));
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65537) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65792) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, byte[] byArray) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 131328) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       byte[" + byArray.length + "]");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendBytesImpl(byArray);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 3) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3);
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 258) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2);
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, long l2) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 768) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + Long.toHexString(l2));
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendPointerImpl(l2);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65539) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65794) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, long l2, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 66304) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + Long.toHexString(l2), "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendPointerImpl(l2);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 7) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4);
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2, int n3) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 262) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2, "s       " + n3);
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, long l2, int n2) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 772) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + Long.toHexString(l2), "s       " + n2);
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendPointerImpl(l2);
        this.sendIntImpl(n2);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65543) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, long l2, long l3, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 67328) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + Long.toHexString(l2), "s       " + Long.toHexString(l3), "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendPointerImpl(l2);
        this.sendPointerImpl(l3);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4, int n5) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 15) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4, "s       " + n5);
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendIntImpl(n5);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2, int n3, int n4) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 270) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2, "s       " + n3, "s       " + n4);
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4, int n5, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65551) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4, "s       " + n5, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendIntImpl(n5);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2, int n3, int n4, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65806) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2, "s       " + n3, "s       " + n4, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 31) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4, "s       " + n5, "s       " + n6);
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendIntImpl(n5);
        this.sendIntImpl(n6);
        this.flush();
    }

    synchronized void sendMessage(int n, long l, int n2, int n3, int n4, int n5) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 286) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + Long.toHexString(l), "s       " + n2, "s       " + n3, "s       " + n4, "s       " + n5);
            }
        }
        this.sendMessageByte(n);
        this.sendPointerImpl(l);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendIntImpl(n5);
        this.flush();
    }

    synchronized void sendMessage(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 65567) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       " + n2, "s       " + n3, "s       " + n4, "s       " + n5, "s       " + n6, "s       \"" + string + "\"");
            }
        }
        this.sendMessageByte(n);
        this.sendIntImpl(n2);
        this.sendIntImpl(n3);
        this.sendIntImpl(n4);
        this.sendIntImpl(n5);
        this.sendIntImpl(n6);
        this.sendStringImpl(string);
        this.flush();
    }

    synchronized void sendMessage(int n, long[] lArray) {
        if (this.df != null) {
            if (this.df.messageArguments(n) != 0x100000) {
                throw new IllegalArgumentException("Sending message 0x" + Integer.toHexString(n).toUpperCase() + " with incorrect arguments");
            }
            if (this.df.logging) {
                this.df.log("send    " + DebugFerrari.logStrings[n], "s       pointer[" + lArray.length + "]");
            }
        }
        this.sendMessageByte(n);
        this.sendPointerArrayImpl(lArray);
        this.flush();
    }

    synchronized void sendJBoolean(Boolean bl) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeBoolean(bl);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJChar(Character c) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeChar(c.charValue());
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJByte(Byte by) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeByte(by.byteValue());
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJShort(Short s) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeShort(s.shortValue());
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJInt(Integer n) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(n);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJLong(Long l) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeLong(l);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJFloat(Float f) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeFloat(f.floatValue());
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized void sendJDouble(Double d) {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeDouble(d);
        }
        catch (Exception exception) {
            this.disconnect();
        }
    }

    synchronized int receiveMessage() {
        int n = 0;
        try {
            n = this.inputStream.readUnsignedByte();
        }
        catch (Exception exception) {
            this.disconnect();
        }
        if (eventOn_OJVM_RECV_MESSAGE) {
            IdeProfile.pulseEvent((int)3798, (String)DebugFerrari.logStrings[n]);
        }
        if (this.df != null && this.df.logging) {
            this.df.log("recv    " + DebugFerrari.logStrings[n]);
        }
        return n;
    }
}

