/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;

final class DebugFerrariVariableInfo
implements DebugVariableInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariClassInfo clazz;
    long localDescPtr;
    String name;
    DebugFerrariDataInfo data;
    int varType;
    static final int VAR_TYPE_UNKNOWN = 0;
    static final int VAR_TYPE_ARGUMENT = 1;
    static final int VAR_TYPE_LOCAL = 2;
    static final int VAR_TYPE_RETURN = 3;
    static final int VAR_TYPE_RETURNED = 4;
    private int hashCode;

    DebugFerrariVariableInfo(DebugFerrari debugFerrari, DebugFerrariClassInfo debugFerrariClassInfo, long l, String string, DebugFerrariDataInfo debugFerrariDataInfo, int n) {
        this.df = debugFerrari;
        this.stoppedCount = debugFerrari.stoppedCount;
        this.clazz = debugFerrariClassInfo;
        this.localDescPtr = l;
        this.name = string;
        this.data = debugFerrariDataInfo;
        if (debugFerrariDataInfo != null) {
            debugFerrariDataInfo.setDeclaredClass(debugFerrariClassInfo);
        }
        this.varType = n;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public String getGenericSignature() {
        return this.df.getGenericSignature(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isInScope() {
        return this.data != null;
    }

    public boolean isArgument() {
        return this.varType == 1;
    }

    public boolean isLocal() {
        return this.varType == 2;
    }

    public boolean isReturn() {
        return this.varType == 3;
    }

    public boolean isReturned() {
        return this.varType == 4;
    }

    public DebugDataInfo getDataInfo() {
        return this.data;
    }

    public int getSlotSize() {
        if (this.clazz.isPrimitive()) {
            String string = this.clazz.getName();
            if (string.equals("long") || string.equals("double")) {
                return 2;
            }
            return 1;
        }
        return this.df.getPointerSlotSize();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.clazz.hashCode() + this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DebugFerrariVariableInfo) {
            DebugFerrariVariableInfo debugFerrariVariableInfo = (DebugFerrariVariableInfo)object;
            return this.clazz.equals(debugFerrariVariableInfo.clazz) && this.name.equals(debugFerrariVariableInfo.name);
        }
        return false;
    }
}

