/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.CharType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.IntegerType;
import com.sun.jdi.Location;
import com.sun.jdi.LongType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.OracleExtension;
import com.sun.jdi.OracleReferenceType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.awt.List;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.log.MessagePage;
import oracle.ide.util.VersionNumber;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManager;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnonymousBlockManagerFactory;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClass;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointClassLoad;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointDeadlock;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointException;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethod;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointWatchpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassLoaderInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataArrayInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataPrimitiveInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIMonitorInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIPinnedInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStoppedListener;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadGroupInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebugJDI
implements Runnable,
DebugCapabilities,
DebugVirtualMachine {
    private static DebugJDIAnonymousBlockManagerFactory anonymousBlockManagerFactory;
    private static DebugJDIAnonymousBlockManager anonymousBlockManager;
    VirtualMachine vm;
    private boolean vmWasRunning;
    private int languages;
    private java.util.List unhandledEventSets;
    private java.util.List unhandledEventThreads;
    private java.util.List needToResume;
    private EventQueue eq;
    EventRequestManager erm;
    private ClassUnloadRequest cur;
    private ClassPrepareRequest startCPR;
    private ThreadStartRequest startTSR;
    private Map startStepRequests;
    private Location stepLocation;
    private String[] stepStack;
    private StepRequest stepRequest;
    private boolean useMethodExitForStepToEndOfMethod;
    private MethodExitRequest methodExitRequest;
    private int runCommand;
    private ThreadReference runCommandThread;
    private Thread runningThread;
    private Thread testConnectionThread;
    private java.util.List breakpoints;
    private Set bpRequests;
    private Map cprsByFilter;
    private Map cprBreakpoints;
    private boolean redefineClassesOccurred;
    private java.util.List classes;
    Map classesByReferenceType;
    private Map classesByName;
    private Map classesByNameWithoutPackage;
    private Set classesCollected;
    private Set classesNotCollected;
    private Set objectsCollected;
    private Set objectsNotCollected;
    private boolean debuggableClassLoaded;
    private boolean lookForAnyUnloadedClassesNeeded;
    java.util.List debuggable;
    java.util.List nonDebuggable;
    Set nonDebuggableClassExclusionFilters;
    private Map otherWaitingThreads;
    Map threadInfos;
    int stoppedCountThreadContextClassLoaders;
    Map stackFrameInfos;
    Map classLoaderInfos;
    Map classLoaderIds;
    private ClassLoaderReference systemClassLoader;
    private DebugJDIBreakpoint currentBreakpoint;
    private DebugJDIThreadInfo currentThread;
    ThreadReference eventThread;
    private DebugJDIDataObjectInfo currentThrow;
    private DebugJDILocation currentThrowHandler;
    private DebugJDIDataObjectInfo watchpointObject;
    private DebugJDIFieldInfo watchpointField;
    private DebugJDIDataInfo watchpointFieldFutureValue;
    private java.util.List knownDeadlockedThreads;
    int stoppedCount;
    java.util.List stoppedListeners;
    private Object[] syncObjects;
    private boolean[] syncValues;
    private static final int SYNC_STOPPED = 0;
    private static final int SYNC_PAUSE_REQUESTED = 1;
    private static final int SYNC_TERMINATED = 2;
    private static final int SYNC_DISCONNECT_REQUESTED = 3;
    private static final int SYNC_TERMINATE_REQUESTED = 4;
    private static final int SYNC_CONNECTION_LOGS = 5;
    private static final int SYNC_CONNECTION_LOST = 6;
    private static final int SYNC_SYSTEM_CLASS_LOADER = 7;
    private static final int SYNC_COUNT = 8;
    private java.util.List pins;
    private MessagePage logPage;
    DebugListener debugListener;
    private DebugBreakpointLogListener bpLogListener;
    private java.util.List connectionLogs;
    private static int stdErrCount;
    private static PrintStream stdErr;
    private static Boolean isBeforeJDK142;
    boolean printedClassNotPreparedWarning;
    private static final Set plsqlJavaClasses;
    private Boolean isOracleDatabaseVM;
    private static final int RunCommand_StartInto = 0;
    private static final int RunCommand_StartOver = 1;
    private static final int RunCommand_Run = 2;
    private static final int RunCommand_StepInto = 3;
    private static final int RunCommand_StepOver = 4;
    private static final int RunCommand_StepIntoBC = 5;
    private static final int RunCommand_StepOverBC = 6;
    private static final int RunCommand_StepOut = 7;
    private static final int RunCommand_StepToEndOfMethod = 8;
    private static final int RunCommand_ContinueStep = 9;

    void $init$() {
        this.languages = 0;
        this.printedClassNotPreparedWarning = false;
    }

    static {
        plsqlJavaClasses = new HashSet();
        plsqlJavaClasses.add("java.lang.Class");
        plsqlJavaClasses.add("java.lang.ClassLoader");
        plsqlJavaClasses.add("java.lang.Exception");
        plsqlJavaClasses.add("java.lang.Object");
        plsqlJavaClasses.add("java.lang.String");
        plsqlJavaClasses.add("java.lang.Thread");
        plsqlJavaClasses.add("java.lang.ThreadGroup");
        plsqlJavaClasses.add("java.lang.Throwable");
    }

    DebugJDI(VirtualMachine virtualMachine) {
        VersionNumber versionNumber;
        this.$init$();
        this.initSync();
        this.unhandledEventSets = new ArrayList();
        this.unhandledEventThreads = new ArrayList();
        this.needToResume = new ArrayList();
        this.stoppedCount = 0;
        this.stoppedListeners = new ArrayList();
        this.breakpoints = new ArrayList();
        this.bpRequests = new HashSet();
        this.cprsByFilter = new HashMap();
        this.cprBreakpoints = new HashMap();
        this.classes = new ArrayList();
        this.classesByReferenceType = new HashMap();
        this.classesByName = new HashMap();
        this.classesByNameWithoutPackage = new HashMap();
        this.classesCollected = new HashSet();
        this.classesNotCollected = new HashSet();
        this.objectsCollected = new HashSet();
        this.objectsNotCollected = new HashSet();
        this.debuggable = new ArrayList();
        this.nonDebuggable = new ArrayList();
        this.nonDebuggableClassExclusionFilters = new HashSet();
        this.otherWaitingThreads = new HashMap();
        this.threadInfos = new HashMap();
        this.stackFrameInfos = new HashMap();
        this.classLoaderInfos = new HashMap();
        this.classLoaderIds = new HashMap();
        this.knownDeadlockedThreads = new ArrayList();
        this.pins = new ArrayList();
        this.vmWasRunning = false;
        this.vm = virtualMachine;
        try {
            String string = Ide.getProperty((String)"DebuggerConnectionLog");
            if (string != null) {
                if (string.equals("System.out")) {
                    this.addConnectionLog(System.out);
                } else if (string.equals("System.err")) {
                    this.addConnectionLog(System.err);
                } else if (string.equals("file")) {
                    this.addConnectionLog(File.createTempFile("jpda", null, new File(Ide.getBinDirectory())));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = virtualMachine.version();
        if (string != null && (versionNumber = new VersionNumber(string)).isAfter(new VersionNumber("1.4"), true)) {
            this.useMethodExitForStepToEndOfMethod = true;
        }
        this.eq = virtualMachine.eventQueue();
        this.lookForVMStartEvent();
        this.setSyncValue(0, true);
        this.erm = virtualMachine.eventRequestManager();
        this.cur = this.erm.createClassUnloadRequest();
        this.cur.setSuspendPolicy(2);
        this.cur.enable();
        this.addPrimitiveClasses();
        for (ReferenceType referenceType : virtualMachine.allClasses()) {
            this.addClassForReferenceType(referenceType, true);
        }
    }

    private void addPrimitiveClasses() {
        Type type = (ByteType)this.vm.mirrorOf((byte)0).type();
        if (type != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (CharType)this.vm.mirrorOf('\u0000').type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (DoubleType)this.vm.mirrorOf(0.0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (FloatType)this.vm.mirrorOf(0.0f).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (IntegerType)this.vm.mirrorOf(0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (LongType)this.vm.mirrorOf(0L).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (ShortType)this.vm.mirrorOf((short)0).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = (BooleanType)this.vm.mirrorOf(false).type()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
        if ((type = this.getVoidType()) != null) {
            this.addClass(new DebugJDIClassInfo(this, type));
        }
    }

    private VoidType getVoidType() {
        try {
            for (ReferenceType referenceType : this.vm.allClasses()) {
                if (!(referenceType instanceof ClassType)) continue;
                ClassType classType = (ClassType)referenceType;
                for (Method method : classType.methodsByName("notify")) {
                    Type type = method.returnType();
                    if (!(type instanceof VoidType)) continue;
                    VoidType voidType = (VoidType)type;
                    return voidType;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized void afterConnection(MessagePage messagePage) {
        if (this.vmWasRunning) {
            this.lookForAnyUnloadedClassesNeeded = true;
        }
        this.logPage = messagePage;
        if (messagePage != null) {
            int n = this.classes.size();
            String string = Integer.toString(n);
            messagePage.log((Object)DebugJDIArb.format(4, string));
        }
        this.preprocessClassLoaders();
        if (messagePage != null) {
            messagePage.log((Object)DebugJDIArb.getString(5));
        }
    }

    @Override
    public synchronized void addDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.add(this.debugListener, debugListener);
    }

    @Override
    public synchronized void removeDebugListener(DebugListener debugListener) {
        this.debugListener = DebugEventMulticaster.remove(this.debugListener, debugListener);
    }

    @Override
    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.add(this.bpLogListener, debugBreakpointLogListener);
    }

    @Override
    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener debugBreakpointLogListener) {
        this.bpLogListener = DebugEventMulticaster.remove(this.bpLogListener, debugBreakpointLogListener);
    }

    private void lookForVMStartEvent() {
        boolean bl = false;
        EventSet eventSet = null;
        try {
            eventSet = this.eq.remove(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (eventSet != null) {
            Event event;
            EventIterator eventIterator = eventSet.eventIterator();
            if (eventIterator.hasNext() && (event = eventIterator.nextEvent()) instanceof VMStartEvent && eventSet.suspendPolicy() == 2) {
                bl = true;
                this.needToResume.add(eventSet);
            }
            if (!bl) {
                eventSet.resume();
            }
        }
        if (!bl) {
            this.vm.suspend();
            this.needToResume.add(this.vm);
            this.vmWasRunning = true;
        }
    }

    private static synchronized boolean isBeforeJDK142() {
        VersionNumber versionNumber;
        if (isBeforeJDK142 != null) {
            return isBeforeJDK142;
        }
        String string = System.getProperty("java.version");
        if (string != null && (versionNumber = new VersionNumber(string = string.replace('_', '.'))).isBefore(new VersionNumber("1.4.2"))) {
            isBeforeJDK142 = Boolean.TRUE;
            return true;
        }
        isBeforeJDK142 = Boolean.FALSE;
        return false;
    }

    private boolean isClassPrepared(ReferenceType referenceType) {
        try {
            if (referenceType instanceof ArrayType) {
                boolean bl = true;
                return bl;
            }
            if (this.isOracleDatabaseVM()) {
                boolean bl = true;
                return bl;
            }
            if (DebugJDI.isBeforeJDK142()) {
                if (referenceType.isInitialized() || referenceType.isPrepared()) {
                    boolean bl = true;
                    return bl;
                }
            } else if (referenceType.isPrepared()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            boolean bl = true;
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            boolean bl = true;
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = true;
            return bl;
        }
        if (!this.printedClassNotPreparedWarning) {
            this.printedClassNotPreparedWarning = true;
        }
        return false;
    }

    private DebugJDIClassInfo addClassForReferenceType(ReferenceType referenceType, boolean bl) {
        if (bl && !this.isClassPrepared(referenceType)) {
            return null;
        }
        if (!this.classesByReferenceType.containsKey(referenceType)) {
            DebugJDIClassInfo debugJDIClassInfo = new DebugJDIClassInfo(this, referenceType);
            if (!this.debuggableClassLoaded && referenceType instanceof ClassType && debugJDIClassInfo.isDebuggable()) {
                this.debuggableClassLoaded = true;
            }
            this.addClass(debugJDIClassInfo);
            return debugJDIClassInfo;
        }
        return null;
    }

    private OracleReferenceType getOracleReferenceType(ReferenceType referenceType) {
        try {
            OracleReferenceType oracleReferenceType = OracleExtension.convert((ReferenceType)referenceType).sourcePrimaryReferenceType();
            return oracleReferenceType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addClass(DebugJDIClassInfo debugJDIClassInfo) {
        OracleReferenceType oracleReferenceType;
        if ((this.languages & 1) == 0 && debugJDIClassInfo.name.startsWith("java.") && !plsqlJavaClasses.contains(debugJDIClassInfo.name)) {
            this.languages |= 1;
        }
        if ((this.languages & 2) == 0 && (debugJDIClassInfo.name.startsWith("$Oracle.Package.") || debugJDIClassInfo.name.startsWith("$Oracle.PackageBody.") || debugJDIClassInfo.name.startsWith("$Oracle.Function.") || debugJDIClassInfo.name.startsWith("$Oracle.Procedure.") || debugJDIClassInfo.name.startsWith("$Oracle.Type.") || debugJDIClassInfo.name.startsWith("$Oracle.TypeBody.") || debugJDIClassInfo.name.startsWith("$Oracle.Trigger.") || debugJDIClassInfo.name.startsWith("$Oracle.Block."))) {
            this.languages |= 2;
        }
        if ((this.languages & 4) == 0 && debugJDIClassInfo.name.startsWith(XSLTRunnerAddin.getXSLTPackage() + ".")) {
            this.languages |= 4;
        }
        this.classes.add(debugJDIClassInfo);
        ReferenceType referenceType = debugJDIClassInfo.getReferenceType();
        if (referenceType != null) {
            this.classesByReferenceType.put(referenceType, debugJDIClassInfo);
        }
        DebugShared.putClass(this.classesByName, debugJDIClassInfo.name, debugJDIClassInfo);
        DebugShared.putClass(this.classesByNameWithoutPackage, debugJDIClassInfo.getNameWithoutPackage(), debugJDIClassInfo);
        if (debugJDIClassInfo.name.startsWith("$Oracle.Block.") && (oracleReferenceType = this.getOracleReferenceType(referenceType)) != null) {
            DebugJDI.makeAnonymousBlockManager();
            if (anonymousBlockManager != null) {
                anonymousBlockManager.add(debugJDIClassInfo, oracleReferenceType);
            }
        }
        if (referenceType instanceof ClassType) {
            this.verifyBreakpoints(referenceType);
        }
    }

    private void removeClass(DebugJDIClassInfo debugJDIClassInfo) {
        debugJDIClassInfo.rtCollected = true;
        this.classes.remove(debugJDIClassInfo);
        this.classesByReferenceType.remove(debugJDIClassInfo.getReferenceType());
        DebugShared.removeClass(this.classesByName, debugJDIClassInfo.name, debugJDIClassInfo);
        DebugShared.removeClass(this.classesByNameWithoutPackage, debugJDIClassInfo.getNameWithoutPackage(), debugJDIClassInfo);
        if (anonymousBlockManager != null) {
            anonymousBlockManager.remove(debugJDIClassInfo);
        }
    }

    @Override
    public boolean wasRunning() {
        return this.vmWasRunning;
    }

    @Override
    public synchronized void disconnect() {
        this.disconnect(this.vmWasRunning ^ true);
    }

    @Override
    public synchronized void disconnect(boolean bl) {
        if (this.vm != null && !this.getSyncValue(2)) {
            this.setSyncValue(4, bl);
            this.setSyncValue(3, true);
            try {
                if (bl) {
                    this.pins.clear();
                    this.vm.exit(0);
                } else {
                    this.unpinAll();
                }
                this.vm.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incrementStoppedCount(false);
            if (!this.isRunning()) {
                this.vm = null;
                this.cleanUp();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.vm != null;
    }

    @Override
    public boolean isStopped() {
        return this.getSyncValue(0);
    }

    @Override
    public boolean isRunning() {
        return this.runningThread != null;
    }

    @Override
    public boolean isTerminated() {
        return this.getSyncValue(2);
    }

    private void parsePackages(String string, java.util.List list) {
        list.clear();
        while (string != null) {
            String string2;
            int n = string.indexOf(59);
            if (n == -1) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            if (string2.length() <= 0) continue;
            list.add(string2);
        }
    }

    @Override
    public synchronized void setNonDebuggablePackages(String string) {
        this.setDebuggablePackages(null, string);
    }

    @Override
    public synchronized void setDebuggablePackages(String string, String string2) {
        this.parsePackages(string, this.debuggable);
        this.parsePackages(string2, this.nonDebuggable);
        this.nonDebuggableClassExclusionFilters.clear();
        this.debuggableClassLoaded = false;
        int n = this.classes.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n2);
            try {
                debugJDIClassInfo.checkDebuggable();
                if (!this.debuggableClassLoaded && debugJDIClassInfo.type instanceof ClassType && debugJDIClassInfo.isDebuggable()) {
                    this.debuggableClassLoaded = true;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    @Override
    public void requestCodeCoverage(String string, String string2) {
    }

    @Override
    public void unrequestCodeCoverage(String string, String string2) {
    }

    @Override
    public void discardCodeCoverage() {
    }

    @Override
    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String string, String string2, int n) {
        DebugJDIBreakpointPackageFileLine debugJDIBreakpointPackageFileLine = new DebugJDIBreakpointPackageFileLine(this, string, string2, n);
        this.putBreakpoint(debugJDIBreakpointPackageFileLine);
        return debugJDIBreakpointPackageFileLine;
    }

    @Override
    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String string, int n) {
        DebugJDIBreakpointFileLine debugJDIBreakpointFileLine = new DebugJDIBreakpointFileLine(this, string, n);
        this.putBreakpoint(debugJDIBreakpointFileLine);
        return debugJDIBreakpointFileLine;
    }

    @Override
    public synchronized DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String string, int n) {
        DebugJDIBreakpointMethodBytecode debugJDIBreakpointMethodBytecode = new DebugJDIBreakpointMethodBytecode(this, string, n);
        this.putBreakpoint(debugJDIBreakpointMethodBytecode);
        return debugJDIBreakpointMethodBytecode;
    }

    @Override
    public synchronized DebugBreakpointMethod putBreakpointMethod(String string) {
        DebugJDIBreakpointMethod debugJDIBreakpointMethod = new DebugJDIBreakpointMethod(this, string);
        this.putBreakpoint(debugJDIBreakpointMethod);
        return debugJDIBreakpointMethod;
    }

    @Override
    public synchronized DebugBreakpointClass putBreakpointClass(String string) {
        DebugJDIBreakpointClass debugJDIBreakpointClass = new DebugJDIBreakpointClass(this, string);
        this.putBreakpoint(debugJDIBreakpointClass);
        return debugJDIBreakpointClass;
    }

    @Override
    public synchronized DebugBreakpointException putBreakpointException(String string) {
        return this.putBreakpointException(string, true, true);
    }

    @Override
    public synchronized DebugBreakpointException putBreakpointException(String string, boolean bl, boolean bl2) {
        DebugJDIBreakpointException debugJDIBreakpointException = new DebugJDIBreakpointException(this, string, bl, bl2);
        this.putBreakpoint(debugJDIBreakpointException);
        return debugJDIBreakpointException;
    }

    @Override
    public synchronized DebugBreakpointClassLoad putBreakpointClassLoad(String string) {
        DebugJDIBreakpointClassLoad debugJDIBreakpointClassLoad = new DebugJDIBreakpointClassLoad(this, string);
        this.putBreakpoint(debugJDIBreakpointClassLoad);
        return debugJDIBreakpointClassLoad;
    }

    @Override
    public synchronized DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int n) {
        return null;
    }

    @Override
    public synchronized DebugBreakpointAllocationClass putBreakpointAllocationClass(String string) {
        return null;
    }

    @Override
    public synchronized DebugBreakpointDeadlock putBreakpointDeadlock() {
        if (this.canPutBreakpointDeadlock()) {
            DebugJDIBreakpointDeadlock debugJDIBreakpointDeadlock = new DebugJDIBreakpointDeadlock(this);
            this.putBreakpoint(debugJDIBreakpointDeadlock);
            return debugJDIBreakpointDeadlock;
        }
        return null;
    }

    @Override
    public synchronized DebugBreakpointWatchpoint putBreakpointWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        if (bl ? (bl2 ? !this.vm.canWatchFieldAccess() && !this.vm.canWatchFieldModification() : !this.vm.canWatchFieldAccess()) : bl2 && !this.vm.canWatchFieldModification()) {
            return null;
        }
        DebugJDIBreakpointWatchpoint debugJDIBreakpointWatchpoint = new DebugJDIBreakpointWatchpoint(this, string, string2, bl, bl2);
        this.putBreakpoint(debugJDIBreakpointWatchpoint);
        return debugJDIBreakpointWatchpoint;
    }

    @Override
    public synchronized void removeAllBreakpoints() {
        int n = this.breakpoints.size() - 1;
        while (n >= 0) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n);
            debugJDIBreakpoint.prepareForChange();
            --n;
        }
        this.breakpoints.clear();
    }

    @Override
    public synchronized void resume() {
        this.doRunCommand(2, null);
    }

    @Override
    public synchronized boolean didStepFinish() {
        return this.startCPR == null && this.startTSR == null && this.stepRequest == null && this.methodExitRequest == null;
    }

    @Override
    public synchronized void continueStep() {
        this.doRunCommand(9, null);
    }

    @Override
    public synchronized void start(boolean bl) {
        int n = bl ? 1 : 0;
        this.doRunCommand(n, null);
    }

    @Override
    public synchronized void setPauseInterval(int n) {
    }

    @Override
    public synchronized void pauseProgram() {
        this.setSyncValue(1, true);
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    @Override
    public void cancelPauseProgram() {
        this.setSyncValue(1, false);
    }

    @Override
    public synchronized int getCurrentStatus() {
        if (this.isStopped()) {
            DebugBreakpoint debugBreakpoint = this.getCurrentBreakpoint();
            if (debugBreakpoint != null) {
                if (debugBreakpoint instanceof DebugBreakpointPackageFileLine || debugBreakpoint instanceof DebugBreakpointFileLine || debugBreakpoint instanceof DebugBreakpointMethodBytecode || debugBreakpoint instanceof DebugBreakpointMethod || debugBreakpoint instanceof DebugBreakpointClass) {
                    return 1;
                }
                if (debugBreakpoint instanceof DebugBreakpointException) {
                    return 2;
                }
                if (debugBreakpoint instanceof DebugBreakpointClassLoad) {
                    return 3;
                }
                if (debugBreakpoint instanceof DebugBreakpointAllocationClass || debugBreakpoint instanceof DebugBreakpointAllocationThreshold) {
                    return 4;
                }
                if (debugBreakpoint instanceof DebugBreakpointDeadlock) {
                    return 5;
                }
                if (debugBreakpoint instanceof DebugBreakpointWatchpoint) {
                    return 10;
                }
            } else {
                if (this.getCurrentThread() == null) {
                    return 8;
                }
                if (this.getCurrentThrow() != null && this.getCurrentThrowHandler() == null) {
                    return 6;
                }
                return 7;
            }
        }
        return 0;
    }

    @Override
    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        return this.currentBreakpoint;
    }

    @Override
    public synchronized DebugThreadInfo getCurrentThread() {
        return this.currentThread;
    }

    @Override
    public synchronized DebugDataObjectInfo getCurrentThrow() {
        return this.currentThrow;
    }

    @Override
    public synchronized boolean isCurrentThrowHandled() {
        return this.currentThrowHandler != null;
    }

    @Override
    public synchronized DebugLocation getCurrentThrowHandler() {
        return this.currentThrowHandler;
    }

    @Override
    public DebugDataObjectInfo getWatchpointObject() {
        return this.watchpointObject;
    }

    @Override
    public DebugFieldInfo getWatchpointField() {
        return this.watchpointField;
    }

    @Override
    public DebugDataInfo getWatchpointFieldFutureValue() {
        return this.watchpointFieldFutureValue;
    }

    @Override
    public synchronized DebugThreadInfo[][] getDeadlockedThreads() {
        if (this.canGetMonitors()) {
            return DebugShared.getDeadlockedThreads(this);
        }
        return new DebugThreadInfo[0][];
    }

    @Override
    public synchronized DebugThreadGroupInfo[] listTopThreadGroups() {
        ArrayList<DebugJDIThreadGroupInfo> arrayList = new ArrayList<DebugJDIThreadGroupInfo>();
        Iterator<ThreadGroupReference> iterator = this.vm.topLevelThreadGroups().iterator();
        while (iterator.hasNext()) {
            arrayList.add(new DebugJDIThreadGroupInfo(this, iterator.next()));
        }
        return arrayList.toArray(new DebugThreadGroupInfo[arrayList.size()]);
    }

    @Override
    public synchronized DebugThreadGroupInfo[] listAllThreadGroups() {
        HashSet hashSet = new HashSet();
        this.recursiveAddThreadGroups(hashSet, this.vm.topLevelThreadGroups().iterator());
        return hashSet.toArray(new DebugThreadGroupInfo[hashSet.size()]);
    }

    private void recursiveAddThreadGroups(Set set, Iterator iterator) {
        while (iterator.hasNext()) {
            ThreadGroupReference threadGroupReference = (ThreadGroupReference)iterator.next();
            DebugJDIThreadGroupInfo debugJDIThreadGroupInfo = new DebugJDIThreadGroupInfo(this, threadGroupReference);
            if (!set.add(debugJDIThreadGroupInfo)) continue;
            this.recursiveAddThreadGroups(set, threadGroupReference.threadGroups().iterator());
        }
    }

    @Override
    public synchronized DebugThreadInfo[] listThreads() {
        java.util.List list = this.allThreads();
        int n = list.size();
        DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[n];
        int n2 = 0;
        while (n2 < n) {
            debugThreadInfoArray[n2] = DebugJDIThreadInfo.makeThreadInfo(this, (ThreadReference)list.get(n2));
            ++n2;
        }
        return debugThreadInfoArray;
    }

    private java.util.List allThreads() {
        ArrayList arrayList = new ArrayList();
        Iterator<ThreadGroupReference> iterator = this.vm.topLevelThreadGroups().iterator();
        while (iterator.hasNext()) {
            DebugJDI.recursiveAddThreads(iterator.next(), arrayList);
        }
        return arrayList;
    }

    private static void recursiveAddThreads(ThreadGroupReference threadGroupReference, java.util.List list) {
        list.addAll(threadGroupReference.threads());
        java.util.List<ThreadGroupReference> list2 = threadGroupReference.threadGroups();
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDI.recursiveAddThreads(list2.get(n2), list);
            ++n2;
        }
    }

    ObjectReference getWaitMonitor(ThreadReference threadReference) {
        try {
            if (threadReference.status() == 4) {
                ObjectReference objectReference = threadReference.currentContendedMonitor();
                if (objectReference == null) {
                    int n = threadReference.frameCount();
                    int n2 = 0;
                    while (n2 < n && n2 < 2) {
                        Method method;
                        ReferenceType referenceType;
                        Location location;
                        StackFrame stackFrame = threadReference.frame(n2);
                        if (stackFrame != null && (location = stackFrame.location()) != null && (referenceType = location.declaringType()) != null && referenceType.name().equals("java.lang.Object") && (method = location.method()) != null && method.name().equals("wait") && (objectReference = stackFrame.thisObject()) != null) {
                            ArrayList<ThreadReference> arrayList = (ArrayList<ThreadReference>)this.otherWaitingThreads.get(objectReference);
                            if (arrayList == null) {
                                arrayList = new ArrayList<ThreadReference>();
                                this.otherWaitingThreads.put(objectReference, arrayList);
                            }
                            arrayList.add(threadReference);
                            break;
                        }
                        ++n2;
                    }
                }
                ObjectReference objectReference2 = objectReference;
                return objectReference2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    java.util.List getOtherWaitingThreads(ObjectReference objectReference) {
        return (java.util.List)this.otherWaitingThreads.get(objectReference);
    }

    @Override
    public synchronized DebugMonitorInfo[] listMonitorsInUse() {
        if (this.canGetMonitors()) {
            HashSet<ObjectReference> hashSet = new HashSet<ObjectReference>();
            java.util.List list = this.allThreads();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ThreadReference threadReference = (ThreadReference)list.get(n2);
                try {
                    switch (threadReference.status()) {
                        case 3: {
                            ObjectReference objectReference = threadReference.currentContendedMonitor();
                            if (objectReference == null) break;
                            hashSet.add(objectReference);
                            break;
                        }
                        case 4: {
                            ObjectReference objectReference = this.getWaitMonitor(threadReference);
                            if (objectReference == null) break;
                            hashSet.add(objectReference);
                        }
                    }
                    java.util.List<ObjectReference> list2 = threadReference.ownedMonitors();
                    int n3 = list2.size();
                    int n4 = 0;
                    while (n4 < n3) {
                        ObjectReference objectReference = list2.get(n4);
                        if (objectReference != null) {
                            hashSet.add(objectReference);
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            int n5 = hashSet.size();
            ObjectReference[] objectReferenceArray = hashSet.toArray(new ObjectReference[n5]);
            DebugMonitorInfo[] debugMonitorInfoArray = new DebugMonitorInfo[n5];
            int n6 = 0;
            while (n6 < n5) {
                debugMonitorInfoArray[n6] = new DebugJDIMonitorInfo(this, objectReferenceArray[n6]);
                ++n6;
            }
            return debugMonitorInfoArray;
        }
        return new DebugMonitorInfo[0];
    }

    @Override
    public synchronized DebugThreadInfo[] listWaitingThreads() {
        if (this.canGetMonitors()) {
            java.util.List list = this.allThreads();
            ArrayList<DebugJDIThreadInfo> arrayList = new ArrayList<DebugJDIThreadInfo>();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ThreadReference threadReference = (ThreadReference)list.get(n2);
                try {
                    if (threadReference.status() == 4) {
                        arrayList.add(DebugJDIThreadInfo.makeThreadInfo(this, threadReference));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[arrayList.size()];
            return arrayList.toArray(debugThreadInfoArray);
        }
        return new DebugThreadInfo[0];
    }

    @Override
    public synchronized DebugThreadInfo[] listBlockedThreads() {
        if (this.canGetMonitors()) {
            java.util.List list = this.allThreads();
            ArrayList<DebugJDIThreadInfo> arrayList = new ArrayList<DebugJDIThreadInfo>();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ThreadReference threadReference = (ThreadReference)list.get(n2);
                try {
                    if (threadReference.status() == 3) {
                        arrayList.add(DebugJDIThreadInfo.makeThreadInfo(this, threadReference));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            DebugThreadInfo[] debugThreadInfoArray = new DebugThreadInfo[arrayList.size()];
            return arrayList.toArray(debugThreadInfoArray);
        }
        return new DebugThreadInfo[0];
    }

    private void lookForMissedClasses() {
        boolean bl = this.startTestConnectionThread("lookForMissedClasses");
        try {
            for (ReferenceType referenceType : this.vm.allClasses()) {
                if (this.classesByReferenceType.containsKey(referenceType) || this.classesCollected.contains(referenceType)) continue;
                this.addClassForReferenceType(referenceType, true);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.killTestConnectionThread();
        }
    }

    private synchronized void lookForUnloadedClassesByName(String string) {
        ArrayList<DebugJDIClassInfo> arrayList = new ArrayList<DebugJDIClassInfo>();
        int n = this.classes.size() - 1;
        while (n >= 0) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n);
            if (string.equals(debugJDIClassInfo.name)) {
                this.classesNotCollected.remove(debugJDIClassInfo.getReferenceType());
                arrayList.add(debugJDIClassInfo);
            }
            --n;
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)arrayList.get(n2);
            if (this.isClassCollected(debugJDIClassInfo.getReferenceType())) {
                this.removeClass(debugJDIClassInfo);
            }
            --n2;
        }
        java.util.List<ReferenceType> list = this.vm.allClasses();
        for (ReferenceType referenceType : list) {
            if (this.classesByReferenceType.containsKey(referenceType) || this.classesCollected.contains(referenceType)) continue;
            this.isClassCollected(referenceType);
        }
    }

    private synchronized void lookForAnyUnloadedClasses() {
        if (!this.lookForAnyUnloadedClassesNeeded) {
            return;
        }
        if (this.logPage != null) {
            this.logPage.log((Object)DebugJDIArb.getString(0));
        }
        DebugJDIClassInfo[] debugJDIClassInfoArray = this.classes.toArray(new DebugJDIClassInfo[this.classes.size()]);
        int n = debugJDIClassInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DebugJDIClassInfo debugJDIClassInfo = debugJDIClassInfoArray[n2];
            if (this.isClassCollected(debugJDIClassInfo.getReferenceType())) {
                this.removeClass(debugJDIClassInfo);
            }
            ++n2;
        }
        if (this.logPage != null) {
            this.logPage.log((Object)DebugJDIArb.getString(1));
        }
        if (this.cur != null) {
            this.lookForAnyUnloadedClassesNeeded = false;
        }
    }

    boolean isClassCollected(ReferenceType referenceType) {
        if (referenceType == null) {
            return false;
        }
        if (this.classesCollected.contains(referenceType)) {
            return true;
        }
        if (this.classesNotCollected.contains(referenceType)) {
            return false;
        }
        boolean bl = false;
        try {
            ClassObjectReference classObjectReference = referenceType.classObject();
            bl = this.isObjectCollected(classObjectReference);
        }
        catch (ObjectCollectedException objectCollectedException) {
            bl = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            boolean bl2 = false;
            return bl2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.classesCollected.add(referenceType);
        } else {
            this.classesNotCollected.add(referenceType);
        }
        return bl;
    }

    boolean isObjectCollected(ObjectReference objectReference) {
        if (this.objectsCollected.contains(objectReference)) {
            return true;
        }
        if (this.objectsNotCollected.contains(objectReference)) {
            return false;
        }
        boolean bl = false;
        try {
            bl = objectReference.isCollected();
        }
        catch (ObjectCollectedException objectCollectedException) {
            bl = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.objectsCollected.add(objectReference);
        } else {
            this.objectsNotCollected.add(objectReference);
        }
        return bl;
    }

    @Override
    public synchronized DebugClassInfo[] listClasses() {
        return this.listClasses(false);
    }

    @Override
    public DebugClassInfo[] listClasses(boolean bl) {
        if (!bl) {
            this.lookForAnyUnloadedClasses();
        }
        this.lookForMissedClasses();
        return this.classes.toArray(new DebugClassInfo[this.classes.size()]);
    }

    @Override
    public synchronized int countClasses() {
        this.lookForAnyUnloadedClasses();
        this.lookForMissedClasses();
        return this.classes.size();
    }

    @Override
    public DebugClassInfo findFirstClassByName(String string) {
        return this.findFirstClassByName(string, false);
    }

    @Override
    public DebugClassInfo findFirstClassByName(String string, boolean bl) {
        DebugJDIClassInfo debugJDIClassInfo;
        while ((debugJDIClassInfo = (DebugJDIClassInfo)DebugShared.getFirstClass(bl ? this.classesByNameWithoutPackage : this.classesByName, string)) != null && this.isClassCollected(debugJDIClassInfo.getReferenceType())) {
            this.removeClass(debugJDIClassInfo);
        }
        return debugJDIClassInfo;
    }

    private void preprocessClassLoaders() {
        int n = 0;
        while (n < this.classes.size()) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n);
            debugJDIClassInfo.getClassLoaderReference();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugClassLoaderInfo[] listClassLoaders() {
        int n = 0;
        while (n < this.classesByReferenceType.size()) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n);
            debugJDIClassInfo.getClassLoader();
            ++n;
        }
        DebugJDIThreadInfo.getThreadContextClassLoaders(this);
        ArrayList arrayList = new ArrayList();
        ArrayList<DebugJDIClassLoaderInfo> arrayList2 = new ArrayList<DebugJDIClassLoaderInfo>();
        Map map = this.classLoaderInfos;
        synchronized (map) {
            for (Map.Entry entry : this.classLoaderInfos.entrySet()) {
                Object k = entry.getKey();
                DebugJDIClassLoaderInfo debugJDIClassLoaderInfo = (DebugJDIClassLoaderInfo)entry.getValue();
                if (debugJDIClassLoaderInfo.hasExpired()) {
                    arrayList.add(k);
                    continue;
                }
                arrayList2.add(debugJDIClassLoaderInfo);
            }
            for (Object e : arrayList) {
                this.classLoaderInfos.remove(e);
            }
        }
        return arrayList2.toArray(new DebugClassLoaderInfo[arrayList2.size()]);
    }

    @Override
    public synchronized int countHeap(DebugHeapSubset debugHeapSubset) {
        return 0;
    }

    @Override
    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset) {
        return null;
    }

    @Override
    public int getSizeOfAddress() {
        return 0;
    }

    @Override
    public synchronized DebugHeapInfo getHeap(DebugHeapSubset debugHeapSubset, int n) {
        return null;
    }

    @Override
    public synchronized boolean isHeapAddressValid(long l) {
        return false;
    }

    @Override
    public synchronized DebugHeapObjectInfo getHeapObjectAtAddress(long l) {
        return null;
    }

    @Override
    public synchronized void doGarbageCollection() {
    }

    @Override
    public DebugCapabilities getCapabilities() {
        return this;
    }

    @Override
    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointMethodBytecode() {
        return true;
    }

    @Override
    public boolean canPutBreakpointMethod() {
        return true;
    }

    @Override
    public boolean canPutBreakpointClass() {
        return true;
    }

    @Override
    public boolean canPutBreakpointException() {
        return true;
    }

    @Override
    public boolean canPutBreakpointClassLoad() {
        return true;
    }

    @Override
    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    @Override
    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    @Override
    public synchronized boolean canPutBreakpointDeadlock() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    @Override
    public boolean canPutBreakpointWatchpoint() {
        if (this.vm != null) {
            return this.vm.canWatchFieldAccess() || this.vm.canWatchFieldModification();
        }
        return false;
    }

    @Override
    public boolean canSetDebuggablePackages() {
        return true;
    }

    @Override
    public boolean canPauseProgram() {
        return true;
    }

    @Override
    public boolean canRedefineClasses() {
        if (this.vm != null) {
            return this.vm.canRedefineClasses();
        }
        return false;
    }

    @Override
    public boolean canCountObjectsOfClass() {
        return false;
    }

    @Override
    public boolean canCountMemoryOfClass() {
        return false;
    }

    @Override
    public boolean canSetDebuggableClass() {
        return true;
    }

    @Override
    public boolean canGetHeap() {
        return false;
    }

    @Override
    public boolean canDoGarbageCollection() {
        return false;
    }

    @Override
    public boolean canDoCodeCoverage() {
        return false;
    }

    @Override
    public synchronized boolean canDisassembleMethod() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    @Override
    public synchronized boolean canGetBytecodes() {
        if (this.vm != null) {
            return this.vm.canGetBytecodes();
        }
        return false;
    }

    @Override
    public boolean canInvokeMethod() {
        return true;
    }

    @Override
    public synchronized boolean canGetMonitors() {
        if (this.vm != null) {
            return this.vm.canGetCurrentContendedMonitor() && this.vm.canGetMonitorInfo() && this.vm.canGetOwnedMonitorInfo();
        }
        return false;
    }

    @Override
    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    @Override
    public boolean canListSlots() {
        return false;
    }

    @Override
    public boolean canPopFrames() {
        if (this.vm != null) {
            return this.vm.canPopFrames();
        }
        return false;
    }

    @Override
    public boolean canSuspendThread() {
        return true;
    }

    @Override
    public boolean canResumeThread() {
        return true;
    }

    @Override
    public boolean canListRegisters() {
        return false;
    }

    @Override
    public boolean canListFloatRegisters() {
        return false;
    }

    @Override
    public synchronized boolean canStepToEndOfMethod() {
        return this.useMethodExitForStepToEndOfMethod;
    }

    @Override
    public boolean canContinueStep() {
        return true;
    }

    @Override
    public boolean canGetReturnValue() {
        return false;
    }

    @Override
    public boolean canGetReturnedValue() {
        return false;
    }

    @Override
    public boolean canSetLocation() {
        return false;
    }

    @Override
    public boolean canPin() {
        return true;
    }

    @Override
    public boolean canGetAddresses() {
        return false;
    }

    @Override
    public boolean canGetUniqueIDs() {
        return true;
    }

    synchronized void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException("Program Is Running");
        }
    }

    synchronized DebugJDIClassInfo findClass(ReferenceType referenceType) {
        if (referenceType == null) {
            return null;
        }
        if (this.isClassCollected(referenceType)) {
            return null;
        }
        DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classesByReferenceType.get(referenceType);
        if (debugJDIClassInfo != null) {
            return debugJDIClassInfo;
        }
        for (ReferenceType referenceType2 : this.vm.allClasses()) {
            if (!referenceType2.equals(referenceType)) continue;
            debugJDIClassInfo = this.addClassForReferenceType(referenceType2, true);
            return debugJDIClassInfo;
        }
        return null;
    }

    synchronized DebugJDIClassInfo findClassByType(Type type) {
        if (type instanceof ReferenceType) {
            return this.findClass((ReferenceType)type);
        }
        int n = this.classes.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n2);
            if (debugJDIClassInfo.type != null && debugJDIClassInfo.type.equals(type)) {
                return debugJDIClassInfo;
            }
            ++n2;
        }
        return null;
    }

    synchronized DebugJDIClassInfo findClassByName(String string, boolean bl) {
        DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)DebugShared.getFirstClass(this.classesByName, string);
        if (debugJDIClassInfo == null && bl) {
            debugJDIClassInfo = new DebugJDIClassInfo(string);
        }
        return debugJDIClassInfo;
    }

    synchronized DebugJDIDataInfo makeNullData(DebugJDIClassInfo debugJDIClassInfo, Object object) {
        if (debugJDIClassInfo.isArray()) {
            return new DebugJDIDataArrayInfo(this, debugJDIClassInfo, null, object);
        }
        return new DebugJDIDataObjectInfo(this, debugJDIClassInfo, null, object);
    }

    synchronized DebugJDIDataInfo makeData(Value value, Object object) {
        DebugJDIClassInfo debugJDIClassInfo = this.findClassByType(value.type());
        if (value instanceof PrimitiveValue) {
            return new DebugJDIDataPrimitiveInfo(this, debugJDIClassInfo, value, object);
        }
        if (value instanceof ArrayReference) {
            return new DebugJDIDataArrayInfo(this, debugJDIClassInfo, value, object);
        }
        if (value instanceof ObjectReference) {
            return new DebugJDIDataObjectInfo(this, debugJDIClassInfo, value, object);
        }
        return null;
    }

    Value makeValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DebugJDIDataInfo) {
            return ((DebugJDIDataInfo)object).value;
        }
        if (object instanceof Boolean) {
            return this.vm.mirrorOf((Boolean)object);
        }
        if (object instanceof Byte) {
            return this.vm.mirrorOf((Byte)object);
        }
        if (object instanceof Character) {
            return this.vm.mirrorOf(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return this.vm.mirrorOf((Double)object);
        }
        if (object instanceof Float) {
            return this.vm.mirrorOf(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return this.vm.mirrorOf((Integer)object);
        }
        if (object instanceof Long) {
            return this.vm.mirrorOf((Long)object);
        }
        if (object instanceof Short) {
            return this.vm.mirrorOf((Short)object);
        }
        if (object instanceof String) {
            return this.vm.mirrorOf((String)object);
        }
        throw new IllegalArgumentException("Invalid newValue argument");
    }

    Value makeBooleanValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.booleanDecode(string));
    }

    Value makeByteValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.byteDecode(string));
    }

    Value makeCharValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.charDecode(string));
    }

    Value makeDoubleValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.doubleDecode(string));
    }

    Value makeFloatValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.floatDecode(string));
    }

    Value makeIntegerValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.intDecode(string));
    }

    Value makeLongValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.longDecode(string));
    }

    Value makeShortValue(String string) {
        return this.vm.mirrorOf(DebugSharedPrimitives.shortDecode(string));
    }

    StringReference makeStringValue(String string) {
        return this.vm.mirrorOf(string);
    }

    java.util.List<Value> makeArgumentsFromStrings(Method method, String[] stringArray) {
        ArrayList<Value> arrayList = null;
        try {
            int n = stringArray.length;
            java.util.List<Type> list = method.argumentTypes();
            if (list.size() != n) {
                java.util.List<Value> list2 = null;
                return list2;
            }
            arrayList = new ArrayList<Value>();
            int n2 = 0;
            while (n2 < n) {
                Type type = list.get(n2);
                Value value = null;
                if (type instanceof BooleanType) {
                    value = this.makeBooleanValue(stringArray[n2]);
                } else if (type instanceof ByteType) {
                    value = this.makeByteValue(stringArray[n2]);
                } else if (type instanceof CharType) {
                    value = this.makeCharValue(stringArray[n2]);
                } else if (type instanceof DoubleType) {
                    value = this.makeDoubleValue(stringArray[n2]);
                } else if (type instanceof FloatType) {
                    value = this.makeFloatValue(stringArray[n2]);
                } else if (type instanceof IntegerType) {
                    value = this.makeIntegerValue(stringArray[n2]);
                } else if (type instanceof LongType) {
                    value = this.makeLongValue(stringArray[n2]);
                } else if (type instanceof ShortType) {
                    value = this.makeShortValue(stringArray[n2]);
                } else if (type instanceof ClassType && ((ClassType)type).name().equals("java.lang.String")) {
                    value = this.makeStringValue(stringArray[n2]);
                }
                if (value == null) {
                    java.util.List<Value> list3 = null;
                    return list3;
                }
                arrayList.add(value);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    synchronized DebugPinnedInfo pinObject(ObjectReference objectReference, DebugPinListener debugPinListener) {
        DebugJDIPinnedInfo debugJDIPinnedInfo = new DebugJDIPinnedInfo(this, objectReference, debugPinListener);
        this.pins.add(debugJDIPinnedInfo);
        return debugJDIPinnedInfo;
    }

    synchronized void unpinObject(DebugJDIPinnedInfo debugJDIPinnedInfo) {
        if (this.pins != null) {
            this.pins.remove(debugJDIPinnedInfo);
        }
    }

    private void unpinAll() {
        int n = this.pins.size() - 1;
        while (n >= 0) {
            DebugJDIPinnedInfo debugJDIPinnedInfo = (DebugJDIPinnedInfo)this.pins.get(n);
            this.unpinObject(debugJDIPinnedInfo);
            --n;
        }
    }

    private synchronized void checkPinnedObjects() {
        ArrayList<DebugJDIPinnedInfo> arrayList = new ArrayList<DebugJDIPinnedInfo>();
        int n = this.pins.size() - 1;
        while (n >= 0) {
            DebugJDIPinnedInfo debugJDIPinnedInfo = (DebugJDIPinnedInfo)this.pins.get(n);
            if (this.isObjectCollected(debugJDIPinnedInfo.or)) {
                debugJDIPinnedInfo.discarded = true;
                arrayList.add(debugJDIPinnedInfo);
            }
            --n;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            DebugJDIPinnedInfo debugJDIPinnedInfo = (DebugJDIPinnedInfo)arrayList.get(n2);
            this.pins.remove(debugJDIPinnedInfo);
            debugJDIPinnedInfo.pinListener.pinnedObjectDiscarded(this, debugJDIPinnedInfo);
            ++n2;
        }
    }

    synchronized void putBreakpoint(DebugJDIBreakpoint debugJDIBreakpoint) {
        this.breakpoints.add(debugJDIBreakpoint);
        debugJDIBreakpoint.afterChange();
    }

    private boolean isOracleDatabaseVM() {
        if (this.isOracleDatabaseVM != null) {
            return this.isOracleDatabaseVM;
        }
        if (this.vm != null) {
            if ("Oracle Multilanguage Debugger".equals(this.vm.name())) {
                this.isOracleDatabaseVM = Boolean.TRUE;
                return true;
            }
            this.isOracleDatabaseVM = Boolean.FALSE;
            return false;
        }
        return false;
    }

    private synchronized void removeBPClassPrepareRequest(DebugJDIBreakpoint debugJDIBreakpoint, String string) {
        ClassPrepareRequest classPrepareRequest;
        if (string.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            string = "";
        }
        if ((classPrepareRequest = (ClassPrepareRequest)this.cprsByFilter.get(string)) != null) {
            java.util.List list = (java.util.List)this.cprBreakpoints.get(classPrepareRequest);
            list.remove(debugJDIBreakpoint);
            if (list.isEmpty()) {
                classPrepareRequest.disable();
                this.erm.deleteEventRequest(classPrepareRequest);
                this.cprBreakpoints.remove(classPrepareRequest);
                this.cprsByFilter.remove(string);
            }
        }
    }

    synchronized void breakpointBeforeChange(DebugJDIBreakpoint debugJDIBreakpoint) {
        String string;
        if (debugJDIBreakpoint.getEnabled() && (string = debugJDIBreakpoint.getClassPrepareFilter()) != null) {
            this.removeBPClassPrepareRequest(debugJDIBreakpoint, string);
            if (string.equals("java.lang.Exception")) {
                this.removeBPClassPrepareRequest(debugJDIBreakpoint, "$Oracle.Builtin.EXCEPTION");
            }
        }
    }

    synchronized void createBPClassPrepareRequest(DebugJDIBreakpoint debugJDIBreakpoint, String string) {
        ClassPrepareRequest classPrepareRequest;
        if (string.startsWith("$Oracle.") && this.isOracleDatabaseVM()) {
            string = "";
        }
        if ((classPrepareRequest = (ClassPrepareRequest)this.cprsByFilter.get(string)) == null) {
            classPrepareRequest = this.erm.createClassPrepareRequest();
            classPrepareRequest.setSuspendPolicy(2);
            if (string.length() > 0) {
                classPrepareRequest.addClassFilter(string);
            }
            classPrepareRequest.enable();
            this.cprsByFilter.put(string, classPrepareRequest);
            this.cprBreakpoints.put(classPrepareRequest, new ArrayList());
        }
        java.util.List list = (java.util.List)this.cprBreakpoints.get(classPrepareRequest);
        list.add(debugJDIBreakpoint);
    }

    synchronized void breakpointAfterChange(DebugJDIBreakpoint debugJDIBreakpoint) {
        String string;
        if (debugJDIBreakpoint.getEnabled() && (string = debugJDIBreakpoint.getClassPrepareFilter()) != null) {
            this.createBPClassPrepareRequest(debugJDIBreakpoint, string);
            if (string.equals("java.lang.Exception") && this.isOracleDatabaseVM()) {
                this.createBPClassPrepareRequest(debugJDIBreakpoint, "$Oracle.Builtin.EXCEPTION");
            }
        }
        boolean bl = false;
        int n = this.classes.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)this.classes.get(n2);
            try {
                ReferenceType referenceType = debugJDIClassInfo.getReferenceType();
                if (referenceType instanceof ClassType && debugJDIBreakpoint.verify(referenceType)) {
                    bl = true;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
        if (bl && this.debugListener != null) {
            this.debugListener.breakpointChanged(debugJDIBreakpoint);
        }
    }

    synchronized boolean removeBreakpoint(DebugJDIBreakpoint debugJDIBreakpoint) {
        if (this.breakpoints.indexOf(debugJDIBreakpoint) != -1) {
            this.breakpoints.remove(debugJDIBreakpoint);
            return true;
        }
        return false;
    }

    private void setOptionsForStepRequest(EventRequest eventRequest) {
        StepRequest stepRequest = eventRequest instanceof StepRequest ? (StepRequest)eventRequest : null;
        MethodExitRequest methodExitRequest = eventRequest instanceof MethodExitRequest ? (MethodExitRequest)eventRequest : null;
        int n = this.nonDebuggable.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.nonDebuggable.get(n2);
            if (stepRequest != null) {
                stepRequest.addClassExclusionFilter(string);
                stepRequest.addClassExclusionFilter(string + ".*");
            } else if (methodExitRequest != null) {
                methodExitRequest.addClassExclusionFilter(string);
                methodExitRequest.addClassExclusionFilter(string + ".*");
            }
            ++n2;
        }
        for (String string : this.nonDebuggableClassExclusionFilters) {
            if (stepRequest != null) {
                stepRequest.addClassExclusionFilter(string);
                continue;
            }
            if (methodExitRequest == null) continue;
            methodExitRequest.addClassExclusionFilter(string);
        }
        eventRequest.setSuspendPolicy(2);
        eventRequest.enable();
    }

    private void createStartCPR() {
        this.startCPR = this.erm.createClassPrepareRequest();
        int n = this.nonDebuggable.size();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)this.nonDebuggable.get(n2);
            this.startCPR.addClassExclusionFilter(string);
            this.startCPR.addClassExclusionFilter(string + ".*");
            ++n2;
        }
        this.startCPR.setSuspendPolicy(2);
        this.startCPR.enable();
    }

    private void removeStartCPR() {
        if (this.startCPR != null) {
            this.startCPR.disable();
            this.erm.deleteEventRequest(this.startCPR);
            this.startCPR = null;
        }
    }

    private void createStartTSR() {
        this.startTSR = this.erm.createThreadStartRequest();
        this.startTSR.setSuspendPolicy(2);
        this.startTSR.enable();
        this.startStepRequests = new HashMap();
        java.util.List list = this.allThreads();
        int n = list.size() - 1;
        while (n >= 0) {
            ThreadReference threadReference = (ThreadReference)list.get(n);
            int n2 = threadReference.status();
            if (n2 != 5 && n2 != 0) {
                try {
                    threadReference.frameCount();
                    this.createStartStepRequest(threadReference);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            --n;
        }
    }

    private void removeStartTSR() {
        if (this.startTSR != null) {
            this.startTSR.disable();
            this.erm.deleteEventRequest(this.startTSR);
            this.startTSR = null;
        }
    }

    private void createStartStepRequest(ThreadReference threadReference) {
        if (!this.startStepRequests.containsKey(threadReference)) {
            StepRequest stepRequest = this.erm.createStepRequest(threadReference, -2, 1);
            this.setOptionsForStepRequest(stepRequest);
            this.startStepRequests.put(threadReference, stepRequest);
        }
    }

    private void removeStartRequest() {
        this.removeStartCPR();
        this.removeStartTSR();
        if (this.startStepRequests != null) {
            Iterator iterator = this.startStepRequests.values().iterator();
            this.startStepRequests = null;
            while (iterator.hasNext()) {
                StepRequest stepRequest = (StepRequest)iterator.next();
                stepRequest.disable();
                this.erm.deleteEventRequest(stepRequest);
            }
        }
    }

    private void disableStepRequest() {
        if (this.stepRequest != null) {
            this.stepRequest.disable();
        }
        this.disableMethodExitRequest();
    }

    private void enableStepRequest() {
        if (this.stepRequest != null) {
            this.stepRequest.enable();
        }
        this.enableMethodExitRequest();
    }

    private void removeStepRequest() {
        this.removeStartRequest();
        this.stepLocation = null;
        this.stepStack = null;
        if (this.stepRequest != null) {
            this.stepRequest.disable();
            this.erm.deleteEventRequest(this.stepRequest);
            this.stepRequest = null;
        }
        this.removeMethodExitRequest();
    }

    private boolean shouldStopAtStepEvent(LocatableEvent locatableEvent) {
        ReferenceType referenceType;
        Location location;
        if (this.runCommand == 8 && locatableEvent instanceof MethodExitEvent && this.stepStack != null) {
            try {
                if (locatableEvent.thread().frameCount() > this.stepStack.length) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((location = locatableEvent.location()) != null && (referenceType = location.declaringType()) != null) {
            String string = referenceType.name();
            if (this.isClassDebuggable(string)) {
                Method method = location.method();
                if (this.runCommand == 1) {
                    if (string.startsWith("$Oracle.Block.")) {
                        return false;
                    }
                    if (method.name().equals("<clinit>")) {
                        return false;
                    }
                }
                if (string.startsWith("$Oracle.Block.") && this.getOracleReferenceType(referenceType) == null) {
                    return false;
                }
                if (this.runCommand != 5 && this.runCommand != 6) {
                    if (DebugJDI.getLineNumber(location, referenceType.defaultStratum()) == -1) {
                        return false;
                    }
                    if (DebugJDI.sameSourceLocation(location, this.stepLocation) && DebugJDI.sameStack(DebugJDI.getStack(locatableEvent.thread()), this.stepStack)) {
                        return false;
                    }
                }
                return !method.isSynthetic();
            }
            String string2 = this.getNonDebuggableClassExclusionFilter(string);
            if (string2 != null && this.nonDebuggableClassExclusionFilters.add(string2)) {
                EventRequest eventRequest = locatableEvent.request();
                eventRequest.disable();
                if (eventRequest instanceof StepRequest) {
                    ((StepRequest)eventRequest).addClassExclusionFilter(string2);
                } else if (eventRequest instanceof MethodExitRequest) {
                    ((MethodExitRequest)eventRequest).addClassExclusionFilter(string2);
                }
                eventRequest.enable();
            }
        }
        return false;
    }

    private void makeEndOfMethodRequest(ThreadReference threadReference) {
        if (this.useMethodExitForStepToEndOfMethod) {
            this.methodExitRequest = this.erm.createMethodExitRequest();
            this.methodExitRequest.addThreadFilter(threadReference);
            this.setOptionsForStepRequest(this.methodExitRequest);
        }
    }

    private void disableMethodExitRequest() {
        if (this.useMethodExitForStepToEndOfMethod && this.methodExitRequest != null) {
            this.methodExitRequest.disable();
        }
    }

    private void enableMethodExitRequest() {
        if (this.useMethodExitForStepToEndOfMethod && this.methodExitRequest != null) {
            this.methodExitRequest.enable();
        }
    }

    private void removeMethodExitRequest() {
        if (this.useMethodExitForStepToEndOfMethod && this.methodExitRequest != null) {
            this.methodExitRequest.disable();
            this.erm.deleteEventRequest(this.methodExitRequest);
            this.methodExitRequest = null;
        }
    }

    private synchronized void doRunCommand(int n, DebugJDIThreadInfo debugJDIThreadInfo) {
        this.throwIfRunning();
        this.runCommand = n;
        this.runCommandThread = debugJDIThreadInfo != null ? debugJDIThreadInfo.tr : null;
        this.runningThread = new Thread((Runnable)this, "JPDA Event Processor");
        this.runningThread.start();
    }

    private void resumeAsNeeded() {
        while (!this.needToResume.isEmpty()) {
            Object e = this.needToResume.remove(0);
            if (e instanceof EventSet) {
                ((EventSet)e).resume();
                continue;
            }
            if (!(e instanceof VirtualMachine)) continue;
            ((VirtualMachine)e).resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.killTestConnectionThread();
        if (this.runCommand != 9) {
            this.removeStepRequest();
        }
        switch (this.runCommand) {
            case 0: 
            case 1: {
                if (this.debuggableClassLoaded) {
                    this.createStartTSR();
                    break;
                }
                this.createStartCPR();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 4: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -2, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 5: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 1);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 6: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 2);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 7: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                break;
            }
            case 8: {
                this.stepLocation = DebugJDI.getLocation(this.runCommandThread);
                this.stepStack = DebugJDI.getStack(this.runCommandThread);
                this.stepRequest = this.erm.createStepRequest(this.runCommandThread, -1, 3);
                this.setOptionsForStepRequest(this.stepRequest);
                this.makeEndOfMethodRequest(this.runCommandThread);
                break;
            }
        }
        this.setSyncValue(0, false);
        this.incrementStoppedCount(false);
        this.currentBreakpoint = null;
        this.currentThread = null;
        this.eventThread = null;
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        this.otherWaitingThreads.clear();
        boolean bl = this.isDeadlockBreakpointSet();
        int n = bl ? 3000 : -1;
        long l = System.currentTimeMillis();
        this.resumeAsNeeded();
        do {
            try {
                EventSet eventSet = null;
                java.util.List list = this.unhandledEventSets;
                synchronized (list) {
                    if (!this.unhandledEventSets.isEmpty()) {
                        eventSet = (EventSet)this.unhandledEventSets.remove(0);
                        ThreadReference threadReference = (ThreadReference)this.unhandledEventThreads.remove(0);
                        this.vm.suspend();
                        this.needToResume.add(this.vm);
                        threadReference.resume();
                    }
                }
                if (eventSet == null) {
                    try {
                        eventSet = n != -1 ? this.eq.remove(n) : this.eq.remove();
                        if (eventSet != null) {
                            this.needToResume.add(eventSet);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (eventSet != null) {
                    EventIterator eventIterator = eventSet.eventIterator();
                    while (eventIterator.hasNext()) {
                        Event event = eventIterator.nextEvent();
                        if (event instanceof ThreadStartEvent) {
                            if (!event.request().equals(this.startTSR)) continue;
                            ThreadStartEvent threadStartEvent = (ThreadStartEvent)event;
                            ThreadReference threadReference = threadStartEvent.thread();
                            this.createStartStepRequest(threadReference);
                            continue;
                        }
                        if (event instanceof ClassPrepareEvent) {
                            ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
                            ReferenceType referenceType = classPrepareEvent.referenceType();
                            this.classesNotCollected.add(referenceType);
                            if (this.addClassForReferenceType(referenceType, false) != null && this.checkForBreakpointHit(event, classPrepareEvent.thread())) {
                                this.setSyncValue(0, true);
                            }
                            if (!classPrepareEvent.request().equals(this.startCPR) || !this.debuggableClassLoaded) continue;
                            this.removeStartCPR();
                            this.createStartTSR();
                            continue;
                        }
                        if (event instanceof ClassUnloadEvent) {
                            this.lookForUnloadedClassesByName(((ClassUnloadEvent)event).className());
                            continue;
                        }
                        if (event instanceof BreakpointEvent || event instanceof ExceptionEvent || event instanceof WatchpointEvent) {
                            if (!this.checkForBreakpointHit(event, ((LocatableEvent)event).thread())) continue;
                            this.setSyncValue(0, true);
                            continue;
                        }
                        if (event instanceof StepEvent) {
                            StepEvent stepEvent = (StepEvent)event;
                            if (!this.shouldStopAtStepEvent(stepEvent)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            ThreadReference threadReference = stepEvent.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, threadReference);
                            this.eventThread = threadReference;
                            continue;
                        }
                        if (event instanceof MethodExitEvent) {
                            MethodExitEvent methodExitEvent = (MethodExitEvent)event;
                            if (!this.shouldStopAtStepEvent(methodExitEvent)) continue;
                            this.removeStepRequest();
                            this.setSyncValue(0, true);
                            ThreadReference threadReference = methodExitEvent.thread();
                            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, threadReference);
                            this.eventThread = threadReference;
                            continue;
                        }
                        if (event instanceof VMDeathEvent) {
                            this.setSyncValue(2, true);
                            this.vm = null;
                            continue;
                        }
                        if (!(event instanceof VMDisconnectEvent)) continue;
                        this.vm = null;
                    }
                    if (!this.getSyncValue(0)) {
                        this.resumeAsNeeded();
                    }
                }
                if (this.vm == null || this.getSyncValue(2) || this.getSyncValue(0)) continue;
                if (this.checkForPause()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                if (!bl || System.currentTimeMillis() - l < 3000L) continue;
                if (this.checkForDeadlock()) {
                    this.needToResume.add(this.vm);
                    this.setSyncValue(0, true);
                    continue;
                }
                l = System.currentTimeMillis();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.vm = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } while (this.vm != null && !this.getSyncValue(2) && !this.getSyncValue(0));
        this.runningThread = null;
        this.incrementStoppedCount(true);
        if (this.getSyncValue(2)) {
            if (this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else if (this.getSyncValue(0)) {
            this.programStopped();
        } else if (this.getSyncValue(3)) {
            if (this.getSyncValue(4) && this.debugListener != null) {
                this.debugListener.programTerminated();
            }
            this.cleanUp();
        } else {
            this.setSyncValue(6, true);
            this.connectionLost();
        }
    }

    private void programStopped() {
        this.startTestConnectionThread("programStopped");
        this.checkPinnedObjects();
        this.lookForMissedClasses();
        if (this.debugListener != null) {
            this.debugListener.programStopped();
        }
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.cleanUp();
    }

    private boolean startTestConnectionThread(String string) {
        if (this.testConnectionThread != null) {
            return false;
        }
        String string2 = "JPDA Test Connection Thread (" + string + ")";
        this.testConnectionThread = new 1(this, string2, string2);
        this.testConnectionThread.start();
        return true;
    }

    private void killTestConnectionThread() {
        this.killThreadAndWait(this.testConnectionThread);
        this.testConnectionThread = null;
    }

    private void killThreadAndWait(Thread thread) {
        if (thread != null) {
            while (thread.isAlive()) {
                thread.interrupt();
                try {
                    thread.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void safeSuspendVM() {
        for (ThreadReference threadReference : this.allThreads()) {
            try {
                threadReference.status();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.vm.suspend();
    }

    private boolean checkForPause() {
        if (this.setSyncValue(1, false)) {
            this.safeSuspendVM();
            return true;
        }
        return false;
    }

    private boolean isDeadlockBreakpointSet() {
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.breakpoints.get(n2);
            if (e instanceof DebugJDIBreakpointDeadlock) {
                DebugJDIBreakpointDeadlock debugJDIBreakpointDeadlock = (DebugJDIBreakpointDeadlock)e;
                if (debugJDIBreakpointDeadlock.enabled && (debugJDIBreakpointDeadlock.stop || debugJDIBreakpointDeadlock.log || debugJDIBreakpointDeadlock.enableOtherBPs != null || debugJDIBreakpointDeadlock.disableOtherBPs != null)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean checkForDeadlock() {
        this.safeSuspendVM();
        if (this.areThreadsDeadlocked()) {
            ThreadReference threadReference = (ThreadReference)this.knownDeadlockedThreads.get(this.knownDeadlockedThreads.size() - 1);
            this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, threadReference);
            DebugJDIBreakpointDeadlock debugJDIBreakpointDeadlock = null;
            int n = this.breakpoints.size();
            int n2 = 0;
            while (n2 < n) {
                DebugJDIBreakpointDeadlock debugJDIBreakpointDeadlock2;
                Object e = this.breakpoints.get(n2);
                if (e instanceof DebugJDIBreakpointDeadlock && this.doBreakpointActions(debugJDIBreakpointDeadlock2 = (DebugJDIBreakpointDeadlock)e, null, threadReference)) {
                    debugJDIBreakpointDeadlock = debugJDIBreakpointDeadlock2;
                }
                ++n2;
            }
            if (debugJDIBreakpointDeadlock != null) {
                this.eventThread = null;
                this.currentBreakpoint = debugJDIBreakpointDeadlock;
                return true;
            }
            this.currentThread = null;
        }
        this.vm.resume();
        return false;
    }

    private boolean areThreadsDeadlocked() {
        try {
            ArrayList arrayList = new ArrayList(this.allThreads());
            arrayList.removeAll(this.knownDeadlockedThreads);
            ArrayList<ThreadReference> arrayList2 = new ArrayList<ThreadReference>();
            while (arrayList.size() > 0) {
                ThreadReference threadReference = (ThreadReference)arrayList.remove(0);
                if (threadReference.status() == 3) {
                    arrayList2.add(threadReference);
                    ThreadReference threadReference2 = threadReference;
                    while ((threadReference2 = threadReference2.currentContendedMonitor().owningThread()) != null) {
                        arrayList.remove(threadReference2);
                        if (threadReference2.status() != 3) break;
                        if (threadReference2 == threadReference) {
                            this.knownDeadlockedThreads.addAll(arrayList2);
                            boolean bl = true;
                            return bl;
                        }
                        arrayList2.add(threadReference2);
                    }
                }
                arrayList2.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void stepInto(DebugJDIThreadInfo debugJDIThreadInfo) {
        this.doRunCommand(3, debugJDIThreadInfo);
    }

    void stepOver(DebugJDIThreadInfo debugJDIThreadInfo) {
        this.doRunCommand(4, debugJDIThreadInfo);
    }

    void stepIntoBC(DebugJDIThreadInfo debugJDIThreadInfo) {
        this.doRunCommand(5, debugJDIThreadInfo);
    }

    void stepOverBC(DebugJDIThreadInfo debugJDIThreadInfo) {
        this.doRunCommand(6, debugJDIThreadInfo);
    }

    void stepOut(DebugJDIThreadInfo debugJDIThreadInfo) {
        this.doRunCommand(7, debugJDIThreadInfo);
    }

    void stepToEndOfMethod(DebugJDIThreadInfo debugJDIThreadInfo) {
        if (this.useMethodExitForStepToEndOfMethod) {
            this.doRunCommand(8, debugJDIThreadInfo);
        }
    }

    java.util.List tempDisableRequests() {
        ArrayList<EventRequest> arrayList = new ArrayList<EventRequest>();
        if (this.stepRequest != null && this.stepRequest.isEnabled()) {
            arrayList.add(this.stepRequest);
        }
        if (this.methodExitRequest != null && this.methodExitRequest.isEnabled()) {
            arrayList.add(this.methodExitRequest);
        }
        if (this.startCPR != null && this.startCPR.isEnabled()) {
            arrayList.add(this.startCPR);
        }
        if (this.startTSR != null && this.startTSR.isEnabled()) {
            arrayList.add(this.startTSR);
        }
        if (this.startStepRequests != null) {
            for (StepRequest stepRequest : this.startStepRequests.values()) {
                if (!stepRequest.isEnabled()) continue;
                arrayList.add(stepRequest);
            }
        }
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            EventRequest eventRequest = (EventRequest)arrayList.get(n2);
            eventRequest.disable();
            ++n2;
        }
        this.tempDisableBreakpoints();
        return arrayList;
    }

    void tempReenableRequests(java.util.List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            EventRequest eventRequest = (EventRequest)list.get(n2);
            eventRequest.enable();
            ++n2;
        }
        this.tempReenableBreakpoints();
    }

    void tempDisableBreakpoints() {
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            debugJDIBreakpoint.tempDisableRequests();
            ++n2;
        }
    }

    void tempReenableBreakpoints() {
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            debugJDIBreakpoint.tempReenableRequests();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (anonymousBlockManager != null) {
            anonymousBlockManager.remove(this);
        }
        java.util.List list = this.unhandledEventSets;
        synchronized (list) {
            this.unhandledEventSets.clear();
            this.unhandledEventThreads.clear();
        }
        this.needToResume.clear();
        this.eq = null;
        this.erm = null;
        this.cur = null;
        this.startCPR = null;
        this.startTSR = null;
        if (this.startStepRequests != null) {
            this.startStepRequests.clear();
            this.startStepRequests = null;
        }
        this.stepLocation = null;
        this.stepStack = null;
        this.stepRequest = null;
        this.methodExitRequest = null;
        if (this.breakpoints != null) {
            this.disconnectBreakpoints();
            this.breakpoints.clear();
            this.breakpoints = null;
        }
        if (this.cprsByFilter != null) {
            this.cprsByFilter.clear();
            this.cprsByFilter = null;
        }
        if (this.cprBreakpoints != null) {
            this.cprBreakpoints.clear();
            this.cprBreakpoints = null;
        }
        if (this.classes != null) {
            this.classes.clear();
            this.classes = null;
        }
        if (this.classesByReferenceType != null) {
            this.classesByReferenceType.clear();
            this.classesByReferenceType = null;
        }
        if (this.classesByName != null) {
            this.classesByName.clear();
            this.classesByName = null;
        }
        if (this.classesByNameWithoutPackage != null) {
            this.classesByNameWithoutPackage.clear();
            this.classesByNameWithoutPackage = null;
        }
        if (this.classesCollected != null) {
            this.classesCollected.clear();
            this.classesCollected = null;
        }
        if (this.classesNotCollected != null) {
            this.classesNotCollected.clear();
            this.classesNotCollected = null;
        }
        if (this.objectsCollected != null) {
            this.objectsCollected.clear();
            this.objectsCollected = null;
        }
        if (this.objectsNotCollected != null) {
            this.objectsNotCollected.clear();
            this.objectsNotCollected = null;
        }
        if (this.debuggable != null) {
            this.debuggable.clear();
            this.debuggable = null;
        }
        if (this.nonDebuggable != null) {
            this.nonDebuggable.clear();
            this.nonDebuggable = null;
        }
        if (this.nonDebuggableClassExclusionFilters != null) {
            this.nonDebuggableClassExclusionFilters.clear();
            this.nonDebuggableClassExclusionFilters = null;
        }
        if (this.otherWaitingThreads != null) {
            this.otherWaitingThreads.clear();
            this.otherWaitingThreads = null;
        }
        this.threadInfos.clear();
        this.stackFrameInfos.clear();
        this.classLoaderInfos.clear();
        this.classLoaderIds.clear();
        this.systemClassLoader = null;
        this.currentBreakpoint = null;
        this.currentThread = null;
        this.eventThread = null;
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        if (this.stoppedListeners != null) {
            this.stoppedListeners.clear();
            this.stoppedListeners = null;
        }
        if (this.pins != null) {
            this.pins.clear();
            this.pins = null;
        }
        this.debugListener = null;
        this.bpLogListener = null;
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                if ((stdErrCount -= this.connectionLogs.size()) == 0 && stdErr != null) {
                    System.setErr(stdErr);
                    stdErr = null;
                }
                this.connectionLogs.clear();
                this.connectionLogs = null;
            }
        }
    }

    private void disconnectBreakpoints() {
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            debugJDIBreakpoint.requests.clear();
            debugJDIBreakpoint.locations.clear();
            ++n2;
        }
        this.bpRequests.clear();
    }

    private boolean checkForBreakpointHit(Event event, ThreadReference threadReference) {
        if (!this.bpRequests.contains(event.request())) {
            return false;
        }
        boolean bl = this.startTestConnectionThread("checkForBreakpointHit");
        this.lookForMissedClasses();
        this.eventThread = threadReference;
        this.currentThread = DebugJDIThreadInfo.makeThreadInfo(this, threadReference);
        if (event instanceof ExceptionEvent) {
            ExceptionEvent exceptionEvent = (ExceptionEvent)event;
            this.currentThrow = (DebugJDIDataObjectInfo)this.makeData(exceptionEvent.exception(), null);
            Location location = exceptionEvent.catchLocation();
            if (location != null) {
                this.currentThrowHandler = this.makeLocation(location);
            }
        } else if (event instanceof WatchpointEvent) {
            ModificationWatchpointEvent modificationWatchpointEvent;
            Value value;
            DebugJDIClassInfo debugJDIClassInfo;
            WatchpointEvent watchpointEvent = (WatchpointEvent)event;
            Field field = watchpointEvent.field();
            try {
                debugJDIClassInfo = this.findClassByType(field.type());
            }
            catch (Exception exception) {
                debugJDIClassInfo = this.findClassByName(field.typeName(), true);
            }
            ObjectReference objectReference = watchpointEvent.object();
            DebugJDIClassInfo debugJDIClassInfo2 = this.findClass(field.declaringType());
            this.watchpointObject = objectReference != null ? (DebugJDIDataObjectInfo)this.makeData(objectReference, null) : (DebugJDIDataObjectInfo)this.makeNullData(debugJDIClassInfo2, null);
            this.watchpointField = new DebugJDIFieldInfo(this, field, debugJDIClassInfo2, objectReference);
            this.watchpointFieldFutureValue = event instanceof ModificationWatchpointEvent ? ((value = (modificationWatchpointEvent = (ModificationWatchpointEvent)event).valueToBe()) != null ? this.makeData(value, null) : this.makeNullData(debugJDIClassInfo, null)) : null;
        }
        DebugJDIBreakpoint debugJDIBreakpoint = null;
        java.util.List list = this.findBreakpointsForEvent(event, threadReference);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint2 = (DebugJDIBreakpoint)list.get(n2);
            if (this.doBreakpointActions(debugJDIBreakpoint2, event, threadReference)) {
                debugJDIBreakpoint = debugJDIBreakpoint2;
            }
            ++n2;
        }
        if (bl) {
            this.killTestConnectionThread();
        }
        if (debugJDIBreakpoint != null) {
            this.eventThread = threadReference;
            this.currentBreakpoint = debugJDIBreakpoint;
            return true;
        }
        this.eventThread = null;
        this.currentThread = null;
        this.currentThrow = null;
        this.currentThrowHandler = null;
        this.watchpointObject = null;
        this.watchpointField = null;
        this.watchpointFieldFutureValue = null;
        return false;
    }

    private java.util.List findBreakpointsForEvent(Event event, ThreadReference threadReference) {
        ArrayList<DebugJDIBreakpoint> arrayList = new ArrayList<DebugJDIBreakpoint>();
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            if (debugJDIBreakpoint.isThisYourEvent(event, threadReference)) {
                arrayList.add(debugJDIBreakpoint);
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean doBreakpointActions(DebugJDIBreakpoint debugJDIBreakpoint, Event event, ThreadReference threadReference) {
        if (debugJDIBreakpoint.enableOtherBPs != null && debugJDIBreakpoint.enableOtherBPs.length() > 0) {
            int n = this.breakpoints.size();
            int n2 = 0;
            while (n2 < n) {
                DebugJDIBreakpoint debugJDIBreakpoint2 = (DebugJDIBreakpoint)this.breakpoints.get(n2);
                if (debugJDIBreakpoint.enableOtherBPs.equals(debugJDIBreakpoint2.name) && !debugJDIBreakpoint2.enabled) {
                    debugJDIBreakpoint2.setEnabled(true);
                    if (this.debugListener != null) {
                        this.debugListener.breakpointChanged(debugJDIBreakpoint2);
                    }
                }
                ++n2;
            }
        }
        if (debugJDIBreakpoint.disableOtherBPs != null && debugJDIBreakpoint.disableOtherBPs.length() > 0) {
            int n = this.breakpoints.size();
            int n3 = 0;
            while (n3 < n) {
                DebugJDIBreakpoint debugJDIBreakpoint3 = (DebugJDIBreakpoint)this.breakpoints.get(n3);
                if (debugJDIBreakpoint.disableOtherBPs.equals(debugJDIBreakpoint3.name) && debugJDIBreakpoint3.enabled) {
                    debugJDIBreakpoint3.setEnabled(false);
                    if (this.debugListener != null) {
                        this.debugListener.breakpointChanged(debugJDIBreakpoint3);
                    }
                }
                ++n3;
            }
        }
        if (debugJDIBreakpoint.log) {
            this.incrementStoppedCount(false);
            DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(this, threadReference);
            DebugStackFrameInfo[] debugStackFrameInfoArray = debugJDIThreadInfo.listStack();
            if (debugJDIBreakpoint instanceof DebugJDIBreakpointPackageFileLine || debugJDIBreakpoint instanceof DebugJDIBreakpointFileLine || debugJDIBreakpoint instanceof DebugJDIBreakpointMethodBytecode || debugJDIBreakpoint instanceof DebugJDIBreakpointMethod || debugJDIBreakpoint instanceof DebugJDIBreakpointClass) {
                this.bpLogListener.logBreakpoint(debugJDIBreakpoint, debugJDIThreadInfo, debugStackFrameInfoArray);
            } else if (debugJDIBreakpoint instanceof DebugJDIBreakpointException) {
                Value value;
                ObjectReference objectReference = (ObjectReference)this.currentThrow.value;
                ReferenceType referenceType = objectReference.referenceType();
                String string = referenceType.name();
                String string2 = "";
                Field field = referenceType.fieldByName("detailMessage");
                if (field != null && (value = objectReference.getValue(field)) != null) {
                    string2 = ((StringReference)value).value();
                }
                this.bpLogListener.logException(debugJDIBreakpoint, string, string2, debugJDIThreadInfo, debugStackFrameInfoArray);
            } else if (debugJDIBreakpoint instanceof DebugJDIBreakpointClassLoad) {
                ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
                ReferenceType referenceType = classPrepareEvent.referenceType();
                String string = referenceType.name();
                this.bpLogListener.logClassLoad(debugJDIBreakpoint, string, debugJDIThreadInfo, debugStackFrameInfoArray);
            } else if (debugJDIBreakpoint instanceof DebugJDIBreakpointDeadlock) {
                this.bpLogListener.logDeadlock(debugJDIBreakpoint, debugJDIThreadInfo, debugStackFrameInfoArray);
            } else if (debugJDIBreakpoint instanceof DebugJDIBreakpointWatchpoint) {
                this.bpLogListener.logWatchpoint(debugJDIBreakpoint, this.watchpointField, this.watchpointFieldFutureValue, debugJDIThreadInfo, debugStackFrameInfoArray);
            }
            this.incrementStoppedCount(false);
        }
        return debugJDIBreakpoint.stop;
    }

    static Location getFirstLocation(java.util.List list) {
        int n = -1;
        long l = 0L;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Location location = (Location)list.get(n3);
            long l2 = location.codeIndex();
            if (n == -1 || l2 < l) {
                n = n3;
                l = l2;
            }
            ++n3;
        }
        if (n != -1) {
            return (Location)list.get(n);
        }
        return null;
    }

    DebugJDILocation makeLocation(Location location) {
        return new DebugJDILocation(this, location);
    }

    private void initSync() {
        this.syncObjects = new Object[8];
        int n = 0;
        while (n < 8) {
            this.syncObjects[n] = new Integer(n);
            ++n;
        }
        this.syncValues = new boolean[8];
        int n2 = 0;
        while (n2 < 8) {
            this.syncValues[n2] = false;
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSyncValue(int n, boolean bl) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl2 = this.syncValues[n];
            this.syncValues[n] = bl;
            boolean bl3 = bl2;
            return bl3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getSyncValue(int n) {
        Object object = this.syncObjects[n];
        synchronized (object) {
            boolean bl = this.syncValues[n];
            return bl;
        }
    }

    private void verifyBreakpoints(ReferenceType referenceType) {
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            try {
                if (debugJDIBreakpoint.verify(referenceType) && this.debugListener != null) {
                    this.debugListener.breakpointChanged(debugJDIBreakpoint);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionLog(Object object) {
        Object object2 = this.syncObjects[5];
        synchronized (object2) {
            boolean bl = false;
            if (this.connectionLogs == null) {
                this.connectionLogs = new ArrayList();
                bl = true;
            }
            this.connectionLogs.add(object);
            if (++stdErrCount == 1 && stdErr == null) {
                stdErr = System.err;
                FakePrintStream fakePrintStream = new FakePrintStream(stdErr);
                System.setErr(fakePrintStream);
            }
            if (bl && this.vm != null) {
                this.vm.setDebugTraceMode(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionLog(Object object) {
        Object object2 = this.syncObjects[5];
        synchronized (object2) {
            if (this.connectionLogs != null) {
                this.connectionLogs.remove(object);
                if (this.connectionLogs.size() == 0) {
                    this.connectionLogs = null;
                    if (this.vm != null) {
                        this.vm.setDebugTraceMode(0);
                    }
                }
                if (--stdErrCount == 0 && stdErr != null) {
                    System.setErr(stdErr);
                    stdErr = null;
                }
            }
        }
    }

    @Override
    public synchronized String getName() {
        return this.vm.name();
    }

    @Override
    public int getLanguages() {
        return this.languages;
    }

    @Override
    public synchronized String[] redefineClasses(Map map) {
        ArrayList<String> arrayList;
        block13: {
            this.throwIfRunning();
            arrayList = new ArrayList<String>();
            if (this.vm.canRedefineClasses()) {
                try {
                    HashMap<ReferenceType, byte[]> hashMap = new HashMap<ReferenceType, byte[]>();
                    ArrayList<DebugJDIClassInfo> arrayList2 = new ArrayList<DebugJDIClassInfo>();
                    for (Map.Entry entry : map.entrySet()) {
                        Object k = entry.getKey();
                        Object v = this.classesByName.get(k);
                        if (v == null) continue;
                        byte[] byArray = (byte[])entry.getValue();
                        if (v instanceof DebugJDIClassInfo) {
                            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)v;
                            if (debugJDIClassInfo.getReferenceType() == null) continue;
                            this.redefiningClass(debugJDIClassInfo);
                            arrayList2.add(debugJDIClassInfo);
                            hashMap.put(debugJDIClassInfo.getReferenceType(), byArray);
                            continue;
                        }
                        if (!(v instanceof java.util.List)) continue;
                        java.util.List list = (java.util.List)v;
                        for (DebugJDIClassInfo debugJDIClassInfo : list) {
                            if (debugJDIClassInfo.getReferenceType() == null) continue;
                            this.redefiningClass(debugJDIClassInfo);
                            arrayList2.add(debugJDIClassInfo);
                            hashMap.put(debugJDIClassInfo.getReferenceType(), byArray);
                        }
                    }
                    try {
                        this.redefineClassesOccurred = true;
                        this.vm.redefineClasses(hashMap);
                    }
                    finally {
                        DebugJDIStackFrameInfo.rebuildCache(this);
                    }
                    int n = arrayList2.size() - 1;
                    while (n >= 0) {
                        this.redefinedClass((DebugJDIClassInfo)arrayList2.get(n));
                        --n;
                    }
                    String[] stringArray = null;
                    return stringArray;
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    if (string == null) break block13;
                    if (string.endsWith(" not implemented")) {
                        string = string.substring(0, string.length() - 16);
                    }
                    if (exception instanceof UnsupportedOperationException) {
                        string = DebugJDIArb.format(2, string);
                    }
                    if (string.length() <= 0) break block13;
                    arrayList.add(string);
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void redefiningClass(DebugJDIClassInfo debugJDIClassInfo) {
        debugJDIClassInfo.redefiningClass();
        int n = this.breakpoints.size();
        int n2 = 0;
        while (n2 < n) {
            DebugJDIBreakpoint debugJDIBreakpoint = (DebugJDIBreakpoint)this.breakpoints.get(n2);
            debugJDIBreakpoint.redefiningClass(debugJDIClassInfo.getReferenceType());
            ++n2;
        }
    }

    private void redefinedClass(DebugJDIClassInfo debugJDIClassInfo) {
        this.verifyBreakpoints(debugJDIClassInfo.getReferenceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logToConnectionLogs(String string) {
        Object object = this.syncObjects[5];
        synchronized (object) {
            if (this.connectionLogs != null) {
                int n = this.connectionLogs.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.connectionLogs.get(n2);
                    try {
                        if (e instanceof List) {
                            List list = (List)e;
                            list.add(string);
                            list.makeVisible(list.getItemCount() - 1);
                        } else if (e instanceof PrintStream) {
                            PrintStream printStream = (PrintStream)e;
                            printStream.println(string);
                        } else if (e instanceof File) {
                            String string2 = ((File)e).getAbsolutePath();
                            PrintWriter printWriter = new PrintWriter(new FileWriter(string2, true));
                            printWriter.println(string);
                            printWriter.flush();
                            printWriter.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }

    void addStoppedListener(DebugJDIStoppedListener debugJDIStoppedListener) {
        this.stoppedListeners.add(debugJDIStoppedListener);
    }

    void removeStoppedListener(DebugJDIStoppedListener debugJDIStoppedListener) {
        this.stoppedListeners.remove(debugJDIStoppedListener);
    }

    void incrementStoppedCount(boolean bl) {
        ++this.stoppedCount;
        if (this.currentThrow != null) {
            this.currentThrow.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointObject != null) {
            this.watchpointObject.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointField != null) {
            this.watchpointField.stoppedCount = this.stoppedCount;
        }
        if (this.watchpointFieldFutureValue != null) {
            this.watchpointFieldFutureValue.stoppedCount = this.stoppedCount;
        }
        if (this.classesNotCollected != null) {
            this.classesNotCollected.clear();
        }
        if (this.objectsNotCollected != null) {
            this.objectsNotCollected.clear();
        }
        DebugJDIThreadInfo.clearCache(this, bl);
        DebugJDIStackFrameInfo.clearCache(this);
        if (this.stoppedListeners != null) {
            DebugJDIStoppedListener[] debugJDIStoppedListenerArray = this.stoppedListeners.toArray(new DebugJDIStoppedListener[this.stoppedListeners.size()]);
            int n = debugJDIStoppedListenerArray.length - 1;
            while (n >= 0) {
                debugJDIStoppedListenerArray[n].stopped(bl);
                --n;
            }
        }
    }

    boolean isClassDebuggable(String string) {
        return DebugShared.isClassOrPackageDebuggable(string, this.debuggable, this.nonDebuggable);
    }

    String getNonDebuggableClassExclusionFilter(String string) {
        if (this.debuggable.size() != 0) {
            int n = string.indexOf(46);
            while (n != -1) {
                String string2 = string.substring(0, n + 1);
                if (!DebugJDI.findPartialNameInPackageList(string2, this.debuggable)) {
                    return string2 + "*";
                }
                n = string.indexOf(46, n + 1);
            }
            return string;
        }
        return null;
    }

    private static boolean findPartialNameInPackageList(String string, java.util.List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)list.get(n2);
            if (string2.startsWith(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static Location getLocation(ThreadReference threadReference) {
        try {
            Location location = threadReference.frame(0).location();
            return location;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean sameSourceLocation(Location location, Location location2) {
        try {
            String string;
            if (location.method().equals(location2.method()) && DebugJDI.getLineNumber(location, string = location.declaringType().defaultStratum()) == DebugJDI.getLineNumber(location2, string)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static String[] getStack(ThreadReference threadReference) {
        try {
            java.util.List<StackFrame> list = threadReference.frames();
            int n = list.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = list.get(n2).toString();
                ++n2;
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean sameStack(String[] stringArray, String[] stringArray2) {
        try {
            if (stringArray == null || stringArray2 == null) {
                boolean bl = false;
                return bl;
            }
            int n = stringArray.length;
            if (n != stringArray2.length) {
                boolean bl = false;
                return bl;
            }
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] == null || stringArray2[n2] == null || !stringArray[n2].equals(stringArray2[n2])) {
                    boolean bl = false;
                    return bl;
                }
                ++n2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void addBPRequest(EventRequest eventRequest) {
        this.bpRequests.add(eventRequest);
    }

    void removeBPRequest(EventRequest eventRequest) {
        this.bpRequests.remove(eventRequest);
    }

    boolean isMethodObsolete(Method method) {
        if (this.redefineClassesOccurred) {
            try {
                boolean bl = method.isObsolete();
                return bl;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoaderReference getSystemClassLoader() {
        Object object = this.syncObjects[7];
        synchronized (object) {
            DebugJDIDataObjectInfo debugJDIDataObjectInfo;
            DebugJDIClassInfo debugJDIClassInfo;
            if (this.systemClassLoader == null && (debugJDIClassInfo = this.findClassByName("java.lang.ClassLoader", false)) != null && (debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)DebugShared.getSystemClassLoaderObject(debugJDIClassInfo)) != null) {
                this.systemClassLoader = (ClassLoaderReference)debugJDIDataObjectInfo.value;
            }
            ClassLoaderReference classLoaderReference = this.systemClassLoader;
            return classLoaderReference;
        }
    }

    ClassLoaderReference getClassLoader(ReferenceType referenceType) throws Exception {
        ClassLoaderReference classLoaderReference = referenceType.classLoader();
        if (this.isOracleDatabaseVM() && classLoaderReference != null && classLoaderReference.referenceType() == referenceType) {
            return null;
        }
        return classLoaderReference;
    }

    static synchronized void setDebugJDIAnonymousBlockManagerFactory(DebugJDIAnonymousBlockManagerFactory debugJDIAnonymousBlockManagerFactory) {
        anonymousBlockManagerFactory = debugJDIAnonymousBlockManagerFactory;
    }

    static synchronized void makeAnonymousBlockManager() {
        if (anonymousBlockManager == null && anonymousBlockManagerFactory != null) {
            anonymousBlockManager = anonymousBlockManagerFactory.createInstance();
        }
    }

    static int getLineNumber(Location location, String string) {
        int n = location.lineNumber(string);
        if (n != -1 && DebugJDI.shouldAdjustLineNumbers(location.declaringType())) {
            ++n;
        }
        return n;
    }

    static boolean shouldAdjustLineNumbers(ReferenceType referenceType) {
        return referenceType.name().startsWith("$Oracle.") && !referenceType.name().startsWith("$Oracle.Block.");
    }

    static java.util.List getLocationsOfLine(Object object, String string, String string2, int n) throws AbsentInformationException {
        ReferenceType referenceType = null;
        if (object instanceof Method) {
            referenceType = ((Method)object).declaringType();
        } else if (object instanceof ReferenceType) {
            referenceType = (ReferenceType)object;
        } else {
            throw new IllegalArgumentException();
        }
        if (DebugJDI.shouldAdjustLineNumbers(referenceType)) {
            --n;
        }
        if (object instanceof Method) {
            if (string == null && string2 == null) {
                return ((Method)object).locationsOfLine(n);
            }
            return ((Method)object).locationsOfLine(string, string2, n);
        }
        return ((ReferenceType)object).locationsOfLine(string, string2, n);
    }

    static EventQueue ra$eq(DebugJDI debugJDI) {
        return debugJDI.eq;
    }

    static boolean mav$getSyncValue(DebugJDI debugJDI, int n) {
        return debugJDI.getSyncValue(n);
    }

    static boolean mav$setSyncValue(DebugJDI debugJDI, int n, boolean bl) {
        return debugJDI.setSyncValue(n, bl);
    }

    static void mav$connectionLost(DebugJDI debugJDI) {
        debugJDI.connectionLost();
    }

    static Set ra$classesNotCollected(DebugJDI debugJDI) {
        return debugJDI.classesNotCollected;
    }

    static DebugJDIClassInfo mav$addClassForReferenceType(DebugJDI debugJDI, ReferenceType referenceType, boolean bl) {
        return debugJDI.addClassForReferenceType(referenceType, bl);
    }

    static void mav$lookForUnloadedClassesByName(DebugJDI debugJDI, String string) {
        debugJDI.lookForUnloadedClassesByName(string);
    }

    static java.util.List ra$unhandledEventSets(DebugJDI debugJDI) {
        return debugJDI.unhandledEventSets;
    }

    static java.util.List ra$unhandledEventThreads(DebugJDI debugJDI) {
        return debugJDI.unhandledEventThreads;
    }

    static void wa$testConnectionThread(DebugJDI debugJDI, Thread thread) {
        debugJDI.testConnectionThread = thread;
    }

    public final class 1
    extends Thread {
        private final /* synthetic */ String v$threadName;
        final /* synthetic */ DebugJDI this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block13: {
                try {
                    EventQueue eventQueue;
                    while ((eventQueue = DebugJDI.ra$eq(this.this$0)) != null) {
                        EventSet eventSet = eventQueue.remove(3000L);
                        if (eventSet == null) continue;
                        boolean bl = false;
                        EventIterator eventIterator = eventSet.eventIterator();
                        while (eventIterator.hasNext()) {
                            Event event = eventIterator.nextEvent();
                            if (event instanceof VMDisconnectEvent) {
                                boolean bl2;
                                if (!DebugJDI.mav$getSyncValue(this.this$0, 3) && !(bl2 = DebugJDI.mav$setSyncValue(this.this$0, 6, true))) {
                                    DebugJDI.mav$connectionLost(this.this$0);
                                }
                                bl = true;
                                continue;
                            }
                            if (event instanceof ClassPrepareEvent) {
                                ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
                                ReferenceType referenceType = classPrepareEvent.referenceType();
                                DebugJDI.ra$classesNotCollected(this.this$0).add(referenceType);
                                DebugJDI.mav$addClassForReferenceType(this.this$0, referenceType, false);
                                continue;
                            }
                            if (event instanceof ClassUnloadEvent) {
                                DebugJDI.mav$lookForUnloadedClassesByName(this.this$0, ((ClassUnloadEvent)event).className());
                                continue;
                            }
                            if (!(event instanceof LocatableEvent)) continue;
                            ThreadReference threadReference = ((LocatableEvent)event).thread();
                            threadReference.suspend();
                            java.util.List list = DebugJDI.ra$unhandledEventSets(this.this$0);
                            synchronized (list) {
                                DebugJDI.ra$unhandledEventSets(this.this$0).add(eventSet);
                                DebugJDI.ra$unhandledEventThreads(this.this$0).add(threadReference);
                                break;
                            }
                        }
                        if (!bl) {
                            eventSet.resume();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    boolean bl = DebugJDI.mav$setSyncValue(this.this$0, 6, true);
                    if (bl) break block13;
                    DebugJDI.mav$connectionLost(this.this$0);
                }
            }
            DebugJDI.wa$testConnectionThread(this.this$0, null);
        }

        public 1(DebugJDI debugJDI, String string, String string2) {
            this.v$threadName = string2;
            this.this$0 = debugJDI;
            super(string);
        }
    }

    public class FakePrintStream
    extends PrintStream {
        String nextLine;
        boolean passOn;

        FakePrintStream(OutputStream outputStream) {
            super(outputStream);
            this.nextLine = "";
        }

        public void print(boolean bl) {
            if (this.passOn) {
                super.print(bl);
            } else {
                this.nextLine = this.nextLine + (bl ? "true" : "false");
            }
        }

        public void print(char c) {
            if (this.passOn) {
                super.print(c);
            } else {
                this.nextLine = this.nextLine + String.valueOf(c);
            }
        }

        public void print(int n) {
            if (this.passOn) {
                super.print(n);
            } else {
                this.nextLine = this.nextLine + String.valueOf(n);
            }
        }

        public void print(long l) {
            if (this.passOn) {
                super.print(l);
            } else {
                this.nextLine = this.nextLine + String.valueOf(l);
            }
        }

        public void print(float f) {
            if (this.passOn) {
                super.print(f);
            } else {
                this.nextLine = this.nextLine + String.valueOf(f);
            }
        }

        public void print(double d) {
            if (this.passOn) {
                super.print(d);
            } else {
                this.nextLine = this.nextLine + String.valueOf(d);
            }
        }

        public void print(char[] cArray) {
            if (this.passOn) {
                super.print(cArray);
            } else {
                this.nextLine = this.nextLine + cArray;
            }
        }

        public void print(String string) {
            if (this.passOn) {
                super.print(string);
            } else {
                if (string == null) {
                    string = "null";
                }
                this.nextLine = this.nextLine + string;
            }
        }

        public void print(Object object) {
            if (this.passOn) {
                super.print(object);
            } else {
                this.nextLine = this.nextLine + String.valueOf(object);
            }
        }

        public void println() {
            if (this.passOn) {
                super.println();
            } else {
                this.log();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(boolean bl) {
            if (this.passOn) {
                super.println(bl);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(bl);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(char c) {
            if (this.passOn) {
                super.println(c);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(c);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(int n) {
            if (this.passOn) {
                super.println(n);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(n);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(long l) {
            if (this.passOn) {
                super.println(l);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(l);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(float f) {
            if (this.passOn) {
                super.println(f);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(f);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(double d) {
            if (this.passOn) {
                super.println(d);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(d);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(char[] cArray) {
            if (this.passOn) {
                super.println(cArray);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(cArray);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(String string) {
            if (this.passOn) {
                super.println(string);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(string);
                    this.log();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println(Object object) {
            if (this.passOn) {
                super.println(object);
            } else {
                FakePrintStream fakePrintStream = this;
                synchronized (fakePrintStream) {
                    this.print(object);
                    this.log();
                }
            }
        }

        private void log() {
            if (this.nextLine.startsWith("[JDI:")) {
                DebugJDI.this.logToConnectionLogs(this.nextLine);
            } else {
                this.passOn = true;
                super.println(this.nextLine);
                this.passOn = false;
            }
            this.nextLine = "";
        }
    }
}

