/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataObjectInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDILocation;
import oracle.jdevimpl.debugger.jdi.DebugJDIThreadInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;

class DebugJDIBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint {
    DebugJDI dj;
    List requests;
    List locations;
    String name;
    boolean enabled;
    List instanceFilters;
    String threadname;
    String threadnameNot;
    DebugBreakpointCondition condition;
    int passCount;
    boolean stop;
    boolean log;
    String enableOtherBPs;
    String disableOtherBPs;
    boolean tempDisabled;

    DebugJDIBreakpoint(DebugJDI debugJDI) {
        this.dj = debugJDI;
        this.requests = new ArrayList();
        this.locations = new ArrayList();
        this.stop = true;
        this.enabled = true;
        this.instanceFilters = new ArrayList();
        this.passCount = 1;
    }

    public void remove() {
        this.prepareForChange();
        if (this.dj != null) {
            this.dj.removeBreakpoint(this);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadname = string;
        if (string != null && this.threadnameNot != null) {
            this.threadnameNot = null;
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadnameNot = string;
        if (string != null && this.threadname != null) {
            this.threadname = null;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.prepareForChange();
            this.enabled = bl;
            int n = this.requests.size();
            int n2 = 0;
            while (n2 < n) {
                EventRequest eventRequest = (EventRequest)this.requests.get(n2);
                eventRequest.setEnabled(bl);
                ++n2;
            }
            this.afterChange();
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean bl) {
        this.log = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String string) {
        this.enableOtherBPs = string;
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String string) {
        this.disableOtherBPs = string;
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition debugBreakpointCondition) {
        this.condition = debugBreakpointCondition;
    }

    public int getPassCount() {
        return this.passCount == 0 ? 1 : this.passCount;
    }

    public void setPassCount(int n) {
        this.passCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
        DebugJDIDataObjectInfo debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)debugDataObjectInfo;
        if (debugJDIDataObjectInfo.value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)debugJDIDataObjectInfo.value;
            List list = this.instanceFilters;
            synchronized (list) {
                if (!this.instanceFilters.contains(objectReference)) {
                    this.instanceFilters.add(objectReference);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
        DebugJDIDataObjectInfo debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)debugDataObjectInfo;
        if (debugJDIDataObjectInfo.value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)debugJDIDataObjectInfo.value;
            List list = this.instanceFilters;
            synchronized (list) {
                this.instanceFilters.remove(objectReference);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(long l) {
        List list = this.instanceFilters;
        synchronized (list) {
            for (ObjectReference objectReference : this.instanceFilters) {
                if (objectReference.uniqueID() != l) continue;
                this.instanceFilters.remove(objectReference);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceFilterSet(DebugDataObjectInfo debugDataObjectInfo) {
        DebugJDIDataObjectInfo debugJDIDataObjectInfo = (DebugJDIDataObjectInfo)debugDataObjectInfo;
        if (debugJDIDataObjectInfo.value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)debugJDIDataObjectInfo.value;
            List list = this.instanceFilters;
            synchronized (list) {
                if (this.instanceFilters.contains(objectReference)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceFilters() {
        List list = this.instanceFilters;
        synchronized (list) {
            long[] lArray = new long[this.instanceFilters.size()];
            int n = 0;
            Iterator iterator = this.instanceFilters.iterator();
            while (iterator.hasNext()) {
                lArray[n++] = ((ObjectReference)iterator.next()).uniqueID();
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
    }

    public DebugLocation[] getLocations() {
        DebugLocation[] debugLocationArray = new DebugLocation[this.locations.size()];
        return this.locations.toArray(debugLocationArray);
    }

    protected void setOptions(EventRequest eventRequest) {
        eventRequest.setSuspendPolicy(2);
        if (!this.tempDisabled) {
            eventRequest.setEnabled(this.enabled);
        }
    }

    private boolean threadMatches(ThreadReference threadReference) {
        if (this.threadname != null) {
            return this.threadname.equals(threadReference.name());
        }
        if (this.threadnameNot != null) {
            return this.threadnameNot.equals(threadReference.name()) ^ true;
        }
        return true;
    }

    private boolean conditionSatisfied(Event event, ThreadReference threadReference) {
        boolean bl = true;
        if (this.condition != null) {
            this.dj.incrementStoppedCount(false);
            DebugJDIThreadInfo debugJDIThreadInfo = DebugJDIThreadInfo.makeThreadInfo(this.dj, threadReference);
            DebugStackFrameInfo[] debugStackFrameInfoArray = debugJDIThreadInfo.listStack();
            bl = this.condition.checkBreakpointCondition(this, this.dj, debugJDIThreadInfo, debugStackFrameInfoArray);
            this.dj.incrementStoppedCount(false);
        }
        return bl;
    }

    private boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
            if (this.dj.debugListener != null) {
                this.dj.debugListener.breakpointChanged(this);
            }
        }
        return this.passCount == 0;
    }

    protected ObjectReference getInstanceForEvent(Event event, ThreadReference threadReference) {
        if (event instanceof BreakpointEvent) {
            try {
                ObjectReference objectReference = threadReference.frame(0).thisObject();
                return objectReference;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean checkConditions(Event event, ThreadReference threadReference) {
        ObjectReference objectReference;
        if (!this.instanceFilters.isEmpty() && (objectReference = this.getInstanceForEvent(event, threadReference)) != null && !this.instanceFilters.contains(objectReference)) {
            return false;
        }
        if (!this.threadMatches(threadReference)) {
            return false;
        }
        if (!this.conditionSatisfied(event, threadReference)) {
            return false;
        }
        return this.checkPassCount();
    }

    boolean isThisYourEvent(Event event, ThreadReference threadReference) {
        if (this.enabled) {
            EventRequest eventRequest = event.request();
            int n = this.requests.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.requests.get(n2).equals(eventRequest)) {
                    return this.checkConditions(event, threadReference);
                }
                ++n2;
            }
        }
        return false;
    }

    void prepareForChange() {
        this.dj.breakpointBeforeChange(this);
        int n = this.requests.size();
        int n2 = 0;
        while (n2 < n) {
            EventRequest eventRequest = (EventRequest)this.requests.get(n2);
            eventRequest.disable();
            this.dj.erm.deleteEventRequest(eventRequest);
            ++n2;
        }
        this.clearRequests();
        this.locations.clear();
    }

    void afterChange() {
        this.dj.breakpointAfterChange(this);
    }

    String getClassPrepareFilter() {
        return null;
    }

    void redefiningClass(ReferenceType referenceType) {
        int n = this.locations.size() - 1;
        while (n >= 0) {
            DebugLocation debugLocation = (DebugLocation)this.locations.get(n);
            DebugJDIClassInfo debugJDIClassInfo = (DebugJDIClassInfo)debugLocation.getClassInfo();
            if (debugJDIClassInfo.getReferenceType() == referenceType) {
                this.locations.remove(n);
            }
            --n;
        }
        int n2 = this.requests.size() - 1;
        while (n2 >= 0) {
            BreakpointRequest breakpointRequest;
            Location location;
            EventRequest eventRequest = (EventRequest)this.requests.get(n2);
            if (eventRequest instanceof BreakpointRequest && (location = (breakpointRequest = (BreakpointRequest)eventRequest).location()).declaringType() == referenceType) {
                breakpointRequest.disable();
                this.dj.erm.deleteEventRequest(breakpointRequest);
                this.removeRequest(eventRequest);
            }
            --n2;
        }
    }

    boolean verify(ReferenceType referenceType) {
        return false;
    }

    protected void locationIdentified(Location location) {
        DebugJDILocation debugJDILocation = this.dj.makeLocation(location);
        if (debugJDILocation != null) {
            this.locations.add(debugJDILocation);
            BreakpointRequest breakpointRequest = this.dj.erm.createBreakpointRequest(location);
            this.setOptions(breakpointRequest);
            this.addRequest(breakpointRequest);
        }
    }

    protected final void addRequest(EventRequest eventRequest) {
        this.dj.addBPRequest(eventRequest);
        this.requests.add(eventRequest);
    }

    protected final void removeRequest(EventRequest eventRequest) {
        this.dj.removeBPRequest(eventRequest);
        this.requests.remove(eventRequest);
    }

    protected final void clearRequests() {
        int n = this.requests.size() - 1;
        while (n >= 0) {
            this.dj.removeBPRequest((EventRequest)this.requests.get(n));
            --n;
        }
        this.requests.clear();
    }

    void tempDisableRequests() {
        int n = this.requests.size();
        int n2 = 0;
        while (n2 < n) {
            EventRequest eventRequest = (EventRequest)this.requests.get(n2);
            eventRequest.disable();
            ++n2;
        }
        this.tempDisabled = true;
    }

    void tempReenableRequests() {
        this.tempDisabled = false;
        int n = this.requests.size() - 1;
        while (n >= 0) {
            EventRequest eventRequest = (EventRequest)this.requests.get(n);
            boolean bl = false;
            if (eventRequest instanceof BreakpointRequest) {
                BreakpointRequest breakpointRequest = (BreakpointRequest)eventRequest;
                ReferenceType referenceType = breakpointRequest.location().declaringType();
                bl = this.dj.isClassCollected(referenceType);
            } else if (eventRequest instanceof ExceptionRequest) {
                ExceptionRequest exceptionRequest = (ExceptionRequest)eventRequest;
                ReferenceType referenceType = exceptionRequest.exception();
                bl = this.dj.isClassCollected(referenceType);
            }
            if (bl) {
                this.removeRequest(eventRequest);
            } else {
                eventRequest.setEnabled(this.enabled);
            }
            --n;
        }
    }
}

