/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;

final class DebugJDIBreakpointClass
extends DebugJDIBreakpoint
implements DebugBreakpointClass {
    String className;

    DebugJDIBreakpointClass(DebugJDI debugJDI, String string) {
        super(debugJDI);
        this.className = string;
    }

    public String getClassname() {
        return this.className;
    }

    public void setClassname(String string) {
        if (ModelUtil.areDifferent((Object)this.className, (Object)string)) {
            this.prepareForChange();
            this.className = string;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.className;
    }

    boolean verify(ReferenceType referenceType) {
        boolean bl = false;
        if (this.className.equals(referenceType.name())) {
            List<Method> list = referenceType.methods();
            int n = 0;
            while (n < list.size()) {
                try {
                    Method method = list.get(n);
                    List<Location> list2 = method.allLineLocations();
                    Location location = DebugJDI.getFirstLocation(list2);
                    if (location != null) {
                        this.locationIdentified(location);
                        bl = true;
                    }
                }
                catch (AbsentInformationException absentInformationException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return bl;
    }
}

