/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ExceptionRequest;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;

final class DebugJDIBreakpointException
extends DebugJDIBreakpoint
implements DebugBreakpointException {
    String exception;
    boolean caught;
    boolean uncaught;

    DebugJDIBreakpointException(DebugJDI debugJDI, String string, boolean bl, boolean bl2) {
        super(debugJDI);
        this.exception = string;
        this.caught = bl;
        this.uncaught = bl2;
    }

    public String getExceptionClassname() {
        return this.exception;
    }

    public boolean getCaught() {
        return this.caught;
    }

    public boolean getUncaught() {
        return this.uncaught;
    }

    public void setExceptionClassname(String string) {
        this.setExceptionClassname(string, true, true);
    }

    public void setExceptionClassname(String string, boolean bl, boolean bl2) {
        if (ModelUtil.areDifferent((Object)this.exception, (Object)string) || this.caught != bl || this.uncaught != bl2) {
            this.prepareForChange();
            this.exception = string;
            this.caught = bl;
            this.uncaught = bl2;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.exception;
    }

    boolean verify(ReferenceType referenceType) {
        ClassType classType;
        boolean bl = false;
        String string = referenceType.name();
        if (this.exception.equals(string)) {
            this.exceptionIdentified(referenceType);
            bl = true;
        } else if (this.exception.equals("java.lang.Exception") && string.equals("$Oracle.Builtin.EXCEPTION") && referenceType instanceof ClassType && (classType = ((ClassType)referenceType).superclass()) != null && classType.name().equals("java.lang.Throwable")) {
            this.exceptionIdentified(referenceType);
            bl = true;
        }
        return bl;
    }

    private void exceptionIdentified(ReferenceType referenceType) {
        ExceptionRequest exceptionRequest = this.dj.erm.createExceptionRequest(referenceType, this.caught, this.uncaught);
        this.setOptions(exceptionRequest);
        this.addRequest(exceptionRequest);
    }
}

