/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;

class DebugJDIBreakpointFileLine
extends DebugJDIBreakpoint
implements DebugBreakpointFileLine {
    String filename;
    int line;

    DebugJDIBreakpointFileLine(DebugJDI debugJDI, String string, int n) {
        super(debugJDI);
        this.filename = string;
        this.line = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public void setFileLine(String string, int n) {
        if (ModelUtil.areDifferent((Object)this.filename, (Object)string) || this.line != n) {
            this.prepareForChange();
            this.filename = string;
            this.line = n;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return "";
    }

    boolean verify(ReferenceType referenceType) {
        boolean bl = false;
        try {
            int n;
            String string = referenceType.defaultStratum();
            ArrayList<Location> arrayList = null;
            try {
                arrayList = DebugJDI.getLocationsOfLine(referenceType, string, this.filename, this.line);
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                boolean bl2 = false;
                return bl2;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (arrayList == null) {
                List<Location> list = referenceType.allLineLocations(string, this.filename);
                ArrayList<Location> arrayList2 = new ArrayList<Location>();
                int n2 = list.size();
                int n3 = 0;
                while (n3 < n2) {
                    Location location = list.get(n3);
                    if (DebugJDI.getLineNumber(location, string) == this.line) {
                        arrayList2.add(location);
                    }
                    ++n3;
                }
                arrayList = arrayList2;
            }
            if ((n = arrayList.size()) > 0) {
                int n4 = 0;
                while (n4 < n) {
                    Location location = (Location)arrayList.get(n4);
                    this.locationIdentified(location);
                    ++n4;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

