/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;

final class DebugJDIBreakpointMethod
extends DebugJDIBreakpoint
implements DebugBreakpointMethod {
    String method;
    String className;

    DebugJDIBreakpointMethod(DebugJDI debugJDI, String string) {
        super(debugJDI);
        this.method = string;
        int n = string.lastIndexOf(".");
        this.className = n == -1 ? "" : string.substring(0, n);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        if (ModelUtil.areDifferent((Object)this.method, (Object)string)) {
            this.prepareForChange();
            this.method = string;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.className;
    }

    boolean verify(ReferenceType referenceType) {
        boolean bl = false;
        if (this.className.equals(referenceType.name())) {
            List<Method> list = referenceType.methods();
            int n = 0;
            while (n < list.size()) {
                Method method = list.get(n);
                if (this.method.equals(this.className + "." + method.name())) {
                    try {
                        List<Location> list2 = method.allLineLocations();
                        Location location = DebugJDI.getFirstLocation(list2);
                        if (location != null) {
                            this.locationIdentified(location);
                            bl = true;
                        }
                    }
                    catch (AbsentInformationException absentInformationException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        return bl;
    }
}

