/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;

final class DebugJDIBreakpointMethodBytecode
extends DebugJDIBreakpoint
implements DebugBreakpointMethodBytecode {
    String method;
    int bytecodeOffset;
    String className;

    DebugJDIBreakpointMethodBytecode(DebugJDI debugJDI, String string, int n) {
        super(debugJDI);
        int n2;
        int n3;
        this.method = string;
        this.bytecodeOffset = n;
        int n4 = string.indexOf(" ");
        this.className = n4 == -1 ? "" : ((n3 = string.indexOf("(", n4 + 1)) == -1 ? "" : ((n2 = string.lastIndexOf(".", n3 - 1)) == -1 ? "" : string.substring(n4 + 1, n2)));
    }

    public String getMethod() {
        return this.method;
    }

    public int getBytecodeOffset() {
        return this.bytecodeOffset;
    }

    public void setMethodBytecodeOffset(String string, int n) {
        if (ModelUtil.areDifferent((Object)this.method, (Object)string) || this.bytecodeOffset != n) {
            this.prepareForChange();
            this.method = string;
            this.bytecodeOffset = n;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.className;
    }

    boolean verify(ReferenceType referenceType) {
        boolean bl = false;
        if (this.className.equals(referenceType.name())) {
            List<Method> list = referenceType.methods();
            int n = 0;
            while (n < list.size()) {
                String string;
                Method method = list.get(n);
                if (this.method.indexOf(method.name()) != -1 && this.method.equals(string = DebugJDIMethodInfo.getFullMethodName(this.className, method))) {
                    Location location = method.locationOfCodeIndex(this.bytecodeOffset);
                    this.locationIdentified(location);
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }
}

