/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ReferenceType;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jsp.util.JspUtil;

final class DebugJDIBreakpointPackageFileLine
extends DebugJDIBreakpointFileLine
implements DebugBreakpointPackageFileLine {
    String pkg;

    DebugJDIBreakpointPackageFileLine(DebugJDI debugJDI, String string, String string2, int n) {
        super(debugJDI, string2, n);
        this.pkg = string;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackageFileLine(String string, String string2, int n) {
        if (ModelUtil.areDifferent((Object)this.pkg, (Object)string) || ModelUtil.areDifferent((Object)this.filename, (Object)string2) || this.line != n) {
            this.prepareForChange();
            this.pkg = string;
            this.filename = string2;
            this.line = n;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        if (this.pkg.length() > 0) {
            if (this.pkg.charAt(0) == '*') {
                return "";
            }
            return this.pkg + ".*";
        }
        if (J2eeSettings.isJsp(this.filename)) {
            String string = JspUtil.getFullClassNameFromURL((String)this.filename);
            return string + "*";
        }
        return "";
    }

    boolean verify(ReferenceType referenceType) {
        String string;
        String string2 = referenceType.name();
        int n = string2.lastIndexOf(".");
        String string3 = string = n == -1 ? "" : string2.substring(0, n);
        if (string.equals(this.pkg)) {
            return super.verify(referenceType);
        }
        if (this.pkg.length() > 0 && this.pkg.charAt(0) == '*' && string.endsWith(this.pkg.substring(1))) {
            return super.verify(referenceType);
        }
        return false;
    }
}

