/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import java.util.List;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;

final class DebugJDIBreakpointWatchpoint
extends DebugJDIBreakpoint
implements DebugBreakpointWatchpoint {
    String classname;
    String fieldname;
    boolean access;
    boolean modify;

    DebugJDIBreakpointWatchpoint(DebugJDI debugJDI, String string, String string2, boolean bl, boolean bl2) {
        super(debugJDI);
        this.classname = string;
        this.fieldname = string2;
        this.access = bl;
        this.modify = bl2;
    }

    public String getWatchpointClassname() {
        return this.classname;
    }

    public String getWatchpointFieldname() {
        return this.fieldname;
    }

    public boolean getAccess() {
        return this.access;
    }

    public boolean getModify() {
        return this.modify;
    }

    public void setWatchpoint(String string, String string2, boolean bl, boolean bl2) {
        if (ModelUtil.areDifferent((Object)this.classname, (Object)string) || ModelUtil.areDifferent((Object)this.fieldname, (Object)string2) || this.access != bl || this.modify != bl2) {
            this.prepareForChange();
            this.classname = string;
            this.fieldname = string2;
            this.access = bl;
            this.modify = bl2;
            this.afterChange();
        }
    }

    String getClassPrepareFilter() {
        return this.classname;
    }

    boolean verify(ReferenceType referenceType) {
        boolean bl = false;
        if (this.classname.equals(referenceType.name())) {
            this.classIdentified(referenceType);
            bl = true;
        }
        return bl;
    }

    private void classIdentified(ReferenceType referenceType) {
        List<Field> list = referenceType.fields();
        if (list != null) {
            for (Field field : list) {
                if (!this.fieldname.equals(field.name())) continue;
                if (this.access) {
                    try {
                        AccessWatchpointRequest accessWatchpointRequest = this.dj.erm.createAccessWatchpointRequest(field);
                        this.setOptions(accessWatchpointRequest);
                        this.addRequest(accessWatchpointRequest);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if (!this.modify) continue;
                try {
                    ModificationWatchpointRequest modificationWatchpointRequest = this.dj.erm.createModificationWatchpointRequest(field);
                    this.setOptions(modificationWatchpointRequest);
                    this.addRequest(modificationWatchpointRequest);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    protected ObjectReference getInstanceForEvent(Event event, ThreadReference threadReference) {
        if (event instanceof WatchpointEvent) {
            WatchpointEvent watchpointEvent = (WatchpointEvent)event;
            return watchpointEvent.object();
        }
        return null;
    }
}

